/*    */ package org.quartz.impl;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import java.util.Collections;
/*    */ import java.util.HashMap;
/*    */ import org.quartz.Scheduler;
/*    */ import org.quartz.SchedulerException;
/*    */ 
/*    */ public class SchedulerRepository
/*    */ {
/*    */   private HashMap schedulers;
/*    */   private static SchedulerRepository inst;
/*    */ 
/*    */   private SchedulerRepository()
/*    */   {
/* 61 */     this.schedulers = new HashMap();
/*    */   }
/*    */ 
/*    */   public static synchronized SchedulerRepository getInstance()
/*    */   {
/* 73 */     if (inst == null) inst = new SchedulerRepository();
/*    */ 
/* 75 */     return inst;
/*    */   }
/*    */ 
/*    */   public synchronized void bind(Scheduler sched) throws SchedulerException
/*    */   {
/* 80 */     if ((Scheduler)this.schedulers.get(sched.getSchedulerName()) != null) {
/* 81 */       throw new SchedulerException("Scheduler with name '" + sched.getSchedulerName() + "' already exists.", 50);
/*    */     }
/*    */ 
/* 85 */     this.schedulers.put(sched.getSchedulerName(), sched);
/*    */   }
/*    */ 
/*    */   public synchronized boolean remove(String schedName) {
/* 89 */     return this.schedulers.remove(schedName) != null;
/*    */   }
/*    */ 
/*    */   public synchronized Scheduler lookup(String schedName) {
/* 93 */     return (Scheduler)this.schedulers.get(schedName);
/*    */   }
/*    */ 
/*    */   public synchronized Collection lookupAll() {
/* 97 */     return Collections.unmodifiableCollection(this.schedulers.values());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.SchedulerRepository
 * JD-Core Version:    0.6.0
 */