/*     */ package org.quartz.impl;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.PrintStream;
/*     */ import java.rmi.RMISecurityManager;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.SchedulerFactory;
/*     */ import org.quartz.SchedulerListener;
/*     */ import org.quartz.Trigger;
/*     */ 
/*     */ public class QuartzServer
/*     */   implements SchedulerListener
/*     */ {
/*  68 */   private Scheduler sched = null;
/*     */ 
/*     */   public void serve(SchedulerFactory schedFact, boolean console)
/*     */     throws Exception
/*     */   {
/*  91 */     this.sched = schedFact.getScheduler();
/*     */ 
/*  93 */     this.sched.start();
/*     */     try
/*     */     {
/*  96 */       Thread.sleep(3000L);
/*     */     }
/*     */     catch (Exception ignore) {
/*     */     }
/* 100 */     System.out.println("\n*** The scheduler successfully started.");
/*     */ 
/* 102 */     if (console) {
/* 103 */       System.out.println("\n");
/* 104 */       System.out.println("The scheduler will now run until you type \"exit\"");
/*     */ 
/* 106 */       System.out.println("   If it was configured to export itself via RMI,");
/*     */ 
/* 108 */       System.out.println("   then other process may now use it.");
/*     */ 
/* 110 */       BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
/*     */       while (true)
/*     */       {
/* 114 */         System.out.print("Type 'exit' to shutdown the server: ");
/* 115 */         if ("exit".equals(rdr.readLine())) {
/* 116 */           break;
/*     */         }
/*     */       }
/*     */ 
/* 120 */       System.out.println("\n...Shutting down server...");
/*     */ 
/* 122 */       this.sched.shutdown(true);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void jobScheduled(Trigger trigger)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void jobUnscheduled(String triggerName, String triggerGroup)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void triggerFinalized(Trigger trigger)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void triggersPaused(String triggerName, String triggerGroup)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void triggersResumed(String triggerName, String triggerGroup)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void jobsPaused(String jobName, String jobGroup)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void jobsResumed(String jobName, String jobGroup)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void schedulerError(String msg, SchedulerException cause)
/*     */   {
/* 234 */     System.err.println("*** " + msg);
/* 235 */     cause.printStackTrace();
/*     */   }
/*     */ 
/*     */   public void schedulerShutdown()
/*     */   {
/* 245 */     System.out.println("\n*** The scheduler is now shutdown.");
/* 246 */     this.sched = null;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/* 263 */     if (System.getSecurityManager() == null) {
/* 264 */       System.setSecurityManager(new RMISecurityManager());
/*     */     }
/*     */     try
/*     */     {
/* 268 */       QuartzServer server = new QuartzServer();
/* 269 */       if (args.length == 0) server.serve(new StdSchedulerFactory(), false);
/* 271 */       else if ((args.length == 1) && (args[0].equalsIgnoreCase("console"))) server.serve(new StdSchedulerFactory(), true);
/*     */       else
/*     */       {
/* 274 */         System.err.println("\nUsage: QuartzServer [console]");
/*     */       }
/*     */     } catch (Exception e) {
/* 277 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.QuartzServer
 * JD-Core Version:    0.6.0
 */