/*      */ package org.quartz.helpers;
/*      */ 
/*      */ import java.util.Collections;
/*      */ import java.util.Date;
/*      */ import java.util.LinkedList;
/*      */ import java.util.List;
/*      */ import java.util.TimeZone;
/*      */ import org.quartz.CronTrigger;
/*      */ import org.quartz.SimpleTrigger;
/*      */ import org.quartz.Trigger;
/*      */ 
/*      */ /** @deprecated */
/*      */ public class TriggerUtils
/*      */ {
/*      */   public static final int SUNDAY = 1;
/*      */   public static final int MONDAY = 2;
/*      */   public static final int TUESDAY = 3;
/*      */   public static final int WEDNESDAY = 4;
/*      */   public static final int THURSDAY = 5;
/*      */   public static final int FRIDAY = 6;
/*      */   public static final int SATURDAY = 7;
/*      */   public static final int LAST_DAY_OF_MONTH = -1;
/*      */   public static final long MILLISECONDS_IN_MINUTE = 60000L;
/*      */   public static final long MILLISECONDS_IN_HOUR = 3600000L;
/*      */   public static final long SECONDS_IN_DAY = 86400L;
/*      */   public static final long MILLISECONDS_IN_DAY = 86400000L;
/*      */ 
/*      */   private static void validateDayOfWeek(int dayOfWeek)
/*      */   {
/*   97 */     if ((dayOfWeek < 1) || (dayOfWeek > 7))
/*   98 */       throw new IllegalArgumentException("Invalid day of week.");
/*      */   }
/*      */ 
/*      */   private static void validateHour(int hour) {
/*  102 */     if ((hour < 0) || (hour > 23))
/*  103 */       throw new IllegalArgumentException("Invalid hour (must be >= 0 and <= 23).");
/*      */   }
/*      */ 
/*      */   private static void validateMinute(int minute)
/*      */   {
/*  108 */     if ((minute < 0) || (minute > 59))
/*  109 */       throw new IllegalArgumentException("Invalid minute (must be >= 0 and <= 59).");
/*      */   }
/*      */ 
/*      */   private static void validateSecond(int second)
/*      */   {
/*  114 */     if ((second < 0) || (second > 59))
/*  115 */       throw new IllegalArgumentException("Invalid second (must be >= 0 and <= 59).");
/*      */   }
/*      */ 
/*      */   private static void validateDayOfMonth(int day)
/*      */   {
/*  120 */     if (((day < 1) || (day > 31)) && (day != -1))
/*  121 */       throw new IllegalArgumentException("Invalid day of month.");
/*      */   }
/*      */ 
/*      */   private static void validateMonth(int month) {
/*  125 */     if ((month < 1) || (month > 12))
/*  126 */       throw new IllegalArgumentException("Invalid month (must be >= 1 and <= 12.");
/*      */   }
/*      */ 
/*      */   private static void validateYear(int year)
/*      */   {
/*  131 */     if ((year < 1970) || (year > 2099))
/*  132 */       throw new IllegalArgumentException("Invalid year (must be >= 1970 and <= 2099.");
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static void setTriggerIdentity(Trigger trig, String name)
/*      */   {
/*  146 */     trig.setName(name);
/*  147 */     trig.setGroup("DEFAULT");
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static void setTriggerIdentity(Trigger trig, String name, String group)
/*      */   {
/*  161 */     trig.setName(name);
/*  162 */     trig.setGroup(group);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeDailyTrigger(int hour, int minute)
/*      */   {
/*  184 */     validateHour(hour);
/*  185 */     validateMinute(minute);
/*      */ 
/*  187 */     CronTrigger trig = new CronTrigger();
/*      */     try
/*      */     {
/*  190 */       trig.setCronExpression("0 " + minute + " " + hour + " ? * *");
/*      */     } catch (Exception ignore) {
/*  192 */       return null;
/*      */     }
/*      */ 
/*  195 */     return trig;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeWeeklyTrigger(int dayOfWeek, int hour, int minute)
/*      */   {
/*  227 */     validateDayOfWeek(dayOfWeek);
/*  228 */     validateHour(hour);
/*  229 */     validateMinute(minute);
/*      */ 
/*  231 */     CronTrigger trig = new CronTrigger();
/*      */     try
/*      */     {
/*  234 */       trig.setCronExpression("0 " + minute + " " + hour + " ? * " + dayOfWeek);
/*      */     }
/*      */     catch (Exception ignore) {
/*  237 */       return null;
/*      */     }
/*      */ 
/*  240 */     return trig;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeMonthlyTrigger(int dayOfMonth, int hour, int minute)
/*      */   {
/*  272 */     validateDayOfMonth(dayOfMonth);
/*  273 */     validateHour(hour);
/*  274 */     validateMinute(minute);
/*      */ 
/*  276 */     CronTrigger trig = new CronTrigger();
/*      */     try
/*      */     {
/*  279 */       if (dayOfMonth != -1) trig.setCronExpression("0 " + minute + " " + hour + " " + dayOfMonth + " * ?");
/*      */       else
/*      */       {
/*  282 */         trig.setCronExpression("0 " + minute + " " + hour + " L * ?");
/*      */       }
/*      */     } catch (Exception ignore) {
/*  284 */       return null;
/*      */     }
/*      */ 
/*  287 */     return trig;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeSecondlyTrigger()
/*      */   {
/*  325 */     return makeSecondlyTrigger(1, SimpleTrigger.REPEAT_INDEFINITELY);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeSecondlyTrigger(int intervalInSeconds)
/*      */   {
/*  345 */     return makeSecondlyTrigger(intervalInSeconds, SimpleTrigger.REPEAT_INDEFINITELY);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeSecondlyTrigger(int intervalInSeconds, int repeatCount)
/*      */   {
/*  370 */     SimpleTrigger trig = new SimpleTrigger();
/*      */ 
/*  372 */     trig.setRepeatInterval(intervalInSeconds * 1000L);
/*  373 */     trig.setRepeatCount(repeatCount);
/*      */ 
/*  375 */     return trig;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeMinutelyTrigger()
/*      */   {
/*  393 */     return makeMinutelyTrigger(1, SimpleTrigger.REPEAT_INDEFINITELY);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeMinutelyTrigger(int intervalInMinutes)
/*      */   {
/*  413 */     return makeMinutelyTrigger(intervalInMinutes, SimpleTrigger.REPEAT_INDEFINITELY);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeMinutelyTrigger(int intervalInMinutes, int repeatCount)
/*      */   {
/*  438 */     SimpleTrigger trig = new SimpleTrigger();
/*      */ 
/*  440 */     trig.setRepeatInterval(intervalInMinutes * 60000L);
/*  441 */     trig.setRepeatCount(repeatCount);
/*      */ 
/*  443 */     return trig;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeHourlyTrigger()
/*      */   {
/*  461 */     return makeHourlyTrigger(1, SimpleTrigger.REPEAT_INDEFINITELY);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeHourlyTrigger(int intervalInHours)
/*      */   {
/*  481 */     return makeHourlyTrigger(intervalInHours, SimpleTrigger.REPEAT_INDEFINITELY);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Trigger makeHourlyTrigger(int intervalInHours, int repeatCount)
/*      */   {
/*  505 */     SimpleTrigger trig = new SimpleTrigger();
/*      */ 
/*  507 */     trig.setRepeatInterval(intervalInHours * 3600000L);
/*  508 */     trig.setRepeatCount(repeatCount);
/*      */ 
/*  510 */     return trig;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date getEvenHourDate(Date date)
/*      */   {
/*  533 */     if (date == null) date = new Date();
/*      */ 
/*  535 */     java.util.Calendar c = java.util.Calendar.getInstance();
/*  536 */     c.setTime(date);
/*  537 */     c.setLenient(true);
/*      */ 
/*  539 */     c.set(11, c.get(11) + 1);
/*  540 */     c.set(12, 0);
/*  541 */     c.set(13, 0);
/*  542 */     c.set(14, 0);
/*      */ 
/*  544 */     return c.getTime();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date getEvenHourDateBefore(Date date)
/*      */   {
/*  566 */     if (date == null) date = new Date();
/*      */ 
/*  568 */     java.util.Calendar c = java.util.Calendar.getInstance();
/*  569 */     c.setTime(date);
/*      */ 
/*  571 */     c.set(12, 0);
/*  572 */     c.set(13, 0);
/*  573 */     c.set(14, 0);
/*      */ 
/*  575 */     return c.getTime();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date getEvenMinuteDate(Date date)
/*      */   {
/*  598 */     if (date == null) date = new Date();
/*      */ 
/*  600 */     java.util.Calendar c = java.util.Calendar.getInstance();
/*  601 */     c.setTime(date);
/*  602 */     c.setLenient(true);
/*      */ 
/*  604 */     c.set(12, c.get(12) + 1);
/*  605 */     c.set(13, 0);
/*  606 */     c.set(14, 0);
/*      */ 
/*  608 */     return c.getTime();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date getEvenMinuteDateBefore(Date date)
/*      */   {
/*  630 */     if (date == null) date = new Date();
/*      */ 
/*  632 */     java.util.Calendar c = java.util.Calendar.getInstance();
/*  633 */     c.setTime(date);
/*      */ 
/*  635 */     c.set(13, 0);
/*  636 */     c.set(14, 0);
/*      */ 
/*  638 */     return c.getTime();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date getEvenSecondDate(Date date)
/*      */   {
/*  655 */     if (date == null) date = new Date();
/*      */ 
/*  657 */     java.util.Calendar c = java.util.Calendar.getInstance();
/*  658 */     c.setTime(date);
/*  659 */     c.setLenient(true);
/*      */ 
/*  661 */     c.set(13, c.get(13) + 1);
/*  662 */     c.set(14, 0);
/*      */ 
/*  664 */     return c.getTime();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date getEvenSecondDateBefore(Date date)
/*      */   {
/*  686 */     if (date == null) date = new Date();
/*      */ 
/*  688 */     java.util.Calendar c = java.util.Calendar.getInstance();
/*  689 */     c.setTime(date);
/*      */ 
/*  691 */     c.set(14, 0);
/*      */ 
/*  693 */     return c.getTime();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date getNextGivenMinuteDate(Date date, int minuteBase)
/*      */   {
/*  792 */     if ((minuteBase < 0) || (minuteBase > 59)) {
/*  793 */       throw new IllegalArgumentException("minuteBase must be >=0 and <= 59");
/*      */     }
/*      */ 
/*  796 */     if (date == null) date = new Date();
/*      */ 
/*  798 */     java.util.Calendar c = java.util.Calendar.getInstance();
/*  799 */     c.setTime(date);
/*  800 */     c.setLenient(true);
/*      */ 
/*  802 */     if (minuteBase == 0) {
/*  803 */       c.set(11, c.get(11) + 1);
/*  804 */       c.set(12, 0);
/*  805 */       c.set(13, 0);
/*  806 */       c.set(14, 0);
/*      */ 
/*  808 */       return c.getTime();
/*      */     }
/*      */ 
/*  811 */     int minute = c.get(12);
/*      */ 
/*  813 */     int arItr = minute / minuteBase;
/*      */ 
/*  815 */     int nextMinuteOccurance = minuteBase * (arItr + 1);
/*      */ 
/*  817 */     if (nextMinuteOccurance < 60) {
/*  818 */       c.set(12, nextMinuteOccurance);
/*  819 */       c.set(13, 0);
/*  820 */       c.set(14, 0);
/*      */ 
/*  822 */       return c.getTime();
/*      */     }
/*  824 */     c.set(11, c.get(11) + 1);
/*  825 */     c.set(12, 0);
/*  826 */     c.set(13, 0);
/*  827 */     c.set(14, 0);
/*      */ 
/*  829 */     return c.getTime();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date getNextGivenSecondDate(Date date, int secondBase)
/*      */   {
/*  853 */     if ((secondBase < 0) || (secondBase > 59)) {
/*  854 */       throw new IllegalArgumentException("secondBase must be >=0 and <= 59");
/*      */     }
/*      */ 
/*  857 */     if (date == null) date = new Date();
/*      */ 
/*  859 */     java.util.Calendar c = java.util.Calendar.getInstance();
/*  860 */     c.setTime(date);
/*  861 */     c.setLenient(true);
/*      */ 
/*  863 */     if (secondBase == 0) {
/*  864 */       c.set(12, c.get(12) + 1);
/*  865 */       c.set(13, 0);
/*  866 */       c.set(14, 0);
/*      */ 
/*  868 */       return c.getTime();
/*      */     }
/*      */ 
/*  871 */     int second = c.get(13);
/*      */ 
/*  873 */     int arItr = second / secondBase;
/*      */ 
/*  875 */     int nextSecondOccurance = secondBase * (arItr + 1);
/*      */ 
/*  877 */     if (nextSecondOccurance < 60) {
/*  878 */       c.set(13, nextSecondOccurance);
/*  879 */       c.set(14, 0);
/*      */ 
/*  881 */       return c.getTime();
/*      */     }
/*  883 */     c.set(12, c.get(12) + 1);
/*  884 */     c.set(13, 0);
/*  885 */     c.set(14, 0);
/*      */ 
/*  887 */     return c.getTime();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date getDateOf(int second, int minute, int hour)
/*      */   {
/*  908 */     validateSecond(second);
/*  909 */     validateMinute(minute);
/*  910 */     validateHour(hour);
/*      */ 
/*  912 */     Date date = new Date();
/*      */ 
/*  914 */     java.util.Calendar c = java.util.Calendar.getInstance();
/*  915 */     c.setTime(date);
/*  916 */     c.setLenient(true);
/*      */ 
/*  918 */     c.set(11, hour);
/*  919 */     c.set(12, minute);
/*  920 */     c.set(13, second);
/*  921 */     c.set(14, 0);
/*      */ 
/*  923 */     return c.getTime();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date getDateOf(int second, int minute, int hour, int dayOfMonth, int month)
/*      */   {
/*  948 */     validateSecond(second);
/*  949 */     validateMinute(minute);
/*  950 */     validateHour(hour);
/*  951 */     validateDayOfMonth(dayOfMonth);
/*  952 */     validateMonth(month);
/*      */ 
/*  954 */     Date date = new Date();
/*      */ 
/*  956 */     java.util.Calendar c = java.util.Calendar.getInstance();
/*  957 */     c.setTime(date);
/*      */ 
/*  959 */     c.set(2, month - 1);
/*  960 */     c.set(5, dayOfMonth);
/*  961 */     c.set(11, hour);
/*  962 */     c.set(12, minute);
/*  963 */     c.set(13, second);
/*  964 */     c.set(14, 0);
/*      */ 
/*  966 */     return c.getTime();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date getDateOf(int second, int minute, int hour, int dayOfMonth, int month, int year)
/*      */   {
/*  993 */     validateSecond(second);
/*  994 */     validateMinute(minute);
/*  995 */     validateHour(hour);
/*  996 */     validateDayOfMonth(dayOfMonth);
/*  997 */     validateMonth(month);
/*  998 */     validateYear(year);
/*      */ 
/* 1000 */     Date date = new Date();
/*      */ 
/* 1002 */     java.util.Calendar c = java.util.Calendar.getInstance();
/* 1003 */     c.setTime(date);
/*      */ 
/* 1005 */     c.set(1, year);
/* 1006 */     c.set(2, month - 1);
/* 1007 */     c.set(5, dayOfMonth);
/* 1008 */     c.set(11, hour);
/* 1009 */     c.set(12, minute);
/* 1010 */     c.set(13, second);
/* 1011 */     c.set(14, 0);
/*      */ 
/* 1013 */     return c.getTime();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static List computeFireTimes(Trigger trigg, org.quartz.Calendar cal, int numTimes)
/*      */   {
/* 1034 */     LinkedList lst = new LinkedList();
/*      */ 
/* 1036 */     Trigger t = (Trigger)trigg.clone();
/*      */ 
/* 1038 */     if (t.getNextFireTime() == null) {
/* 1039 */       t.computeFirstFireTime(cal);
/*      */     }
/*      */ 
/* 1042 */     for (int i = 0; i < numTimes; i++) {
/* 1043 */       Date d = t.getNextFireTime();
/* 1044 */       if (d == null) break;
/* 1045 */       lst.add(d);
/* 1046 */       t.triggered(cal);
/*      */     }
/*      */ 
/* 1051 */     return Collections.unmodifiableList(lst);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static List computeFireTimesBetween(Trigger trigg, org.quartz.Calendar cal, Date from, Date to)
/*      */   {
/* 1076 */     LinkedList lst = new LinkedList();
/*      */ 
/* 1078 */     Trigger t = (Trigger)trigg.clone();
/*      */ 
/* 1080 */     if (t.getNextFireTime() == null) {
/* 1081 */       t.computeFirstFireTime(cal);
/*      */     }
/*      */ 
/*      */     while (true)
/*      */     {
/* 1087 */       Date d = t.getNextFireTime();
/* 1088 */       if (d == null) break;
/* 1089 */       if (d.before(from)) {
/* 1090 */         t.triggered(cal);
/* 1091 */         continue;
/*      */       }
/* 1093 */       if (d.after(to)) break;
/* 1094 */       lst.add(d);
/* 1095 */       t.triggered(cal);
/*      */     }
/*      */ 
/* 1100 */     return Collections.unmodifiableList(lst);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static Date translateTime(Date date, TimeZone src, TimeZone dest)
/*      */   {
/* 1112 */     Date newDate = new Date();
/*      */ 
/* 1114 */     int offset = getOffset(date.getTime(), dest) - getOffset(date.getTime(), src);
/*      */ 
/* 1116 */     newDate.setTime(date.getTime() - offset);
/*      */ 
/* 1118 */     return newDate;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static int getOffset(long date, TimeZone tz)
/*      */   {
/* 1135 */     if (tz.inDaylightTime(new Date(date))) {
/* 1136 */       return tz.getRawOffset() + getDSTSavings(tz);
/*      */     }
/*      */ 
/* 1139 */     return tz.getRawOffset();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static int getDSTSavings(TimeZone tz)
/*      */   {
/* 1152 */     if (tz.useDaylightTime()) {
/* 1153 */       return 3600000;
/*      */     }
/* 1155 */     return 0;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.helpers.TriggerUtils
 * JD-Core Version:    0.6.0
 */