/*     */ package org.quartz.ee.servlet;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import javax.servlet.ServletConfig;
/*     */ import javax.servlet.ServletContext;
/*     */ import javax.servlet.ServletException;
/*     */ import javax.servlet.http.HttpServlet;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.impl.StdSchedulerFactory;
/*     */ 
/*     */ public class QuartzInitializerServlet extends HttpServlet
/*     */ {
/*     */   public static final String QUARTZ_FACTORY_KEY = "org.quartz.impl.StdSchedulerFactory.KEY";
/* 114 */   private boolean performShutdown = true;
/*     */ 
/* 116 */   private Scheduler scheduler = null;
/*     */ 
/*     */   public void init(ServletConfig cfg)
/*     */     throws ServletException
/*     */   {
/* 127 */     super.init(cfg);
/*     */ 
/* 129 */     log("Quartz Initializer Servlet loaded, initializing Scheduler...");
/*     */     try
/*     */     {
/* 134 */       String configFile = cfg.getInitParameter("config-file");
/* 135 */       String shutdownPref = cfg.getInitParameter("shutdown-on-unload");
/*     */ 
/* 137 */       if (shutdownPref != null)
/* 138 */         this.performShutdown = Boolean.valueOf(shutdownPref).booleanValue();
/*     */       StdSchedulerFactory factory;
/*     */       StdSchedulerFactory factory;
/* 141 */       if (configFile != null)
/* 142 */         factory = new StdSchedulerFactory(configFile);
/*     */       else {
/* 144 */         factory = new StdSchedulerFactory();
/*     */       }
/*     */ 
/* 148 */       String startOnLoad = cfg.getInitParameter("start-scheduler-on-load");
/*     */ 
/* 155 */       if ((startOnLoad == null) || (Boolean.valueOf(startOnLoad).booleanValue()))
/*     */       {
/* 157 */         this.scheduler = factory.getScheduler();
/* 158 */         this.scheduler.start();
/* 159 */         log("Scheduler has been started...");
/*     */       } else {
/* 161 */         log("Scheduler has not been started. Use scheduler.start()");
/*     */       }
/*     */ 
/* 164 */       log("Storing the Quartz Scheduler Factory in the servlet context at key: org.quartz.impl.StdSchedulerFactory.KEY");
/*     */ 
/* 166 */       cfg.getServletContext().setAttribute("org.quartz.impl.StdSchedulerFactory.KEY", factory);
/*     */     }
/*     */     catch (Exception e) {
/* 169 */       log("Quartz Scheduler failed to initialize: " + e.toString());
/* 170 */       throw new ServletException(e);
/*     */     }StdSchedulerFactory factory;
/*     */   }
/*     */ 
/*     */   public void destroy() {
/* 176 */     if (!this.performShutdown)
/* 177 */       return;
/*     */     try
/*     */     {
/* 180 */       if (this.scheduler != null)
/* 181 */         this.scheduler.shutdown();
/*     */     } catch (Exception e) {
/* 183 */       log("Quartz Scheduler failed to shutdown cleanly: " + e.toString());
/* 184 */       e.printStackTrace();
/*     */     }
/*     */ 
/* 187 */     log("Quartz Scheduler successful shutdown.");
/*     */   }
/*     */ 
/*     */   public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
/*     */   {
/* 192 */     response.sendError(403);
/*     */   }
/*     */ 
/*     */   public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
/*     */   {
/* 197 */     response.sendError(403);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.ee.servlet.QuartzInitializerServlet
 * JD-Core Version:    0.6.0
 */