/*     */ package org.quartz.ee.jmx.jboss;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.util.Properties;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.NonSerializableFactory;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerConfigException;
/*     */ import org.quartz.impl.StdSchedulerFactory;
/*     */ 
/*     */ public class QuartzService extends ServiceMBeanSupport
/*     */   implements QuartzServiceMBean
/*     */ {
/*     */   private Properties properties;
/*     */   private StdSchedulerFactory schedulerFactory;
/*     */   private String jndiName;
/*     */   private String propertiesFile;
/*     */   private boolean error;
/*     */   private boolean useProperties;
/*     */   private boolean usePropertiesFile;
/*     */ 
/*     */   public QuartzService()
/*     */   {
/*  84 */     this.error = false;
/*     */ 
/*  87 */     this.usePropertiesFile = false;
/*  88 */     this.propertiesFile = "";
/*     */ 
/*  91 */     this.useProperties = false;
/*  92 */     this.properties = new Properties();
/*     */ 
/*  95 */     this.jndiName = "Quartz";
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */     throws Exception
/*     */   {
/* 107 */     String oldName = this.jndiName;
/* 108 */     this.jndiName = jndiName;
/*     */ 
/* 110 */     if (super.getState() == 3) {
/* 111 */       unbind(oldName);
/*     */       try
/*     */       {
/* 114 */         rebind();
/*     */       } catch (NamingException ne) {
/* 116 */         this.log.error(captureStackTrace(ne));
/*     */ 
/* 118 */         throw new SchedulerConfigException("Failed to rebind Scheduler - ", ne);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 125 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public String getName() {
/* 129 */     return "QuartzService(" + this.jndiName + ")";
/*     */   }
/*     */ 
/*     */   public void setProperties(String properties) {
/* 133 */     if (this.usePropertiesFile) {
/* 134 */       this.log.error("Must specify only one of 'Properties' or 'PropertiesFile'");
/*     */ 
/* 137 */       this.error = true;
/*     */ 
/* 139 */       return;
/*     */     }
/*     */ 
/* 142 */     this.useProperties = true;
/*     */     try
/*     */     {
/* 145 */       ByteArrayInputStream bais = new ByteArrayInputStream(properties.getBytes());
/*     */ 
/* 147 */       this.properties = new Properties();
/* 148 */       this.properties.load(bais);
/*     */     }
/*     */     catch (IOException ioe) {
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getProperties() {
/*     */     try {
/* 156 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 157 */       this.properties.store(baos, "");
/*     */ 
/* 159 */       return new String(baos.toByteArray());
/*     */     } catch (IOException ioe) {
/*     */     }
/* 162 */     return "";
/*     */   }
/*     */ 
/*     */   public void setPropertiesFile(String propertiesFile)
/*     */   {
/* 167 */     if (this.useProperties) {
/* 168 */       this.log.error("Must specify only one of 'Properties' or 'PropertiesFile'");
/*     */ 
/* 171 */       this.error = true;
/*     */ 
/* 173 */       return;
/*     */     }
/*     */ 
/* 176 */     this.usePropertiesFile = true;
/*     */ 
/* 178 */     this.propertiesFile = propertiesFile;
/*     */   }
/*     */ 
/*     */   public String getPropertiesFile() {
/* 182 */     return this.propertiesFile;
/*     */   }
/*     */ 
/*     */   public void createService() throws Exception {
/* 186 */     this.log.info("Create QuartzService(" + this.jndiName + ")...");
/*     */ 
/* 188 */     if (this.error) {
/* 189 */       this.log.error("Must specify only one of 'Properties' or 'PropertiesFile'");
/*     */ 
/* 192 */       throw new Exception("Must specify only one of 'Properties' or 'PropertiesFile'");
/*     */     }
/*     */ 
/* 196 */     this.schedulerFactory = new StdSchedulerFactory();
/*     */     try
/*     */     {
/* 199 */       if (this.useProperties) {
/* 200 */         this.schedulerFactory.initialize(this.properties);
/*     */       }
/*     */ 
/* 203 */       if (this.usePropertiesFile)
/* 204 */         this.schedulerFactory.initialize(this.propertiesFile);
/*     */     }
/*     */     catch (Exception e) {
/* 207 */       this.log.error(captureStackTrace(e));
/*     */ 
/* 209 */       throw new SchedulerConfigException("Failed to initialize Scheduler - ", e);
/*     */     }
/*     */ 
/* 213 */     this.log.info("QuartzService(" + this.jndiName + ") created.");
/*     */   }
/*     */ 
/*     */   public void destroyService() throws Exception {
/* 217 */     this.log.info("Destroy QuartzService(" + this.jndiName + ")...");
/*     */ 
/* 219 */     this.schedulerFactory = null;
/*     */ 
/* 221 */     this.log.info("QuartzService(" + this.jndiName + ") destroyed.");
/*     */   }
/*     */ 
/*     */   public void startService() throws Exception {
/* 225 */     this.log.info("Start QuartzService(" + this.jndiName + ")...");
/*     */     try
/*     */     {
/* 228 */       rebind();
/*     */     } catch (NamingException ne) {
/* 230 */       this.log.error(captureStackTrace(ne));
/*     */ 
/* 232 */       throw new SchedulerConfigException("Failed to rebind Scheduler - ", ne);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 237 */       Scheduler scheduler = this.schedulerFactory.getScheduler();
/*     */ 
/* 239 */       scheduler.start();
/*     */     } catch (Exception e) {
/* 241 */       this.log.error(captureStackTrace(e));
/*     */ 
/* 243 */       throw new SchedulerConfigException("Failed to start Scheduler - ", e);
/*     */     }
/*     */ 
/* 247 */     this.log.info("QuartzService(" + this.jndiName + ") started.");
/*     */   }
/*     */ 
/*     */   public void stopService() throws Exception {
/* 251 */     this.log.info("Stop QuartzService(" + this.jndiName + ")...");
/*     */     try
/*     */     {
/* 254 */       Scheduler scheduler = this.schedulerFactory.getScheduler();
/*     */ 
/* 256 */       scheduler.shutdown();
/*     */     } catch (Exception e) {
/* 258 */       this.log.error(captureStackTrace(e));
/*     */ 
/* 260 */       throw new SchedulerConfigException("Failed to shutdown Scheduler - ");
/*     */     }
/*     */ 
/* 264 */     unbind(this.jndiName);
/*     */ 
/* 266 */     this.log.info("QuartzService(" + this.jndiName + ") stopped.");
/*     */   }
/*     */ 
/*     */   private String captureStackTrace(Throwable throwable) {
/* 270 */     StringWriter sw = new StringWriter();
/* 271 */     throwable.printStackTrace(new PrintWriter(sw, true));
/*     */ 
/* 273 */     return sw.toString();
/*     */   }
/*     */ 
/*     */   private void rebind() throws Exception
/*     */   {
/* 278 */     InitialContext rootCtx = new InitialContext();
/* 279 */     Name fullName = rootCtx.getNameParser("").parse(this.jndiName);
/* 280 */     Scheduler scheduler = this.schedulerFactory.getScheduler();
/* 281 */     NonSerializableFactory.rebind(fullName, scheduler, true);
/*     */   }
/*     */ 
/*     */   private void unbind(String jndiName)
/*     */   {
/*     */     try
/*     */     {
/* 288 */       InitialContext rootCtx = new InitialContext();
/* 289 */       rootCtx.unbind(jndiName);
/* 290 */       NonSerializableFactory.unbind(jndiName);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 294 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.ee.jmx.jboss.QuartzService
 * JD-Core Version:    0.6.0
 */