package org.quartz.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;

public final class QuartzScheduler_Stub extends RemoteStub
  implements RemotableQuartzScheduler
{
  private static final Operation[] operations = { new Operation("void addCalendar(org.quartz.core.SchedulingContext, java.lang.String, org.quartz.Calendar, boolean, boolean)"), new Operation("void addGlobalJobListener(org.quartz.JobListener)"), new Operation("void addGlobalTriggerListener(org.quartz.TriggerListener)"), new Operation("void addJob(org.quartz.core.SchedulingContext, org.quartz.JobDetail, boolean)"), new Operation("void addJobListener(org.quartz.JobListener)"), new Operation("void addSchedulerListener(org.quartz.SchedulerListener)"), new Operation("void addTriggerListener(org.quartz.TriggerListener)"), new Operation("boolean deleteCalendar(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("boolean deleteJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("org.quartz.Calendar getCalendar(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("java.lang.String getCalendarNames(org.quartz.core.SchedulingContext)[]"), new Operation("java.util.List getCurrentlyExecutingJobs()"), new Operation("java.util.List getGlobalJobListeners()"), new Operation("java.util.List getGlobalTriggerListeners()"), new Operation("org.quartz.JobDetail getJobDetail(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("java.lang.String getJobGroupNames(org.quartz.core.SchedulingContext)[]"), new Operation("org.quartz.JobListener getJobListener(java.lang.String)"), new Operation("java.util.Set getJobListenerNames()"), new Operation("java.lang.String getJobNames(org.quartz.core.SchedulingContext, java.lang.String)[]"), new Operation("java.lang.Class getJobStoreClass()"), new Operation("java.util.Set getPausedTriggerGroups(org.quartz.core.SchedulingContext)"), new Operation("org.quartz.SchedulerContext getSchedulerContext()"), new Operation("java.lang.String getSchedulerInstanceId()"), new Operation("java.util.List getSchedulerListeners()"), new Operation("java.lang.String getSchedulerName()"), new Operation("java.lang.Class getThreadPoolClass()"), new Operation("int getThreadPoolSize()"), new Operation("org.quartz.Trigger getTrigger(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("java.lang.String getTriggerGroupNames(org.quartz.core.SchedulingContext)[]"), new Operation("org.quartz.TriggerListener getTriggerListener(java.lang.String)"), new Operation("java.util.Set getTriggerListenerNames()"), new Operation("java.lang.String getTriggerNames(org.quartz.core.SchedulingContext, java.lang.String)[]"), new Operation("int getTriggerState(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("org.quartz.Trigger getTriggersOfJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)[]"), new Operation("java.lang.String getVersion()"), new Operation("boolean interrupt(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("boolean isInStandbyMode()"), new Operation("boolean isShutdown()"), new Operation("int numJobsExecuted()"), new Operation("void pauseAll(org.quartz.core.SchedulingContext)"), new Operation("void pauseJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("void pauseJobGroup(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("void pauseTrigger(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("void pauseTriggerGroup(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("boolean removeGlobalJobListener(org.quartz.JobListener)"), new Operation("boolean removeGlobalTriggerListener(org.quartz.TriggerListener)"), new Operation("boolean removeJobListener(java.lang.String)"), new Operation("boolean removeSchedulerListener(org.quartz.SchedulerListener)"), new Operation("boolean removeTriggerListener(java.lang.String)"), new Operation("java.util.Date rescheduleJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String, org.quartz.Trigger)"), new Operation("void resumeAll(org.quartz.core.SchedulingContext)"), new Operation("void resumeJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("void resumeJobGroup(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("void resumeTrigger(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("void resumeTriggerGroup(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("java.util.Date runningSince()"), new Operation("java.util.Date scheduleJob(org.quartz.core.SchedulingContext, org.quartz.JobDetail, org.quartz.Trigger)"), new Operation("java.util.Date scheduleJob(org.quartz.core.SchedulingContext, org.quartz.Trigger)"), new Operation("void shutdown()"), new Operation("void shutdown(boolean)"), new Operation("void standby()"), new Operation("void start()"), new Operation("boolean supportsPersistence()"), new Operation("void triggerJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String, org.quartz.JobDataMap)"), new Operation("void triggerJobWithVolatileTrigger(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String, org.quartz.JobDataMap)"), new Operation("boolean unscheduleJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)") };
  private static final long interfaceHash = -426943571078592559L;
  private static final long serialVersionUID = 2L;
  private static boolean useNewInvoke;
  private static Method $method_addCalendar_0;
  private static Method $method_addGlobalJobListener_1;
  private static Method $method_addGlobalTriggerListener_2;
  private static Method $method_addJob_3;
  private static Method $method_addJobListener_4;
  private static Method $method_addSchedulerListener_5;
  private static Method $method_addTriggerListener_6;
  private static Method $method_deleteCalendar_7;
  private static Method $method_deleteJob_8;
  private static Method $method_getCalendar_9;
  private static Method $method_getCalendarNames_10;
  private static Method $method_getCurrentlyExecutingJobs_11;
  private static Method $method_getGlobalJobListeners_12;
  private static Method $method_getGlobalTriggerListeners_13;
  private static Method $method_getJobDetail_14;
  private static Method $method_getJobGroupNames_15;
  private static Method $method_getJobListener_16;
  private static Method $method_getJobListenerNames_17;
  private static Method $method_getJobNames_18;
  private static Method $method_getJobStoreClass_19;
  private static Method $method_getPausedTriggerGroups_20;
  private static Method $method_getSchedulerContext_21;
  private static Method $method_getSchedulerInstanceId_22;
  private static Method $method_getSchedulerListeners_23;
  private static Method $method_getSchedulerName_24;
  private static Method $method_getThreadPoolClass_25;
  private static Method $method_getThreadPoolSize_26;
  private static Method $method_getTrigger_27;
  private static Method $method_getTriggerGroupNames_28;
  private static Method $method_getTriggerListener_29;
  private static Method $method_getTriggerListenerNames_30;
  private static Method $method_getTriggerNames_31;
  private static Method $method_getTriggerState_32;
  private static Method $method_getTriggersOfJob_33;
  private static Method $method_getVersion_34;
  private static Method $method_interrupt_35;
  private static Method $method_isInStandbyMode_36;
  private static Method $method_isShutdown_37;
  private static Method $method_numJobsExecuted_38;
  private static Method $method_pauseAll_39;
  private static Method $method_pauseJob_40;
  private static Method $method_pauseJobGroup_41;
  private static Method $method_pauseTrigger_42;
  private static Method $method_pauseTriggerGroup_43;
  private static Method $method_removeGlobalJobListener_44;
  private static Method $method_removeGlobalTriggerListener_45;
  private static Method $method_removeJobListener_46;
  private static Method $method_removeSchedulerListener_47;
  private static Method $method_removeTriggerListener_48;
  private static Method $method_rescheduleJob_49;
  private static Method $method_resumeAll_50;
  private static Method $method_resumeJob_51;
  private static Method $method_resumeJobGroup_52;
  private static Method $method_resumeTrigger_53;
  private static Method $method_resumeTriggerGroup_54;
  private static Method $method_runningSince_55;
  private static Method $method_scheduleJob_56;
  private static Method $method_scheduleJob_57;
  private static Method $method_shutdown_58;
  private static Method $method_shutdown_59;
  private static Method $method_standby_60;
  private static Method $method_start_61;
  private static Method $method_supportsPersistence_62;
  private static Method $method_triggerJob_63;
  private static Method $method_triggerJobWithVolatileTrigger_64;
  private static Method $method_unscheduleJob_65;

  static
  {
    try
    {
      RemoteRef.class.getMethod("invoke", new Class[] { Remote.class, Method.class, new Object[0].getClass(), Long.TYPE });
      useNewInvoke = true;
      $method_addCalendar_0 = RemotableQuartzScheduler.class.getMethod("addCalendar", new Class[] { SchedulingContext.class, String.class, Calendar.class, Boolean.TYPE, Boolean.TYPE });
      $method_addGlobalJobListener_1 = RemotableQuartzScheduler.class.getMethod("addGlobalJobListener", new Class[] { JobListener.class });
      $method_addGlobalTriggerListener_2 = RemotableQuartzScheduler.class.getMethod("addGlobalTriggerListener", new Class[] { TriggerListener.class });
      $method_addJob_3 = RemotableQuartzScheduler.class.getMethod("addJob", new Class[] { SchedulingContext.class, JobDetail.class, Boolean.TYPE });
      $method_addJobListener_4 = RemotableQuartzScheduler.class.getMethod("addJobListener", new Class[] { JobListener.class });
      $method_addSchedulerListener_5 = RemotableQuartzScheduler.class.getMethod("addSchedulerListener", new Class[] { SchedulerListener.class });
      $method_addTriggerListener_6 = RemotableQuartzScheduler.class.getMethod("addTriggerListener", new Class[] { TriggerListener.class });
      $method_deleteCalendar_7 = RemotableQuartzScheduler.class.getMethod("deleteCalendar", new Class[] { SchedulingContext.class, String.class });
      $method_deleteJob_8 = RemotableQuartzScheduler.class.getMethod("deleteJob", new Class[] { SchedulingContext.class, String.class, String.class });
      $method_getCalendar_9 = RemotableQuartzScheduler.class.getMethod("getCalendar", new Class[] { SchedulingContext.class, String.class });
      $method_getCalendarNames_10 = RemotableQuartzScheduler.class.getMethod("getCalendarNames", new Class[] { SchedulingContext.class });
      $method_getCurrentlyExecutingJobs_11 = RemotableQuartzScheduler.class.getMethod("getCurrentlyExecutingJobs", new Class[0]);
      $method_getGlobalJobListeners_12 = RemotableQuartzScheduler.class.getMethod("getGlobalJobListeners", new Class[0]);
      $method_getGlobalTriggerListeners_13 = RemotableQuartzScheduler.class.getMethod("getGlobalTriggerListeners", new Class[0]);
      $method_getJobDetail_14 = RemotableQuartzScheduler.class.getMethod("getJobDetail", new Class[] { SchedulingContext.class, String.class, String.class });
      $method_getJobGroupNames_15 = RemotableQuartzScheduler.class.getMethod("getJobGroupNames", new Class[] { SchedulingContext.class });
      $method_getJobListener_16 = RemotableQuartzScheduler.class.getMethod("getJobListener", new Class[] { String.class });
      $method_getJobListenerNames_17 = RemotableQuartzScheduler.class.getMethod("getJobListenerNames", new Class[0]);
      $method_getJobNames_18 = RemotableQuartzScheduler.class.getMethod("getJobNames", new Class[] { SchedulingContext.class, String.class });
      $method_getJobStoreClass_19 = RemotableQuartzScheduler.class.getMethod("getJobStoreClass", new Class[0]);
      $method_getPausedTriggerGroups_20 = RemotableQuartzScheduler.class.getMethod("getPausedTriggerGroups", new Class[] { SchedulingContext.class });
      $method_getSchedulerContext_21 = RemotableQuartzScheduler.class.getMethod("getSchedulerContext", new Class[0]);
      $method_getSchedulerInstanceId_22 = RemotableQuartzScheduler.class.getMethod("getSchedulerInstanceId", new Class[0]);
      $method_getSchedulerListeners_23 = RemotableQuartzScheduler.class.getMethod("getSchedulerListeners", new Class[0]);
      $method_getSchedulerName_24 = RemotableQuartzScheduler.class.getMethod("getSchedulerName", new Class[0]);
      $method_getThreadPoolClass_25 = RemotableQuartzScheduler.class.getMethod("getThreadPoolClass", new Class[0]);
      $method_getThreadPoolSize_26 = RemotableQuartzScheduler.class.getMethod("getThreadPoolSize", new Class[0]);
      $method_getTrigger_27 = RemotableQuartzScheduler.class.getMethod("getTrigger", new Class[] { SchedulingContext.class, String.class, String.class });
      $method_getTriggerGroupNames_28 = RemotableQuartzScheduler.class.getMethod("getTriggerGroupNames", new Class[] { SchedulingContext.class });
      $method_getTriggerListener_29 = RemotableQuartzScheduler.class.getMethod("getTriggerListener", new Class[] { String.class });
      $method_getTriggerListenerNames_30 = RemotableQuartzScheduler.class.getMethod("getTriggerListenerNames", new Class[0]);
      $method_getTriggerNames_31 = RemotableQuartzScheduler.class.getMethod("getTriggerNames", new Class[] { SchedulingContext.class, String.class });
      $method_getTriggerState_32 = RemotableQuartzScheduler.class.getMethod("getTriggerState", new Class[] { SchedulingContext.class, String.class, String.class });
      $method_getTriggersOfJob_33 = RemotableQuartzScheduler.class.getMethod("getTriggersOfJob", new Class[] { SchedulingContext.class, String.class, String.class });
      $method_getVersion_34 = RemotableQuartzScheduler.class.getMethod("getVersion", new Class[0]);
      $method_interrupt_35 = RemotableQuartzScheduler.class.getMethod("interrupt", new Class[] { SchedulingContext.class, String.class, String.class });
      $method_isInStandbyMode_36 = RemotableQuartzScheduler.class.getMethod("isInStandbyMode", new Class[0]);
      $method_isShutdown_37 = RemotableQuartzScheduler.class.getMethod("isShutdown", new Class[0]);
      $method_numJobsExecuted_38 = RemotableQuartzScheduler.class.getMethod("numJobsExecuted", new Class[0]);
      $method_pauseAll_39 = RemotableQuartzScheduler.class.getMethod("pauseAll", new Class[] { SchedulingContext.class });
      $method_pauseJob_40 = RemotableQuartzScheduler.class.getMethod("pauseJob", new Class[] { SchedulingContext.class, String.class, String.class });
      $method_pauseJobGroup_41 = RemotableQuartzScheduler.class.getMethod("pauseJobGroup", new Class[] { SchedulingContext.class, String.class });
      $method_pauseTrigger_42 = RemotableQuartzScheduler.class.getMethod("pauseTrigger", new Class[] { SchedulingContext.class, String.class, String.class });
      $method_pauseTriggerGroup_43 = RemotableQuartzScheduler.class.getMethod("pauseTriggerGroup", new Class[] { SchedulingContext.class, String.class });
      $method_removeGlobalJobListener_44 = RemotableQuartzScheduler.class.getMethod("removeGlobalJobListener", new Class[] { JobListener.class });
      $method_removeGlobalTriggerListener_45 = RemotableQuartzScheduler.class.getMethod("removeGlobalTriggerListener", new Class[] { TriggerListener.class });
      $method_removeJobListener_46 = RemotableQuartzScheduler.class.getMethod("removeJobListener", new Class[] { String.class });
      $method_removeSchedulerListener_47 = RemotableQuartzScheduler.class.getMethod("removeSchedulerListener", new Class[] { SchedulerListener.class });
      $method_removeTriggerListener_48 = RemotableQuartzScheduler.class.getMethod("removeTriggerListener", new Class[] { String.class });
      $method_rescheduleJob_49 = RemotableQuartzScheduler.class.getMethod("rescheduleJob", new Class[] { SchedulingContext.class, String.class, String.class, Trigger.class });
      $method_resumeAll_50 = RemotableQuartzScheduler.class.getMethod("resumeAll", new Class[] { SchedulingContext.class });
      $method_resumeJob_51 = RemotableQuartzScheduler.class.getMethod("resumeJob", new Class[] { SchedulingContext.class, String.class, String.class });
      $method_resumeJobGroup_52 = RemotableQuartzScheduler.class.getMethod("resumeJobGroup", new Class[] { SchedulingContext.class, String.class });
      $method_resumeTrigger_53 = RemotableQuartzScheduler.class.getMethod("resumeTrigger", new Class[] { SchedulingContext.class, String.class, String.class });
      $method_resumeTriggerGroup_54 = RemotableQuartzScheduler.class.getMethod("resumeTriggerGroup", new Class[] { SchedulingContext.class, String.class });
      $method_runningSince_55 = RemotableQuartzScheduler.class.getMethod("runningSince", new Class[0]);
      $method_scheduleJob_56 = RemotableQuartzScheduler.class.getMethod("scheduleJob", new Class[] { SchedulingContext.class, JobDetail.class, Trigger.class });
      $method_scheduleJob_57 = RemotableQuartzScheduler.class.getMethod("scheduleJob", new Class[] { SchedulingContext.class, Trigger.class });
      $method_shutdown_58 = RemotableQuartzScheduler.class.getMethod("shutdown", new Class[0]);
      $method_shutdown_59 = RemotableQuartzScheduler.class.getMethod("shutdown", new Class[] { Boolean.TYPE });
      $method_standby_60 = RemotableQuartzScheduler.class.getMethod("standby", new Class[0]);
      $method_start_61 = RemotableQuartzScheduler.class.getMethod("start", new Class[0]);
      $method_supportsPersistence_62 = RemotableQuartzScheduler.class.getMethod("supportsPersistence", new Class[0]);
      $method_triggerJob_63 = RemotableQuartzScheduler.class.getMethod("triggerJob", new Class[] { SchedulingContext.class, String.class, String.class, JobDataMap.class });
      $method_triggerJobWithVolatileTrigger_64 = RemotableQuartzScheduler.class.getMethod("triggerJobWithVolatileTrigger", new Class[] { SchedulingContext.class, String.class, String.class, JobDataMap.class });
      $method_unscheduleJob_65 = RemotableQuartzScheduler.class.getMethod("unscheduleJob", new Class[] { SchedulingContext.class, String.class, String.class });
    }
    catch (NoSuchMethodException localNoSuchMethodException)
    {
      useNewInvoke = false;
    }
  }

  public QuartzScheduler_Stub()
  {
  }

  public QuartzScheduler_Stub(RemoteRef paramRemoteRef)
  {
    super(paramRemoteRef);
  }

  public void addCalendar(SchedulingContext paramSchedulingContext, String paramString, Calendar paramCalendar, boolean paramBoolean1, boolean paramBoolean2)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_addCalendar_0, new Object[] { paramSchedulingContext, paramString, paramCalendar, new Boolean(paramBoolean1), new Boolean(paramBoolean2) }, 7877410577445016705L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 0, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramString);
          localObjectOutput.writeObject(paramCalendar);
          localObjectOutput.writeBoolean(paramBoolean1);
          localObjectOutput.writeBoolean(paramBoolean2);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void addGlobalJobListener(JobListener paramJobListener)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_addGlobalJobListener_1, new Object[] { paramJobListener }, -6041517808460841247L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 1, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramJobListener);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void addGlobalTriggerListener(TriggerListener paramTriggerListener)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_addGlobalTriggerListener_2, new Object[] { paramTriggerListener }, -8640695946527295764L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 2, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramTriggerListener);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void addJob(SchedulingContext paramSchedulingContext, JobDetail paramJobDetail, boolean paramBoolean)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_addJob_3, new Object[] { paramSchedulingContext, paramJobDetail, new Boolean(paramBoolean) }, -4297726825849051791L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 3, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramJobDetail);
          localObjectOutput.writeBoolean(paramBoolean);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void addJobListener(JobListener paramJobListener)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_addJobListener_4, new Object[] { paramJobListener }, 2426087316584382316L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 4, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramJobListener);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void addSchedulerListener(SchedulerListener paramSchedulerListener)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_addSchedulerListener_5, new Object[] { paramSchedulerListener }, -5353439874786710385L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 5, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulerListener);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void addTriggerListener(TriggerListener paramTriggerListener)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_addTriggerListener_6, new Object[] { paramTriggerListener }, -1282295024260163224L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 6, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramTriggerListener);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public boolean deleteCalendar(SchedulingContext paramSchedulingContext, String paramString)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_deleteCalendar_7, new Object[] { paramSchedulingContext, paramString }, 2032298556184576237L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 7, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public boolean deleteJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_deleteJob_8, new Object[] { paramSchedulingContext, paramString1, paramString2 }, 4168665377724210756L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 8, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString1);
        localObjectOutput.writeObject(paramString2);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public Calendar getCalendar(SchedulingContext paramSchedulingContext, String paramString)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getCalendar_9, new Object[] { paramSchedulingContext, paramString }, -10248060608263696L);
        return (Calendar)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 9, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      Calendar localCalendar;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localCalendar = (Calendar)localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localCalendar;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public String[] getCalendarNames(SchedulingContext paramSchedulingContext)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getCalendarNames_10, new Object[] { paramSchedulingContext }, -6682625582061442910L);
        return (String[])localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 10, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      String[] arrayOfString;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        arrayOfString = (String[])localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return arrayOfString;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public List getCurrentlyExecutingJobs()
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getCurrentlyExecutingJobs_11, null, 5767551841304860517L);
        return (List)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 11, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      List localList;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localList = (List)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localList;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public List getGlobalJobListeners()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getGlobalJobListeners_12, null, 673892492619661816L);
        return (List)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 12, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      List localList;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localList = (List)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localList;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public List getGlobalTriggerListeners()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getGlobalTriggerListeners_13, null, -8753723098388680500L);
        return (List)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 13, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      List localList;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localList = (List)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localList;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public JobDetail getJobDetail(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getJobDetail_14, new Object[] { paramSchedulingContext, paramString1, paramString2 }, 1526724571948603194L);
        return (JobDetail)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 14, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString1);
        localObjectOutput.writeObject(paramString2);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      JobDetail localJobDetail;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localJobDetail = (JobDetail)localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localJobDetail;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public String[] getJobGroupNames(SchedulingContext paramSchedulingContext)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getJobGroupNames_15, new Object[] { paramSchedulingContext }, -1825157456250210748L);
        return (String[])localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 15, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      String[] arrayOfString;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        arrayOfString = (String[])localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return arrayOfString;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public JobListener getJobListener(String paramString)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getJobListener_16, new Object[] { paramString }, 5473249512736598697L);
        return (JobListener)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 16, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramString);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      JobListener localJobListener;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localJobListener = (JobListener)localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localJobListener;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public Set getJobListenerNames()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getJobListenerNames_17, null, -7990922162145169540L);
        return (Set)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 17, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      Set localSet;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localSet = (Set)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localSet;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public String[] getJobNames(SchedulingContext paramSchedulingContext, String paramString)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getJobNames_18, new Object[] { paramSchedulingContext, paramString }, 1858655376871511804L);
        return (String[])localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 18, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      String[] arrayOfString;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        arrayOfString = (String[])localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return arrayOfString;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public Class getJobStoreClass()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getJobStoreClass_19, null, 6705397913929502666L);
        return (Class)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 19, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      Class localClass;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localClass = (Class)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localClass;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public Set getPausedTriggerGroups(SchedulingContext paramSchedulingContext)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getPausedTriggerGroups_20, new Object[] { paramSchedulingContext }, -2879840167355937712L);
        return (Set)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 20, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      Set localSet;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localSet = (Set)localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localSet;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public SchedulerContext getSchedulerContext()
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getSchedulerContext_21, null, 2814359591403475563L);
        return (SchedulerContext)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 21, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      SchedulerContext localSchedulerContext;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localSchedulerContext = (SchedulerContext)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localSchedulerContext;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public String getSchedulerInstanceId()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getSchedulerInstanceId_22, null, -2454925768252868567L);
        return (String)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 22, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      String str;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        str = (String)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return str;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public List getSchedulerListeners()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getSchedulerListeners_23, null, 8248801052666236332L);
        return (List)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 23, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      List localList;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localList = (List)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localList;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public String getSchedulerName()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getSchedulerName_24, null, 1038196595245667445L);
        return (String)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 24, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      String str;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        str = (String)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return str;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public Class getThreadPoolClass()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getThreadPoolClass_25, null, -706336661940287388L);
        return (Class)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 25, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      Class localClass;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localClass = (Class)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localClass;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public int getThreadPoolSize()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getThreadPoolSize_26, null, 6528392066641712137L);
        return ((Integer)localObject1).intValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 26, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      int i;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        i = localObjectInput.readInt();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return i;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public Trigger getTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getTrigger_27, new Object[] { paramSchedulingContext, paramString1, paramString2 }, 9028403249244762358L);
        return (Trigger)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 27, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString1);
        localObjectOutput.writeObject(paramString2);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      Trigger localTrigger;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localTrigger = (Trigger)localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localTrigger;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public String[] getTriggerGroupNames(SchedulingContext paramSchedulingContext)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getTriggerGroupNames_28, new Object[] { paramSchedulingContext }, -8434571962701082662L);
        return (String[])localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 28, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      String[] arrayOfString;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        arrayOfString = (String[])localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return arrayOfString;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public TriggerListener getTriggerListener(String paramString)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getTriggerListener_29, new Object[] { paramString }, 8731987467532226032L);
        return (TriggerListener)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 29, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramString);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      TriggerListener localTriggerListener;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localTriggerListener = (TriggerListener)localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localTriggerListener;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public Set getTriggerListenerNames()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getTriggerListenerNames_30, null, 7833515964595158714L);
        return (Set)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 30, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      Set localSet;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localSet = (Set)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localSet;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public String[] getTriggerNames(SchedulingContext paramSchedulingContext, String paramString)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getTriggerNames_31, new Object[] { paramSchedulingContext, paramString }, -2884522838858275815L);
        return (String[])localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 31, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      String[] arrayOfString;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        arrayOfString = (String[])localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return arrayOfString;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public int getTriggerState(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getTriggerState_32, new Object[] { paramSchedulingContext, paramString1, paramString2 }, 7113203090429654348L);
        return ((Integer)localObject1).intValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 32, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString1);
        localObjectOutput.writeObject(paramString2);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      int i;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        i = localObjectInput.readInt();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return i;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public Trigger[] getTriggersOfJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getTriggersOfJob_33, new Object[] { paramSchedulingContext, paramString1, paramString2 }, -8009982909598772742L);
        return (Trigger[])localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 33, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString1);
        localObjectOutput.writeObject(paramString2);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      Trigger[] arrayOfTrigger;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        arrayOfTrigger = (Trigger[])localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return arrayOfTrigger;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public String getVersion()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_getVersion_34, null, -8081107751519807347L);
        return (String)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 34, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      String str;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        str = (String)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return str;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public boolean interrupt(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws RemoteException, UnableToInterruptJobException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_interrupt_35, new Object[] { paramSchedulingContext, paramString1, paramString2 }, -7290260908606214465L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 35, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString1);
        localObjectOutput.writeObject(paramString2);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (UnableToInterruptJobException localUnableToInterruptJobException)
    {
      throw localUnableToInterruptJobException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public boolean isInStandbyMode()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_isInStandbyMode_36, null, 809977841435240287L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 36, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public boolean isShutdown()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_isShutdown_37, null, 6424449119484905518L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 37, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public int numJobsExecuted()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_numJobsExecuted_38, null, 3699847707830503805L);
        return ((Integer)localObject1).intValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 38, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      int i;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        i = localObjectInput.readInt();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return i;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public void pauseAll(SchedulingContext paramSchedulingContext)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_pauseAll_39, new Object[] { paramSchedulingContext }, 7610858889894251336L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 39, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void pauseJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_pauseJob_40, new Object[] { paramSchedulingContext, paramString1, paramString2 }, 457226404522509022L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 40, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramString1);
          localObjectOutput.writeObject(paramString2);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void pauseJobGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_pauseJobGroup_41, new Object[] { paramSchedulingContext, paramString }, 494589007973942166L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 41, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramString);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void pauseTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_pauseTrigger_42, new Object[] { paramSchedulingContext, paramString1, paramString2 }, -5185189284912572184L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 42, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramString1);
          localObjectOutput.writeObject(paramString2);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void pauseTriggerGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_pauseTriggerGroup_43, new Object[] { paramSchedulingContext, paramString }, -7240210608959627830L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 43, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramString);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public boolean removeGlobalJobListener(JobListener paramJobListener)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_removeGlobalJobListener_44, new Object[] { paramJobListener }, -7798731862695006935L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 44, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramJobListener);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public boolean removeGlobalTriggerListener(TriggerListener paramTriggerListener)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_removeGlobalTriggerListener_45, new Object[] { paramTriggerListener }, -1342125205976373432L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 45, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramTriggerListener);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public boolean removeJobListener(String paramString)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_removeJobListener_46, new Object[] { paramString }, -1791615026186070730L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 46, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramString);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public boolean removeSchedulerListener(SchedulerListener paramSchedulerListener)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_removeSchedulerListener_47, new Object[] { paramSchedulerListener }, -1142568476223351084L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 47, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulerListener);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public boolean removeTriggerListener(String paramString)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_removeTriggerListener_48, new Object[] { paramString }, 6164681776053435325L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 48, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramString);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public Date rescheduleJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2, Trigger paramTrigger)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_rescheduleJob_49, new Object[] { paramSchedulingContext, paramString1, paramString2, paramTrigger }, -703684548061517373L);
        return (Date)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 49, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString1);
        localObjectOutput.writeObject(paramString2);
        localObjectOutput.writeObject(paramTrigger);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      Date localDate;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localDate = (Date)localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localDate;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public void resumeAll(SchedulingContext paramSchedulingContext)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_resumeAll_50, new Object[] { paramSchedulingContext }, -8589950808160578625L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 50, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void resumeJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_resumeJob_51, new Object[] { paramSchedulingContext, paramString1, paramString2 }, -5716727411566322179L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 51, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramString1);
          localObjectOutput.writeObject(paramString2);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void resumeJobGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_resumeJobGroup_52, new Object[] { paramSchedulingContext, paramString }, 315342150948211927L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 52, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramString);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void resumeTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_resumeTrigger_53, new Object[] { paramSchedulingContext, paramString1, paramString2 }, 2820522932412169300L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 53, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramString1);
          localObjectOutput.writeObject(paramString2);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void resumeTriggerGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_resumeTriggerGroup_54, new Object[] { paramSchedulingContext, paramString }, 1070390834921208886L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 54, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramString);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public Date runningSince()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_runningSince_55, null, -1739625058868381113L);
        return (Date)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 55, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      Date localDate;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localDate = (Date)localObjectInput.readObject();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localDate;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public Date scheduleJob(SchedulingContext paramSchedulingContext, JobDetail paramJobDetail, Trigger paramTrigger)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_scheduleJob_56, new Object[] { paramSchedulingContext, paramJobDetail, paramTrigger }, 7479428518730356220L);
        return (Date)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 56, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramJobDetail);
        localObjectOutput.writeObject(paramTrigger);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      Date localDate;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localDate = (Date)localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localDate;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public Date scheduleJob(SchedulingContext paramSchedulingContext, Trigger paramTrigger)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_scheduleJob_57, new Object[] { paramSchedulingContext, paramTrigger }, 684430237226999070L);
        return (Date)localObject1;
      }
      Object localObject1 = this.ref.newCall(this, operations, 57, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramTrigger);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      Date localDate;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        localDate = (Date)localObjectInput.readObject();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new UnmarshalException("error unmarshalling return", localClassNotFoundException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return localDate;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public void shutdown()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_shutdown_58, null, -7207851917985848402L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 58, -426943571078592559L);
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void shutdown(boolean paramBoolean)
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_shutdown_59, new Object[] { new Boolean(paramBoolean) }, -7158426071079062438L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 59, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeBoolean(paramBoolean);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void standby()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_standby_60, null, 7161048918451732526L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 60, -426943571078592559L);
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void start()
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_start_61, null, -8025343665958530775L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 61, -426943571078592559L);
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public boolean supportsPersistence()
    throws RemoteException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_supportsPersistence_62, null, -5767630451452602400L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 62, -426943571078592559L);
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }

  public void triggerJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2, JobDataMap paramJobDataMap)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_triggerJob_63, new Object[] { paramSchedulingContext, paramString1, paramString2, paramJobDataMap }, 8046579710400247221L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 63, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramString1);
          localObjectOutput.writeObject(paramString2);
          localObjectOutput.writeObject(paramJobDataMap);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public void triggerJobWithVolatileTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2, JobDataMap paramJobDataMap)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        this.ref.invoke(this, $method_triggerJobWithVolatileTrigger_64, new Object[] { paramSchedulingContext, paramString1, paramString2, paramJobDataMap }, -2523046364662965662L);
      }
      else
      {
        RemoteCall localRemoteCall = this.ref.newCall(this, operations, 64, -426943571078592559L);
        try
        {
          ObjectOutput localObjectOutput = localRemoteCall.getOutputStream();
          localObjectOutput.writeObject(paramSchedulingContext);
          localObjectOutput.writeObject(paramString1);
          localObjectOutput.writeObject(paramString2);
          localObjectOutput.writeObject(paramJobDataMap);
        }
        catch (IOException localIOException)
        {
          throw new MarshalException("error marshalling arguments", localIOException);
        }
        this.ref.invoke(localRemoteCall);
        this.ref.done(localRemoteCall);
      }
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
      throw new UnexpectedException("undeclared checked exception", localException);
    }
  }

  public boolean unscheduleJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws RemoteException, SchedulerException
  {
    try
    {
      if (useNewInvoke)
      {
        localObject1 = this.ref.invoke(this, $method_unscheduleJob_65, new Object[] { paramSchedulingContext, paramString1, paramString2 }, -4730547894112448329L);
        return ((Boolean)localObject1).booleanValue();
      }
      Object localObject1 = this.ref.newCall(this, operations, 65, -426943571078592559L);
      try
      {
        ObjectOutput localObjectOutput = ((RemoteCall)localObject1).getOutputStream();
        localObjectOutput.writeObject(paramSchedulingContext);
        localObjectOutput.writeObject(paramString1);
        localObjectOutput.writeObject(paramString2);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling arguments", localIOException1);
      }
      this.ref.invoke((RemoteCall)localObject1);
      boolean bool;
      try
      {
        ObjectInput localObjectInput = ((RemoteCall)localObject1).getInputStream();
        bool = localObjectInput.readBoolean();
      }
      catch (IOException localIOException2)
      {
        throw new UnmarshalException("error unmarshalling return", localIOException2);
      }
      finally
      {
        this.ref.done((RemoteCall)localObject1);
      }
      return bool;
    }
    catch (RuntimeException localRuntimeException)
    {
      throw localRuntimeException;
    }
    catch (RemoteException localRemoteException)
    {
      throw localRemoteException;
    }
    catch (SchedulerException localSchedulerException)
    {
      throw localSchedulerException;
    }
    catch (Exception localException)
    {
    }
    throw new UnexpectedException("undeclared checked exception", localException);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.core.QuartzScheduler_Stub
 * JD-Core Version:    0.6.0
 */