package org.quartz.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonMismatchException;
import java.util.Date;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

public final class QuartzScheduler_Skel
  implements Skeleton
{
  private static final Operation[] operations = { new Operation("void addCalendar(org.quartz.core.SchedulingContext, java.lang.String, org.quartz.Calendar, boolean, boolean)"), new Operation("void addGlobalJobListener(org.quartz.JobListener)"), new Operation("void addGlobalTriggerListener(org.quartz.TriggerListener)"), new Operation("void addJob(org.quartz.core.SchedulingContext, org.quartz.JobDetail, boolean)"), new Operation("void addJobListener(org.quartz.JobListener)"), new Operation("void addSchedulerListener(org.quartz.SchedulerListener)"), new Operation("void addTriggerListener(org.quartz.TriggerListener)"), new Operation("boolean deleteCalendar(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("boolean deleteJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("org.quartz.Calendar getCalendar(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("java.lang.String getCalendarNames(org.quartz.core.SchedulingContext)[]"), new Operation("java.util.List getCurrentlyExecutingJobs()"), new Operation("java.util.List getGlobalJobListeners()"), new Operation("java.util.List getGlobalTriggerListeners()"), new Operation("org.quartz.JobDetail getJobDetail(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("java.lang.String getJobGroupNames(org.quartz.core.SchedulingContext)[]"), new Operation("org.quartz.JobListener getJobListener(java.lang.String)"), new Operation("java.util.Set getJobListenerNames()"), new Operation("java.lang.String getJobNames(org.quartz.core.SchedulingContext, java.lang.String)[]"), new Operation("java.lang.Class getJobStoreClass()"), new Operation("java.util.Set getPausedTriggerGroups(org.quartz.core.SchedulingContext)"), new Operation("org.quartz.SchedulerContext getSchedulerContext()"), new Operation("java.lang.String getSchedulerInstanceId()"), new Operation("java.util.List getSchedulerListeners()"), new Operation("java.lang.String getSchedulerName()"), new Operation("java.lang.Class getThreadPoolClass()"), new Operation("int getThreadPoolSize()"), new Operation("org.quartz.Trigger getTrigger(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("java.lang.String getTriggerGroupNames(org.quartz.core.SchedulingContext)[]"), new Operation("org.quartz.TriggerListener getTriggerListener(java.lang.String)"), new Operation("java.util.Set getTriggerListenerNames()"), new Operation("java.lang.String getTriggerNames(org.quartz.core.SchedulingContext, java.lang.String)[]"), new Operation("int getTriggerState(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("org.quartz.Trigger getTriggersOfJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)[]"), new Operation("java.lang.String getVersion()"), new Operation("boolean interrupt(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("boolean isInStandbyMode()"), new Operation("boolean isShutdown()"), new Operation("int numJobsExecuted()"), new Operation("void pauseAll(org.quartz.core.SchedulingContext)"), new Operation("void pauseJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("void pauseJobGroup(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("void pauseTrigger(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("void pauseTriggerGroup(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("boolean removeGlobalJobListener(org.quartz.JobListener)"), new Operation("boolean removeGlobalTriggerListener(org.quartz.TriggerListener)"), new Operation("boolean removeJobListener(java.lang.String)"), new Operation("boolean removeSchedulerListener(org.quartz.SchedulerListener)"), new Operation("boolean removeTriggerListener(java.lang.String)"), new Operation("java.util.Date rescheduleJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String, org.quartz.Trigger)"), new Operation("void resumeAll(org.quartz.core.SchedulingContext)"), new Operation("void resumeJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("void resumeJobGroup(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("void resumeTrigger(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)"), new Operation("void resumeTriggerGroup(org.quartz.core.SchedulingContext, java.lang.String)"), new Operation("java.util.Date runningSince()"), new Operation("java.util.Date scheduleJob(org.quartz.core.SchedulingContext, org.quartz.JobDetail, org.quartz.Trigger)"), new Operation("java.util.Date scheduleJob(org.quartz.core.SchedulingContext, org.quartz.Trigger)"), new Operation("void shutdown()"), new Operation("void shutdown(boolean)"), new Operation("void standby()"), new Operation("void start()"), new Operation("boolean supportsPersistence()"), new Operation("void triggerJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String, org.quartz.JobDataMap)"), new Operation("void triggerJobWithVolatileTrigger(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String, org.quartz.JobDataMap)"), new Operation("boolean unscheduleJob(org.quartz.core.SchedulingContext, java.lang.String, java.lang.String)") };
  private static final long interfaceHash = -426943571078592559L;

  public void dispatch(Remote paramRemote, RemoteCall paramRemoteCall, int paramInt, long paramLong)
    throws Exception
  {
    if (paramInt < 0)
    {
      if (paramLong == 7877410577445016705L)
        paramInt = 0;
      else if (paramLong == -6041517808460841247L)
        paramInt = 1;
      else if (paramLong == -8640695946527295764L)
        paramInt = 2;
      else if (paramLong == -4297726825849051791L)
        paramInt = 3;
      else if (paramLong == 2426087316584382316L)
        paramInt = 4;
      else if (paramLong == -5353439874786710385L)
        paramInt = 5;
      else if (paramLong == -1282295024260163224L)
        paramInt = 6;
      else if (paramLong == 2032298556184576237L)
        paramInt = 7;
      else if (paramLong == 4168665377724210756L)
        paramInt = 8;
      else if (paramLong == -10248060608263696L)
        paramInt = 9;
      else if (paramLong == -6682625582061442910L)
        paramInt = 10;
      else if (paramLong == 5767551841304860517L)
        paramInt = 11;
      else if (paramLong == 673892492619661816L)
        paramInt = 12;
      else if (paramLong == -8753723098388680500L)
        paramInt = 13;
      else if (paramLong == 1526724571948603194L)
        paramInt = 14;
      else if (paramLong == -1825157456250210748L)
        paramInt = 15;
      else if (paramLong == 5473249512736598697L)
        paramInt = 16;
      else if (paramLong == -7990922162145169540L)
        paramInt = 17;
      else if (paramLong == 1858655376871511804L)
        paramInt = 18;
      else if (paramLong == 6705397913929502666L)
        paramInt = 19;
      else if (paramLong == -2879840167355937712L)
        paramInt = 20;
      else if (paramLong == 2814359591403475563L)
        paramInt = 21;
      else if (paramLong == -2454925768252868567L)
        paramInt = 22;
      else if (paramLong == 8248801052666236332L)
        paramInt = 23;
      else if (paramLong == 1038196595245667445L)
        paramInt = 24;
      else if (paramLong == -706336661940287388L)
        paramInt = 25;
      else if (paramLong == 6528392066641712137L)
        paramInt = 26;
      else if (paramLong == 9028403249244762358L)
        paramInt = 27;
      else if (paramLong == -8434571962701082662L)
        paramInt = 28;
      else if (paramLong == 8731987467532226032L)
        paramInt = 29;
      else if (paramLong == 7833515964595158714L)
        paramInt = 30;
      else if (paramLong == -2884522838858275815L)
        paramInt = 31;
      else if (paramLong == 7113203090429654348L)
        paramInt = 32;
      else if (paramLong == -8009982909598772742L)
        paramInt = 33;
      else if (paramLong == -8081107751519807347L)
        paramInt = 34;
      else if (paramLong == -7290260908606214465L)
        paramInt = 35;
      else if (paramLong == 809977841435240287L)
        paramInt = 36;
      else if (paramLong == 6424449119484905518L)
        paramInt = 37;
      else if (paramLong == 3699847707830503805L)
        paramInt = 38;
      else if (paramLong == 7610858889894251336L)
        paramInt = 39;
      else if (paramLong == 457226404522509022L)
        paramInt = 40;
      else if (paramLong == 494589007973942166L)
        paramInt = 41;
      else if (paramLong == -5185189284912572184L)
        paramInt = 42;
      else if (paramLong == -7240210608959627830L)
        paramInt = 43;
      else if (paramLong == -7798731862695006935L)
        paramInt = 44;
      else if (paramLong == -1342125205976373432L)
        paramInt = 45;
      else if (paramLong == -1791615026186070730L)
        paramInt = 46;
      else if (paramLong == -1142568476223351084L)
        paramInt = 47;
      else if (paramLong == 6164681776053435325L)
        paramInt = 48;
      else if (paramLong == -703684548061517373L)
        paramInt = 49;
      else if (paramLong == -8589950808160578625L)
        paramInt = 50;
      else if (paramLong == -5716727411566322179L)
        paramInt = 51;
      else if (paramLong == 315342150948211927L)
        paramInt = 52;
      else if (paramLong == 2820522932412169300L)
        paramInt = 53;
      else if (paramLong == 1070390834921208886L)
        paramInt = 54;
      else if (paramLong == -1739625058868381113L)
        paramInt = 55;
      else if (paramLong == 7479428518730356220L)
        paramInt = 56;
      else if (paramLong == 684430237226999070L)
        paramInt = 57;
      else if (paramLong == -7207851917985848402L)
        paramInt = 58;
      else if (paramLong == -7158426071079062438L)
        paramInt = 59;
      else if (paramLong == 7161048918451732526L)
        paramInt = 60;
      else if (paramLong == -8025343665958530775L)
        paramInt = 61;
      else if (paramLong == -5767630451452602400L)
        paramInt = 62;
      else if (paramLong == 8046579710400247221L)
        paramInt = 63;
      else if (paramLong == -2523046364662965662L)
        paramInt = 64;
      else if (paramLong == -4730547894112448329L)
        paramInt = 65;
      else
        throw new UnmarshalException("invalid method hash");
    }
    else if (paramLong != -426943571078592559L)
      throw new SkeletonMismatchException("interface hash mismatch");
    QuartzScheduler localQuartzScheduler = (QuartzScheduler)paramRemote;
    Object localObject1;
    String str2;
    Object localObject10;
    Object localObject66;
    Object localObject13;
    Object localObject14;
    Object localObject16;
    Object localObject2;
    Object localObject69;
    Object localObject19;
    Object localObject20;
    Object localObject47;
    Object localObject21;
    boolean bool1;
    Object localObject3;
    String str5;
    Object localObject78;
    Object localObject29;
    Object localObject30;
    SchedulingContext localSchedulingContext;
    String str7;
    String str16;
    JobDataMap localJobDataMap;
    switch (paramInt)
    {
    case 0:
      String str1;
      Calendar localCalendar1;
      boolean bool11;
      boolean bool15;
      try
      {
        ObjectInput localObjectInput42 = paramRemoteCall.getInputStream();
        localObject1 = (SchedulingContext)localObjectInput42.readObject();
        str1 = (String)localObjectInput42.readObject();
        localCalendar1 = (Calendar)localObjectInput42.readObject();
        bool11 = localObjectInput42.readBoolean();
        bool15 = localObjectInput42.readBoolean();
      }
      catch (IOException localIOException111)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException111);
      }
      catch (ClassNotFoundException localClassNotFoundException44)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException44);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.addCalendar((SchedulingContext)localObject1, str1, localCalendar1, bool11, bool15);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException93)
      {
        throw new MarshalException("error marshalling return", localIOException93);
      }
    case 1:
      try
      {
        ObjectInput localObjectInput1 = paramRemoteCall.getInputStream();
        localObject1 = (JobListener)localObjectInput1.readObject();
      }
      catch (IOException localIOException45)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException45);
      }
      catch (ClassNotFoundException localClassNotFoundException1)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException1);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.addGlobalJobListener((JobListener)localObject1);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException4)
      {
        throw new MarshalException("error marshalling return", localIOException4);
      }
    case 2:
      try
      {
        ObjectInput localObjectInput2 = paramRemoteCall.getInputStream();
        localObject1 = (TriggerListener)localObjectInput2.readObject();
      }
      catch (IOException localIOException46)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException46);
      }
      catch (ClassNotFoundException localClassNotFoundException2)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException2);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.addGlobalTriggerListener((TriggerListener)localObject1);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException5)
      {
        throw new MarshalException("error marshalling return", localIOException5);
      }
    case 3:
      JobDetail localJobDetail;
      boolean bool9;
      try
      {
        ObjectInput localObjectInput26 = paramRemoteCall.getInputStream();
        localObject1 = (SchedulingContext)localObjectInput26.readObject();
        localJobDetail = (JobDetail)localObjectInput26.readObject();
        bool9 = localObjectInput26.readBoolean();
      }
      catch (IOException localIOException94)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException94);
      }
      catch (ClassNotFoundException localClassNotFoundException28)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException28);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.addJob((SchedulingContext)localObject1, localJobDetail, bool9);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException47)
      {
        throw new MarshalException("error marshalling return", localIOException47);
      }
    case 4:
      try
      {
        ObjectInput localObjectInput3 = paramRemoteCall.getInputStream();
        localObject1 = (JobListener)localObjectInput3.readObject();
      }
      catch (IOException localIOException48)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException48);
      }
      catch (ClassNotFoundException localClassNotFoundException3)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException3);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.addJobListener((JobListener)localObject1);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException6)
      {
        throw new MarshalException("error marshalling return", localIOException6);
      }
    case 5:
      try
      {
        ObjectInput localObjectInput4 = paramRemoteCall.getInputStream();
        localObject1 = (SchedulerListener)localObjectInput4.readObject();
      }
      catch (IOException localIOException49)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException49);
      }
      catch (ClassNotFoundException localClassNotFoundException4)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException4);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.addSchedulerListener((SchedulerListener)localObject1);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException7)
      {
        throw new MarshalException("error marshalling return", localIOException7);
      }
    case 6:
      try
      {
        ObjectInput localObjectInput5 = paramRemoteCall.getInputStream();
        localObject1 = (TriggerListener)localObjectInput5.readObject();
      }
      catch (IOException localIOException50)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException50);
      }
      catch (ClassNotFoundException localClassNotFoundException5)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException5);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.addTriggerListener((TriggerListener)localObject1);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException8)
      {
        throw new MarshalException("error marshalling return", localIOException8);
      }
    case 7:
      try
      {
        ObjectInput localObjectInput17 = paramRemoteCall.getInputStream();
        localObject1 = (SchedulingContext)localObjectInput17.readObject();
        str2 = (String)localObjectInput17.readObject();
      }
      catch (IOException localIOException74)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException74);
      }
      catch (ClassNotFoundException localClassNotFoundException19)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException19);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      boolean bool10 = localQuartzScheduler.deleteCalendar((SchedulingContext)localObject1, str2);
      try
      {
        ObjectOutput localObjectOutput22 = paramRemoteCall.getResultStream(true);
        localObjectOutput22.writeBoolean(bool10);
      }
      catch (IOException localIOException51)
      {
        throw new MarshalException("error marshalling return", localIOException51);
      }
    case 8:
      String str8;
      try
      {
        ObjectInput localObjectInput27 = paramRemoteCall.getInputStream();
        localObject1 = (SchedulingContext)localObjectInput27.readObject();
        str2 = (String)localObjectInput27.readObject();
        str8 = (String)localObjectInput27.readObject();
      }
      catch (IOException localIOException95)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException95);
      }
      catch (ClassNotFoundException localClassNotFoundException29)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException29);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      boolean bool12 = localQuartzScheduler.deleteJob((SchedulingContext)localObject1, str2, str8);
      try
      {
        ObjectOutput localObjectOutput27 = paramRemoteCall.getResultStream(true);
        localObjectOutput27.writeBoolean(bool12);
      }
      catch (IOException localIOException75)
      {
        throw new MarshalException("error marshalling return", localIOException75);
      }
    case 9:
      try
      {
        ObjectInput localObjectInput18 = paramRemoteCall.getInputStream();
        localObject1 = (SchedulingContext)localObjectInput18.readObject();
        str2 = (String)localObjectInput18.readObject();
      }
      catch (IOException localIOException76)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException76);
      }
      catch (ClassNotFoundException localClassNotFoundException20)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException20);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      Calendar localCalendar2 = localQuartzScheduler.getCalendar((SchedulingContext)localObject1, str2);
      try
      {
        ObjectOutput localObjectOutput23 = paramRemoteCall.getResultStream(true);
        localObjectOutput23.writeObject(localCalendar2);
      }
      catch (IOException localIOException52)
      {
        throw new MarshalException("error marshalling return", localIOException52);
      }
    case 10:
      try
      {
        ObjectInput localObjectInput6 = paramRemoteCall.getInputStream();
        localObject1 = (SchedulingContext)localObjectInput6.readObject();
      }
      catch (IOException localIOException53)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException53);
      }
      catch (ClassNotFoundException localClassNotFoundException6)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException6);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localObject10 = localQuartzScheduler.getCalendarNames((SchedulingContext)localObject1);
      try
      {
        ObjectOutput localObjectOutput11 = paramRemoteCall.getResultStream(true);
        localObjectOutput11.writeObject(localObject10);
      }
      catch (IOException localIOException30)
      {
        throw new MarshalException("error marshalling return", localIOException30);
      }
    case 11:
      paramRemoteCall.releaseInputStream();
      localObject1 = localQuartzScheduler.getCurrentlyExecutingJobs();
      try
      {
        localObject10 = paramRemoteCall.getResultStream(true);
        ((ObjectOutput)localObject10).writeObject(localObject1);
      }
      catch (IOException localIOException9)
      {
        throw new MarshalException("error marshalling return", localIOException9);
      }
    case 12:
      paramRemoteCall.releaseInputStream();
      localObject1 = localQuartzScheduler.getGlobalJobListeners();
      try
      {
        ObjectOutput localObjectOutput1 = paramRemoteCall.getResultStream(true);
        localObjectOutput1.writeObject(localObject1);
      }
      catch (IOException localIOException10)
      {
        throw new MarshalException("error marshalling return", localIOException10);
      }
    case 13:
      paramRemoteCall.releaseInputStream();
      localObject1 = localQuartzScheduler.getGlobalTriggerListeners();
      try
      {
        ObjectOutput localObjectOutput2 = paramRemoteCall.getResultStream(true);
        localObjectOutput2.writeObject(localObject1);
      }
      catch (IOException localIOException11)
      {
        throw new MarshalException("error marshalling return", localIOException11);
      }
    case 14:
      String str3;
      String str9;
      try
      {
        ObjectInput localObjectInput28 = paramRemoteCall.getInputStream();
        localObject1 = (SchedulingContext)localObjectInput28.readObject();
        str3 = (String)localObjectInput28.readObject();
        str9 = (String)localObjectInput28.readObject();
      }
      catch (IOException localIOException96)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException96);
      }
      catch (ClassNotFoundException localClassNotFoundException30)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException30);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localObject66 = localQuartzScheduler.getJobDetail((SchedulingContext)localObject1, str3, str9);
      try
      {
        ObjectOutput localObjectOutput28 = paramRemoteCall.getResultStream(true);
        localObjectOutput28.writeObject(localObject66);
      }
      catch (IOException localIOException77)
      {
        throw new MarshalException("error marshalling return", localIOException77);
      }
    case 15:
      try
      {
        localObject66 = paramRemoteCall.getInputStream();
        localObject1 = (SchedulingContext)((ObjectInput)localObject66).readObject();
      }
      catch (IOException localIOException54)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException54);
      }
      catch (ClassNotFoundException localClassNotFoundException7)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException7);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      String[] arrayOfString1 = localQuartzScheduler.getJobGroupNames((SchedulingContext)localObject1);
      try
      {
        ObjectOutput localObjectOutput12 = paramRemoteCall.getResultStream(true);
        localObjectOutput12.writeObject(arrayOfString1);
      }
      catch (IOException localIOException31)
      {
        throw new MarshalException("error marshalling return", localIOException31);
      }
    case 16:
      try
      {
        ObjectInput localObjectInput7 = paramRemoteCall.getInputStream();
        localObject1 = (String)localObjectInput7.readObject();
      }
      catch (IOException localIOException55)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException55);
      }
      catch (ClassNotFoundException localClassNotFoundException8)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException8);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localObject13 = localQuartzScheduler.getJobListener((String)localObject1);
      try
      {
        ObjectOutput localObjectOutput13 = paramRemoteCall.getResultStream(true);
        localObjectOutput13.writeObject(localObject13);
      }
      catch (IOException localIOException32)
      {
        throw new MarshalException("error marshalling return", localIOException32);
      }
    case 17:
      paramRemoteCall.releaseInputStream();
      localObject1 = localQuartzScheduler.getJobListenerNames();
      try
      {
        localObject13 = paramRemoteCall.getResultStream(true);
        ((ObjectOutput)localObject13).writeObject(localObject1);
      }
      catch (IOException localIOException12)
      {
        throw new MarshalException("error marshalling return", localIOException12);
      }
    case 18:
      try
      {
        ObjectInput localObjectInput19 = paramRemoteCall.getInputStream();
        localObject1 = (SchedulingContext)localObjectInput19.readObject();
        localObject14 = (String)localObjectInput19.readObject();
      }
      catch (IOException localIOException78)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException78);
      }
      catch (ClassNotFoundException localClassNotFoundException21)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException21);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      String[] arrayOfString3 = localQuartzScheduler.getJobNames((SchedulingContext)localObject1, (String)localObject14);
      try
      {
        ObjectOutput localObjectOutput24 = paramRemoteCall.getResultStream(true);
        localObjectOutput24.writeObject(arrayOfString3);
      }
      catch (IOException localIOException56)
      {
        throw new MarshalException("error marshalling return", localIOException56);
      }
    case 19:
      paramRemoteCall.releaseInputStream();
      localObject1 = localQuartzScheduler.getJobStoreClass();
      try
      {
        localObject14 = paramRemoteCall.getResultStream(true);
        ((ObjectOutput)localObject14).writeObject(localObject1);
      }
      catch (IOException localIOException13)
      {
        throw new MarshalException("error marshalling return", localIOException13);
      }
    case 20:
      try
      {
        ObjectInput localObjectInput8 = paramRemoteCall.getInputStream();
        localObject1 = (SchedulingContext)localObjectInput8.readObject();
      }
      catch (IOException localIOException57)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException57);
      }
      catch (ClassNotFoundException localClassNotFoundException9)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException9);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localObject16 = localQuartzScheduler.getPausedTriggerGroups((SchedulingContext)localObject1);
      try
      {
        ObjectOutput localObjectOutput14 = paramRemoteCall.getResultStream(true);
        localObjectOutput14.writeObject(localObject16);
      }
      catch (IOException localIOException33)
      {
        throw new MarshalException("error marshalling return", localIOException33);
      }
    case 21:
      paramRemoteCall.releaseInputStream();
      localObject1 = localQuartzScheduler.getSchedulerContext();
      try
      {
        localObject16 = paramRemoteCall.getResultStream(true);
        ((ObjectOutput)localObject16).writeObject(localObject1);
      }
      catch (IOException localIOException14)
      {
        throw new MarshalException("error marshalling return", localIOException14);
      }
    case 22:
      paramRemoteCall.releaseInputStream();
      localObject1 = localQuartzScheduler.getSchedulerInstanceId();
      try
      {
        ObjectOutput localObjectOutput3 = paramRemoteCall.getResultStream(true);
        localObjectOutput3.writeObject(localObject1);
      }
      catch (IOException localIOException15)
      {
        throw new MarshalException("error marshalling return", localIOException15);
      }
    case 23:
      paramRemoteCall.releaseInputStream();
      localObject1 = localQuartzScheduler.getSchedulerListeners();
      try
      {
        ObjectOutput localObjectOutput4 = paramRemoteCall.getResultStream(true);
        localObjectOutput4.writeObject(localObject1);
      }
      catch (IOException localIOException16)
      {
        throw new MarshalException("error marshalling return", localIOException16);
      }
    case 24:
      paramRemoteCall.releaseInputStream();
      localObject1 = localQuartzScheduler.getSchedulerName();
      try
      {
        ObjectOutput localObjectOutput5 = paramRemoteCall.getResultStream(true);
        localObjectOutput5.writeObject(localObject1);
      }
      catch (IOException localIOException17)
      {
        throw new MarshalException("error marshalling return", localIOException17);
      }
    case 25:
      paramRemoteCall.releaseInputStream();
      localObject1 = localQuartzScheduler.getThreadPoolClass();
      try
      {
        ObjectOutput localObjectOutput6 = paramRemoteCall.getResultStream(true);
        localObjectOutput6.writeObject(localObject1);
      }
      catch (IOException localIOException18)
      {
        throw new MarshalException("error marshalling return", localIOException18);
      }
    case 26:
      paramRemoteCall.releaseInputStream();
      int i = localQuartzScheduler.getThreadPoolSize();
      try
      {
        ObjectOutput localObjectOutput7 = paramRemoteCall.getResultStream(true);
        localObjectOutput7.writeInt(i);
      }
      catch (IOException localIOException19)
      {
        throw new MarshalException("error marshalling return", localIOException19);
      }
    case 27:
      String str4;
      String str10;
      try
      {
        ObjectInput localObjectInput29 = paramRemoteCall.getInputStream();
        localObject2 = (SchedulingContext)localObjectInput29.readObject();
        str4 = (String)localObjectInput29.readObject();
        str10 = (String)localObjectInput29.readObject();
      }
      catch (IOException localIOException97)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException97);
      }
      catch (ClassNotFoundException localClassNotFoundException31)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException31);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localObject69 = localQuartzScheduler.getTrigger((SchedulingContext)localObject2, str4, str10);
      try
      {
        ObjectOutput localObjectOutput29 = paramRemoteCall.getResultStream(true);
        localObjectOutput29.writeObject(localObject69);
      }
      catch (IOException localIOException79)
      {
        throw new MarshalException("error marshalling return", localIOException79);
      }
    case 28:
      try
      {
        localObject69 = paramRemoteCall.getInputStream();
        localObject2 = (SchedulingContext)((ObjectInput)localObject69).readObject();
      }
      catch (IOException localIOException58)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException58);
      }
      catch (ClassNotFoundException localClassNotFoundException10)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException10);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      String[] arrayOfString2 = localQuartzScheduler.getTriggerGroupNames((SchedulingContext)localObject2);
      try
      {
        ObjectOutput localObjectOutput15 = paramRemoteCall.getResultStream(true);
        localObjectOutput15.writeObject(arrayOfString2);
      }
      catch (IOException localIOException34)
      {
        throw new MarshalException("error marshalling return", localIOException34);
      }
    case 29:
      try
      {
        ObjectInput localObjectInput9 = paramRemoteCall.getInputStream();
        localObject2 = (String)localObjectInput9.readObject();
      }
      catch (IOException localIOException59)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException59);
      }
      catch (ClassNotFoundException localClassNotFoundException11)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException11);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localObject19 = localQuartzScheduler.getTriggerListener((String)localObject2);
      try
      {
        ObjectOutput localObjectOutput16 = paramRemoteCall.getResultStream(true);
        localObjectOutput16.writeObject(localObject19);
      }
      catch (IOException localIOException35)
      {
        throw new MarshalException("error marshalling return", localIOException35);
      }
    case 30:
      paramRemoteCall.releaseInputStream();
      localObject2 = localQuartzScheduler.getTriggerListenerNames();
      try
      {
        localObject19 = paramRemoteCall.getResultStream(true);
        ((ObjectOutput)localObject19).writeObject(localObject2);
      }
      catch (IOException localIOException20)
      {
        throw new MarshalException("error marshalling return", localIOException20);
      }
    case 31:
      try
      {
        ObjectInput localObjectInput20 = paramRemoteCall.getInputStream();
        localObject2 = (SchedulingContext)localObjectInput20.readObject();
        localObject20 = (String)localObjectInput20.readObject();
      }
      catch (IOException localIOException80)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException80);
      }
      catch (ClassNotFoundException localClassNotFoundException22)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException22);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localObject47 = localQuartzScheduler.getTriggerNames((SchedulingContext)localObject2, (String)localObject20);
      try
      {
        ObjectOutput localObjectOutput25 = paramRemoteCall.getResultStream(true);
        localObjectOutput25.writeObject(localObject47);
      }
      catch (IOException localIOException60)
      {
        throw new MarshalException("error marshalling return", localIOException60);
      }
    case 32:
      try
      {
        ObjectInput localObjectInput30 = paramRemoteCall.getInputStream();
        localObject2 = (SchedulingContext)localObjectInput30.readObject();
        localObject20 = (String)localObjectInput30.readObject();
        localObject47 = (String)localObjectInput30.readObject();
      }
      catch (IOException localIOException98)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException98);
      }
      catch (ClassNotFoundException localClassNotFoundException32)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException32);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      int k = localQuartzScheduler.getTriggerState((SchedulingContext)localObject2, (String)localObject20, (String)localObject47);
      try
      {
        ObjectOutput localObjectOutput30 = paramRemoteCall.getResultStream(true);
        localObjectOutput30.writeInt(k);
      }
      catch (IOException localIOException81)
      {
        throw new MarshalException("error marshalling return", localIOException81);
      }
    case 33:
      try
      {
        ObjectInput localObjectInput31 = paramRemoteCall.getInputStream();
        localObject2 = (SchedulingContext)localObjectInput31.readObject();
        localObject20 = (String)localObjectInput31.readObject();
        localObject47 = (String)localObjectInput31.readObject();
      }
      catch (IOException localIOException99)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException99);
      }
      catch (ClassNotFoundException localClassNotFoundException33)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException33);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      Trigger[] arrayOfTrigger = localQuartzScheduler.getTriggersOfJob((SchedulingContext)localObject2, (String)localObject20, (String)localObject47);
      try
      {
        ObjectOutput localObjectOutput31 = paramRemoteCall.getResultStream(true);
        localObjectOutput31.writeObject(arrayOfTrigger);
      }
      catch (IOException localIOException82)
      {
        throw new MarshalException("error marshalling return", localIOException82);
      }
    case 34:
      paramRemoteCall.releaseInputStream();
      localObject2 = localQuartzScheduler.getVersion();
      try
      {
        localObject20 = paramRemoteCall.getResultStream(true);
        ((ObjectOutput)localObject20).writeObject(localObject2);
      }
      catch (IOException localIOException21)
      {
        throw new MarshalException("error marshalling return", localIOException21);
      }
    case 35:
      try
      {
        ObjectInput localObjectInput32 = paramRemoteCall.getInputStream();
        localObject2 = (SchedulingContext)localObjectInput32.readObject();
        localObject21 = (String)localObjectInput32.readObject();
        localObject47 = (String)localObjectInput32.readObject();
      }
      catch (IOException localIOException100)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException100);
      }
      catch (ClassNotFoundException localClassNotFoundException34)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException34);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      boolean bool13 = localQuartzScheduler.interrupt((SchedulingContext)localObject2, (String)localObject21, (String)localObject47);
      try
      {
        ObjectOutput localObjectOutput32 = paramRemoteCall.getResultStream(true);
        localObjectOutput32.writeBoolean(bool13);
      }
      catch (IOException localIOException83)
      {
        throw new MarshalException("error marshalling return", localIOException83);
      }
    case 36:
      paramRemoteCall.releaseInputStream();
      bool1 = localQuartzScheduler.isInStandbyMode();
      try
      {
        localObject21 = paramRemoteCall.getResultStream(true);
        ((DataOutput)localObject21).writeBoolean(bool1);
      }
      catch (IOException localIOException22)
      {
        throw new MarshalException("error marshalling return", localIOException22);
      }
    case 37:
      paramRemoteCall.releaseInputStream();
      bool1 = localQuartzScheduler.isShutdown();
      try
      {
        ObjectOutput localObjectOutput8 = paramRemoteCall.getResultStream(true);
        localObjectOutput8.writeBoolean(bool1);
      }
      catch (IOException localIOException23)
      {
        throw new MarshalException("error marshalling return", localIOException23);
      }
    case 38:
      paramRemoteCall.releaseInputStream();
      int j = localQuartzScheduler.numJobsExecuted();
      try
      {
        ObjectOutput localObjectOutput9 = paramRemoteCall.getResultStream(true);
        localObjectOutput9.writeInt(j);
      }
      catch (IOException localIOException24)
      {
        throw new MarshalException("error marshalling return", localIOException24);
      }
    case 39:
      try
      {
        ObjectInput localObjectInput10 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput10.readObject();
      }
      catch (IOException localIOException61)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException61);
      }
      catch (ClassNotFoundException localClassNotFoundException12)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException12);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.pauseAll((SchedulingContext)localObject3);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException25)
      {
        throw new MarshalException("error marshalling return", localIOException25);
      }
    case 40:
      String str11;
      try
      {
        ObjectInput localObjectInput33 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput33.readObject();
        str5 = (String)localObjectInput33.readObject();
        str11 = (String)localObjectInput33.readObject();
      }
      catch (IOException localIOException101)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException101);
      }
      catch (ClassNotFoundException localClassNotFoundException35)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException35);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.pauseJob((SchedulingContext)localObject3, str5, str11);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException62)
      {
        throw new MarshalException("error marshalling return", localIOException62);
      }
    case 41:
      try
      {
        ObjectInput localObjectInput21 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput21.readObject();
        str5 = (String)localObjectInput21.readObject();
      }
      catch (IOException localIOException84)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException84);
      }
      catch (ClassNotFoundException localClassNotFoundException23)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException23);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.pauseJobGroup((SchedulingContext)localObject3, str5);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException36)
      {
        throw new MarshalException("error marshalling return", localIOException36);
      }
    case 42:
      String str12;
      try
      {
        ObjectInput localObjectInput34 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput34.readObject();
        str5 = (String)localObjectInput34.readObject();
        str12 = (String)localObjectInput34.readObject();
      }
      catch (IOException localIOException102)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException102);
      }
      catch (ClassNotFoundException localClassNotFoundException36)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException36);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.pauseTrigger((SchedulingContext)localObject3, str5, str12);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException63)
      {
        throw new MarshalException("error marshalling return", localIOException63);
      }
    case 43:
      try
      {
        ObjectInput localObjectInput22 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput22.readObject();
        str5 = (String)localObjectInput22.readObject();
      }
      catch (IOException localIOException85)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException85);
      }
      catch (ClassNotFoundException localClassNotFoundException24)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException24);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.pauseTriggerGroup((SchedulingContext)localObject3, str5);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException37)
      {
        throw new MarshalException("error marshalling return", localIOException37);
      }
    case 44:
      try
      {
        ObjectInput localObjectInput11 = paramRemoteCall.getInputStream();
        localObject3 = (JobListener)localObjectInput11.readObject();
      }
      catch (IOException localIOException64)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException64);
      }
      catch (ClassNotFoundException localClassNotFoundException13)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException13);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      boolean bool4 = localQuartzScheduler.removeGlobalJobListener((JobListener)localObject3);
      try
      {
        ObjectOutput localObjectOutput17 = paramRemoteCall.getResultStream(true);
        localObjectOutput17.writeBoolean(bool4);
      }
      catch (IOException localIOException38)
      {
        throw new MarshalException("error marshalling return", localIOException38);
      }
    case 45:
      try
      {
        ObjectInput localObjectInput12 = paramRemoteCall.getInputStream();
        localObject3 = (TriggerListener)localObjectInput12.readObject();
      }
      catch (IOException localIOException65)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException65);
      }
      catch (ClassNotFoundException localClassNotFoundException14)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException14);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      boolean bool5 = localQuartzScheduler.removeGlobalTriggerListener((TriggerListener)localObject3);
      try
      {
        ObjectOutput localObjectOutput18 = paramRemoteCall.getResultStream(true);
        localObjectOutput18.writeBoolean(bool5);
      }
      catch (IOException localIOException39)
      {
        throw new MarshalException("error marshalling return", localIOException39);
      }
    case 46:
      try
      {
        ObjectInput localObjectInput13 = paramRemoteCall.getInputStream();
        localObject3 = (String)localObjectInput13.readObject();
      }
      catch (IOException localIOException66)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException66);
      }
      catch (ClassNotFoundException localClassNotFoundException15)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException15);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      boolean bool6 = localQuartzScheduler.removeJobListener((String)localObject3);
      try
      {
        ObjectOutput localObjectOutput19 = paramRemoteCall.getResultStream(true);
        localObjectOutput19.writeBoolean(bool6);
      }
      catch (IOException localIOException40)
      {
        throw new MarshalException("error marshalling return", localIOException40);
      }
    case 47:
      try
      {
        ObjectInput localObjectInput14 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulerListener)localObjectInput14.readObject();
      }
      catch (IOException localIOException67)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException67);
      }
      catch (ClassNotFoundException localClassNotFoundException16)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException16);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      boolean bool7 = localQuartzScheduler.removeSchedulerListener((SchedulerListener)localObject3);
      try
      {
        ObjectOutput localObjectOutput20 = paramRemoteCall.getResultStream(true);
        localObjectOutput20.writeBoolean(bool7);
      }
      catch (IOException localIOException41)
      {
        throw new MarshalException("error marshalling return", localIOException41);
      }
    case 48:
      try
      {
        ObjectInput localObjectInput15 = paramRemoteCall.getInputStream();
        localObject3 = (String)localObjectInput15.readObject();
      }
      catch (IOException localIOException68)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException68);
      }
      catch (ClassNotFoundException localClassNotFoundException17)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException17);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      boolean bool8 = localQuartzScheduler.removeTriggerListener((String)localObject3);
      try
      {
        ObjectOutput localObjectOutput21 = paramRemoteCall.getResultStream(true);
        localObjectOutput21.writeBoolean(bool8);
      }
      catch (IOException localIOException42)
      {
        throw new MarshalException("error marshalling return", localIOException42);
      }
    case 49:
      String str6;
      String str13;
      try
      {
        ObjectInput localObjectInput39 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput39.readObject();
        str6 = (String)localObjectInput39.readObject();
        str13 = (String)localObjectInput39.readObject();
        localObject78 = (Trigger)localObjectInput39.readObject();
      }
      catch (IOException localIOException108)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException108);
      }
      catch (ClassNotFoundException localClassNotFoundException41)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException41);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      Date localDate3 = localQuartzScheduler.rescheduleJob((SchedulingContext)localObject3, str6, str13, (Trigger)localObject78);
      try
      {
        ObjectOutput localObjectOutput35 = paramRemoteCall.getResultStream(true);
        localObjectOutput35.writeObject(localDate3);
      }
      catch (IOException localIOException103)
      {
        throw new MarshalException("error marshalling return", localIOException103);
      }
    case 50:
      try
      {
        localObject78 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)((ObjectInput)localObject78).readObject();
      }
      catch (IOException localIOException69)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException69);
      }
      catch (ClassNotFoundException localClassNotFoundException18)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException18);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.resumeAll((SchedulingContext)localObject3);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException26)
      {
        throw new MarshalException("error marshalling return", localIOException26);
      }
    case 51:
      String str14;
      try
      {
        ObjectInput localObjectInput35 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput35.readObject();
        localObject29 = (String)localObjectInput35.readObject();
        str14 = (String)localObjectInput35.readObject();
      }
      catch (IOException localIOException104)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException104);
      }
      catch (ClassNotFoundException localClassNotFoundException37)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException37);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.resumeJob((SchedulingContext)localObject3, (String)localObject29, str14);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException70)
      {
        throw new MarshalException("error marshalling return", localIOException70);
      }
    case 52:
      try
      {
        ObjectInput localObjectInput23 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput23.readObject();
        localObject29 = (String)localObjectInput23.readObject();
      }
      catch (IOException localIOException86)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException86);
      }
      catch (ClassNotFoundException localClassNotFoundException25)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException25);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.resumeJobGroup((SchedulingContext)localObject3, (String)localObject29);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException43)
      {
        throw new MarshalException("error marshalling return", localIOException43);
      }
    case 53:
      String str15;
      try
      {
        ObjectInput localObjectInput36 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput36.readObject();
        localObject29 = (String)localObjectInput36.readObject();
        str15 = (String)localObjectInput36.readObject();
      }
      catch (IOException localIOException105)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException105);
      }
      catch (ClassNotFoundException localClassNotFoundException38)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException38);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.resumeTrigger((SchedulingContext)localObject3, (String)localObject29, str15);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException71)
      {
        throw new MarshalException("error marshalling return", localIOException71);
      }
    case 54:
      try
      {
        ObjectInput localObjectInput24 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput24.readObject();
        localObject29 = (String)localObjectInput24.readObject();
      }
      catch (IOException localIOException87)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException87);
      }
      catch (ClassNotFoundException localClassNotFoundException26)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException26);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.resumeTriggerGroup((SchedulingContext)localObject3, (String)localObject29);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException44)
      {
        throw new MarshalException("error marshalling return", localIOException44);
      }
    case 55:
      paramRemoteCall.releaseInputStream();
      localObject3 = localQuartzScheduler.runningSince();
      try
      {
        localObject29 = paramRemoteCall.getResultStream(true);
        ((ObjectOutput)localObject29).writeObject(localObject3);
      }
      catch (IOException localIOException27)
      {
        throw new MarshalException("error marshalling return", localIOException27);
      }
    case 56:
      Trigger localTrigger;
      try
      {
        ObjectInput localObjectInput37 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput37.readObject();
        localObject30 = (JobDetail)localObjectInput37.readObject();
        localTrigger = (Trigger)localObjectInput37.readObject();
      }
      catch (IOException localIOException106)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException106);
      }
      catch (ClassNotFoundException localClassNotFoundException39)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException39);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      Date localDate2 = localQuartzScheduler.scheduleJob((SchedulingContext)localObject3, (JobDetail)localObject30, localTrigger);
      try
      {
        ObjectOutput localObjectOutput33 = paramRemoteCall.getResultStream(true);
        localObjectOutput33.writeObject(localDate2);
      }
      catch (IOException localIOException88)
      {
        throw new MarshalException("error marshalling return", localIOException88);
      }
    case 57:
      try
      {
        ObjectInput localObjectInput25 = paramRemoteCall.getInputStream();
        localObject3 = (SchedulingContext)localObjectInput25.readObject();
        localObject30 = (Trigger)localObjectInput25.readObject();
      }
      catch (IOException localIOException89)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException89);
      }
      catch (ClassNotFoundException localClassNotFoundException27)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException27);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      Date localDate1 = localQuartzScheduler.scheduleJob((SchedulingContext)localObject3, (Trigger)localObject30);
      try
      {
        ObjectOutput localObjectOutput26 = paramRemoteCall.getResultStream(true);
        localObjectOutput26.writeObject(localDate1);
      }
      catch (IOException localIOException72)
      {
        throw new MarshalException("error marshalling return", localIOException72);
      }
    case 58:
      paramRemoteCall.releaseInputStream();
      localQuartzScheduler.shutdown();
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException1)
      {
        throw new MarshalException("error marshalling return", localIOException1);
      }
    case 59:
      boolean bool2;
      try
      {
        ObjectInput localObjectInput16 = paramRemoteCall.getInputStream();
        bool2 = localObjectInput16.readBoolean();
      }
      catch (IOException localIOException73)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException73);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.shutdown(bool2);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException28)
      {
        throw new MarshalException("error marshalling return", localIOException28);
      }
    case 60:
      paramRemoteCall.releaseInputStream();
      localQuartzScheduler.standby();
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException2)
      {
        throw new MarshalException("error marshalling return", localIOException2);
      }
    case 61:
      paramRemoteCall.releaseInputStream();
      localQuartzScheduler.start();
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException3)
      {
        throw new MarshalException("error marshalling return", localIOException3);
      }
    case 62:
      paramRemoteCall.releaseInputStream();
      boolean bool3 = localQuartzScheduler.supportsPersistence();
      try
      {
        ObjectOutput localObjectOutput10 = paramRemoteCall.getResultStream(true);
        localObjectOutput10.writeBoolean(bool3);
      }
      catch (IOException localIOException29)
      {
        throw new MarshalException("error marshalling return", localIOException29);
      }
    case 63:
      try
      {
        ObjectInput localObjectInput40 = paramRemoteCall.getInputStream();
        localSchedulingContext = (SchedulingContext)localObjectInput40.readObject();
        str7 = (String)localObjectInput40.readObject();
        str16 = (String)localObjectInput40.readObject();
        localJobDataMap = (JobDataMap)localObjectInput40.readObject();
      }
      catch (IOException localIOException109)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException109);
      }
      catch (ClassNotFoundException localClassNotFoundException42)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException42);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.triggerJob(localSchedulingContext, str7, str16, localJobDataMap);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException90)
      {
        throw new MarshalException("error marshalling return", localIOException90);
      }
    case 64:
      try
      {
        ObjectInput localObjectInput41 = paramRemoteCall.getInputStream();
        localSchedulingContext = (SchedulingContext)localObjectInput41.readObject();
        str7 = (String)localObjectInput41.readObject();
        str16 = (String)localObjectInput41.readObject();
        localJobDataMap = (JobDataMap)localObjectInput41.readObject();
      }
      catch (IOException localIOException110)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException110);
      }
      catch (ClassNotFoundException localClassNotFoundException43)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException43);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      localQuartzScheduler.triggerJobWithVolatileTrigger(localSchedulingContext, str7, str16, localJobDataMap);
      try
      {
        paramRemoteCall.getResultStream(true);
      }
      catch (IOException localIOException91)
      {
        throw new MarshalException("error marshalling return", localIOException91);
      }
    case 65:
      try
      {
        ObjectInput localObjectInput38 = paramRemoteCall.getInputStream();
        localSchedulingContext = (SchedulingContext)localObjectInput38.readObject();
        str7 = (String)localObjectInput38.readObject();
        str16 = (String)localObjectInput38.readObject();
      }
      catch (IOException localIOException107)
      {
        throw new UnmarshalException("error unmarshalling arguments", localIOException107);
      }
      catch (ClassNotFoundException localClassNotFoundException40)
      {
        throw new UnmarshalException("error unmarshalling arguments", localClassNotFoundException40);
      }
      finally
      {
        paramRemoteCall.releaseInputStream();
      }
      boolean bool14 = localQuartzScheduler.unscheduleJob(localSchedulingContext, str7, str16);
      try
      {
        ObjectOutput localObjectOutput34 = paramRemoteCall.getResultStream(true);
        localObjectOutput34.writeBoolean(bool14);
      }
      catch (IOException localIOException92)
      {
        throw new MarshalException("error marshalling return", localIOException92);
      }
    default:
      throw new UnmarshalException("invalid method number");
    }
  }

  public Operation[] getOperations()
  {
    return (Operation[])operations.clone();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.core.QuartzScheduler_Skel
 * JD-Core Version:    0.6.0
 */