/*     */ package org.quartz.core;
/*     */ 
/*     */ import java.util.Date;
/*     */ import java.util.Random;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.JobPersistenceException;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.Trigger;
/*     */ import org.quartz.spi.JobStore;
/*     */ import org.quartz.spi.ThreadPool;
/*     */ import org.quartz.spi.TriggerFiredBundle;
/*     */ 
/*     */ public class QuartzSchedulerThread extends Thread
/*     */ {
/*     */   private QuartzScheduler qs;
/*     */   private QuartzSchedulerResources qsRsrcs;
/*  58 */   private Object pauseLock = new Object();
/*     */ 
/*  60 */   private Object idleLock = new Object();
/*     */   private boolean signaled;
/*     */   private boolean paused;
/*     */   private boolean halted;
/*  68 */   private SchedulingContext ctxt = null;
/*     */ 
/*  70 */   private Random random = new Random(System.currentTimeMillis());
/*     */ 
/*  74 */   private static long DEFAULT_IDLE_WAIT_TIME = 30000L;
/*     */ 
/*  76 */   private long idleWaitTime = DEFAULT_IDLE_WAIT_TIME;
/*     */ 
/*  78 */   private int idleWaitVariablness = 7000;
/*     */ 
/*  80 */   private long dbFailureRetryInterval = 15000L;
/*     */ 
/*     */   QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt)
/*     */   {
/*  99 */     this(qs, qsRsrcs, ctxt, false, 5);
/*     */   }
/*     */ 
/*     */   QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt, boolean setDaemon, int threadPrio)
/*     */   {
/* 111 */     super(qs.getSchedulerThreadGroup(), qsRsrcs.getThreadName());
/* 112 */     this.qs = qs;
/* 113 */     this.qsRsrcs = qsRsrcs;
/* 114 */     this.ctxt = ctxt;
/* 115 */     setDaemon(setDaemon);
/* 116 */     setPriority(threadPrio);
/*     */ 
/* 121 */     this.paused = true;
/* 122 */     this.halted = false;
/* 123 */     start();
/*     */   }
/*     */ 
/*     */   void setIdleWaitTime(long waitTime)
/*     */   {
/* 135 */     this.idleWaitTime = waitTime;
/* 136 */     this.idleWaitVariablness = (int)(waitTime * 0.2D);
/*     */   }
/*     */ 
/*     */   private long getDbFailureRetryInterval() {
/* 140 */     return this.dbFailureRetryInterval;
/*     */   }
/*     */ 
/*     */   public void setDbFailureRetryInterval(long dbFailureRetryInterval) {
/* 144 */     this.dbFailureRetryInterval = dbFailureRetryInterval;
/*     */   }
/*     */ 
/*     */   private long getRandomizedIdleWaitTime() {
/* 148 */     return this.idleWaitTime - this.random.nextInt(this.idleWaitVariablness);
/*     */   }
/*     */ 
/*     */   void togglePause(boolean pause)
/*     */   {
/* 157 */     synchronized (this.pauseLock) {
/* 158 */       this.paused = pause;
/*     */ 
/* 160 */       if (this.paused)
/* 161 */         signalSchedulingChange();
/*     */       else
/* 163 */         this.pauseLock.notify();
/*     */     }
/*     */   }
/*     */ 
/*     */   void halt()
/*     */   {
/* 174 */     synchronized (this.pauseLock) {
/* 175 */       this.halted = true;
/*     */ 
/* 177 */       if (this.paused)
/* 178 */         this.pauseLock.notify();
/*     */       else
/* 180 */         signalSchedulingChange();
/*     */     }
/*     */   }
/*     */ 
/*     */   boolean isPaused()
/*     */   {
/* 186 */     return this.paused;
/*     */   }
/*     */ 
/*     */   void signalSchedulingChange()
/*     */   {
/* 197 */     this.signaled = true;
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 206 */     boolean lastAcquireFailed = false;
/*     */ 
/* 208 */     while (!this.halted)
/*     */     {
/* 210 */       this.signaled = false;
/*     */       try
/*     */       {
/* 214 */         synchronized (this.pauseLock) {
/* 215 */           while ((this.paused) && (!this.halted))
/*     */             try
/*     */             {
/* 218 */               this.pauseLock.wait(100L);
/*     */             }
/*     */             catch (InterruptedException ignore)
/*     */             {
/*     */             }
/* 223 */           if (this.halted) {
/* 224 */             break;
/*     */           }
/*     */         }
/*     */ 
/* 228 */         Trigger trigger = null;
/*     */ 
/* 230 */         long now = System.currentTimeMillis();
/*     */         try
/*     */         {
/* 233 */           trigger = this.qsRsrcs.getJobStore().acquireNextTrigger(this.ctxt, now + this.idleWaitTime);
/*     */ 
/* 235 */           lastAcquireFailed = false;
/*     */         } catch (JobPersistenceException jpe) {
/* 237 */           if (!lastAcquireFailed) {
/* 238 */             this.qs.notifySchedulerListenersError("An error occured while scanning for the next trigger to fire.", jpe);
/*     */           }
/*     */ 
/* 241 */           lastAcquireFailed = true;
/*     */         }
/*     */         catch (RuntimeException e) {
/* 244 */           if (!lastAcquireFailed) {
/* 245 */             getLog().error("quartzSchedulerThreadLoop: RuntimeException " + e.getMessage(), e);
/*     */           }
/* 247 */           lastAcquireFailed = true;
/*     */         }
/*     */ 
/* 250 */         if (trigger != null)
/*     */         {
/* 252 */           now = System.currentTimeMillis();
/* 253 */           long triggerTime = trigger.getNextFireTime().getTime();
/* 254 */           long timeUntilTrigger = triggerTime - now;
/* 255 */           long spinInterval = 10L;
/*     */ 
/* 268 */           int numPauses = (int)(timeUntilTrigger / spinInterval);
/* 269 */           while ((numPauses >= 0) && (!this.signaled))
/*     */           {
/*     */             try {
/* 272 */               Thread.sleep(spinInterval);
/*     */             }
/*     */             catch (InterruptedException ignore) {
/*     */             }
/* 276 */             now = System.currentTimeMillis();
/* 277 */             timeUntilTrigger = triggerTime - now;
/* 278 */             numPauses = (int)(timeUntilTrigger / spinInterval);
/*     */           }
/* 280 */           if (this.signaled) {
/*     */             try {
/* 282 */               this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
/*     */             }
/*     */             catch (JobPersistenceException jpe) {
/* 285 */               this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
/*     */ 
/* 291 */               releaseTriggerRetryLoop(trigger);
/*     */             } catch (RuntimeException e) {
/* 293 */               getLog().error("releaseTriggerRetryLoop: RuntimeException " + e.getMessage(), e);
/*     */ 
/* 298 */               releaseTriggerRetryLoop(trigger);
/*     */             }
/* 300 */             this.signaled = false;
/* 301 */             continue;
/*     */           }
/*     */ 
/* 305 */           TriggerFiredBundle bndle = null;
/*     */           try
/*     */           {
/* 308 */             bndle = this.qsRsrcs.getJobStore().triggerFired(this.ctxt, trigger);
/*     */           }
/*     */           catch (SchedulerException se) {
/* 311 */             this.qs.notifySchedulerListenersError("An error occured while firing trigger '" + trigger.getFullName() + "'", se);
/*     */           }
/*     */           catch (RuntimeException e)
/*     */           {
/* 315 */             getLog().error("RuntimeException while firing trigger " + trigger.getFullName(), e);
/*     */ 
/* 320 */             releaseTriggerRetryLoop(trigger);
/*     */           }
/*     */ 
/* 326 */           if (bndle == null) {
/*     */             try {
/* 328 */               this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
/*     */             }
/*     */             catch (SchedulerException se) {
/* 331 */               this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", se);
/*     */ 
/* 336 */               releaseTriggerRetryLoop(trigger);
/*     */             }
/* 338 */             continue;
/*     */           }
/*     */ 
/* 350 */           JobRunShell shell = null;
/*     */           try {
/* 352 */             shell = this.qsRsrcs.getJobRunShellFactory().borrowJobRunShell();
/* 353 */             shell.initialize(this.qs, bndle);
/*     */           } catch (SchedulerException se) {
/*     */             try {
/* 356 */               this.qsRsrcs.getJobStore().triggeredJobComplete(this.ctxt, trigger, bndle.getJobDetail(), 6);
/*     */             }
/*     */             catch (SchedulerException se2) {
/* 359 */               this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", se2);
/*     */ 
/* 364 */               errorTriggerRetryLoop(bndle);
/*     */             }
/*     */           }
/* 366 */           continue;
/*     */ 
/* 369 */           this.qsRsrcs.getThreadPool().runInThread(shell);
/*     */ 
/* 371 */           continue;
/*     */         }
/*     */ 
/* 385 */         now = System.currentTimeMillis();
/* 386 */         long waitTime = now + getRandomizedIdleWaitTime();
/* 387 */         long timeUntilContinue = waitTime - now;
/* 388 */         long spinInterval = 10L;
/* 389 */         int numPauses = (int)(timeUntilContinue / spinInterval);
/*     */ 
/* 391 */         while ((numPauses > 0) && (!this.signaled))
/*     */         {
/*     */           try {
/* 394 */             Thread.sleep(10L);
/*     */           }
/*     */           catch (InterruptedException ignore) {
/*     */           }
/* 398 */           now = System.currentTimeMillis();
/* 399 */           timeUntilContinue = waitTime - now;
/* 400 */           numPauses = (int)(timeUntilContinue / spinInterval);
/*     */         }
/*     */       }
/*     */       catch (RuntimeException re) {
/* 404 */         getLog().error("Runtime error occured in main trigger firing loop.", re);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 409 */     this.qs = null;
/* 410 */     this.qsRsrcs = null;
/*     */   }
/*     */ 
/*     */   public void errorTriggerRetryLoop(TriggerFiredBundle bndle) {
/* 414 */     int retryCount = 0;
/*     */     try {
/* 416 */       while (!this.halted)
/*     */         try {
/* 418 */           Thread.sleep(getDbFailureRetryInterval());
/*     */ 
/* 422 */           retryCount++;
/* 423 */           this.qsRsrcs.getJobStore().triggeredJobComplete(this.ctxt, bndle.getTrigger(), bndle.getJobDetail(), 6);
/*     */ 
/* 425 */           retryCount = 0;
/*     */         }
/*     */         catch (JobPersistenceException jpe) {
/* 428 */           if (retryCount % 4 == 0) {
/* 429 */             this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + bndle.getTrigger().getFullName() + "'", jpe);
/*     */           }
/*     */ 
/* 436 */           continue;
/*     */         }
/*     */         catch (RuntimeException e)
/*     */         {
/* 433 */           getLog().error("releaseTriggerRetryLoop: RuntimeException " + e.getMessage(), e);
/*     */ 
/* 436 */           continue;
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/* 435 */           getLog().error("releaseTriggerRetryLoop: InterruptedException " + e.getMessage(), e);
/*     */         }
/*     */     }
/*     */     finally {
/* 439 */       if (retryCount == 0)
/* 440 */         getLog().info("releaseTriggerRetryLoop: connection restored.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void releaseTriggerRetryLoop(Trigger trigger) {
/* 445 */     int retryCount = 0;
/*     */     try {
/* 447 */       while (!this.halted)
/*     */         try {
/* 449 */           Thread.sleep(getDbFailureRetryInterval());
/*     */ 
/* 453 */           retryCount++;
/* 454 */           this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
/* 455 */           retryCount = 0;
/*     */         }
/*     */         catch (JobPersistenceException jpe) {
/* 458 */           if (retryCount % 4 == 0) {
/* 459 */             this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
/*     */           }
/*     */ 
/* 466 */           continue;
/*     */         }
/*     */         catch (RuntimeException e)
/*     */         {
/* 463 */           getLog().error("releaseTriggerRetryLoop: RuntimeException " + e.getMessage(), e);
/*     */ 
/* 466 */           continue;
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/* 465 */           getLog().error("releaseTriggerRetryLoop: InterruptedException " + e.getMessage(), e);
/*     */         }
/*     */     }
/*     */     finally {
/* 469 */       if (retryCount == 0)
/* 470 */         getLog().info("releaseTriggerRetryLoop: connection restored.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Log getLog() {
/* 475 */     return LogFactory.getLog(QuartzSchedulerThread.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.core.QuartzSchedulerThread
 * JD-Core Version:    0.6.0
 */