/*     */ package org.quartz.core;
/*     */ 
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.Job;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.JobExecutionContext;
/*     */ import org.quartz.JobExecutionException;
/*     */ import org.quartz.JobPersistenceException;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.Trigger;
/*     */ import org.quartz.spi.JobFactory;
/*     */ import org.quartz.spi.TriggerFiredBundle;
/*     */ 
/*     */ public class JobRunShell
/*     */   implements Runnable
/*     */ {
/*  68 */   protected JobExecutionContext jec = null;
/*     */ 
/*  70 */   protected QuartzScheduler qs = null;
/*     */ 
/*  72 */   protected Scheduler scheduler = null;
/*     */ 
/*  74 */   protected SchedulingContext schdCtxt = null;
/*     */ 
/*  76 */   protected JobRunShellFactory jobRunShellFactory = null;
/*     */ 
/*  78 */   protected boolean shutdownRequested = false;
/*     */ 
/*  80 */   protected Log log = LogFactory.getLog(getClass());
/*     */ 
/*     */   public JobRunShell(JobRunShellFactory jobRunShellFactory, Scheduler scheduler, SchedulingContext schdCtxt)
/*     */   {
/* 107 */     this.jobRunShellFactory = jobRunShellFactory;
/* 108 */     this.scheduler = scheduler;
/* 109 */     this.schdCtxt = schdCtxt;
/*     */   }
/*     */ 
/*     */   private static Log getLog()
/*     */   {
/* 122 */     return LogFactory.getLog(JobRunShell.class);
/*     */   }
/*     */ 
/*     */   public void initialize(QuartzScheduler qs, TriggerFiredBundle firedBundle) throws SchedulerException
/*     */   {
/* 127 */     this.qs = qs;
/*     */ 
/* 129 */     Job job = null;
/* 130 */     JobDetail jobDetail = firedBundle.getJobDetail();
/*     */     try
/*     */     {
/* 133 */       job = qs.getJobFactory().newJob(firedBundle);
/*     */     } catch (SchedulerException se) {
/* 135 */       qs.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getFullName() + "'", se);
/*     */ 
/* 138 */       throw se;
/*     */     } catch (Exception e) {
/* 140 */       SchedulerException se = new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "'", e);
/*     */ 
/* 143 */       qs.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getFullName() + "'", se);
/*     */ 
/* 146 */       throw se;
/*     */     } catch (Throwable ncdfe) {
/* 148 */       SchedulerException se = new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "' - " + ncdfe);
/*     */ 
/* 151 */       qs.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getFullName() + "'", se);
/*     */ 
/* 154 */       throw se;
/*     */     }
/*     */ 
/* 157 */     this.jec = new JobExecutionContext(this.scheduler, firedBundle, job);
/*     */   }
/*     */ 
/*     */   public void requestShutdown() {
/* 161 */     this.shutdownRequested = true;
/*     */   }
/*     */ 
/*     */   public void run() {
/* 165 */     Trigger trigger = this.jec.getTrigger();
/* 166 */     JobDetail jobDetail = this.jec.getJobDetail();
/*     */     while (true)
/*     */     {
/* 170 */       JobExecutionException jobExEx = null;
/* 171 */       Job job = this.jec.getJobInstance();
/*     */       try
/*     */       {
/* 174 */         begin();
/*     */       } catch (SchedulerException se) {
/* 176 */         this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getFullName() + ": couldn't begin execution.", se);
/*     */ 
/* 179 */         break;
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 184 */         if (!notifyListenersBeginning(this.jec)) break; 
/*     */       }
/*     */       catch (VetoedException ve)
/*     */       {
/*     */         try {
/* 188 */           complete(true);
/*     */         } catch (SchedulerException se) {
/* 190 */           this.qs.notifySchedulerListenersError("Error during veto of Job (" + this.jec.getJobDetail().getFullName() + ": couldn't finalize execution.", se);
/*     */         }
/*     */ 
/* 194 */         break;
/*     */       }
/*     */ 
/* 197 */       long startTime = System.currentTimeMillis();
/* 198 */       long endTime = startTime;
/*     */       try
/*     */       {
/* 202 */         this.log.debug("Calling execute on job " + jobDetail.getFullName());
/* 203 */         job.execute(this.jec);
/* 204 */         endTime = System.currentTimeMillis();
/*     */       } catch (JobExecutionException jee) {
/* 206 */         endTime = System.currentTimeMillis();
/* 207 */         jobExEx = jee;
/* 208 */         getLog().info("Job " + jobDetail.getFullName() + " threw a JobExecutionException: ", jobExEx);
/*     */       }
/*     */       catch (Exception e) {
/* 211 */         endTime = System.currentTimeMillis();
/* 212 */         getLog().error("Job " + jobDetail.getFullName() + " threw an unhandled Exception: ", e);
/*     */ 
/* 214 */         SchedulerException se = new SchedulerException("Job threw an unhandled exception.", e);
/*     */ 
/* 216 */         se.setErrorCode(800);
/* 217 */         this.qs.notifySchedulerListenersError("Job (" + this.jec.getJobDetail().getFullName() + " threw an exception.", se);
/*     */ 
/* 220 */         jobExEx = new JobExecutionException(se, false);
/* 221 */         jobExEx.setErrorCode(800);
/*     */       }
/*     */ 
/* 224 */       this.jec.setJobRunTime(endTime - startTime);
/*     */ 
/* 227 */       if (!notifyJobListenersComplete(this.jec, jobExEx))
/*     */         break;
/* 229 */       int instCode = 0;
/*     */       try
/*     */       {
/* 233 */         instCode = trigger.executionComplete(this.jec, jobExEx);
/*     */       }
/*     */       catch (Exception e) {
/* 236 */         SchedulerException se = new SchedulerException("Trigger threw an unhandled exception.", e);
/*     */ 
/* 238 */         se.setErrorCode(850);
/* 239 */         this.qs.notifySchedulerListenersError("Please report this error to the Quartz developers.", se);
/*     */       }
/*     */ 
/* 245 */       if (!notifyTriggerListenersComplete(this.jec, instCode)) {
/*     */         break;
/*     */       }
/* 248 */       if (instCode == 1) {
/* 249 */         this.jec.incrementRefireCount();
/*     */         try {
/* 251 */           complete(false);
/*     */         } catch (SchedulerException se) {
/* 253 */           this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getFullName() + ": couldn't finalize execution.", se);
/*     */         }
/*     */ 
/* 257 */         continue;
/*     */       }
/*     */       try
/*     */       {
/* 261 */         complete(true);
/*     */       } catch (SchedulerException se) {
/* 263 */         this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getFullName() + ": couldn't finalize execution.", se);
/*     */       }
/*     */ 
/* 266 */       continue;
/*     */       try
/*     */       {
/* 270 */         this.qs.notifyJobStoreJobComplete(this.schdCtxt, trigger, jobDetail, instCode);
/*     */       }
/*     */       catch (JobPersistenceException jpe) {
/* 273 */         this.qs.notifySchedulerListenersError("An error occured while marking executed job complete. job= '" + jobDetail.getFullName() + "'", jpe);
/*     */ 
/* 276 */         if (!completeTriggerRetryLoop(trigger, jobDetail, instCode));
/* 278 */         return;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 284 */     this.qs.notifySchedulerThread();
/*     */ 
/* 286 */     this.jobRunShellFactory.returnJobRunShell(this);
/*     */   }
/*     */ 
/*     */   protected void begin() throws SchedulerException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void complete(boolean successfulExecution) throws SchedulerException {
/*     */   }
/*     */ 
/*     */   public void passivate() {
/* 297 */     this.jec = null;
/* 298 */     this.qs = null;
/*     */   }
/*     */ 
/*     */   private boolean notifyListenersBeginning(JobExecutionContext jec) throws JobRunShell.VetoedException
/*     */   {
/* 303 */     boolean vetoed = false;
/*     */     try
/*     */     {
/* 307 */       vetoed = this.qs.notifyTriggerListenersFired(jec);
/*     */     } catch (SchedulerException se) {
/* 309 */       this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) while firing trigger (Trigger and Job will NOT be fired!). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
/*     */ 
/* 315 */       return false;
/*     */     }
/*     */ 
/* 318 */     if (vetoed) {
/*     */       try {
/* 320 */         this.qs.notifyJobListenersWasVetoed(jec);
/*     */       } catch (SchedulerException se) {
/* 322 */         this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of vetoed execution while firing trigger (Trigger and Job will NOT be fired!). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
/*     */       }
/*     */ 
/* 330 */       throw new VetoedException();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 335 */       this.qs.notifyJobListenersToBeExecuted(jec);
/*     */     } catch (SchedulerException se) {
/* 337 */       this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job to be executed: (Job will NOT be executed!). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
/*     */ 
/* 343 */       return false;
/*     */     }
/*     */ 
/* 346 */     return true;
/*     */   }
/*     */ 
/*     */   private boolean notifyJobListenersComplete(JobExecutionContext jec, JobExecutionException jobExEx)
/*     */   {
/*     */     try {
/* 352 */       this.qs.notifyJobListenersWasExecuted(jec, jobExEx);
/*     */     } catch (SchedulerException se) {
/* 354 */       this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job that was executed: (error will be ignored). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
/*     */ 
/* 360 */       return false;
/*     */     }
/*     */ 
/* 363 */     return true;
/*     */   }
/*     */ 
/*     */   private boolean notifyTriggerListenersComplete(JobExecutionContext jec, int instCode)
/*     */   {
/*     */     try {
/* 369 */       this.qs.notifyTriggerListenersComplete(jec, instCode);
/*     */     }
/*     */     catch (SchedulerException se) {
/* 372 */       this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) of Job that was executed: (error will be ignored). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
/*     */ 
/* 378 */       return false;
/*     */     }
/* 380 */     if (jec.getTrigger().getNextFireTime() == null) {
/* 381 */       this.qs.notifySchedulerListenersFinalized(jec.getTrigger());
/*     */     }
/* 383 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean completeTriggerRetryLoop(Trigger trigger, JobDetail jobDetail, int instCode)
/*     */   {
/* 388 */     while (!this.shutdownRequested) {
/*     */       try {
/* 390 */         Thread.sleep(5000L);
/*     */ 
/* 392 */         this.qs.notifyJobStoreJobComplete(this.schdCtxt, trigger, jobDetail, instCode);
/*     */ 
/* 394 */         return true;
/*     */       } catch (JobPersistenceException jpe) {
/* 396 */         this.qs.notifySchedulerListenersError("An error occured while marking executed job complete. job= '" + jobDetail.getFullName() + "'", jpe);
/*     */       }
/*     */       catch (InterruptedException ignore)
/*     */       {
/*     */       }
/*     */     }
/* 402 */     return false;
/*     */   }
/*     */ 
/*     */   class VetoedException extends Exception
/*     */   {
/*     */     public VetoedException()
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.core.JobRunShell
 * JD-Core Version:    0.6.0
 */