/*     */ package org.quartz;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.quartz.utils.DirtyFlagMap;
/*     */ 
/*     */ public class SchedulerContext extends DirtyFlagMap
/*     */   implements Serializable
/*     */ {
/*  51 */   private boolean allowsTransientData = false;
/*     */ 
/*     */   public SchedulerContext()
/*     */   {
/*  67 */     super(15);
/*     */   }
/*     */ 
/*     */   public SchedulerContext(Map map)
/*     */   {
/*  76 */     this();
/*     */ 
/*  78 */     putAll(map);
/*     */   }
/*     */ 
/*     */   public void setAllowsTransientData(boolean allowsTransientData)
/*     */   {
/* 103 */     if ((containsTransientData()) && (!allowsTransientData)) {
/* 104 */       throw new IllegalStateException("Cannot set property 'allowsTransientData' to 'false' when data map contains non-serializable objects.");
/*     */     }
/*     */ 
/* 108 */     this.allowsTransientData = allowsTransientData;
/*     */   }
/*     */ 
/*     */   public boolean getAllowsTransientData() {
/* 112 */     return this.allowsTransientData;
/*     */   }
/*     */ 
/*     */   public boolean containsTransientData()
/*     */   {
/* 117 */     if (!getAllowsTransientData()) {
/* 118 */       return false;
/*     */     }
/* 120 */     String[] keys = getKeys();
/*     */ 
/* 122 */     for (int i = 0; i < keys.length; i++) {
/* 123 */       Object o = super.get(keys[i]);
/* 124 */       if (!(o instanceof Serializable)) return true;
/*     */     }
/*     */ 
/* 127 */     return false;
/*     */   }
/*     */ 
/*     */   public void removeTransientData()
/*     */   {
/* 137 */     if (!getAllowsTransientData()) {
/* 138 */       return;
/*     */     }
/* 140 */     String[] keys = getKeys();
/*     */ 
/* 142 */     for (int i = 0; i < keys.length; i++) {
/* 143 */       Object o = super.get(keys[i]);
/* 144 */       if ((o instanceof Serializable)) continue; remove(keys[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void putAll(Map map)
/*     */   {
/* 159 */     Iterator itr = map.keySet().iterator();
/* 160 */     while (itr.hasNext()) {
/* 161 */       Object key = itr.next();
/* 162 */       Object val = map.get(key);
/*     */ 
/* 164 */       put(key, val);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void put(String key, int value)
/*     */   {
/* 175 */     super.put(key, new Integer(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, long value)
/*     */   {
/* 184 */     super.put(key, new Long(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, float value)
/*     */   {
/* 193 */     super.put(key, new Float(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, double value)
/*     */   {
/* 202 */     super.put(key, new Double(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, boolean value)
/*     */   {
/* 211 */     super.put(key, new Boolean(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, char value)
/*     */   {
/* 220 */     super.put(key, new Character(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, String value)
/*     */   {
/* 229 */     super.put(key, value);
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object value)
/*     */   {
/* 238 */     if (!(key instanceof String)) {
/* 239 */       throw new IllegalArgumentException("Keys in map must be Strings.");
/*     */     }
/*     */ 
/* 242 */     return super.put(key, value);
/*     */   }
/*     */ 
/*     */   public int getInt(String key)
/*     */   {
/* 254 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 257 */       return ((Integer)obj).intValue(); } catch (Exception e) {
/*     */     }
/* 259 */     throw new ClassCastException("Identified object is not an Integer.");
/*     */   }
/*     */ 
/*     */   public long getLong(String key)
/*     */   {
/* 272 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 275 */       return ((Long)obj).longValue(); } catch (Exception e) {
/*     */     }
/* 277 */     throw new ClassCastException("Identified object is not a Long.");
/*     */   }
/*     */ 
/*     */   public float getFloat(String key)
/*     */   {
/* 290 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 293 */       return ((Float)obj).floatValue(); } catch (Exception e) {
/*     */     }
/* 295 */     throw new ClassCastException("Identified object is not a Float.");
/*     */   }
/*     */ 
/*     */   public double getDouble(String key)
/*     */   {
/* 308 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 311 */       return ((Double)obj).doubleValue(); } catch (Exception e) {
/*     */     }
/* 313 */     throw new ClassCastException("Identified object is not a Double.");
/*     */   }
/*     */ 
/*     */   public boolean getBoolean(String key)
/*     */   {
/* 326 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 329 */       return ((Boolean)obj).booleanValue(); } catch (Exception e) {
/*     */     }
/* 331 */     throw new ClassCastException("Identified object is not a Boolean.");
/*     */   }
/*     */ 
/*     */   public char getChar(String key)
/*     */   {
/* 344 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 347 */       return ((Character)obj).charValue(); } catch (Exception e) {
/*     */     }
/* 349 */     throw new ClassCastException("Identified object is not a Character.");
/*     */   }
/*     */ 
/*     */   public String getString(String key)
/*     */   {
/* 363 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 366 */       return (String)obj; } catch (Exception e) {
/*     */     }
/* 368 */     throw new ClassCastException("Identified object is not a String.");
/*     */   }
/*     */ 
/*     */   public String[] getKeys()
/*     */   {
/* 373 */     return (String[])keySet().toArray(new String[size()]);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.SchedulerContext
 * JD-Core Version:    0.6.0
 */