package org.quartz;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.quartz.spi.JobFactory;

public abstract interface Scheduler
{
  public static final String DEFAULT_GROUP = "DEFAULT";
  public static final String DEFAULT_MANUAL_TRIGGERS = "MANUAL_TRIGGER";
  public static final String DEFAULT_RECOVERY_GROUP = "RECOVERING_JOBS";
  public static final String DEFAULT_FAIL_OVER_GROUP = "FAILED_OVER_JOBS";

  public abstract String getSchedulerName()
    throws SchedulerException;

  public abstract String getSchedulerInstanceId()
    throws SchedulerException;

  public abstract SchedulerContext getContext()
    throws SchedulerException;

  public abstract void start()
    throws SchedulerException;

  public abstract void standby()
    throws SchedulerException;

  /** @deprecated */
  public abstract void pause()
    throws SchedulerException;

  public abstract boolean isInStandbyMode()
    throws SchedulerException;

  /** @deprecated */
  public abstract boolean isPaused()
    throws SchedulerException;

  public abstract void shutdown()
    throws SchedulerException;

  public abstract void shutdown(boolean paramBoolean)
    throws SchedulerException;

  public abstract boolean isShutdown()
    throws SchedulerException;

  public abstract SchedulerMetaData getMetaData()
    throws SchedulerException;

  public abstract List getCurrentlyExecutingJobs()
    throws SchedulerException;

  public abstract void setJobFactory(JobFactory paramJobFactory)
    throws SchedulerException;

  public abstract Date scheduleJob(JobDetail paramJobDetail, Trigger paramTrigger)
    throws SchedulerException;

  public abstract Date scheduleJob(Trigger paramTrigger)
    throws SchedulerException;

  public abstract boolean unscheduleJob(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract Date rescheduleJob(String paramString1, String paramString2, Trigger paramTrigger)
    throws SchedulerException;

  public abstract void addJob(JobDetail paramJobDetail, boolean paramBoolean)
    throws SchedulerException;

  public abstract boolean deleteJob(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract void triggerJob(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract void triggerJobWithVolatileTrigger(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract void triggerJob(String paramString1, String paramString2, JobDataMap paramJobDataMap)
    throws SchedulerException;

  public abstract void triggerJobWithVolatileTrigger(String paramString1, String paramString2, JobDataMap paramJobDataMap)
    throws SchedulerException;

  public abstract void pauseJob(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract void pauseJobGroup(String paramString)
    throws SchedulerException;

  public abstract void pauseTrigger(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract void pauseTriggerGroup(String paramString)
    throws SchedulerException;

  public abstract void resumeJob(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract void resumeJobGroup(String paramString)
    throws SchedulerException;

  public abstract void resumeTrigger(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract void resumeTriggerGroup(String paramString)
    throws SchedulerException;

  public abstract void pauseAll()
    throws SchedulerException;

  public abstract void resumeAll()
    throws SchedulerException;

  public abstract String[] getJobGroupNames()
    throws SchedulerException;

  public abstract String[] getJobNames(String paramString)
    throws SchedulerException;

  public abstract Trigger[] getTriggersOfJob(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract String[] getTriggerGroupNames()
    throws SchedulerException;

  public abstract String[] getTriggerNames(String paramString)
    throws SchedulerException;

  public abstract Set getPausedTriggerGroups()
    throws SchedulerException;

  public abstract JobDetail getJobDetail(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract Trigger getTrigger(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract int getTriggerState(String paramString1, String paramString2)
    throws SchedulerException;

  public abstract void addCalendar(String paramString, Calendar paramCalendar, boolean paramBoolean1, boolean paramBoolean2)
    throws SchedulerException;

  public abstract boolean deleteCalendar(String paramString)
    throws SchedulerException;

  public abstract Calendar getCalendar(String paramString)
    throws SchedulerException;

  public abstract String[] getCalendarNames()
    throws SchedulerException;

  public abstract boolean interrupt(String paramString1, String paramString2)
    throws UnableToInterruptJobException;

  public abstract void addGlobalJobListener(JobListener paramJobListener)
    throws SchedulerException;

  public abstract void addJobListener(JobListener paramJobListener)
    throws SchedulerException;

  public abstract boolean removeGlobalJobListener(JobListener paramJobListener)
    throws SchedulerException;

  public abstract boolean removeJobListener(String paramString)
    throws SchedulerException;

  public abstract List getGlobalJobListeners()
    throws SchedulerException;

  public abstract Set getJobListenerNames()
    throws SchedulerException;

  public abstract JobListener getJobListener(String paramString)
    throws SchedulerException;

  public abstract void addGlobalTriggerListener(TriggerListener paramTriggerListener)
    throws SchedulerException;

  public abstract void addTriggerListener(TriggerListener paramTriggerListener)
    throws SchedulerException;

  public abstract boolean removeGlobalTriggerListener(TriggerListener paramTriggerListener)
    throws SchedulerException;

  public abstract boolean removeTriggerListener(String paramString)
    throws SchedulerException;

  public abstract List getGlobalTriggerListeners()
    throws SchedulerException;

  public abstract Set getTriggerListenerNames()
    throws SchedulerException;

  public abstract TriggerListener getTriggerListener(String paramString)
    throws SchedulerException;

  public abstract void addSchedulerListener(SchedulerListener paramSchedulerListener)
    throws SchedulerException;

  public abstract boolean removeSchedulerListener(SchedulerListener paramSchedulerListener)
    throws SchedulerException;

  public abstract List getSchedulerListeners()
    throws SchedulerException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.Scheduler
 * JD-Core Version:    0.6.0
 */