/*     */ package org.quartz;
/*     */ 
/*     */ import java.util.Date;
/*     */ 
/*     */ public class NthIncludedDayTrigger extends Trigger
/*     */ {
/*     */   public static final int MISFIRE_INSTRUCTION_FIRE_ONCE_NOW = 1;
/*     */   public static final int MISFIRE_INSTRUCTION_DO_NOTHING = 2;
/*     */   public static final int INTERVAL_TYPE_MONTHLY = 1;
/*     */   public static final int INTERVAL_TYPE_YEARLY = 2;
/*     */   public static final int INTERVAL_TYPE_WEEKLY = 3;
/* 114 */   private Date startTime = new Date();
/*     */   private Date endTime;
/*     */   private Date previousFireTime;
/*     */   private Date nextFireTime;
/*     */   private Calendar calendar;
/* 120 */   private int n = 1;
/* 121 */   private int intervalType = 1;
/* 122 */   private int fireAtHour = 12;
/* 123 */   private int fireAtMinute = 0;
/* 124 */   private int nextFireCutoffInterval = 12;
/*     */ 
/*     */   public NthIncludedDayTrigger()
/*     */   {
/*     */   }
/*     */ 
/*     */   public NthIncludedDayTrigger(String name, String group)
/*     */   {
/* 159 */     super(name, group);
/*     */   }
/*     */ 
/*     */   public NthIncludedDayTrigger(String name, String group, String jobName, String jobGroup)
/*     */   {
/* 179 */     super(name, group, jobName, jobGroup);
/*     */   }
/*     */ 
/*     */   public void setN(int n)
/*     */   {
/* 195 */     if (n > 0)
/* 196 */       this.n = n;
/*     */     else
/* 198 */       throw new IllegalArgumentException("N must be greater than 0.");
/*     */   }
/*     */ 
/*     */   public int getN()
/*     */   {
/* 210 */     return this.n;
/*     */   }
/*     */ 
/*     */   public void setIntervalType(int intervalType)
/*     */   {
/* 233 */     switch (intervalType) {
/*     */     case 3:
/* 235 */       this.intervalType = intervalType;
/* 236 */       break;
/*     */     case 1:
/* 238 */       this.intervalType = intervalType;
/* 239 */       break;
/*     */     case 2:
/* 241 */       this.intervalType = intervalType;
/* 242 */       break;
/*     */     default:
/* 244 */       throw new IllegalArgumentException("Invalid Interval Type:" + intervalType);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getIntervalType()
/*     */   {
/* 259 */     return this.intervalType;
/*     */   }
/*     */ 
/*     */   public void setFireAtTime(String fireAtTime)
/*     */   {
/* 275 */     int fireHour = 12;
/* 276 */     int fireMinute = 0;
/*     */     try
/*     */     {
/* 280 */       int i = fireAtTime.indexOf(":");
/* 281 */       fireHour = Integer.parseInt(fireAtTime.substring(0, i));
/* 282 */       fireMinute = Integer.parseInt(fireAtTime.substring(i + 1));
/*     */     } catch (Exception e) {
/* 284 */       fireHour = 12;
/* 285 */       fireMinute = 0;
/* 286 */       throw new IllegalArgumentException("Could not parse time expression: " + e.getMessage());
/*     */     }
/*     */     finally
/*     */     {
/* 290 */       this.fireAtHour = fireHour;
/* 291 */       this.fireAtMinute = fireMinute;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getFireAtTime()
/*     */   {
/* 304 */     return this.fireAtHour + ":" + this.fireAtMinute;
/*     */   }
/*     */ 
/*     */   public void setNextFireCutoffInterval(int nextFireCutoffInterval)
/*     */   {
/* 336 */     this.nextFireCutoffInterval = nextFireCutoffInterval;
/*     */   }
/*     */ 
/*     */   public int getNextFireCutoffInterval()
/*     */   {
/* 357 */     return this.nextFireCutoffInterval;
/*     */   }
/*     */ 
/*     */   public void setStartTime(Date startTime)
/*     */   {
/* 373 */     if (startTime == null) {
/* 374 */       throw new IllegalArgumentException("Start time may not be null");
/*     */     }
/* 376 */     if ((this.endTime != null) && (this.endTime.before(startTime))) {
/* 377 */       throw new IllegalArgumentException("Start time must be before end time.");
/*     */     }
/* 379 */     this.startTime = startTime;
/*     */   }
/*     */ 
/*     */   public Date getStartTime()
/*     */   {
/* 391 */     return this.startTime;
/*     */   }
/*     */ 
/*     */   public void setEndTime(Date endTime)
/*     */   {
/* 406 */     if ((endTime != null) && (endTime.before(this.startTime))) {
/* 407 */       throw new IllegalArgumentException("End time must be after start time.");
/*     */     }
/* 409 */     this.endTime = endTime;
/*     */   }
/*     */ 
/*     */   public Date getEndTime()
/*     */   {
/* 422 */     return this.endTime;
/*     */   }
/*     */ 
/*     */   public Date getNextFireTime()
/*     */   {
/* 448 */     return this.nextFireTime;
/*     */   }
/*     */ 
/*     */   public Date getPreviousFireTime()
/*     */   {
/* 459 */     return this.previousFireTime;
/*     */   }
/*     */ 
/*     */   public Date getFireTimeAfter(Date afterTime)
/*     */   {
/* 498 */     if (afterTime == null) {
/* 499 */       afterTime = new Date();
/*     */     }
/*     */ 
/* 502 */     if (afterTime.before(this.startTime)) {
/* 503 */       afterTime = new Date(this.startTime.getTime() - 1000L);
/*     */     }
/*     */ 
/* 506 */     if (this.intervalType == 3)
/* 507 */       return getWeeklyFireTimeAfter(afterTime);
/* 508 */     if (this.intervalType == 1)
/* 509 */       return getMonthlyFireTimeAfter(afterTime);
/* 510 */     if (this.intervalType == 2) {
/* 511 */       return getYearlyFireTimeAfter(afterTime);
/*     */     }
/* 513 */     return null;
/*     */   }
/*     */ 
/*     */   public Date getFinalFireTime()
/*     */   {
/* 525 */     Date finalTime = null;
/* 526 */     java.util.Calendar currCal = java.util.Calendar.getInstance();
/* 527 */     currCal.setTime(this.endTime);
/*     */ 
/* 530 */     while ((finalTime == null) && (this.startTime.before(currCal.getTime()))) {
/* 531 */       currCal.add(5, -1);
/*     */ 
/* 533 */       finalTime = getFireTimeAfter(currCal.getTime());
/*     */     }
/*     */ 
/* 536 */     return finalTime;
/*     */   }
/*     */ 
/*     */   public void triggered(Calendar calendar)
/*     */   {
/* 546 */     this.calendar = calendar;
/* 547 */     this.previousFireTime = this.nextFireTime;
/* 548 */     this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*     */   }
/*     */ 
/*     */   public Date computeFirstFireTime(Calendar calendar)
/*     */   {
/* 566 */     this.calendar = calendar;
/* 567 */     this.nextFireTime = getFireTimeAfter(new Date(this.startTime.getTime() - 1000L));
/*     */ 
/* 570 */     return this.nextFireTime;
/*     */   }
/*     */ 
/*     */   public int executionComplete(JobExecutionContext jobCtx, JobExecutionException result)
/*     */   {
/* 586 */     if ((result != null) && (result.refireImmediately())) {
/* 587 */       return 1;
/*     */     }
/* 589 */     if ((result != null) && (result.unscheduleFiringTrigger())) {
/* 590 */       return 2;
/*     */     }
/* 592 */     if ((result != null) && (result.unscheduleAllTriggers())) {
/* 593 */       return 4;
/*     */     }
/* 595 */     if (!mayFireAgain()) return 3;
/*     */ 
/* 597 */     return 0;
/*     */   }
/*     */ 
/*     */   public boolean mayFireAgain()
/*     */   {
/* 612 */     return getNextFireTime() == null;
/*     */   }
/*     */ 
/*     */   protected boolean validateMisfireInstruction(int misfireInstruction)
/*     */   {
/* 625 */     return (misfireInstruction == 0) || (misfireInstruction == 2) || (misfireInstruction == 1);
/*     */   }
/*     */ 
/*     */   public void updateAfterMisfire(Calendar calendar)
/*     */   {
/* 643 */     int instruction = getMisfireInstruction();
/*     */ 
/* 645 */     this.calendar = calendar;
/*     */ 
/* 647 */     if (instruction == 0) {
/* 648 */       instruction = 1;
/*     */     }
/*     */ 
/* 651 */     if (instruction == 2)
/* 652 */       this.nextFireTime = getFireTimeAfter(new Date());
/* 653 */     else if (instruction == 1)
/* 654 */       this.nextFireTime = new Date();
/*     */   }
/*     */ 
/*     */   public void updateWithNewCalendar(Calendar calendar, long misfireThreshold)
/*     */   {
/* 669 */     Date now = new Date();
/*     */ 
/* 672 */     this.calendar = calendar;
/* 673 */     this.nextFireTime = getFireTimeAfter(this.previousFireTime);
/*     */ 
/* 675 */     if ((this.nextFireTime != null) && (this.nextFireTime.before(now))) {
/* 676 */       long diff = now.getTime() - this.nextFireTime.getTime();
/* 677 */       if (diff >= misfireThreshold)
/* 678 */         this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Date getWeeklyFireTimeAfter(Date afterDate)
/*     */   {
/* 697 */     int currN = 0;
/*     */ 
/* 701 */     int weekCount = 0;
/* 702 */     boolean gotOne = false;
/*     */ 
/* 704 */     java.util.Calendar afterCal = java.util.Calendar.getInstance();
/* 705 */     afterCal.setTime(afterDate);
/*     */ 
/* 707 */     java.util.Calendar currCal = java.util.Calendar.getInstance();
/* 708 */     currCal.set(afterCal.get(1), afterCal.get(2), afterCal.get(5));
/*     */ 
/* 713 */     currCal.add(5, (afterCal.get(7) - 1) * -1);
/*     */ 
/* 716 */     currCal.set(11, this.fireAtHour);
/* 717 */     currCal.set(12, this.fireAtMinute);
/* 718 */     currCal.set(13, 0);
/* 719 */     currCal.set(14, 0);
/*     */ 
/* 721 */     int currWeek = currCal.get(3);
/*     */ 
/* 723 */     while ((!gotOne) && (weekCount < this.nextFireCutoffInterval)) {
/* 724 */       while ((currN != this.n) && (weekCount < 12))
/*     */       {
/* 726 */         if (currCal.get(3) != currWeek) {
/* 727 */           currN = 0;
/* 728 */           weekCount++;
/* 729 */           currWeek = currCal.get(3);
/*     */         }
/*     */ 
/* 735 */         if ((this.calendar == null) || (this.calendar.isTimeIncluded(currCal.getTime().getTime())))
/*     */         {
/* 737 */           currN++;
/*     */         }
/*     */ 
/* 740 */         if (currN != this.n) {
/* 741 */           currCal.add(5, 1);
/*     */         }
/*     */ 
/* 745 */         if ((this.endTime != null) && (currCal.getTime().after(this.endTime)))
/*     */         {
/* 747 */           return null;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 754 */       if (currN == this.n) {
/* 755 */         if (afterDate.before(currCal.getTime())) {
/* 756 */           gotOne = true; continue;
/*     */         }
/* 758 */         currCal.add(5, -1 * (currN - 1));
/* 759 */         currCal.add(5, 7);
/* 760 */         currN = 0;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 765 */     if (weekCount < this.nextFireCutoffInterval) {
/* 766 */       return currCal.getTime();
/*     */     }
/* 768 */     return null;
/*     */   }
/*     */ 
/*     */   private Date getMonthlyFireTimeAfter(Date afterDate)
/*     */   {
/* 786 */     int currN = 0;
/*     */ 
/* 790 */     int monthCount = 0;
/* 791 */     boolean gotOne = false;
/*     */ 
/* 793 */     java.util.Calendar afterCal = java.util.Calendar.getInstance();
/* 794 */     afterCal.setTime(afterDate);
/*     */ 
/* 796 */     java.util.Calendar currCal = java.util.Calendar.getInstance();
/* 797 */     currCal.set(afterCal.get(1), afterCal.get(2), 1);
/*     */ 
/* 799 */     currCal.set(11, this.fireAtHour);
/* 800 */     currCal.set(12, this.fireAtMinute);
/* 801 */     currCal.set(13, 0);
/* 802 */     currCal.set(14, 0);
/*     */ 
/* 804 */     int currMonth = currCal.get(2);
/*     */ 
/* 806 */     while ((!gotOne) && (monthCount < this.nextFireCutoffInterval)) {
/* 807 */       while ((currN != this.n) && (monthCount < 12))
/*     */       {
/* 809 */         if (currCal.get(2) != currMonth) {
/* 810 */           currN = 0;
/* 811 */           monthCount++;
/* 812 */           currMonth = currCal.get(2);
/*     */         }
/*     */ 
/* 818 */         if ((this.calendar == null) || (this.calendar.isTimeIncluded(currCal.getTime().getTime())))
/*     */         {
/* 820 */           currN++;
/*     */         }
/*     */ 
/* 823 */         if (currN != this.n) {
/* 824 */           currCal.add(5, 1);
/*     */         }
/*     */ 
/* 828 */         if ((this.endTime != null) && (currCal.getTime().after(this.endTime)))
/*     */         {
/* 830 */           return null;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 837 */       if (currN == this.n) {
/* 838 */         if (afterDate.before(currCal.getTime())) {
/* 839 */           gotOne = true; continue;
/*     */         }
/* 841 */         currCal.set(5, 1);
/* 842 */         currCal.add(2, 1);
/* 843 */         currN = 0;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 848 */     if (monthCount < this.nextFireCutoffInterval) {
/* 849 */       return currCal.getTime();
/*     */     }
/* 851 */     return null;
/*     */   }
/*     */ 
/*     */   private Date getYearlyFireTimeAfter(Date afterDate)
/*     */   {
/* 869 */     int currN = 0;
/*     */ 
/* 873 */     int yearCount = 0;
/* 874 */     boolean gotOne = false;
/*     */ 
/* 876 */     java.util.Calendar afterCal = java.util.Calendar.getInstance();
/* 877 */     afterCal.setTime(afterDate);
/*     */ 
/* 879 */     java.util.Calendar currCal = java.util.Calendar.getInstance();
/* 880 */     currCal.set(afterCal.get(1), 0, 1);
/*     */ 
/* 882 */     currCal.set(11, this.fireAtHour);
/* 883 */     currCal.set(12, this.fireAtMinute);
/* 884 */     currCal.set(13, 0);
/* 885 */     currCal.set(14, 0);
/*     */ 
/* 887 */     int currYear = currCal.get(1);
/*     */ 
/* 889 */     while ((!gotOne) && (yearCount < this.nextFireCutoffInterval)) {
/* 890 */       while ((currN != this.n) && (yearCount < 5))
/*     */       {
/* 892 */         if (currCal.get(1) != currYear) {
/* 893 */           currN = 0;
/* 894 */           yearCount++;
/* 895 */           currYear = currCal.get(1);
/*     */         }
/*     */ 
/* 901 */         if ((this.calendar == null) || (this.calendar.isTimeIncluded(currCal.getTime().getTime())))
/*     */         {
/* 903 */           currN++;
/*     */         }
/*     */ 
/* 906 */         if (currN != this.n) {
/* 907 */           currCal.add(5, 1);
/*     */         }
/*     */ 
/* 911 */         if ((this.endTime != null) && (currCal.getTime().after(this.endTime)))
/*     */         {
/* 913 */           return null;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 920 */       if (currN == this.n) {
/* 921 */         if (afterDate.before(currCal.getTime())) {
/* 922 */           gotOne = true; continue;
/*     */         }
/* 924 */         currCal.set(5, 1);
/* 925 */         currCal.set(2, 0);
/*     */ 
/* 927 */         currCal.add(1, 1);
/* 928 */         currN = 0;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 933 */     if (yearCount < this.nextFireCutoffInterval) {
/* 934 */       return currCal.getTime();
/*     */     }
/* 936 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.NthIncludedDayTrigger
 * JD-Core Version:    0.6.0
 */