/*     */ package org.quartz;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.quartz.utils.DirtyFlagMap;
/*     */ 
/*     */ public class JobDataMap extends DirtyFlagMap
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -6939901990106713909L;
/*  75 */   private boolean allowsTransientData = false;
/*     */ 
/*     */   public JobDataMap()
/*     */   {
/*  91 */     super(15);
/*     */   }
/*     */ 
/*     */   public JobDataMap(Map map)
/*     */   {
/* 100 */     this();
/*     */ 
/* 102 */     putAll(map);
/*     */   }
/*     */ 
/*     */   public void setAllowsTransientData(boolean allowsTransientData)
/*     */   {
/* 128 */     if ((containsTransientData()) && (!allowsTransientData)) {
/* 129 */       throw new IllegalStateException("Cannot set property 'allowsTransientData' to 'false' when data map contains non-serializable objects.");
/*     */     }
/*     */ 
/* 133 */     this.allowsTransientData = allowsTransientData;
/*     */   }
/*     */ 
/*     */   public boolean getAllowsTransientData() {
/* 137 */     return this.allowsTransientData;
/*     */   }
/*     */ 
/*     */   public boolean containsTransientData()
/*     */   {
/* 142 */     if (!getAllowsTransientData()) {
/* 143 */       return false;
/*     */     }
/* 145 */     String[] keys = getKeys();
/*     */ 
/* 147 */     for (int i = 0; i < keys.length; i++) {
/* 148 */       Object o = super.get(keys[i]);
/* 149 */       if (!(o instanceof Serializable)) return true;
/*     */     }
/*     */ 
/* 152 */     return false;
/*     */   }
/*     */ 
/*     */   public void removeTransientData()
/*     */   {
/* 162 */     if (!getAllowsTransientData()) {
/* 163 */       return;
/*     */     }
/* 165 */     String[] keys = getKeys();
/*     */ 
/* 167 */     for (int i = 0; i < keys.length; i++) {
/* 168 */       Object o = super.get(keys[i]);
/* 169 */       if ((o instanceof Serializable)) continue; remove(keys[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void putAll(Map map)
/*     */   {
/* 184 */     Iterator itr = map.keySet().iterator();
/* 185 */     while (itr.hasNext()) {
/* 186 */       Object key = itr.next();
/* 187 */       Object val = map.get(key);
/*     */ 
/* 189 */       put(key, val);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void put(String key, int value)
/*     */   {
/* 201 */     super.put(key, new Integer(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, long value)
/*     */   {
/* 211 */     super.put(key, new Long(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, float value)
/*     */   {
/* 221 */     super.put(key, new Float(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, double value)
/*     */   {
/* 231 */     super.put(key, new Double(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, boolean value)
/*     */   {
/* 241 */     super.put(key, new Boolean(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, char value)
/*     */   {
/* 251 */     super.put(key, new Character(value));
/*     */   }
/*     */ 
/*     */   public void put(String key, String value)
/*     */   {
/* 261 */     super.put(key, value);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, boolean value)
/*     */   {
/* 271 */     String strValue = new Boolean(value).toString();
/*     */ 
/* 273 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, Boolean value)
/*     */   {
/* 283 */     String strValue = value.toString();
/*     */ 
/* 285 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, char value)
/*     */   {
/* 295 */     String strValue = new Character(value).toString();
/*     */ 
/* 297 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, Character value)
/*     */   {
/* 307 */     String strValue = value.toString();
/*     */ 
/* 309 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, double value)
/*     */   {
/* 319 */     String strValue = new Double(value).toString();
/*     */ 
/* 321 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, Double value)
/*     */   {
/* 331 */     String strValue = value.toString();
/*     */ 
/* 333 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, float value)
/*     */   {
/* 343 */     String strValue = new Float(value).toString();
/*     */ 
/* 345 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, Float value)
/*     */   {
/* 355 */     String strValue = value.toString();
/*     */ 
/* 357 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, int value)
/*     */   {
/* 367 */     String strValue = new Integer(value).toString();
/*     */ 
/* 369 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, Integer value)
/*     */   {
/* 379 */     String strValue = value.toString();
/*     */ 
/* 381 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, long value)
/*     */   {
/* 391 */     String strValue = new Long(value).toString();
/*     */ 
/* 393 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public void putAsString(String key, Long value)
/*     */   {
/* 403 */     String strValue = value.toString();
/*     */ 
/* 405 */     super.put(key, strValue);
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object value)
/*     */   {
/* 414 */     if (!(key instanceof String)) {
/* 415 */       throw new IllegalArgumentException("Keys in map must be Strings.");
/*     */     }
/*     */ 
/* 418 */     return super.put(key, value);
/*     */   }
/*     */ 
/*     */   public int getInt(String key)
/*     */   {
/* 430 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 433 */       return ((Integer)obj).intValue(); } catch (Exception e) {
/*     */     }
/* 435 */     throw new ClassCastException("Identified object is not an Integer.");
/*     */   }
/*     */ 
/*     */   public long getLong(String key)
/*     */   {
/* 448 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 451 */       return ((Long)obj).longValue(); } catch (Exception e) {
/*     */     }
/* 453 */     throw new ClassCastException("Identified object is not a Long.");
/*     */   }
/*     */ 
/*     */   public float getFloat(String key)
/*     */   {
/* 466 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 469 */       return ((Float)obj).floatValue(); } catch (Exception e) {
/*     */     }
/* 471 */     throw new ClassCastException("Identified object is not a Float.");
/*     */   }
/*     */ 
/*     */   public double getDouble(String key)
/*     */   {
/* 484 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 487 */       return ((Double)obj).doubleValue(); } catch (Exception e) {
/*     */     }
/* 489 */     throw new ClassCastException("Identified object is not a Double.");
/*     */   }
/*     */ 
/*     */   public boolean getBoolean(String key)
/*     */   {
/* 502 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 505 */       return ((Boolean)obj).booleanValue(); } catch (Exception e) {
/*     */     }
/* 507 */     throw new ClassCastException("Identified object is not a Boolean.");
/*     */   }
/*     */ 
/*     */   public char getChar(String key)
/*     */   {
/* 520 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 523 */       return ((Character)obj).charValue(); } catch (Exception e) {
/*     */     }
/* 525 */     throw new ClassCastException("Identified object is not a Character.");
/*     */   }
/*     */ 
/*     */   public String getString(String key)
/*     */   {
/* 539 */     Object obj = get(key);
/*     */     try
/*     */     {
/* 542 */       return (String)obj; } catch (Exception e) {
/*     */     }
/* 544 */     throw new ClassCastException("Identified object is not a String.");
/*     */   }
/*     */ 
/*     */   public int getIntFromString(String key)
/*     */   {
/* 557 */     Object obj = get(key);
/*     */ 
/* 559 */     return new Integer((String)obj).intValue();
/*     */   }
/*     */ 
/*     */   public long getIntValue(String key)
/*     */   {
/* 571 */     Object obj = get(key);
/*     */ 
/* 573 */     if ((obj instanceof String)) {
/* 574 */       return getIntFromString(key);
/*     */     }
/* 576 */     return getInt(key);
/*     */   }
/*     */ 
/*     */   public Integer getIntegerFromString(String key)
/*     */   {
/* 588 */     Object obj = get(key);
/*     */ 
/* 590 */     return new Integer((String)obj);
/*     */   }
/*     */ 
/*     */   public boolean getBooleanValueFromString(String key)
/*     */   {
/* 602 */     Object obj = get(key);
/*     */ 
/* 604 */     return new Boolean((String)obj).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean getBooleanValue(String key)
/*     */   {
/* 617 */     Object obj = get(key);
/*     */ 
/* 619 */     if ((obj instanceof String)) {
/* 620 */       return getBooleanValueFromString(key);
/*     */     }
/* 622 */     return getBoolean(key);
/*     */   }
/*     */ 
/*     */   public Boolean getBooleanFromString(String key)
/*     */   {
/* 634 */     Object obj = get(key);
/*     */ 
/* 636 */     return new Boolean((String)obj);
/*     */   }
/*     */ 
/*     */   public char getCharFromString(String key)
/*     */   {
/* 648 */     Object obj = get(key);
/*     */ 
/* 650 */     return ((String)obj).charAt(0);
/*     */   }
/*     */ 
/*     */   public Character getCharacterFromString(String key)
/*     */   {
/* 662 */     Object obj = get(key);
/*     */ 
/* 664 */     return new Character(((String)obj).charAt(0));
/*     */   }
/*     */ 
/*     */   public double getDoubleValueFromString(String key)
/*     */   {
/* 676 */     Object obj = get(key);
/*     */ 
/* 678 */     return new Double((String)obj).doubleValue();
/*     */   }
/*     */ 
/*     */   public double getDoubleValue(String key)
/*     */   {
/* 690 */     Object obj = get(key);
/*     */ 
/* 692 */     if ((obj instanceof String)) {
/* 693 */       return getDoubleValueFromString(key);
/*     */     }
/* 695 */     return getDouble(key);
/*     */   }
/*     */ 
/*     */   public Double getDoubleFromString(String key)
/*     */   {
/* 707 */     Object obj = get(key);
/*     */ 
/* 709 */     return new Double((String)obj);
/*     */   }
/*     */ 
/*     */   public float getFloatValueFromString(String key)
/*     */   {
/* 721 */     Object obj = get(key);
/*     */ 
/* 723 */     return new Float((String)obj).floatValue();
/*     */   }
/*     */ 
/*     */   public float getFloatValue(String key)
/*     */   {
/* 735 */     Object obj = get(key);
/*     */ 
/* 737 */     if ((obj instanceof String)) {
/* 738 */       return getFloatValueFromString(key);
/*     */     }
/* 740 */     return getFloat(key);
/*     */   }
/*     */ 
/*     */   public Float getFloatFromString(String key)
/*     */   {
/* 752 */     Object obj = get(key);
/*     */ 
/* 754 */     return new Float((String)obj);
/*     */   }
/*     */ 
/*     */   public long getLongValueFromString(String key)
/*     */   {
/* 766 */     Object obj = get(key);
/*     */ 
/* 768 */     return new Long((String)obj).longValue();
/*     */   }
/*     */ 
/*     */   public long getLongValue(String key)
/*     */   {
/* 780 */     Object obj = get(key);
/*     */ 
/* 782 */     if ((obj instanceof String)) {
/* 783 */       return getLongValueFromString(key);
/*     */     }
/* 785 */     return getLong(key);
/*     */   }
/*     */ 
/*     */   public Long getLongFromString(String key)
/*     */   {
/* 797 */     Object obj = get(key);
/*     */ 
/* 799 */     return new Long((String)obj);
/*     */   }
/*     */ 
/*     */   public String[] getKeys() {
/* 803 */     return (String[])keySet().toArray(new String[size()]);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.JobDataMap
 * JD-Core Version:    0.6.0
 */