/*      */ package org.quartz;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.Serializable;
/*      */ import java.text.ParseException;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Calendar;
/*      */ import java.util.Date;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.Locale;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.SortedSet;
/*      */ import java.util.StringTokenizer;
/*      */ import java.util.TimeZone;
/*      */ import java.util.TreeSet;
/*      */ 
/*      */ public class CronExpression
/*      */   implements Serializable, Cloneable
/*      */ {
/*      */   private static final long serialVersionUID = 12423409423L;
/*      */   protected static final int SECOND = 0;
/*      */   protected static final int MINUTE = 1;
/*      */   protected static final int HOUR = 2;
/*      */   protected static final int DAY_OF_MONTH = 3;
/*      */   protected static final int MONTH = 4;
/*      */   protected static final int DAY_OF_WEEK = 5;
/*      */   protected static final int YEAR = 6;
/*      */   protected static final int ALL_SPEC_INT = 99;
/*      */   protected static final int NO_SPEC_INT = 98;
/*  185 */   protected static final Integer ALL_SPEC = new Integer(99);
/*  186 */   protected static final Integer NO_SPEC = new Integer(98);
/*      */ 
/*  188 */   protected static Map monthMap = new HashMap(20);
/*  189 */   protected static Map dayMap = new HashMap(60);
/*      */ 
/*  213 */   private String cronExpression = null;
/*  214 */   private TimeZone timeZone = null;
/*      */   protected transient TreeSet seconds;
/*      */   protected transient TreeSet minutes;
/*      */   protected transient TreeSet hours;
/*      */   protected transient TreeSet daysOfMonth;
/*      */   protected transient TreeSet months;
/*      */   protected transient TreeSet daysOfWeek;
/*      */   protected transient TreeSet years;
/*  223 */   protected transient boolean lastdayOfWeek = false;
/*  224 */   protected transient int nthdayOfWeek = 0;
/*  225 */   protected transient boolean lastdayOfMonth = false;
/*  226 */   protected transient boolean nearestWeekday = false;
/*  227 */   protected transient boolean calendardayOfWeek = false;
/*  228 */   protected transient boolean calendardayOfMonth = false;
/*  229 */   protected transient boolean expressionParsed = false;
/*      */ 
/*      */   public CronExpression(String cronExpression)
/*      */     throws ParseException
/*      */   {
/*  242 */     if (cronExpression == null) {
/*  243 */       throw new IllegalArgumentException("cronExpression cannot be null");
/*      */     }
/*      */ 
/*  246 */     this.cronExpression = cronExpression;
/*      */ 
/*  248 */     buildExpression(cronExpression.toUpperCase(Locale.US));
/*      */   }
/*      */ 
/*      */   public boolean isSatisfiedBy(Date date)
/*      */   {
/*  261 */     Calendar testDateCal = Calendar.getInstance();
/*  262 */     testDateCal.setTime(date);
/*  263 */     testDateCal.set(14, 0);
/*  264 */     Date originalDate = testDateCal.getTime();
/*      */ 
/*  266 */     testDateCal.add(13, -1);
/*      */ 
/*  269 */     return getTimeAfter(testDateCal.getTime()).equals(originalDate);
/*      */   }
/*      */ 
/*      */   public Date getNextValidTimeAfter(Date date)
/*      */   {
/*  284 */     return getTimeAfter(date);
/*      */   }
/*      */ 
/*      */   public TimeZone getTimeZone()
/*      */   {
/*  294 */     if (this.timeZone == null) this.timeZone = TimeZone.getDefault();
/*      */ 
/*  296 */     return this.timeZone;
/*      */   }
/*      */ 
/*      */   public void setTimeZone(TimeZone timeZone)
/*      */   {
/*  306 */     this.timeZone = timeZone;
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  315 */     return this.cronExpression;
/*      */   }
/*      */ 
/*      */   public static boolean isValidExpression(String cronExpression)
/*      */   {
/*      */     try
/*      */     {
/*  329 */       new CronExpression(cronExpression);
/*      */     } catch (ParseException pe) {
/*  331 */       return false;
/*      */     }
/*      */ 
/*  334 */     return true;
/*      */   }
/*      */ 
/*      */   protected void buildExpression(String expression)
/*      */     throws ParseException
/*      */   {
/*  344 */     this.expressionParsed = true;
/*      */     try
/*      */     {
/*  348 */       if (this.seconds == null) this.seconds = new TreeSet();
/*  349 */       if (this.minutes == null) this.minutes = new TreeSet();
/*  350 */       if (this.hours == null) this.hours = new TreeSet();
/*  351 */       if (this.daysOfMonth == null) this.daysOfMonth = new TreeSet();
/*  352 */       if (this.months == null) this.months = new TreeSet();
/*  353 */       if (this.daysOfWeek == null) this.daysOfWeek = new TreeSet();
/*  354 */       if (this.years == null) this.years = new TreeSet();
/*      */ 
/*  356 */       int exprOn = 0;
/*      */ 
/*  358 */       StringTokenizer exprsTok = new StringTokenizer(expression, " \t", false);
/*      */ 
/*  361 */       while ((exprsTok.hasMoreTokens()) && (exprOn <= 6)) {
/*  362 */         String expr = exprsTok.nextToken().trim();
/*  363 */         StringTokenizer vTok = new StringTokenizer(expr, ",");
/*  364 */         while (vTok.hasMoreTokens()) {
/*  365 */           String v = vTok.nextToken();
/*  366 */           storeExpressionVals(0, v, exprOn);
/*      */         }
/*      */ 
/*  369 */         exprOn++;
/*      */       }
/*      */ 
/*  372 */       if (exprOn <= 5) {
/*  373 */         throw new ParseException("Unexpected end of expression.", expression.length());
/*      */       }
/*      */ 
/*  376 */       if (exprOn <= 6) storeExpressionVals(0, "*", 6); 
/*      */     }
/*      */     catch (ParseException pe)
/*      */     {
/*  379 */       throw pe;
/*      */     } catch (Exception e) {
/*  381 */       throw new ParseException("Illegal cron expression format (" + e.toString() + ")", 0);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int storeExpressionVals(int pos, String s, int type)
/*      */     throws ParseException
/*      */   {
/*  388 */     int incr = 0;
/*  389 */     int i = skipWhiteSpace(pos, s);
/*  390 */     if (i >= s.length()) return i;
/*  391 */     char c = s.charAt(i);
/*  392 */     if ((c >= 'A') && (c <= 'Z') && (!s.equals("L")) && (!s.equals("LW"))) {
/*  393 */       String sub = s.substring(i, i + 3);
/*  394 */       int sval = -1;
/*  395 */       int eval = -1;
/*  396 */       if (type == 4) {
/*  397 */         sval = getMonthNumber(sub) + 1;
/*  398 */         if (sval < 0) {
/*  399 */           throw new ParseException("Invalid Month value: '" + sub + "'", i);
/*      */         }
/*  401 */         if (s.length() > i + 3) {
/*  402 */           c = s.charAt(i + 3);
/*  403 */           if (c == '-') {
/*  404 */             i += 4;
/*  405 */             sub = s.substring(i, i + 3);
/*  406 */             eval = getMonthNumber(sub) + 1;
/*  407 */             if (eval < 0)
/*  408 */               throw new ParseException("Invalid Month value: '" + sub + "'", i);
/*      */           }
/*      */         }
/*      */       }
/*  412 */       else if (type == 5) {
/*  413 */         sval = getDayOfWeekNumber(sub);
/*  414 */         if (sval < 0) {
/*  415 */           throw new ParseException("Invalid Day-of-Week value: '" + sub + "'", i);
/*      */         }
/*  417 */         if (s.length() > i + 3) {
/*  418 */           c = s.charAt(i + 3);
/*  419 */           if (c == '-') {
/*  420 */             i += 4;
/*  421 */             sub = s.substring(i, i + 3);
/*  422 */             eval = getDayOfWeekNumber(sub);
/*  423 */             if (eval < 0) {
/*  424 */               throw new ParseException("Invalid Day-of-Week value: '" + sub + "'", i);
/*      */             }
/*      */ 
/*  427 */             if (sval > eval) {
/*  428 */               throw new ParseException("Invalid Day-of-Week sequence: " + sval + " > " + eval, i);
/*      */             }
/*      */ 
/*      */           }
/*  432 */           else if (c == '#') {
/*      */             try {
/*  434 */               i += 4;
/*  435 */               this.nthdayOfWeek = Integer.parseInt(s.substring(i));
/*  436 */               if ((this.nthdayOfWeek < 1) || (this.nthdayOfWeek > 5))
/*  437 */                 throw new Exception();
/*      */             } catch (Exception e) {
/*  439 */               throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", i);
/*      */             }
/*      */ 
/*      */           }
/*  443 */           else if (c == 'L') {
/*  444 */             this.lastdayOfWeek = true;
/*  445 */             i++;
/*      */           }
/*      */         }
/*      */       }
/*      */       else {
/*  450 */         throw new ParseException("Illegal characters for this position: '" + sub + "'", i);
/*      */       }
/*      */ 
/*  454 */       if (eval != -1) incr = 1;
/*  455 */       addToSet(sval, eval, incr, type);
/*  456 */       return i + 3;
/*      */     }
/*      */ 
/*  459 */     if (c == '?') {
/*  460 */       i++;
/*  461 */       if ((i + 1 < s.length()) && (s.charAt(i) != ' ') && (s.charAt(i + 1) != '\t'))
/*      */       {
/*  463 */         throw new ParseException("Illegal character after '?': " + s.charAt(i), i);
/*      */       }
/*  465 */       if ((type != 5) && (type != 3)) {
/*  466 */         throw new ParseException("'?' can only be specfied for Day-of-Month or Day-of-Week.", i);
/*      */       }
/*      */ 
/*  469 */       if ((type == 5) && (!this.lastdayOfMonth)) {
/*  470 */         int val = ((Integer)this.daysOfMonth.last()).intValue();
/*  471 */         if (val == 98) {
/*  472 */           throw new ParseException("'?' can only be specfied for Day-of-Month -OR- Day-of-Week.", i);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  477 */       addToSet(98, -1, 0, type);
/*  478 */       return i;
/*      */     }
/*      */ 
/*  481 */     if ((c == '*') || (c == '/')) {
/*  482 */       if ((c == '*') && (i + 1 >= s.length())) {
/*  483 */         addToSet(99, -1, incr, type);
/*  484 */         return i + 1;
/*  485 */       }if ((c == '/') && ((i + 1 >= s.length()) || (s.charAt(i + 1) == ' ') || (s.charAt(i + 1) == '\t')))
/*      */       {
/*  487 */         throw new ParseException("'/' must be followed by an integer.", i);
/*      */       }
/*  489 */       if (c == '*') i++;
/*  490 */       c = s.charAt(i);
/*  491 */       if (c == '/') {
/*  492 */         i++;
/*  493 */         if (i >= s.length()) {
/*  494 */           throw new ParseException("Unexpected end of string.", i);
/*      */         }
/*  496 */         incr = getNumericValue(s, i);
/*      */ 
/*  498 */         i++;
/*  499 */         if (incr > 10) i++;
/*  500 */         if ((incr > 59) && ((type == 0) || (type == 1))) throw new ParseException("Increment > 60 : " + incr, i);
/*      */ 
/*  502 */         if ((incr > 23) && (type == 2)) throw new ParseException("Increment > 24 : " + incr, i);
/*      */ 
/*  504 */         if ((incr > 31) && (type == 3)) throw new ParseException("Increment > 31 : " + incr, i);
/*      */ 
/*  506 */         if ((incr > 7) && (type == 5)) throw new ParseException("Increment > 7 : " + incr, i);
/*      */ 
/*  508 */         if ((incr > 12) && (type == 4))
/*  509 */           throw new ParseException("Increment > 12 : " + incr, i);
/*      */       } else {
/*  511 */         incr = 1;
/*      */       }
/*  513 */       addToSet(99, -1, incr, type);
/*  514 */       return i;
/*  515 */     }if (c == 'L') {
/*  516 */       i++;
/*  517 */       if (type == 3) this.lastdayOfMonth = true;
/*  518 */       if (type == 5) addToSet(7, 7, 0, type);
/*  519 */       if ((type == 3) && (s.length() > i)) {
/*  520 */         c = s.charAt(i);
/*  521 */         if (c == 'W') {
/*  522 */           this.nearestWeekday = true;
/*  523 */           i++;
/*      */         }
/*      */       }
/*  526 */       return i;
/*  527 */     }if ((c >= '0') && (c <= '9')) {
/*  528 */       int val = Integer.parseInt(String.valueOf(c));
/*  529 */       i++;
/*  530 */       if (i >= s.length()) { addToSet(val, -1, -1, type);
/*      */       } else {
/*  532 */         c = s.charAt(i);
/*  533 */         if ((c >= '0') && (c <= '9')) {
/*  534 */           ValueSet vs = getValue(val, s, i);
/*  535 */           val = vs.value;
/*  536 */           i = vs.pos;
/*      */         }
/*  538 */         i = checkNext(i, s, val, type);
/*  539 */         return i;
/*      */       }
/*      */     } else {
/*  542 */       throw new ParseException("Unexpected character: " + c, i);
/*      */     }
/*  544 */     return i;
/*      */   }
/*      */ 
/*      */   protected int checkNext(int pos, String s, int val, int type) throws ParseException
/*      */   {
/*  549 */     int end = -1;
/*  550 */     int i = pos;
/*      */ 
/*  552 */     if (i >= s.length()) {
/*  553 */       addToSet(val, end, -1, type);
/*  554 */       return i;
/*      */     }
/*      */ 
/*  557 */     char c = s.charAt(pos);
/*      */ 
/*  559 */     if (c == 'L') {
/*  560 */       if (type == 5) this.lastdayOfWeek = true;
/*      */       else {
/*  562 */         throw new ParseException("'L' option is not valid here. (pos=" + i + ")", i);
/*      */       }
/*  564 */       TreeSet set = getSet(type);
/*  565 */       set.add(new Integer(val));
/*  566 */       i++;
/*  567 */       return i;
/*      */     }
/*      */ 
/*  570 */     if (c == 'W') {
/*  571 */       if (type == 3) this.nearestWeekday = true;
/*      */       else {
/*  573 */         throw new ParseException("'W' option is not valid here. (pos=" + i + ")", i);
/*      */       }
/*  575 */       TreeSet set = getSet(type);
/*  576 */       set.add(new Integer(val));
/*  577 */       i++;
/*  578 */       return i;
/*      */     }
/*      */ 
/*  581 */     if (c == '#') {
/*  582 */       if (type != 5) {
/*  583 */         throw new ParseException("'#' option is not valid here. (pos=" + i + ")", i);
/*      */       }
/*  585 */       i++;
/*      */       try {
/*  587 */         this.nthdayOfWeek = Integer.parseInt(s.substring(i));
/*  588 */         if ((this.nthdayOfWeek < 1) || (this.nthdayOfWeek > 5))
/*  589 */           throw new Exception();
/*      */       } catch (Exception e) {
/*  591 */         throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", i);
/*      */       }
/*      */ 
/*  596 */       TreeSet set = getSet(type);
/*  597 */       set.add(new Integer(val));
/*  598 */       i++;
/*  599 */       return i;
/*      */     }
/*      */ 
/*  602 */     if (c == 'C') {
/*  603 */       if (type == 5) this.calendardayOfWeek = true;
/*  604 */       else if (type == 3) this.calendardayOfMonth = true;
/*      */       else {
/*  606 */         throw new ParseException("'C' option is not valid here. (pos=" + i + ")", i);
/*      */       }
/*  608 */       TreeSet set = getSet(type);
/*  609 */       set.add(new Integer(val));
/*  610 */       i++;
/*  611 */       return i;
/*      */     }
/*      */ 
/*  614 */     if (c == '-') {
/*  615 */       i++;
/*  616 */       c = s.charAt(i);
/*  617 */       int v = Integer.parseInt(String.valueOf(c));
/*  618 */       end = v;
/*  619 */       i++;
/*  620 */       if (i >= s.length()) {
/*  621 */         addToSet(val, end, 1, type);
/*  622 */         return i;
/*      */       }
/*  624 */       c = s.charAt(i);
/*  625 */       if ((c >= '0') && (c <= '9')) {
/*  626 */         ValueSet vs = getValue(v, s, i);
/*  627 */         int v1 = vs.value;
/*  628 */         end = v1;
/*  629 */         i = vs.pos;
/*      */       }
/*  631 */       if ((i < s.length()) && ((c = s.charAt(i)) == '/')) {
/*  632 */         i++;
/*  633 */         c = s.charAt(i);
/*  634 */         int v2 = Integer.parseInt(String.valueOf(c));
/*  635 */         i++;
/*  636 */         if (i >= s.length()) {
/*  637 */           addToSet(val, end, v2, type);
/*  638 */           return i;
/*      */         }
/*  640 */         c = s.charAt(i);
/*  641 */         if ((c >= '0') && (c <= '9')) {
/*  642 */           ValueSet vs = getValue(v2, s, i);
/*  643 */           int v3 = vs.value;
/*  644 */           addToSet(val, end, v3, type);
/*  645 */           i = vs.pos;
/*  646 */           return i;
/*      */         }
/*  648 */         addToSet(val, end, v2, type);
/*  649 */         return i;
/*      */       }
/*      */ 
/*  652 */       addToSet(val, end, 1, type);
/*  653 */       return i;
/*      */     }
/*      */ 
/*  657 */     if (c == '/') {
/*  658 */       i++;
/*  659 */       c = s.charAt(i);
/*  660 */       int v2 = Integer.parseInt(String.valueOf(c));
/*  661 */       i++;
/*  662 */       if (i >= s.length()) {
/*  663 */         addToSet(val, end, v2, type);
/*  664 */         return i;
/*      */       }
/*  666 */       c = s.charAt(i);
/*  667 */       if ((c >= '0') && (c <= '9')) {
/*  668 */         ValueSet vs = getValue(v2, s, i);
/*  669 */         int v3 = vs.value;
/*  670 */         addToSet(val, end, v3, type);
/*  671 */         i = vs.pos;
/*  672 */         return i;
/*      */       }
/*  674 */       throw new ParseException("Unexpected character '" + c + "' after '/'", i);
/*      */     }
/*      */ 
/*  678 */     addToSet(val, end, 0, type);
/*  679 */     i++;
/*  680 */     return i;
/*      */   }
/*      */ 
/*      */   public String getCronExpression() {
/*  684 */     return this.cronExpression;
/*      */   }
/*      */ 
/*      */   public String getExpressionSummary() {
/*  688 */     StringBuffer buf = new StringBuffer();
/*      */ 
/*  690 */     buf.append("seconds: ");
/*  691 */     buf.append(getExpressionSetSummary(this.seconds));
/*  692 */     buf.append("\n");
/*  693 */     buf.append("minutes: ");
/*  694 */     buf.append(getExpressionSetSummary(this.minutes));
/*  695 */     buf.append("\n");
/*  696 */     buf.append("hours: ");
/*  697 */     buf.append(getExpressionSetSummary(this.hours));
/*  698 */     buf.append("\n");
/*  699 */     buf.append("daysOfMonth: ");
/*  700 */     buf.append(getExpressionSetSummary(this.daysOfMonth));
/*  701 */     buf.append("\n");
/*  702 */     buf.append("months: ");
/*  703 */     buf.append(getExpressionSetSummary(this.months));
/*  704 */     buf.append("\n");
/*  705 */     buf.append("daysOfWeek: ");
/*  706 */     buf.append(getExpressionSetSummary(this.daysOfWeek));
/*  707 */     buf.append("\n");
/*  708 */     buf.append("lastdayOfWeek: ");
/*  709 */     buf.append(this.lastdayOfWeek);
/*  710 */     buf.append("\n");
/*  711 */     buf.append("nearestWeekday: ");
/*  712 */     buf.append(this.nearestWeekday);
/*  713 */     buf.append("\n");
/*  714 */     buf.append("NthDayOfWeek: ");
/*  715 */     buf.append(this.nthdayOfWeek);
/*  716 */     buf.append("\n");
/*  717 */     buf.append("lastdayOfMonth: ");
/*  718 */     buf.append(this.lastdayOfMonth);
/*  719 */     buf.append("\n");
/*  720 */     buf.append("calendardayOfWeek: ");
/*  721 */     buf.append(this.calendardayOfWeek);
/*  722 */     buf.append("\n");
/*  723 */     buf.append("calendardayOfMonth: ");
/*  724 */     buf.append(this.calendardayOfMonth);
/*  725 */     buf.append("\n");
/*  726 */     buf.append("years: ");
/*  727 */     buf.append(getExpressionSetSummary(this.years));
/*  728 */     buf.append("\n");
/*      */ 
/*  730 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   protected String getExpressionSetSummary(Set set)
/*      */   {
/*  735 */     if (set.contains(NO_SPEC)) return "?";
/*  736 */     if (set.contains(ALL_SPEC)) return "*";
/*      */ 
/*  738 */     StringBuffer buf = new StringBuffer();
/*      */ 
/*  740 */     Iterator itr = set.iterator();
/*  741 */     boolean first = true;
/*  742 */     while (itr.hasNext()) {
/*  743 */       Integer iVal = (Integer)itr.next();
/*  744 */       String val = iVal.toString();
/*  745 */       if (!first) buf.append(",");
/*  746 */       buf.append(val);
/*  747 */       first = false;
/*      */     }
/*      */ 
/*  750 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   protected String getExpressionSetSummary(ArrayList list)
/*      */   {
/*  755 */     if (list.contains(NO_SPEC)) return "?";
/*  756 */     if (list.contains(ALL_SPEC)) return "*";
/*      */ 
/*  758 */     StringBuffer buf = new StringBuffer();
/*      */ 
/*  760 */     Iterator itr = list.iterator();
/*  761 */     boolean first = true;
/*  762 */     while (itr.hasNext()) {
/*  763 */       Integer iVal = (Integer)itr.next();
/*  764 */       String val = iVal.toString();
/*  765 */       if (!first) buf.append(",");
/*  766 */       buf.append(val);
/*  767 */       first = false;
/*      */     }
/*      */ 
/*  770 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   protected int skipWhiteSpace(int i, String s) {
/*  774 */     while ((i < s.length()) && ((s.charAt(i) == ' ') || (s.charAt(i) == '\t'))) i++;
/*      */ 
/*  777 */     return i;
/*      */   }
/*      */ 
/*      */   protected int findNextWhiteSpace(int i, String s) {
/*  781 */     while ((i < s.length()) && ((s.charAt(i) != ' ') || (s.charAt(i) != '\t'))) i++;
/*      */ 
/*  784 */     return i;
/*      */   }
/*      */ 
/*      */   protected void addToSet(int val, int end, int incr, int type) throws ParseException
/*      */   {
/*  789 */     TreeSet set = getSet(type);
/*      */ 
/*  791 */     if ((type == 0) || (type == 1)) {
/*  792 */       if (((val < 0) || (val > 59) || (end > 59)) && (val != 99)) {
/*  793 */         throw new ParseException("Minute and Second values must be between 0 and 59", -1);
/*      */       }
/*      */     }
/*  796 */     else if (type == 2) {
/*  797 */       if (((val < 0) || (val > 23) || (end > 23)) && (val != 99))
/*  798 */         throw new ParseException("Hour values must be between 0 and 23", -1);
/*      */     }
/*  800 */     else if (type == 3) {
/*  801 */       if (((val < 1) || (val > 31) || (end > 31)) && (val != 99) && (val != 98))
/*      */       {
/*  803 */         throw new ParseException("Day of month values must be between 1 and 31", -1);
/*      */       }
/*  805 */     } else if (type == 4) {
/*  806 */       if (((val < 1) || (val > 12) || (end > 12)) && (val != 99))
/*  807 */         throw new ParseException("Month values must be between 1 and 12", -1);
/*      */     }
/*  809 */     else if ((type == 5) && 
/*  810 */       ((val == 0) || (val > 7) || (end > 7)) && (val != 99) && (val != 98))
/*      */     {
/*  812 */       throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
/*      */     }
/*      */ 
/*  816 */     if (((incr == 0) || (incr == -1)) && (val != 99)) {
/*  817 */       if (val != -1) set.add(new Integer(val));
/*      */       else
/*  819 */         set.add(NO_SPEC);
/*  820 */       return;
/*      */     }
/*      */ 
/*  823 */     int startAt = val;
/*  824 */     int stopAt = end;
/*      */ 
/*  826 */     if ((val == 99) && (incr <= 0)) {
/*  827 */       incr = 1;
/*  828 */       set.add(ALL_SPEC);
/*      */     }
/*      */ 
/*  831 */     if ((type == 0) || (type == 1)) {
/*  832 */       if (stopAt == -1) stopAt = 59;
/*  833 */       if ((startAt == -1) || (startAt == 99)) startAt = 0; 
/*      */     }
/*  834 */     else if (type == 2) {
/*  835 */       if (stopAt == -1) stopAt = 23;
/*  836 */       if ((startAt == -1) || (startAt == 99)) startAt = 0; 
/*      */     }
/*  837 */     else if (type == 3) {
/*  838 */       if (stopAt == -1) stopAt = 31;
/*  839 */       if ((startAt == -1) || (startAt == 99)) startAt = 1; 
/*      */     }
/*  840 */     else if (type == 4) {
/*  841 */       if (stopAt == -1) stopAt = 12;
/*  842 */       if ((startAt == -1) || (startAt == 99)) startAt = 1; 
/*      */     }
/*  843 */     else if (type == 5) {
/*  844 */       if (stopAt == -1) stopAt = 7;
/*  845 */       if ((startAt == -1) || (startAt == 99)) startAt = 1; 
/*      */     }
/*  846 */     else if (type == 6) {
/*  847 */       if (stopAt == -1) stopAt = 2099;
/*  848 */       if ((startAt == -1) || (startAt == 99)) startAt = 1970;
/*      */     }
/*      */ 
/*  851 */     for (int i = startAt; i <= stopAt; i += incr)
/*  852 */       set.add(new Integer(i));
/*      */   }
/*      */ 
/*      */   protected TreeSet getSet(int type) {
/*  856 */     switch (type) {
/*      */     case 0:
/*  858 */       return this.seconds;
/*      */     case 1:
/*  860 */       return this.minutes;
/*      */     case 2:
/*  862 */       return this.hours;
/*      */     case 3:
/*  864 */       return this.daysOfMonth;
/*      */     case 4:
/*  866 */       return this.months;
/*      */     case 5:
/*  868 */       return this.daysOfWeek;
/*      */     case 6:
/*  870 */       return this.years;
/*      */     }
/*  872 */     return null;
/*      */   }
/*      */ 
/*      */   protected ValueSet getValue(int v, String s, int i)
/*      */   {
/*  877 */     char c = s.charAt(i);
/*  878 */     String s1 = String.valueOf(v);
/*  879 */     while ((c >= '0') && (c <= '9')) {
/*  880 */       s1 = s1 + c;
/*  881 */       i++;
/*  882 */       if (i >= s.length()) break;
/*  883 */       c = s.charAt(i);
/*      */     }
/*  885 */     ValueSet val = new ValueSet();
/*  886 */     if (i < s.length()) val.pos = i;
/*      */     else
/*  888 */       val.pos = (i + 1);
/*  889 */     val.value = Integer.parseInt(s1);
/*  890 */     return val;
/*      */   }
/*      */ 
/*      */   protected int getNumericValue(String s, int i) {
/*  894 */     int endOfVal = findNextWhiteSpace(i, s);
/*  895 */     String val = s.substring(i, endOfVal);
/*  896 */     return Integer.parseInt(val);
/*      */   }
/*      */ 
/*      */   protected int getMonthNumber(String s) {
/*  900 */     Integer integer = (Integer)monthMap.get(s);
/*      */ 
/*  902 */     if (integer == null) return -1;
/*      */ 
/*  904 */     return integer.intValue();
/*      */   }
/*      */ 
/*      */   protected int getDayOfWeekNumber(String s) {
/*  908 */     Integer integer = (Integer)dayMap.get(s);
/*      */ 
/*  910 */     if (integer == null) return -1;
/*      */ 
/*  912 */     return integer.intValue();
/*      */   }
/*      */ 
/*      */   protected Date getTime(int sc, int mn, int hr, int dayofmn, int mon) {
/*      */     try {
/*  917 */       Calendar cl = Calendar.getInstance(getTimeZone());
/*      */ 
/*  919 */       if ((hr >= 0) && (hr <= 12)) cl.set(9, 0);
/*  920 */       if ((hr >= 13) && (hr <= 23)) cl.set(9, 1);
/*  921 */       cl.setLenient(false);
/*  922 */       if (sc != -1) cl.set(13, sc);
/*  923 */       if (mn != -1) cl.set(12, mn);
/*  924 */       if (hr != -1) cl.set(11, hr);
/*  925 */       if (dayofmn != -1) cl.set(5, dayofmn);
/*  926 */       if (mon != -1) cl.set(2, mon);
/*  927 */       return cl.getTime(); } catch (Exception e) {
/*      */     }
/*  929 */     return null;
/*      */   }
/*      */ 
/*      */   protected Date getTimeAfter(Date afterTime)
/*      */   {
/*  941 */     Calendar cl = Calendar.getInstance(getTimeZone());
/*      */ 
/*  945 */     afterTime = new Date(afterTime.getTime() + 1000L);
/*      */ 
/*  947 */     cl.setTime(afterTime);
/*  948 */     cl.set(14, 0);
/*      */ 
/*  950 */     boolean gotOne = false;
/*      */ 
/*  952 */     while (!gotOne)
/*      */     {
/*  956 */       SortedSet st = null;
/*  957 */       int t = 0;
/*      */ 
/*  959 */       int sec = cl.get(13);
/*  960 */       int min = cl.get(12);
/*      */ 
/*  963 */       st = this.seconds.tailSet(new Integer(sec));
/*  964 */       if ((st != null) && (st.size() != 0)) {
/*  965 */         sec = ((Integer)st.first()).intValue();
/*      */       } else {
/*  967 */         sec = ((Integer)this.seconds.first()).intValue();
/*  968 */         min++;
/*  969 */         cl.set(12, min);
/*      */       }
/*  971 */       cl.set(13, sec);
/*      */ 
/*  973 */       min = cl.get(12);
/*  974 */       int hr = cl.get(11);
/*  975 */       t = -1;
/*      */ 
/*  978 */       st = this.minutes.tailSet(new Integer(min));
/*  979 */       if ((st != null) && (st.size() != 0)) {
/*  980 */         t = min;
/*  981 */         min = ((Integer)st.first()).intValue();
/*      */       } else {
/*  983 */         min = ((Integer)this.minutes.first()).intValue();
/*  984 */         hr++;
/*      */       }
/*  986 */       if (min != t) {
/*  987 */         cl.set(13, 0);
/*  988 */         cl.set(12, min);
/*  989 */         setCalendarHour(cl, hr);
/*  990 */         continue;
/*      */       }
/*  992 */       cl.set(12, min);
/*      */ 
/*  994 */       hr = cl.get(11);
/*  995 */       int day = cl.get(5);
/*  996 */       t = -1;
/*      */ 
/*  999 */       st = this.hours.tailSet(new Integer(hr));
/* 1000 */       if ((st != null) && (st.size() != 0)) {
/* 1001 */         t = hr;
/* 1002 */         hr = ((Integer)st.first()).intValue();
/*      */       } else {
/* 1004 */         hr = ((Integer)this.hours.first()).intValue();
/* 1005 */         day++;
/*      */       }
/* 1007 */       if (hr != t) {
/* 1008 */         cl.set(13, 0);
/* 1009 */         cl.set(12, 0);
/* 1010 */         cl.set(5, day);
/* 1011 */         setCalendarHour(cl, hr);
/* 1012 */         continue;
/*      */       }
/* 1014 */       cl.set(11, hr);
/*      */ 
/* 1016 */       day = cl.get(5);
/* 1017 */       int mon = cl.get(2) + 1;
/*      */ 
/* 1020 */       t = -1;
/* 1021 */       int tmon = mon;
/*      */ 
/* 1024 */       boolean dayOfMSpec = !this.daysOfMonth.contains(NO_SPEC);
/* 1025 */       boolean dayOfWSpec = !this.daysOfWeek.contains(NO_SPEC);
/* 1026 */       if ((dayOfMSpec) && (!dayOfWSpec)) {
/* 1027 */         st = this.daysOfMonth.tailSet(new Integer(day));
/* 1028 */         if (this.lastdayOfMonth) {
/* 1029 */           if (!this.nearestWeekday) {
/* 1030 */             t = day;
/* 1031 */             day = getLastDayOfMonth(mon, cl.get(1));
/*      */           }
/*      */           else {
/* 1034 */             t = day;
/* 1035 */             day = getLastDayOfMonth(mon, cl.get(1));
/*      */ 
/* 1037 */             Calendar tcal = Calendar.getInstance();
/* 1038 */             tcal.set(13, 0);
/* 1039 */             tcal.set(12, 0);
/* 1040 */             tcal.set(11, 0);
/* 1041 */             tcal.set(5, day);
/* 1042 */             tcal.set(2, mon - 1);
/* 1043 */             tcal.set(1, cl.get(1));
/*      */ 
/* 1045 */             int ldom = getLastDayOfMonth(mon, cl.get(1));
/* 1046 */             int dow = tcal.get(7);
/*      */ 
/* 1048 */             if ((dow == 7) && (day == 1))
/* 1049 */               day += 2;
/* 1050 */             else if (dow == 7)
/* 1051 */               day--;
/* 1052 */             else if ((dow == 1) && (day == ldom))
/* 1053 */               day -= 2;
/* 1054 */             else if (dow == 1) {
/* 1055 */               day++;
/*      */             }
/* 1057 */             tcal.set(13, sec);
/* 1058 */             tcal.set(12, min);
/* 1059 */             tcal.set(11, hr);
/* 1060 */             tcal.set(5, day);
/* 1061 */             tcal.set(2, mon - 1);
/* 1062 */             Date nTime = tcal.getTime();
/* 1063 */             if (nTime.before(afterTime)) {
/* 1064 */               day = 1;
/* 1065 */               mon++;
/*      */             }
/*      */           }
/* 1068 */         } else if (this.nearestWeekday) {
/* 1069 */           t = day;
/* 1070 */           day = ((Integer)this.daysOfMonth.first()).intValue();
/*      */ 
/* 1072 */           Calendar tcal = Calendar.getInstance();
/* 1073 */           tcal.set(13, 0);
/* 1074 */           tcal.set(12, 0);
/* 1075 */           tcal.set(11, 0);
/* 1076 */           tcal.set(5, day);
/* 1077 */           tcal.set(2, mon - 1);
/* 1078 */           tcal.set(1, cl.get(1));
/*      */ 
/* 1080 */           int ldom = getLastDayOfMonth(mon, cl.get(1));
/* 1081 */           int dow = tcal.get(7);
/*      */ 
/* 1083 */           if ((dow == 7) && (day == 1))
/* 1084 */             day += 2;
/* 1085 */           else if (dow == 7)
/* 1086 */             day--;
/* 1087 */           else if ((dow == 1) && (day == ldom))
/* 1088 */             day -= 2;
/* 1089 */           else if (dow == 1) {
/* 1090 */             day++;
/*      */           }
/*      */ 
/* 1093 */           tcal.set(13, sec);
/* 1094 */           tcal.set(12, min);
/* 1095 */           tcal.set(11, hr);
/* 1096 */           tcal.set(5, day);
/* 1097 */           tcal.set(2, mon - 1);
/* 1098 */           Date nTime = tcal.getTime();
/* 1099 */           if (nTime.before(afterTime)) {
/* 1100 */             day = ((Integer)this.daysOfMonth.first()).intValue();
/* 1101 */             mon++;
/*      */           }
/*      */         }
/* 1104 */         else if ((st != null) && (st.size() != 0)) {
/* 1105 */           t = day;
/* 1106 */           day = ((Integer)st.first()).intValue();
/*      */         } else {
/* 1108 */           day = ((Integer)this.daysOfMonth.first()).intValue();
/* 1109 */           mon++;
/*      */         }
/*      */ 
/* 1112 */         if ((day != t) || (mon != tmon)) {
/* 1113 */           cl.set(13, 0);
/* 1114 */           cl.set(12, 0);
/* 1115 */           cl.set(11, 0);
/* 1116 */           cl.set(5, day);
/* 1117 */           cl.set(2, mon - 1);
/*      */ 
/* 1120 */           continue;
/*      */         }
/* 1122 */       } else if ((dayOfWSpec) && (!dayOfMSpec)) {
/* 1123 */         if (this.lastdayOfWeek)
/*      */         {
/* 1125 */           int dow = ((Integer)this.daysOfWeek.first()).intValue();
/*      */ 
/* 1127 */           int cDow = cl.get(7);
/* 1128 */           int daysToAdd = 0;
/* 1129 */           if (cDow < dow) daysToAdd = dow - cDow;
/* 1130 */           if (cDow > dow) daysToAdd = dow + (7 - cDow);
/*      */ 
/* 1132 */           int lDay = getLastDayOfMonth(mon, cl.get(1));
/*      */ 
/* 1134 */           if (day + daysToAdd > lDay)
/*      */           {
/* 1136 */             cl.set(13, 0);
/* 1137 */             cl.set(12, 0);
/* 1138 */             cl.set(11, 0);
/* 1139 */             cl.set(5, 1);
/* 1140 */             cl.set(2, mon);
/*      */ 
/* 1142 */             continue;
/*      */           }
/*      */ 
/* 1146 */           while (day + daysToAdd + 7 <= lDay) {
/* 1147 */             daysToAdd += 7;
/*      */           }
/* 1149 */           day += daysToAdd;
/*      */ 
/* 1151 */           if (daysToAdd > 0) {
/* 1152 */             cl.set(13, 0);
/* 1153 */             cl.set(12, 0);
/* 1154 */             cl.set(11, 0);
/* 1155 */             cl.set(5, day);
/* 1156 */             cl.set(2, mon - 1);
/*      */ 
/* 1158 */             continue;
/*      */           }
/*      */         }
/* 1161 */         else if (this.nthdayOfWeek != 0)
/*      */         {
/* 1163 */           int dow = ((Integer)this.daysOfWeek.first()).intValue();
/*      */ 
/* 1165 */           int cDow = cl.get(7);
/* 1166 */           int daysToAdd = 0;
/* 1167 */           if (cDow < dow) daysToAdd = dow - cDow;
/* 1168 */           else if (cDow > dow) daysToAdd = dow + (7 - cDow);
/*      */ 
/* 1170 */           boolean dayShifted = false;
/* 1171 */           if (daysToAdd > 0) dayShifted = true;
/*      */ 
/* 1173 */           day += daysToAdd;
/* 1174 */           int weekOfMonth = day / 7;
/* 1175 */           if (day % 7 > 0) weekOfMonth++;
/*      */ 
/* 1177 */           daysToAdd = (this.nthdayOfWeek - weekOfMonth) * 7;
/* 1178 */           day += daysToAdd;
/* 1179 */           if ((daysToAdd < 0) || (day > getLastDayOfMonth(mon, cl.get(1))))
/*      */           {
/* 1182 */             cl.set(13, 0);
/* 1183 */             cl.set(12, 0);
/* 1184 */             cl.set(11, 0);
/* 1185 */             cl.set(5, 1);
/* 1186 */             cl.set(2, mon);
/*      */ 
/* 1188 */             continue;
/* 1189 */           }if ((daysToAdd > 0) || (dayShifted)) {
/* 1190 */             cl.set(13, 0);
/* 1191 */             cl.set(12, 0);
/* 1192 */             cl.set(11, 0);
/* 1193 */             cl.set(5, day);
/* 1194 */             cl.set(2, mon - 1);
/*      */ 
/* 1196 */             continue;
/*      */           }
/*      */         } else {
/* 1199 */           int cDow = cl.get(7);
/* 1200 */           int dow = ((Integer)this.daysOfWeek.first()).intValue();
/*      */ 
/* 1202 */           st = this.daysOfWeek.tailSet(new Integer(cDow));
/* 1203 */           if ((st != null) && (st.size() > 0)) {
/* 1204 */             dow = ((Integer)st.first()).intValue();
/*      */           }
/*      */ 
/* 1207 */           int daysToAdd = 0;
/* 1208 */           if (cDow < dow) daysToAdd = dow - cDow;
/* 1209 */           if (cDow > dow) daysToAdd = dow + (7 - cDow);
/*      */ 
/* 1211 */           int lDay = getLastDayOfMonth(mon, cl.get(1));
/*      */ 
/* 1213 */           if (day + daysToAdd > lDay)
/*      */           {
/* 1215 */             cl.set(13, 0);
/* 1216 */             cl.set(12, 0);
/* 1217 */             cl.set(11, 0);
/* 1218 */             cl.set(5, 1);
/* 1219 */             cl.set(2, mon);
/*      */ 
/* 1221 */             continue;
/* 1222 */           }if (daysToAdd > 0) {
/* 1223 */             cl.set(13, 0);
/* 1224 */             cl.set(12, 0);
/* 1225 */             cl.set(11, 0);
/* 1226 */             cl.set(5, day + daysToAdd);
/* 1227 */             cl.set(2, mon - 1);
/*      */ 
/* 1230 */             continue;
/*      */           }
/*      */         }
/*      */       } else {
/* 1234 */         throw new UnsupportedOperationException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.");
/*      */       }
/*      */ 
/* 1238 */       cl.set(5, day);
/*      */ 
/* 1240 */       mon = cl.get(2) + 1;
/*      */ 
/* 1243 */       int year = cl.get(1);
/* 1244 */       t = -1;
/*      */ 
/* 1248 */       if (year > 2099) return null;
/*      */ 
/* 1251 */       st = this.months.tailSet(new Integer(mon));
/* 1252 */       if ((st != null) && (st.size() != 0)) {
/* 1253 */         t = mon;
/* 1254 */         mon = ((Integer)st.first()).intValue();
/*      */       } else {
/* 1256 */         mon = ((Integer)this.months.first()).intValue();
/* 1257 */         year++;
/*      */       }
/* 1259 */       if (mon != t) {
/* 1260 */         cl.set(13, 0);
/* 1261 */         cl.set(12, 0);
/* 1262 */         cl.set(11, 0);
/* 1263 */         cl.set(5, 1);
/* 1264 */         cl.set(2, mon - 1);
/*      */ 
/* 1267 */         cl.set(1, year);
/* 1268 */         continue;
/*      */       }
/* 1270 */       cl.set(2, mon - 1);
/*      */ 
/* 1274 */       year = cl.get(1);
/* 1275 */       t = -1;
/*      */ 
/* 1278 */       st = this.years.tailSet(new Integer(year));
/* 1279 */       if ((st != null) && (st.size() != 0)) {
/* 1280 */         t = year;
/* 1281 */         year = ((Integer)st.first()).intValue();
/*      */       } else {
/* 1283 */         return null;
/*      */       }
/* 1285 */       if (year != t) {
/* 1286 */         cl.set(13, 0);
/* 1287 */         cl.set(12, 0);
/* 1288 */         cl.set(11, 0);
/* 1289 */         cl.set(5, 1);
/* 1290 */         cl.set(2, 0);
/*      */ 
/* 1293 */         cl.set(1, year);
/* 1294 */         continue;
/*      */       }
/* 1296 */       cl.set(1, year);
/*      */ 
/* 1298 */       gotOne = true;
/*      */     }
/*      */ 
/* 1301 */     return cl.getTime();
/*      */   }
/*      */ 
/*      */   protected void setCalendarHour(Calendar cal, int hour)
/*      */   {
/* 1312 */     cal.set(11, hour);
/* 1313 */     if ((cal.get(11) != hour) && (hour != 24))
/* 1314 */       cal.set(11, hour + 1);
/*      */   }
/*      */ 
/*      */   protected Date getTimeBefore(Date endTime)
/*      */   {
/* 1320 */     return null;
/*      */   }
/*      */ 
/*      */   protected boolean isLeapYear(int year) {
/* 1324 */     return ((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0);
/*      */   }
/*      */ 
/*      */   protected int getLastDayOfMonth(int monthNum, int year)
/*      */   {
/* 1331 */     switch (monthNum) {
/*      */     case 1:
/* 1333 */       return 31;
/*      */     case 2:
/* 1335 */       return isLeapYear(year) ? 29 : 28;
/*      */     case 3:
/* 1337 */       return 31;
/*      */     case 4:
/* 1339 */       return 30;
/*      */     case 5:
/* 1341 */       return 31;
/*      */     case 6:
/* 1343 */       return 30;
/*      */     case 7:
/* 1345 */       return 31;
/*      */     case 8:
/* 1347 */       return 31;
/*      */     case 9:
/* 1349 */       return 30;
/*      */     case 10:
/* 1351 */       return 31;
/*      */     case 11:
/* 1353 */       return 30;
/*      */     case 12:
/* 1355 */       return 31;
/*      */     }
/* 1357 */     throw new IllegalArgumentException("Illegal month number: " + monthNum);
/*      */   }
/*      */ 
/*      */   private void readObject(ObjectInputStream stream)
/*      */     throws IOException, ClassNotFoundException
/*      */   {
/* 1365 */     stream.defaultReadObject();
/*      */     try {
/* 1367 */       buildExpression(this.cronExpression);
/*      */     } catch (Exception ignore) {
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object clone() {
/* 1373 */     CronExpression copy = null;
/*      */     try {
/* 1375 */       copy = new CronExpression(getCronExpression());
/* 1376 */       copy.setTimeZone(getTimeZone());
/*      */     } catch (ParseException ex) {
/* 1378 */       throw new IncompatibleClassChangeError("Not Cloneable.");
/*      */     }
/* 1380 */     return copy;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  191 */     monthMap.put("JAN", new Integer(0));
/*  192 */     monthMap.put("FEB", new Integer(1));
/*  193 */     monthMap.put("MAR", new Integer(2));
/*  194 */     monthMap.put("APR", new Integer(3));
/*  195 */     monthMap.put("MAY", new Integer(4));
/*  196 */     monthMap.put("JUN", new Integer(5));
/*  197 */     monthMap.put("JUL", new Integer(6));
/*  198 */     monthMap.put("AUG", new Integer(7));
/*  199 */     monthMap.put("SEP", new Integer(8));
/*  200 */     monthMap.put("OCT", new Integer(9));
/*  201 */     monthMap.put("NOV", new Integer(10));
/*  202 */     monthMap.put("DEC", new Integer(11));
/*      */ 
/*  204 */     dayMap.put("SUN", new Integer(1));
/*  205 */     dayMap.put("MON", new Integer(2));
/*  206 */     dayMap.put("TUE", new Integer(3));
/*  207 */     dayMap.put("WED", new Integer(4));
/*  208 */     dayMap.put("THU", new Integer(5));
/*  209 */     dayMap.put("FRI", new Integer(6));
/*  210 */     dayMap.put("SAT", new Integer(7));
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.CronExpression
 * JD-Core Version:    0.6.0
 */