package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SqlFile
{
  private static final int DEFAULT_HISTORY_SIZE = 40;
  private File file;
  private boolean interactive;
  private String primaryPrompt = "sql> ";
  private String rawPrompt = null;
  private String contPrompt = "  +> ";
  private Connection curConn = null;
  private boolean htmlMode = false;
  private Map userVars;
  private List history = null;
  private int rawMode = 0;
  private String nullRepToken = null;
  private String dsvTargetFile = null;
  private String dsvTargetTable = null;
  private String dsvConstCols = null;
  private String dsvRejectFile = null;
  private String dsvRejectReport = null;
  public static String LS = System.getProperty("line.separator");
  private int maxHistoryLength = 1;
  private SqltoolRB rb = null;
  private String magicPrefix = null;
  private static final int RAW_FALSE = 0;
  private static final int RAW_EMPTY = 1;
  private static final int RAW_DATA = 2;
  private static Pattern specialPattern = Pattern.compile("\\s*\\\\(\\S+)(?:\\s+(.*\\S))?\\s*");
  private static Pattern plPattern = Pattern.compile("\\s*\\*\\s*(.*\\S)?\\s*");
  private static Pattern foreachPattern = Pattern.compile("\\s*\\*\\s*foreach\\s+(\\S+)\\s*\\(([^)]*)\\)\\s*");
  private static Pattern ifwhilePattern = Pattern.compile("\\s*\\*\\s*\\S+\\s*\\(([^)]*)\\)\\s*");
  private static Pattern varsetPattern = Pattern.compile("\\s*\\*\\s*(\\S+)\\s*([=_~])\\s*(?:(.*\\S)\\s*)?");
  private static Pattern substitutionPattern = Pattern.compile("(\\S)(.+?)\\1(.*?)\\1(.+)?\\s*");
  private static Pattern slashHistoryPattern = Pattern.compile("\\s*/([^/]+)/\\s*(\\S.*)?");
  private static Pattern historyPattern = Pattern.compile("\\s*(-?\\d+)?\\s*(\\S.*)?");
  private static Pattern wincmdPattern = null;
  BooleanBucket possiblyUncommitteds = new BooleanBucket();
  private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
  private static final String SPACES = "                                                                                                                                  ";
  private static String revnum;
  private String DSV_OPTIONS_TEXT = null;
  private String D_OPTIONS_TEXT = null;
  private String RAW_LEADIN_MSG = null;
  public boolean recursed = false;
  private String lastSqlStatement = null;
  private int curLinenum = -1;
  private PrintStream psStd = null;
  private PrintStream psErr = null;
  private PrintWriter pwQuery = null;
  private PrintWriter pwDsv = null;
  StringBuffer immCmdSB = new StringBuffer();
  private boolean continueOnError = false;
  private static final String DEFAULT_CHARSET;
  private BufferedReader br = null;
  private String charset = null;
  private String buffer = null;
  private boolean doPrepare = false;
  private String prepareVar = null;
  private String dsvColDelim = null;
  private String dsvSkipPrefix = null;
  private String dsvRowDelim = null;
  private String dsvSkipCols = null;
  private String DSV_X_SYNTAX_MSG = null;
  private String DSV_M_SYNTAX_MSG = null;
  private String nobufferYetString = null;
  private static final char[] nonVarChars;
  public boolean plMode = false;
  private String fetchingVar = null;
  private boolean silentFetch = false;
  private boolean fetchBinary = false;
  private static final String DEFAULT_NULL_REP = "[null]";
  private static final String DEFAULT_ROW_DELIM;
  private static final String DEFAULT_COL_DELIM = "|";
  private static final String DEFAULT_SKIP_PREFIX = "#";
  private static final int DEFAULT_ELEMENT = 0;
  private static final int HSQLDB_ELEMENT = 1;
  private static final int ORACLE_ELEMENT = 2;
  private static final int[] listMDSchemaCols;
  private static final int[] listMDIndexCols;
  private static final int[][] listMDTableCols;
  private static final String[] oracleSysSchemas;
  private boolean excludeSysSchemas = false;
  private static final int COL_HEAD = 0;
  private static final int COL_ODD = 1;
  private static final int COL_EVEN = 2;
  private static final String PRE_TR;
  private static final String PRE_TD;
  int oldestHist = 1;
  byte[] binBuffer = null;
  private static final int JDBC3_BOOLEAN = 16;
  private static final int JDBC3_DATALINK = 70;

  private void updateUserSettings()
  {
    this.dsvSkipPrefix = convertEscapes((String)this.userVars.get("*DSV_SKIP_PREFIX"));
    if (this.dsvSkipPrefix == null)
      this.dsvSkipPrefix = "#";
    this.dsvSkipCols = ((String)this.userVars.get("*DSV_SKIP_COLS"));
    this.dsvColDelim = convertEscapes((String)this.userVars.get("*DSV_COL_DELIM"));
    if (this.dsvColDelim == null)
      this.dsvColDelim = convertEscapes((String)this.userVars.get("*CSV_COL_DELIM"));
    if (this.dsvColDelim == null)
      this.dsvColDelim = "|";
    this.dsvRowDelim = convertEscapes((String)this.userVars.get("*DSV_ROW_DELIM"));
    if (this.dsvRowDelim == null)
      this.dsvRowDelim = convertEscapes((String)this.userVars.get("*CSV_ROW_DELIM"));
    if (this.dsvRowDelim == null)
      this.dsvRowDelim = DEFAULT_ROW_DELIM;
    this.dsvTargetFile = ((String)this.userVars.get("*DSV_TARGET_FILE"));
    if (this.dsvTargetFile == null)
      this.dsvTargetFile = ((String)this.userVars.get("*CSV_FILEPATH"));
    this.dsvTargetTable = ((String)this.userVars.get("*DSV_TARGET_TABLE"));
    if (this.dsvTargetTable == null)
      this.dsvTargetTable = ((String)this.userVars.get("*CSV_TABLENAME"));
    this.dsvConstCols = ((String)this.userVars.get("*DSV_CONST_COLS"));
    this.dsvRejectFile = ((String)this.userVars.get("*DSV_REJECT_FILE"));
    this.dsvRejectReport = ((String)this.userVars.get("*DSV_REJECT_REPORT"));
    this.nullRepToken = ((String)this.userVars.get("*NULL_REP_TOKEN"));
    if (this.nullRepToken == null)
      this.nullRepToken = ((String)this.userVars.get("*CSV_NULL_REP"));
    if (this.nullRepToken == null)
      this.nullRepToken = "[null]";
  }

  public SqlFile(File paramFile, boolean paramBoolean, Map paramMap)
    throws IOException
  {
    try
    {
      this.rb = new SqltoolRB();
      this.rb.validate();
      this.rb.setMissingPosValueBehavior(2);
      this.rb.setMissingPropertyBehavior(2);
    }
    catch (RuntimeException localRuntimeException)
    {
      System.err.println("Failed to initialize resource bundle");
      throw localRuntimeException;
    }
    this.rawPrompt = (this.rb.getString(SqltoolRB.RAWMODE_PROMPT) + "> ");
    this.DSV_OPTIONS_TEXT = this.rb.getString(SqltoolRB.DSV_OPTIONS);
    this.D_OPTIONS_TEXT = this.rb.getString(SqltoolRB.D_OPTIONS);
    this.RAW_LEADIN_MSG = this.rb.getString(SqltoolRB.RAW_LEADIN);
    this.DSV_X_SYNTAX_MSG = this.rb.getString(SqltoolRB.DSV_X_SYNTAX);
    this.DSV_M_SYNTAX_MSG = this.rb.getString(SqltoolRB.DSV_M_SYNTAX);
    this.nobufferYetString = this.rb.getString(SqltoolRB.NOBUFFER_YET);
    this.file = paramFile;
    this.interactive = paramBoolean;
    this.userVars = paramMap;
    if (this.userVars == null)
      this.userVars = new HashMap();
    updateUserSettings();
    if ((this.file != null) && (!this.file.canRead()))
      throw new IOException(this.rb.getString(SqltoolRB.SQLFILE_READFAIL, this.file.toString()));
    if (this.interactive)
    {
      this.history = new ArrayList();
      String str = System.getProperty("sqltool.historyLength");
      if (str != null)
        try
        {
          this.maxHistoryLength = Integer.parseInt(str);
        }
        catch (Exception localException)
        {
        }
      else
        this.maxHistoryLength = 40;
    }
  }

  public SqlFile(boolean paramBoolean, Map paramMap)
    throws IOException
  {
    this(null, paramBoolean, paramMap);
  }

  public void execute(Connection paramConnection, Boolean paramBoolean)
    throws SqlToolError, SQLException
  {
    execute(paramConnection, System.out, System.err, paramBoolean);
  }

  public void execute(Connection paramConnection, boolean paramBoolean)
    throws SqlToolError, SQLException
  {
    execute(paramConnection, System.out, System.err, new Boolean(paramBoolean));
  }

  public synchronized void execute(Connection paramConnection, PrintStream paramPrintStream1, PrintStream paramPrintStream2, Boolean paramBoolean)
    throws SqlToolError, SQLException
  {
    this.psStd = paramPrintStream1;
    this.psErr = paramPrintStream2;
    this.curConn = paramConnection;
    this.curLinenum = -1;
    int i = 0;
    int k = 1;
    this.continueOnError = (paramBoolean == null ? this.interactive : paramBoolean.booleanValue());
    if (this.userVars.size() > 0)
      this.plMode = true;
    String str4 = System.getProperty("sqlfile.charset");
    this.charset = (str4 == null ? DEFAULT_CHARSET : str4);
    try
    {
      if (this.file == null)
        tmpTernaryOp = System.in;
      this.br = new BufferedReader(this.charset == null ? new InputStreamReader(new FileInputStream(this.file)) : new InputStreamReader(this.file == null ? System.in : new FileInputStream(this.file), this.charset));
      this.curLinenum = 0;
      if (this.interactive)
        stdprintln(this.rb.getString(SqltoolRB.SQLFILE_BANNER, revnum));
      while (true)
      {
        if ((this.interactive) && (this.magicPrefix == null))
          this.psStd.print(this.rawMode == 0 ? this.primaryPrompt : (this.immCmdSB.length() > 0) || (this.rawMode == 2) ? this.contPrompt : this.rawPrompt);
        String str1 = this.br.readLine();
        if (this.magicPrefix != null)
        {
          str1 = this.magicPrefix + str1;
          this.magicPrefix = null;
        }
        if (str1 == null)
        {
          if (!this.interactive)
            break;
          this.psStd.println();
          break;
        }
        this.curLinenum += 1;
        int j;
        if (i != 0)
        {
          j = str1.indexOf("*/") + 2;
          if (j <= 1)
            continue;
          str1 = str1.substring(j);
          this.immCmdSB.setLength(0);
          i = 0;
        }
        String str2 = str1.trim();
        try
        {
          if (this.rawMode != 0)
          {
            boolean bool = str1.equals(".;");
            if ((bool) || (str1.equals(":.")))
            {
              if (this.rawMode == 1)
              {
                this.rawMode = 0;
                throw new SqlToolError(this.rb.getString(SqltoolRB.RAW_EMPTY));
              }
              this.rawMode = 0;
              setBuf(this.immCmdSB.toString());
              this.immCmdSB.setLength(0);
              if (bool)
              {
                historize();
                processSQL();
              }
              else if (this.interactive)
              {
                stdprintln(this.rb.getString(SqltoolRB.RAW_MOVEDTOBUFFER));
              }
            }
            else
            {
              if (this.rawMode == 2)
                this.immCmdSB.append('\n');
              this.rawMode = 2;
              if (str1.length() > 0)
                this.immCmdSB.append(str1);
            }
            continue;
          }
          if (this.immCmdSB.length() == 0)
          {
            if (str2.startsWith("/*"))
            {
              j = str2.indexOf("*/", 2) + 2;
              if (j > 1)
              {
                str1 = str1.substring(j + str1.length() - str2.length());
                str2 = str1.trim();
              }
              else
              {
                this.immCmdSB.append("COMMENT");
                i = 1;
                continue;
              }
            }
            if (str2.length() == 0)
              continue;
            if (((str2.charAt(0) == '*') && ((str2.length() < 2) || (str2.charAt(1) != '{'))) || (str2.charAt(0) == '\\'))
            {
              setBuf(str2);
              processFromBuffer();
              continue;
            }
            if ((str2.charAt(0) == ':') && (this.interactive))
            {
              processBuffHist(str2.substring(1));
              continue;
            }
            String str5 = str2.toUpperCase();
            if ((str5.startsWith("DECLARE")) || (str5.startsWith("BEGIN")))
            {
              this.rawMode = 1;
              this.immCmdSB.append(str1);
              if (this.interactive)
                stdprintln(this.RAW_LEADIN_MSG);
              continue;
            }
          }
          if ((str2.length() == 0) && (this.interactive) && (i == 0))
          {
            setBuf(this.immCmdSB.toString());
            this.immCmdSB.setLength(0);
            stdprintln(this.rb.getString(SqltoolRB.INPUT_MOVEDTOBUFFER));
            continue;
          }
          String str3 = deTerminated(str1);
          if (!str2.equals(";"))
          {
            if (this.immCmdSB.length() > 0)
              this.immCmdSB.append('\n');
            this.immCmdSB.append(str3 == null ? str1 : str3);
          }
          if (str3 == null)
            continue;
          if (this.immCmdSB.toString().trim().length() == 0)
          {
            this.immCmdSB.setLength(0);
            throw new SqlToolError(this.rb.getString(SqltoolRB.SQLSTATEMENT_EMPTY));
          }
          setBuf(this.immCmdSB.toString());
          this.immCmdSB.setLength(0);
          historize();
          processSQL();
        }
        catch (BadSpecial localBadSpecial)
        {
          errprintln(this.rb.getString(SqltoolRB.ERRORAT, new String[] { this.file == null ? "stdin" : this.file.toString(), Integer.toString(this.curLinenum), str1, localBadSpecial.getMessage() }));
          localObject1 = localBadSpecial.getCause();
          if (localObject1 != null)
            errprintln(this.rb.getString(SqltoolRB.CAUSEREPORT, ((Throwable)localObject1).toString()));
          if (!this.continueOnError)
            throw new SqlToolError(localBadSpecial);
        }
        catch (SQLException localSQLException)
        {
          errprintln("SQL " + this.rb.getString(SqltoolRB.ERRORAT, new String[] { this.file == null ? "stdin" : this.file.toString(), Integer.toString(this.curLinenum), this.lastSqlStatement, localSQLException.getMessage() }));
          if (!this.continueOnError)
            throw localSQLException;
        }
        catch (BreakException localBreakException)
        {
          localObject1 = localBreakException.getMessage();
          if (this.recursed)
          {
            k = 0;
          }
          else
          {
            if ((localObject1 != null) && (((String)localObject1).equals("file")))
              break;
            errprintln(this.rb.getString(SqltoolRB.BREAK_UNSATISFIED, (String)localObject1));
          }
          if ((this.recursed) || (!this.continueOnError))
            throw localBreakException;
        }
        catch (ContinueException localContinueException)
        {
          localObject1 = localContinueException.getMessage();
          if (this.recursed)
            k = 0;
          else
            errprintln(this.rb.getString(SqltoolRB.CONTINUE_UNSATISFIED, (String)localObject1));
          if ((this.recursed) || (!this.continueOnError))
            throw localContinueException;
        }
        catch (QuitNow localQuitNow1)
        {
          throw localQuitNow1;
        }
        catch (SqlToolError localSqlToolError)
        {
          errprint(this.rb.getString(SqltoolRB.ERRORAT, new String[] { this.file == null ? "stdin" : this.file.toString(), Integer.toString(this.curLinenum), str1, localSqlToolError.getMessage() == null ? "" : localSqlToolError.getMessage() }));
          if (localSqlToolError.getMessage() != null)
            errprintln("");
          Object localObject1 = localSqlToolError.getCause();
          if (localObject1 != null)
            errprintln(this.rb.getString(SqltoolRB.CAUSEREPORT, ((Throwable)localObject1).toString()));
          if (!this.continueOnError)
            throw localSqlToolError;
        }
        this.immCmdSB.setLength(0);
      }
      if ((i != 0) || (this.immCmdSB.length() != 0))
      {
        errprintln(this.rb.getString(SqltoolRB.INPUT_UNTERMINATED, this.immCmdSB.toString()));
        throw new SqlToolError(this.rb.getString(SqltoolRB.INPUT_UNTERMINATED, this.immCmdSB.toString()));
      }
      k = 0;
    }
    catch (IOException localIOException1)
    {
      throw new SqlToolError(this.rb.getString(SqltoolRB.PRIMARYINPUT_ACCESSFAIL), localIOException1);
    }
    catch (QuitNow localQuitNow2)
    {
      if (this.recursed)
        throw localQuitNow2;
      k = localQuitNow2.getMessage() != null ? 1 : 0;
      if (k != 0)
      {
        errprintln(this.rb.getString(SqltoolRB.ABORTING, localQuitNow2.getMessage()));
        throw new SqlToolError(localQuitNow2.getMessage());
      }
      return;
    }
    finally
    {
      closeQueryOutputStream();
      if (this.fetchingVar != null)
      {
        errprintln(this.rb.getString(SqltoolRB.PLVAR_SET_INCOMPLETE, this.fetchingVar));
        k = 1;
      }
      if (this.br != null)
        try
        {
          this.br.close();
        }
        catch (IOException localIOException2)
        {
          throw new SqlToolError(this.rb.getString(SqltoolRB.INPUTREADER_CLOSEFAIL), localIOException2);
        }
      if ((k != 0) && (this.possiblyUncommitteds.get()))
      {
        errprintln(this.rb.getString(SqltoolRB.ROLLINGBACK));
        this.curConn.rollback();
        this.possiblyUncommitteds.set(false);
      }
    }
  }

  private static String deTerminated(String paramString)
  {
    int i = paramString.lastIndexOf(';');
    if (i < 0)
      return null;
    for (int j = i + 1; j < paramString.length(); j++)
      if (!Character.isWhitespace(paramString.charAt(j)))
        return null;
    return paramString.substring(0, i);
  }

  public void processFromBuffer()
    throws SqlFile.BadSpecial, SQLException, SqlToolError
  {
    historize();
    if ((this.buffer.charAt(0) == '*') && ((this.buffer.length() < 2) || (this.buffer.charAt(1) != '{')))
    {
      processPL(this.buffer);
      return;
    }
    if (this.buffer.charAt(0) == '\\')
    {
      processSpecial(this.buffer);
      return;
    }
    processSQL();
  }

  private void processBuffHist(String paramString)
    throws SqlFile.BadSpecial, SQLException, SqlToolError
  {
    if (paramString.length() < 1)
      throw new BadSpecial(this.rb.getString(SqltoolRB.BUFHIST_UNSPECIFIED));
    char c = paramString.charAt(0);
    String str1 = paramString.substring(1);
    if (str1.trim().length() == 0)
      str1 = null;
    switch (c)
    {
    case 'b':
    case 'l':
      enforce1charBH(str1, 'l');
      if (this.buffer == null)
        stdprintln(this.nobufferYetString);
      else
        stdprintln(this.rb.getString(SqltoolRB.EDITBUFFER_CONTENTS, this.buffer));
      return;
    case 'h':
      enforce1charBH(str1, 'h');
      showHistory();
      return;
    case '?':
      stdprintln(this.rb.getString(SqltoolRB.BUFFER_HELP));
      return;
    }
    Integer localInteger = null;
    Matcher localMatcher1 = slashHistoryPattern.matcher(paramString);
    if (localMatcher1.matches())
    {
      localInteger = historySearch(localMatcher1.group(1));
      if (localInteger == null)
      {
        stdprintln(this.rb.getString(SqltoolRB.SUBSTITUTION_NOMATCH));
        return;
      }
    }
    else
    {
      localMatcher1 = historyPattern.matcher(paramString);
      if (!localMatcher1.matches())
        throw new BadSpecial(this.rb.getString(SqltoolRB.EDIT_MALFORMAT));
      localInteger = (localMatcher1.group(1) == null) || (localMatcher1.group(1).length() < 1) ? null : new Integer(localMatcher1.group(1));
    }
    if (localMatcher1.groupCount() != 2)
      throw new BadSpecial(this.rb.getString(SqltoolRB.EDIT_MALFORMAT));
    c = (localMatcher1.group(2) == null) || (localMatcher1.group(2).length() < 1) ? '\000' : localMatcher1.group(2).charAt(0);
    str1 = c == 0 ? null : localMatcher1.group(2).substring(1);
    if ((str1 != null) && (str1.length() < 1))
      str1 = null;
    String str2 = localInteger == null ? null : commandFromHistory(localInteger.intValue());
    String str3;
    switch (c)
    {
    case '\000':
      setBuf(str2);
      stdprintln(this.rb.getString(SqltoolRB.BUFFER_RESTORED, this.buffer));
      return;
    case ';':
      enforce1charBH(str1, ';');
      if (str2 != null)
        setBuf(str2);
      if (this.buffer == null)
        throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
      stdprintln(this.rb.getString(SqltoolRB.BUFFER_EXECUTING, this.buffer));
      processFromBuffer();
      return;
    case 'a':
      if (str2 == null)
        str2 = this.buffer;
      if (str2 == null)
        throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
      this.immCmdSB.append(str2);
      if (str1 != null)
      {
        str3 = deTerminated(str1);
        if (!str1.equals(";"))
          this.immCmdSB.append(str3 == null ? str1 : str3);
        if (str3 != null)
        {
          setBuf(this.immCmdSB.toString());
          this.immCmdSB.setLength(0);
          stdprintln(this.rb.getString(SqltoolRB.BUFFER_EXECUTING, this.buffer));
          processFromBuffer();
          return;
        }
      }
      this.magicPrefix = this.immCmdSB.toString();
      this.immCmdSB.setLength(0);
      if (this.interactive)
        stdprint(this.magicPrefix);
      return;
    case 'w':
      if (str2 == null)
        str2 = this.buffer;
      if (str2 == null)
        throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
      if (str1 == null)
        throw new BadSpecial(this.rb.getString(SqltoolRB.DESTFILE_DEMAND));
      str3 = dereference(str1.trim(), false);
      PrintWriter localPrintWriter = null;
      try
      {
        localPrintWriter = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(str3, true)) : new OutputStreamWriter(new FileOutputStream(str3, true), this.charset));
        localPrintWriter.print(str2);
        if (!str2.matches("\\s*[*:\\\\].*"))
          localPrintWriter.print(';');
        localPrintWriter.println();
        localPrintWriter.flush();
      }
      catch (Exception localException)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_APPENDFAIL, str3), localException);
      }
      finally
      {
        if (localPrintWriter != null)
          localPrintWriter.close();
      }
      return;
    case 's':
      int i = 0;
      int j = 0;
      if (str2 == null)
        str2 = this.buffer;
      if (str2 == null)
        throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
      try
      {
        if ((str1 == null) || (str1.length() < 3))
          throw new BadSubst(this.rb.getString(SqltoolRB.SUBSTITUTION_MALFORMAT));
        Matcher localMatcher2 = substitutionPattern.matcher(str1);
        if (!localMatcher2.matches())
          throw new BadSubst(this.rb.getString(SqltoolRB.SUBSTITUTION_MALFORMAT));
        if ((localMatcher2.groupCount() < 3) || (localMatcher2.groupCount() > 4))
          throw new RuntimeException("Matched substitution pattern, but captured " + localMatcher2.groupCount() + " groups");
        String str4 = (localMatcher2.groupCount() > 3) && (localMatcher2.group(4) != null) ? new String(localMatcher2.group(4)) : null;
        if (str4 != null)
        {
          if (str4.indexOf(';') > -1)
          {
            i = 1;
            str4 = str4.replaceFirst(";", "");
          }
          if (str4.indexOf('g') > -1)
          {
            j = 1;
            str4 = str4.replaceFirst("g", "");
          }
        }
        Matcher localMatcher3 = Pattern.compile("(?s" + (str4 == null ? "" : str4) + ')' + localMatcher2.group(2)).matcher(str2);
        String str5 = j != 0 ? localMatcher3.replaceAll(localMatcher2.group(3)) : localMatcher3.replaceFirst(localMatcher2.group(3));
        if (str5.equals(str2))
        {
          stdprintln(this.rb.getString(SqltoolRB.SUBSTITUTION_NOMATCH));
          return;
        }
        setBuf(str5);
        stdprintln(this.rb.getString(i != 0 ? SqltoolRB.BUFFER_EXECUTING : SqltoolRB.EDITBUFFER_CONTENTS, this.buffer));
      }
      catch (PatternSyntaxException localPatternSyntaxException)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.SUBSTITUTION_SYNTAX), localPatternSyntaxException);
      }
      catch (BadSubst localBadSubst)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.SUBSTITUTION_SYNTAX));
      }
      if (i != 0)
      {
        this.immCmdSB.setLength(0);
        processFromBuffer();
      }
      return;
    }
    throw new BadSpecial(this.rb.getString(SqltoolRB.BUFFER_UNKNOWN, Character.toString(c)));
  }

  private void enforce1charSpecial(String paramString, char paramChar)
    throws SqlFile.BadSpecial
  {
    if (paramString.length() != 1)
      throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_EXTRACHARS, Character.toString(paramChar), paramString.substring(1)));
  }

  private void enforce1charBH(String paramString, char paramChar)
    throws SqlFile.BadSpecial
  {
    if (paramString != null)
      throw new BadSpecial(this.rb.getString(SqltoolRB.BUFFER_EXTRACHARS, Character.toString(paramChar), paramString));
  }

  private void processSpecial(String paramString)
    throws SqlFile.BadSpecial, SqlFile.QuitNow, SQLException, SqlToolError
  {
    if (paramString.equals("\\"))
      throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_UNSPECIFIED));
    Matcher localMatcher = specialPattern.matcher(this.plMode ? dereference(paramString, false) : paramString);
    if (!localMatcher.matches())
      throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_MALFORMAT));
    if ((localMatcher.groupCount() < 1) || (localMatcher.groupCount() > 2))
      throw new RuntimeException("Pattern matched, yet captured " + localMatcher.groupCount() + " groups");
    String str1 = localMatcher.group(1);
    String str2 = localMatcher.groupCount() > 1 ? localMatcher.group(2) : null;
    Object localObject1;
    Object localObject2;
    Object localObject3;
    Object localObject4;
    Object localObject5;
    switch (str1.charAt(0))
    {
    case 'q':
      enforce1charSpecial(str1, 'q');
      if (str2 != null)
        throw new QuitNow(str2);
      throw new QuitNow();
    case 'H':
      enforce1charSpecial(str1, 'H');
      this.htmlMode = (!this.htmlMode);
      stdprintln(this.rb.getString(SqltoolRB.HTML_MODE, Boolean.toString(this.htmlMode)));
      return;
    case 'm':
      if ((str1.equals("m?")) || ((str1.equals("m")) && (str2 != null) && (str2.equals("?"))))
      {
        stdprintln(this.DSV_OPTIONS_TEXT + LS + this.DSV_M_SYNTAX_MSG);
        return;
      }
      if ((str1.length() != 1) || (str2 == null))
        throw new BadSpecial(this.DSV_M_SYNTAX_MSG);
      int i = str2.charAt(str2.length() - 1) == '*' ? 1 : 0;
      String str3 = null;
      if (i != 0)
      {
        str2 = str2.substring(0, str2.length() - 1).trim();
        if (str2.length() < 1)
          throw new BadSpecial(this.DSV_M_SYNTAX_MSG);
      }
      else
      {
        str3 = this.dsvSkipPrefix;
      }
      int j = str2.indexOf(" :");
      if ((j > -1) && (j < str2.length() - 2))
      {
        str3 = str2.substring(j + 2);
        str2 = str2.substring(0, j).trim();
      }
      importDsv(str2, str3);
      return;
    case 'x':
      if ((str1.equals("x?")) || ((str1.equals("x")) && (str2 != null) && (str2.equals("?"))))
      {
        stdprintln(this.DSV_OPTIONS_TEXT + LS + this.DSV_X_SYNTAX_MSG);
        return;
      }
      try
      {
        if ((str1.length() != 1) || (str2 == null))
          throw new BadSpecial(this.DSV_X_SYNTAX_MSG);
        String str4 = str2.indexOf(' ') > 0 ? null : str2;
        if ((this.dsvTargetFile == null) && (str4 == null))
          throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_TARGETFILE_DEMAND));
        localObject1 = new File(this.dsvTargetFile == null ? str4 + ".dsv" : this.dsvTargetFile);
        this.pwDsv = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream((File)localObject1)) : new OutputStreamWriter(new FileOutputStream((File)localObject1), this.charset));
        localObject2 = this.curConn.createStatement().executeQuery("SELECT * FROM " + str4);
        localObject3 = new ArrayList();
        localObject4 = null;
        if (this.dsvSkipCols != null)
        {
          localObject5 = new HashSet();
          String[] arrayOfString = this.dsvSkipCols.split("\\s*\\Q" + this.dsvColDelim + "\\E\\s*");
          for (int n = 0; n < arrayOfString.length; n++)
            ((Set)localObject5).add(arrayOfString[n].toLowerCase());
          ResultSetMetaData localResultSetMetaData = ((ResultSet)localObject2).getMetaData();
          for (int i1 = 1; i1 <= localResultSetMetaData.getColumnCount(); i1++)
          {
            if (((Set)localObject5).remove(localResultSetMetaData.getColumnName(i1).toLowerCase()))
              continue;
            ((List)localObject3).add(new Integer(i1));
          }
          if (((List)localObject3).size() < 1)
            throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_NOCOLSLEFT, this.dsvSkipCols));
          if (((Set)localObject5).size() > 0)
            throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_SKIPCOLS_MISSING, localObject5.toString()));
          localObject4 = new int[((List)localObject3).size()];
          for (i1 = 0; i1 < localObject4.length; i1++)
            localObject4[i1] = ((Integer)((List)localObject3).get(i1)).intValue();
        }
        displayResultSet(null, (ResultSet)localObject2, localObject4, null);
        this.pwDsv.flush();
        stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, Long.toString(((File)localObject1).length()), ((File)localObject1).toString()));
      }
      catch (FileNotFoundException localFileNotFoundException)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, str2), localFileNotFoundException);
      }
      catch (UnsupportedEncodingException localUnsupportedEncodingException)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, str2), localUnsupportedEncodingException);
      }
      finally
      {
        if (this.pwDsv != null)
          this.pwDsv.close();
        this.pwDsv = null;
      }
      return;
    case 'd':
      if ((str1.equals("d?")) || ((str1.equals("d")) && (str2 != null) && (str2.equals("?"))))
      {
        stdprintln(this.D_OPTIONS_TEXT);
        return;
      }
      if (str1.length() == 2)
      {
        listTables(str1.charAt(1), str2);
        return;
      }
      if ((str1.length() == 1) && (str2 != null))
        try
        {
          int k = str2.indexOf(' ');
          if (k < 0)
            describe(str2, null);
          else
            describe(str2.substring(0, k), str2.substring(k + 1).trim());
          return;
        }
        catch (SQLException localSQLException)
        {
          throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL), localSQLException);
        }
      throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_D_LIKE));
    case 'o':
      enforce1charSpecial(str1, 'o');
      if (str2 == null)
      {
        if (this.pwQuery == null)
          throw new BadSpecial(this.rb.getString(SqltoolRB.OUTPUTFILE_NONETOCLOSE));
        closeQueryOutputStream();
        return;
      }
      if (this.pwQuery != null)
      {
        stdprintln(this.rb.getString(SqltoolRB.OUTPUTFILE_REOPENING));
        closeQueryOutputStream();
      }
      try
      {
        this.pwQuery = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(str2, true)) : new OutputStreamWriter(new FileOutputStream(str2, true), this.charset));
        this.pwQuery.println((this.htmlMode ? "<HTML>" + LS + "<!--" : "#") + " " + new Date() + ".  " + this.rb.getString(SqltoolRB.OUTPUTFILE_HEADER, getClass().getName()) + (this.htmlMode ? " -->" + LS + LS + "<BODY>" : LS));
        this.pwQuery.flush();
      }
      catch (Exception localException1)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, str2), localException1);
      }
      return;
    case 'i':
      enforce1charSpecial(str1, 'i');
      if (str2 == null)
        throw new BadSpecial(this.rb.getString(SqltoolRB.SQLFILE_NAME_DEMAND));
      try
      {
        SqlFile localSqlFile = new SqlFile(new File(str2), false, this.userVars);
        localSqlFile.recursed = true;
        localSqlFile.possiblyUncommitteds = this.possiblyUncommitteds;
        localSqlFile.plMode = this.plMode;
        localSqlFile.execute(this.curConn, this.continueOnError);
      }
      catch (ContinueException localContinueException)
      {
        throw localContinueException;
      }
      catch (BreakException localBreakException)
      {
        localObject1 = localBreakException.getMessage();
        if ((localObject1 != null) && (!((String)localObject1).equals("file")))
          throw localBreakException;
      }
      catch (QuitNow localQuitNow)
      {
        throw localQuitNow;
      }
      catch (Exception localException2)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.SQLFILE_EXECUTE_FAIL, str2), localException2);
      }
      return;
    case 'p':
      enforce1charSpecial(str1, 'p');
      if (str2 == null)
        stdprintln(true);
      else
        stdprintln(str2, true);
      return;
    case 'a':
      enforce1charSpecial(str1, 'a');
      if (str2 != null)
        this.curConn.setAutoCommit(Boolean.valueOf(str2).booleanValue());
      stdprintln(this.rb.getString(SqltoolRB.A_SETTING, Boolean.toString(this.curConn.getAutoCommit())));
      return;
    case '=':
      enforce1charSpecial(str1, '=');
      this.curConn.commit();
      this.possiblyUncommitteds.set(false);
      stdprintln(this.rb.getString(SqltoolRB.COMMITTED));
      return;
    case 'b':
      if (str1.length() == 1)
      {
        if (str2 != null)
          throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
        this.fetchBinary = true;
        return;
      }
      if (str1.charAt(1) == 'p')
      {
        if (str2 != null)
          throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
        this.doPrepare = true;
        return;
      }
      if (((str1.charAt(1) != 'd') && (str1.charAt(1) != 'l')) || (str2 == null))
        throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
      File localFile = new File(str2);
      try
      {
        if (str1.charAt(1) == 'd')
        {
          dump(localFile);
        }
        else
        {
          this.binBuffer = loadBinary(localFile);
          stdprintln(this.rb.getString(SqltoolRB.BINARY_LOADEDBYTESINTO, this.binBuffer.length));
        }
      }
      catch (BadSpecial localBadSpecial1)
      {
        throw localBadSpecial1;
      }
      catch (IOException localIOException)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.BINARY_FILEFAIL, str2), localIOException);
      }
      return;
    case '*':
    case 'c':
      enforce1charSpecial(str1, '=');
      if (str2 != null)
        this.continueOnError = Boolean.valueOf(str2).booleanValue();
      stdprintln(this.rb.getString(SqltoolRB.C_SETTING, Boolean.toString(this.continueOnError)));
      return;
    case '?':
      stdprintln(this.rb.getString(SqltoolRB.SPECIAL_HELP));
      return;
    case '!':
      localObject2 = new byte[1024];
      localObject3 = (str1.length() == 1 ? "" : str1.substring(1)) + ((str1.length() > 1) && (str2 != null) ? " " : "") + (str2 == null ? "" : str2);
      if (((String)localObject3).trim().length() < 1)
        throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_INCOMPLETE));
      try
      {
        localObject4 = Runtime.getRuntime();
        localObject5 = wincmdPattern == null ? ((Runtime)localObject4).exec((String)localObject3) : ((Runtime)localObject4).exec(genWinArgs((String)localObject3));
        ((Process)localObject5).getOutputStream().close();
        InputStream localInputStream = ((Process)localObject5).getInputStream();
        int m;
        while ((m = localInputStream.read(localObject2)) > 0)
          stdprint(new String(localObject2, 0, m));
        localInputStream.close();
        localInputStream = ((Process)localObject5).getErrorStream();
        while ((m = localInputStream.read(localObject2)) > 0)
          errprint(new String(localObject2, 0, m));
        localInputStream.close();
        if (((Process)localObject5).waitFor() != 0)
          throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_COMMAND_FAIL, (String)localObject3));
      }
      catch (BadSpecial localBadSpecial2)
      {
        throw localBadSpecial2;
      }
      catch (Exception localException3)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_COMMAND_FAIL, (String)localObject3), localException3);
      }
      return;
    case '.':
      enforce1charSpecial(str1, '.');
      this.rawMode = 1;
      if (this.interactive)
        stdprintln(this.RAW_LEADIN_MSG);
      return;
    }
    throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_UNKNOWN, Character.toString(str1.charAt(0))));
  }

  static int pastName(String paramString, int paramInt)
  {
    String str = paramString.substring(paramInt);
    int i = paramString.length();
    for (int k = 0; k < nonVarChars.length; k++)
    {
      int j = str.indexOf(nonVarChars[k]);
      if ((j <= -1) || (j >= i))
        continue;
      i = j;
    }
    return paramInt + i;
  }

  private String dereference(String paramString, boolean paramBoolean)
    throws SqlToolError
  {
    StringBuffer localStringBuffer = new StringBuffer(paramString);
    int j;
    String str1;
    String str2;
    if ((paramBoolean) && (paramString.trim().charAt(0) == '/'))
    {
      int m = paramString.indexOf('/');
      j = pastName(paramString.substring(m + 1), 0);
      if (j < 1)
        throw new SqlToolError(this.rb.getString(SqltoolRB.PLALIAS_MALFORMAT));
      str1 = paramString.substring(m + 1, m + 1 + j);
      str2 = (String)this.userVars.get(str1);
      if (str2 == null)
        throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, str1));
      localStringBuffer.replace(m, m + 1 + j, (String)this.userVars.get(str1));
    }
    int k = 0;
    String str3;
    int i;
    int n;
    while (true)
    {
      str3 = localStringBuffer.toString();
      i = str3.indexOf("${");
      if (i < 0)
        break;
      j = str3.indexOf('}', i + 2);
      if (j == i + 2)
        throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_EMPTY));
      if (j < 0)
        throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_UNTERMINATED));
      n = str3.charAt(i + 2) == ':' ? 1 : 0;
      str1 = str3.substring(i + (n != 0 ? 3 : 2), j);
      if (k++ > 10000)
        throw new SqlToolError(this.rb.getString(SqltoolRB.VAR_INFINITE, str1));
      str2 = System.getProperty(str1);
      if (str2 == null)
        if (n != 0)
          str2 = "";
        else
          throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_UNDEFINED, str1));
      localStringBuffer.replace(i, j + 1, str2);
    }
    k = 0;
    while (true)
    {
      str3 = localStringBuffer.toString();
      i = str3.indexOf("*{");
      if (i < 0)
        break;
      j = str3.indexOf('}', i + 2);
      if (j == i + 2)
        throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_NAMEEMPTY));
      if (j < 0)
        throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNTERMINATED));
      n = str3.charAt(i + 2) == ':' ? 1 : 0;
      str1 = str3.substring(i + (n != 0 ? 3 : 2), j);
      if (k++ > 10000)
        throw new SqlToolError(this.rb.getString(SqltoolRB.VAR_INFINITE, str1));
      str2 = (String)this.userVars.get(str1);
      if (str2 == null)
        if (n != 0)
          str2 = "";
        else
          throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, str1));
      localStringBuffer.replace(i, j + 1, str2);
    }
    return localStringBuffer.toString();
  }

  private void processPL(String paramString)
    throws SqlFile.BadSpecial, SqlToolError
  {
    Matcher localMatcher = plPattern.matcher(dereference(paramString, false));
    if (!localMatcher.matches())
      throw new BadSpecial(this.rb.getString(SqltoolRB.PL_MALFORMAT));
    if ((localMatcher.groupCount() < 1) || (localMatcher.group(1) == null))
    {
      this.plMode = true;
      stdprintln(this.rb.getString(SqltoolRB.PL_EXPANSIONMODE, "on"));
      return;
    }
    String[] arrayOfString = localMatcher.group(1).split("\\s+");
    if (arrayOfString[0].charAt(0) == '?')
    {
      stdprintln(this.rb.getString(SqltoolRB.PL_HELP));
      return;
    }
    this.plMode = true;
    if (arrayOfString[0].equals("end"))
      throw new BadSpecial(this.rb.getString(SqltoolRB.END_NOBLOCK));
    if (arrayOfString[0].equals("continue"))
    {
      if (arrayOfString.length > 1)
      {
        if ((arrayOfString.length == 2) && ((arrayOfString[1].equals("foreach")) || (arrayOfString[1].equals("while"))))
          throw new ContinueException(arrayOfString[1]);
        throw new BadSpecial(this.rb.getString(SqltoolRB.CONTINUE_SYNTAX));
      }
      throw new ContinueException();
    }
    if (arrayOfString[0].equals("break"))
    {
      if (arrayOfString.length > 1)
      {
        if ((arrayOfString.length == 2) && ((arrayOfString[1].equals("foreach")) || (arrayOfString[1].equals("if")) || (arrayOfString[1].equals("while")) || (arrayOfString[1].equals("file"))))
          throw new BreakException(arrayOfString[1]);
        throw new BadSpecial(this.rb.getString(SqltoolRB.BREAK_SYNTAX));
      }
      throw new BreakException();
    }
    Object localObject2;
    if ((arrayOfString[0].equals("list")) || (arrayOfString[0].equals("listvalues")) || (arrayOfString[0].equals("listsysprops")))
    {
      boolean bool1 = arrayOfString[0].equals("listsysprops");
      boolean bool2 = (arrayOfString[0].equals("listvalues")) || (bool1);
      if (arrayOfString.length == 1)
      {
        stdprint(formatNicely(bool1 ? System.getProperties() : this.userVars, bool2));
      }
      else
      {
        if (bool2)
          stdprintln(this.rb.getString(SqltoolRB.PL_LIST_PARENS));
        else
          stdprintln(this.rb.getString(SqltoolRB.PL_LIST_LENGTHS));
        for (int i = 1; i < arrayOfString.length; i++)
        {
          localObject2 = (String)(bool1 ? System.getProperties() : this.userVars).get(arrayOfString[i]);
          if (localObject2 == null)
            continue;
          stdprintln("    " + arrayOfString[i] + ": " + (bool2 ? "(" + (String)localObject2 + ')' : Integer.toString(((String)localObject2).length())));
        }
      }
      return;
    }
    if ((arrayOfString[0].equals("dump")) || (arrayOfString[0].equals("load")))
    {
      if (arrayOfString.length != 3)
        throw new BadSpecial(this.rb.getString(SqltoolRB.DUMPLOAD_MALFORMAT));
      localObject1 = arrayOfString[1];
      if (((String)localObject1).indexOf(':') > -1)
        throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
      localObject2 = new File(arrayOfString[2]);
      try
      {
        if (arrayOfString[0].equals("dump"))
          dump((String)localObject1, (File)localObject2);
        else
          load((String)localObject1, (File)localObject2, this.charset);
      }
      catch (IOException localIOException1)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.DUMPLOAD_FAIL, (String)localObject1, ((File)localObject2).toString()), localIOException1);
      }
      return;
    }
    if (arrayOfString[0].equals("prepare"))
    {
      if (arrayOfString.length != 2)
        throw new BadSpecial(this.rb.getString(SqltoolRB.PREPARE_MALFORMAT));
      if (this.userVars.get(arrayOfString[1]) == null)
        throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, arrayOfString[1]));
      this.prepareVar = arrayOfString[1];
      this.doPrepare = true;
      return;
    }
    Object localObject3;
    String str2;
    Object localObject4;
    if (arrayOfString[0].equals("foreach"))
    {
      localObject1 = foreachPattern.matcher(dereference(paramString, false));
      if (!((Matcher)localObject1).matches())
        throw new BadSpecial(this.rb.getString(SqltoolRB.FOREACH_MALFORMAT));
      if (((Matcher)localObject1).groupCount() != 2)
        throw new RuntimeException("foreach pattern matched, but captured " + ((Matcher)localObject1).groupCount() + " groups");
      localObject2 = ((Matcher)localObject1).group(1);
      if (((String)localObject2).indexOf(':') > -1)
        throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
      localObject3 = ((Matcher)localObject1).group(2).split("\\s+");
      File localFile = null;
      try
      {
        localFile = plBlockFile("foreach");
      }
      catch (IOException localIOException4)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.PL_TEMPFILE_FAIL), localIOException4);
      }
      str2 = (String)this.userVars.get(localObject2);
      try
      {
        for (int j = 0; j < localObject3.length; j++)
          try
          {
            localObject4 = localObject3[j];
            this.userVars.put(localObject2, localObject4);
            updateUserSettings();
            SqlFile localSqlFile3 = new SqlFile(localFile, false, this.userVars);
            localSqlFile3.plMode = true;
            localSqlFile3.recursed = true;
            localSqlFile3.possiblyUncommitteds = this.possiblyUncommitteds;
            localSqlFile3.execute(this.curConn, this.continueOnError);
          }
          catch (ContinueException localContinueException3)
          {
            String str4 = localContinueException3.getMessage();
            if ((str4 == null) || (str4.equals("foreach")))
              continue;
            throw localContinueException3;
          }
      }
      catch (BreakException localBreakException3)
      {
        String str3 = localBreakException3.getMessage();
        if ((str3 != null) && (!str3.equals("foreach")))
          throw localBreakException3;
      }
      catch (QuitNow localQuitNow3)
      {
        throw localQuitNow3;
      }
      catch (Exception localException3)
      {
        throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), localException3);
      }
      if (str2 == null)
      {
        this.userVars.remove(localObject2);
        updateUserSettings();
      }
      else
      {
        this.userVars.put(localObject2, str2);
      }
      if ((localFile != null) && (!localFile.delete()))
        throw new BadSpecial(this.rb.getString(SqltoolRB.TEMPFILE_REMOVAL_FAIL, localFile.toString()));
      return;
    }
    if ((arrayOfString[0].equals("if")) || (arrayOfString[0].equals("while")))
    {
      localObject1 = ifwhilePattern.matcher(dereference(paramString, false));
      if (!((Matcher)localObject1).matches())
        throw new BadSpecial(this.rb.getString(SqltoolRB.IFWHILE_MALFORMAT));
      if (((Matcher)localObject1).groupCount() != 1)
        throw new RuntimeException("if/while pattern matched, but captured " + ((Matcher)localObject1).groupCount() + " groups");
      localObject2 = ((Matcher)localObject1).group(1).replaceAll("!([a-zA-Z0-9*])", "! $1").replaceAll("([a-zA-Z0-9*])!", "$1 !").split("\\s+");
      localObject3 = null;
      if (arrayOfString[0].equals("if"))
      {
        try
        {
          localObject3 = plBlockFile("if");
        }
        catch (IOException localIOException2)
        {
          throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), localIOException2);
        }
        try
        {
          if (eval(localObject2))
          {
            SqlFile localSqlFile1 = new SqlFile((File)localObject3, false, this.userVars);
            localSqlFile1.plMode = true;
            localSqlFile1.recursed = true;
            localSqlFile1.possiblyUncommitteds = this.possiblyUncommitteds;
            localSqlFile1.execute(this.curConn, this.continueOnError);
          }
        }
        catch (BreakException localBreakException1)
        {
          localObject4 = localBreakException1.getMessage();
          if ((localObject4 == null) || (!((String)localObject4).equals("if")))
            throw localBreakException1;
        }
        catch (ContinueException localContinueException1)
        {
          throw localContinueException1;
        }
        catch (QuitNow localQuitNow1)
        {
          throw localQuitNow1;
        }
        catch (BadSpecial localBadSpecial1)
        {
          localBadSpecial1.appendMessage(this.rb.getString(SqltoolRB.IF_MALFORMAT));
          throw localBadSpecial1;
        }
        catch (Exception localException1)
        {
          throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), localException1);
        }
      }
      else
      {
        if (arrayOfString[0].equals("while"))
        {
          try
          {
            localObject3 = plBlockFile("while");
          }
          catch (IOException localIOException3)
          {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_TEMPFILE_FAIL), localIOException3);
          }
          try
          {
            while (eval(localObject2))
              try
              {
                SqlFile localSqlFile2 = new SqlFile((File)localObject3, false, this.userVars);
                localSqlFile2.recursed = true;
                localSqlFile2.possiblyUncommitteds = this.possiblyUncommitteds;
                localSqlFile2.plMode = true;
                localSqlFile2.execute(this.curConn, this.continueOnError);
              }
              catch (ContinueException localContinueException2)
              {
                str2 = localContinueException2.getMessage();
                if ((str2 != null) && (!str2.equals("while")))
                  throw localContinueException2;
              }
          }
          catch (BreakException localBreakException2)
          {
            String str1 = localBreakException2.getMessage();
            if ((str1 != null) && (!str1.equals("while")))
              throw localBreakException2;
          }
          catch (QuitNow localQuitNow2)
          {
            throw localQuitNow2;
          }
          catch (BadSpecial localBadSpecial2)
          {
            localBadSpecial2.appendMessage(this.rb.getString(SqltoolRB.WHILE_MALFORMAT));
            throw localBadSpecial2;
          }
          catch (Exception localException2)
          {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), localException2);
          }
        }
        throw new RuntimeException(this.rb.getString(SqltoolRB.PL_UNKNOWN, arrayOfString[0]));
      }
      if ((localObject3 != null) && (!((File)localObject3).delete()))
        throw new BadSpecial(this.rb.getString(SqltoolRB.TEMPFILE_REMOVAL_FAIL, ((File)localObject3).toString()));
      return;
    }
    localMatcher = varsetPattern.matcher(dereference(paramString, false));
    if (!localMatcher.matches())
      throw new BadSpecial(this.rb.getString(SqltoolRB.PL_UNKNOWN, arrayOfString[0]));
    if ((localMatcher.groupCount() < 2) || (localMatcher.groupCount() > 3))
      throw new RuntimeException("varset pattern matched but captured " + localMatcher.groupCount() + " groups");
    Object localObject1 = localMatcher.group(1);
    if (((String)localObject1).indexOf(':') > -1)
      throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
    switch (localMatcher.group(2).charAt(0))
    {
    case '_':
      this.silentFetch = true;
    case '~':
      if ((localMatcher.groupCount() > 2) && (localMatcher.group(3) != null))
        throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_TILDEDASH_NOMOREARGS, localMatcher.group(3)));
      this.userVars.remove(localObject1);
      updateUserSettings();
      this.fetchingVar = ((String)localObject1);
      return;
    case '=':
      if ((this.fetchingVar != null) && (this.fetchingVar.equals(localObject1)))
        this.fetchingVar = null;
      if ((localMatcher.groupCount() > 2) && (localMatcher.group(3) != null))
        this.userVars.put(localObject1, localMatcher.group(3));
      else
        this.userVars.remove(localObject1);
      updateUserSettings();
      return;
    }
    throw new BadSpecial(this.rb.getString(SqltoolRB.PL_UNKNOWN, arrayOfString[0]));
  }

  private File plBlockFile(String paramString)
    throws IOException, SqlToolError
  {
    int i = 1;
    if ((paramString == null) || ((!paramString.equals("foreach")) && (!paramString.equals("if")) && (!paramString.equals("while"))))
      throw new RuntimeException("Assertion failed.  Unsupported PL block type:  " + paramString);
    File localFile = File.createTempFile("sqltool-", ".sql");
    PrintWriter localPrintWriter = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(localFile)) : new OutputStreamWriter(new FileOutputStream(localFile), this.charset));
    try
    {
      localPrintWriter.println("/* " + new Date() + ". " + getClass().getName() + " PL block. */");
      localPrintWriter.println();
      while (true)
      {
        String str1 = this.br.readLine();
        if (str1 == null)
        {
          str1 = this.rb.getString(SqltoolRB.PL_BLOCK_UNTERMINATED, paramString);
          errprintln(str1);
          throw new SqlToolError(str1);
        }
        this.curLinenum += 1;
        Matcher localMatcher = plPattern.matcher(str1);
        if ((localMatcher.matches()) && (localMatcher.groupCount() > 0) && (localMatcher.group(1) != null))
        {
          String[] arrayOfString = localMatcher.group(1).split("\\s+");
          String str2 = arrayOfString[0];
          if (str2.equals(paramString))
          {
            i++;
          }
          else if (str2.equals("end"))
          {
            if (arrayOfString.length < 2)
            {
              str1 = this.rb.getString(SqltoolRB.END_SYNTAX, "1");
              errprintln(str1);
              throw new SqlToolError(str1);
            }
            String str3 = arrayOfString[1];
            if (str3.equals(paramString))
            {
              i--;
              if (i < 1)
                break;
            }
            if ((!str3.equals("foreach")) && (!str3.equals("if")) && (!str3.equals("while")))
            {
              str1 = this.rb.getString(SqltoolRB.END_SYNTAX, "2");
              errprintln(str1);
              throw new SqlToolError(str1);
            }
          }
        }
        localPrintWriter.println(str1);
      }
      localPrintWriter.flush();
    }
    finally
    {
      localPrintWriter.close();
    }
    return localFile;
  }

  private void stdprint(String paramString)
  {
    stdprint(paramString, false);
  }

  private void stdprintln(String paramString)
  {
    stdprintln(paramString, false);
  }

  private void stdprintln(boolean paramBoolean)
  {
    if (this.htmlMode)
      this.psStd.println("<BR>");
    else
      this.psStd.println();
    if ((paramBoolean) && (this.pwQuery != null))
    {
      if (this.htmlMode)
        this.pwQuery.println("<BR>");
      else
        this.pwQuery.println();
      this.pwQuery.flush();
    }
  }

  private void errprint(String paramString)
  {
    this.psErr.print(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + paramString + "</DIV>" : paramString);
  }

  private void errprintln(String paramString)
  {
    this.psErr.println(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + paramString + "</DIV>" : paramString);
  }

  private void stdprint(String paramString, boolean paramBoolean)
  {
    this.psStd.print(this.htmlMode ? "<P>" + paramString + "</P>" : paramString);
    if ((paramBoolean) && (this.pwQuery != null))
    {
      this.pwQuery.print(this.htmlMode ? "<P>" + paramString + "</P>" : paramString);
      this.pwQuery.flush();
    }
  }

  private void stdprintln(String paramString, boolean paramBoolean)
  {
    this.psStd.println(this.htmlMode ? "<P>" + paramString + "</P>" : paramString);
    if ((paramBoolean) && (this.pwQuery != null))
    {
      this.pwQuery.println(this.htmlMode ? "<P>" + paramString + "</P>" : paramString);
      this.pwQuery.flush();
    }
  }

  private void listTables(char paramChar, String paramString)
    throws SqlFile.BadSpecial, SqlToolError
  {
    String str1 = null;
    int[] arrayOfInt = null;
    String[] arrayOfString1 = null;
    String[] arrayOfString2 = null;
    Statement localStatement = null;
    ResultSet localResultSet = null;
    String str2 = "";
    String str3 = paramString;
    try
    {
      DatabaseMetaData localDatabaseMetaData = this.curConn.getMetaData();
      String str4 = localDatabaseMetaData.getDatabaseProductName();
      arrayOfString1 = new String[1];
      switch (paramChar)
      {
      case '*':
        arrayOfString1 = null;
        break;
      case 'S':
        if (str4.indexOf("Oracle") > -1)
        {
          errprintln(this.rb.getString(SqltoolRB.VENDOR_ORACLE_DS));
          arrayOfString1[0] = "TABLE";
          str1 = "SYS";
          arrayOfString2 = oracleSysSchemas;
        }
        else
        {
          arrayOfString1[0] = "SYSTEM TABLE";
        }
        break;
      case 's':
        if (str4.indexOf("HSQL") > -1)
        {
          if ((str3 != null) && (str3.charAt(str3.length() - 1) == '.'))
          {
            str2 = "\nWHERE sequence_schema = '" + str3.substring(0, str3.length() - 1) + "'";
            str3 = null;
          }
          localStatement = this.curConn.createStatement();
          localStatement.execute("SELECT sequence_schema, sequence_name FROM information_schema.system_sequences" + str2);
        }
        else
        {
          arrayOfString1[0] = "SEQUENCE";
        }
        break;
      case 'r':
        if (str4.indexOf("HSQL") > -1)
        {
          localStatement = this.curConn.createStatement();
          localStatement.execute("SELECT authorization_name FROM information_schema.system_authorizations\nWHERE authorization_type = 'ROLE'\nORDER BY authorization_name");
        }
        else if (str4.indexOf("Adaptive Server Enterprise") > -1)
        {
          localStatement = this.curConn.createStatement();
          localStatement.execute("SELECT name FROM syssrvroles ORDER BY name");
        }
        else
        {
          if (str4.indexOf("Apache Derby") > -1)
            throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_DERBY_DR));
          throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_NOSUP_D, "r"));
        }
      case 'u':
        if (str4.indexOf("HSQL") > -1)
        {
          localStatement = this.curConn.createStatement();
          localStatement.execute("SELECT user, admin FROM information_schema.system_users\nORDER BY user");
        }
        else if (str4.indexOf("Oracle") > -1)
        {
          localStatement = this.curConn.createStatement();
          localStatement.execute("SELECT username, created FROM all_users ORDER BY username");
        }
        else if (str4.indexOf("PostgreSQL") > -1)
        {
          localStatement = this.curConn.createStatement();
          localStatement.execute("SELECT usename, usesuper FROM pg_catalog.pg_user ORDER BY usename");
        }
        else if (str4.indexOf("Adaptive Server Enterprise") > -1)
        {
          localStatement = this.curConn.createStatement();
          localStatement.execute("SELECT name, accdate, fullname FROM syslogins ORDER BY name");
        }
        else
        {
          if (str4.indexOf("Apache Derby") > -1)
            throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_DERBY_DU));
          throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_NOSUP_D, "u"));
        }
      case 'a':
        if (str4.indexOf("HSQL") > -1)
        {
          if ((str3 != null) && (str3.charAt(str3.length() - 1) == '.'))
          {
            str2 = "\nWHERE alias_schem = '" + str3.substring(0, str3.length() - 1) + "'";
            str3 = null;
          }
          localStatement = this.curConn.createStatement();
          localStatement.execute("SELECT alias_schem, alias FROM information_schema.system_aliases" + str2);
        }
        else
        {
          arrayOfString1[0] = "ALIAS";
        }
        break;
      case 't':
        this.excludeSysSchemas = (str4.indexOf("Oracle") > -1);
        arrayOfString1[0] = "TABLE";
        break;
      case 'v':
        arrayOfString1[0] = "VIEW";
        break;
      case 'n':
        localResultSet = localDatabaseMetaData.getSchemas();
        if (localResultSet == null)
          throw new BadSpecial("Failed to get metadata from database");
        displayResultSet(null, localResultSet, listMDSchemaCols, str3);
        jsr 495;
      case 'i':
        String str5 = null;
        if (str3 != null)
        {
          int j = str3.indexOf('.');
          str1 = j > 0 ? str3.substring(0, j) : null;
          if (j < str3.length() - 1)
            str5 = j > 0 ? str3.substring(j + 1) : str3;
          str3 = null;
        }
        localResultSet = localDatabaseMetaData.getIndexInfo(null, str1, str5, false, true);
        if (localResultSet == null)
          throw new BadSpecial("Failed to get metadata from database");
        displayResultSet(null, localResultSet, listMDIndexCols, null);
        jsr 378;
      default:
        throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_D_UNKNOWN, Character.toString(paramChar)) + LS + this.D_OPTIONS_TEXT);
      }
      if (localStatement == null)
      {
        if (str4.indexOf("HSQL") > -1)
          arrayOfInt = listMDTableCols[1];
        else if (str4.indexOf("Oracle") > -1)
          arrayOfInt = listMDTableCols[2];
        else
          arrayOfInt = listMDTableCols[0];
        if ((str1 == null) && (str3 != null) && (str3.charAt(str3.length() - 1) == '.'))
        {
          str1 = str3.substring(0, str3.length() - 1);
          str3 = null;
        }
      }
      localResultSet = localStatement == null ? localDatabaseMetaData.getTables(null, str1, null, arrayOfString1) : localStatement.getResultSet();
      if (localResultSet == null)
        throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL));
      displayResultSet(null, localResultSet, arrayOfInt, str3);
      if (arrayOfString2 != null)
        for (int i = 1; i < arrayOfString2.length; i++)
        {
          localResultSet = localDatabaseMetaData.getTables(null, arrayOfString2[i], null, arrayOfString1);
          if (localResultSet == null)
            throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAILFOR, arrayOfString2[i]));
          if (!localResultSet.next())
            continue;
          displayResultSet(null, localDatabaseMetaData.getTables(null, arrayOfString2[i], null, arrayOfString1), arrayOfInt, str3);
        }
    }
    catch (SQLException localSQLException)
    {
      throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL), localSQLException);
    }
    catch (NullPointerException localNullPointerException)
    {
      throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL), localNullPointerException);
    }
    finally
    {
      this.excludeSysSchemas = false;
      if (localResultSet != null)
        localResultSet = null;
      if (localStatement != null)
      {
        try
        {
          localStatement.close();
        }
        catch (Exception localException)
        {
        }
        localStatement = null;
      }
    }
  }

  private void processSQL()
    throws SQLException, SqlToolError
  {
    this.lastSqlStatement = (this.plMode ? dereference(this.buffer, true) : this.buffer);
    Object localObject1 = null;
    if (this.doPrepare)
    {
      if (this.lastSqlStatement.indexOf('?') < 1)
      {
        this.lastSqlStatement = null;
        throw new SqlToolError(this.rb.getString(SqltoolRB.PREPARE_DEMANDQM));
      }
      this.doPrepare = false;
      PreparedStatement localPreparedStatement = this.curConn.prepareStatement(this.lastSqlStatement);
      if (this.prepareVar == null)
      {
        if (this.binBuffer == null)
        {
          this.lastSqlStatement = null;
          throw new SqlToolError(this.rb.getString(SqltoolRB.BINBUFFER_EMPTY));
        }
        localPreparedStatement.setBytes(1, this.binBuffer);
      }
      else
      {
        String str = (String)this.userVars.get(this.prepareVar);
        if (str == null)
        {
          this.lastSqlStatement = null;
          throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, this.prepareVar));
        }
        this.prepareVar = null;
        localPreparedStatement.setString(1, str);
      }
      localPreparedStatement.executeUpdate();
      localObject1 = localPreparedStatement;
    }
    else
    {
      localObject1 = this.curConn.createStatement();
      ((Statement)localObject1).execute(this.lastSqlStatement);
    }
    this.possiblyUncommitteds.set(true);
    try
    {
      displayResultSet((Statement)localObject1, ((Statement)localObject1).getResultSet(), null, null);
    }
    finally
    {
      try
      {
        ((Statement)localObject1).close();
      }
      catch (Exception localException2)
      {
      }
    }
    this.lastSqlStatement = null;
  }

  private void displayResultSet(Statement paramStatement, ResultSet paramResultSet, int[] paramArrayOfInt, String paramString)
    throws SQLException, SqlToolError
  {
    int j = paramStatement == null ? -1 : paramStatement.getUpdateCount();
    boolean bool1 = this.silentFetch;
    boolean bool2 = this.fetchBinary;
    this.silentFetch = false;
    this.fetchBinary = false;
    if (this.excludeSysSchemas)
      stdprintln(this.rb.getString(SqltoolRB.VENDOR_NOSUP_SYSSCHEMAS));
    switch (j)
    {
    case -1:
      if (paramResultSet == null)
      {
        stdprintln(this.rb.getString(SqltoolRB.NORESULT), true);
      }
      else
      {
        ResultSetMetaData localResultSetMetaData = paramResultSet.getMetaData();
        int k = localResultSetMetaData.getColumnCount();
        int m = paramArrayOfInt == null ? k : paramArrayOfInt.length;
        ArrayList localArrayList = new ArrayList();
        String[] arrayOfString1 = null;
        int[] arrayOfInt1 = new int[m];
        if (!this.htmlMode)
          for (int i2 = 0; i2 < arrayOfInt1.length; i2++)
            arrayOfInt1[i2] = 0;
        boolean[] arrayOfBoolean1 = new boolean[m];
        int[] arrayOfInt2 = new int[m];
        boolean[] arrayOfBoolean2 = new boolean[m];
        int n = -1;
        arrayOfString1 = new String[m];
        int i1;
        int i4;
        for (int i3 = 1; i3 <= k; i3++)
        {
          if (paramArrayOfInt != null)
          {
            i1 = 1;
            for (i4 = 0; i4 < paramArrayOfInt.length; i4++)
            {
              if (i3 != paramArrayOfInt[i4])
                continue;
              i1 = 0;
            }
            if (i1 != 0)
              continue;
          }
          n++;
          arrayOfString1[n] = localResultSetMetaData.getColumnLabel(i3);
          arrayOfInt2[n] = localResultSetMetaData.getColumnType(i3);
          arrayOfBoolean1[n] = false;
          arrayOfBoolean2[n] = true;
          switch (arrayOfInt2[n])
          {
          case -7:
          case -6:
          case -5:
          case 2:
          case 3:
          case 4:
          case 5:
          case 6:
          case 7:
          case 8:
            arrayOfBoolean1[n] = true;
            break;
          case -4:
          case -3:
          case -1:
          case 12:
          case 2003:
          case 2004:
          case 2005:
            arrayOfBoolean2[n] = false;
          }
          if ((this.htmlMode) || (arrayOfString1[n].length() <= arrayOfInt1[n]))
            continue;
          arrayOfInt1[n] = arrayOfString1[n].length();
        }
        String[] arrayOfString2;
        int i6;
        while (paramResultSet.next())
        {
          arrayOfString2 = new String[m];
          n = -1;
          i3 = paramString != null ? 1 : 0;
          for (i4 = 1; i4 <= k; i4++)
          {
            int i5;
            if (paramArrayOfInt != null)
            {
              i1 = 1;
              for (i5 = 0; i5 < paramArrayOfInt.length; i5++)
              {
                if (i4 != paramArrayOfInt[i5])
                  continue;
                i1 = 0;
              }
              if (i1 != 0)
                continue;
            }
            n++;
            if (!canDisplayType(arrayOfInt2[n]))
              bool2 = true;
            String str = null;
            if (!bool2)
              switch (arrayOfInt2[n])
              {
              case 91:
              case 92:
              case 93:
                Timestamp localTimestamp = paramResultSet.getTimestamp(i4);
                str = localTimestamp == null ? null : localTimestamp.toString();
                if ((arrayOfInt2[n] == 93) || (str == null))
                  break;
                int i = str.lastIndexOf('.');
                for (i5 = i + 1; i5 < str.length(); i5++)
                {
                  if (str.charAt(i5) == '0')
                    continue;
                  i = 0;
                  break;
                }
                if (i <= 1)
                  break;
                str = str.substring(0, i);
                break;
              default:
                str = paramResultSet.getString(i4);
                if (str != null)
                  break;
                try
                {
                  str = streamToString(paramResultSet.getAsciiStream(i4), this.charset);
                }
                catch (Exception localException)
                {
                }
              }
            if ((bool2) || ((str == null) && (!paramResultSet.wasNull())))
            {
              if (this.pwDsv != null)
                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_BINCOL));
              try
              {
                this.binBuffer = streamToBytes(paramResultSet.getBinaryStream(i4));
              }
              catch (IOException localIOException)
              {
                throw new SqlToolError("Failed to read value using stream", localIOException);
              }
              stdprintln(this.rb.getString(SqltoolRB.BINBUF_WRITE, Integer.toString(this.binBuffer.length), arrayOfString1[n], sqlTypeToString(arrayOfInt2[n])));
              return;
            }
            if ((this.excludeSysSchemas) && (str != null) && (i4 == 2))
              for (i6 = 0; i6 < oracleSysSchemas.length; i6++)
              {
                if (!str.equals(oracleSysSchemas[i6]))
                  continue;
                i3 = 1;
                break;
              }
            this.userVars.put("?", str == null ? this.nullRepToken : str);
            if (this.fetchingVar != null)
            {
              this.userVars.put(this.fetchingVar, this.userVars.get("?"));
              updateUserSettings();
              this.fetchingVar = null;
            }
            if (bool1)
              return;
            if ((paramString != null) && ((str == null) || (str.indexOf(paramString) > -1)))
              i3 = 0;
            if ((str == null) && (this.pwDsv == null))
            {
              if (arrayOfInt2[n] == 12)
                arrayOfString2[n] = (this.htmlMode ? "<I>null</I>" : this.nullRepToken);
              else
                arrayOfString2[n] = "";
            }
            else
              arrayOfString2[n] = str;
            if ((this.htmlMode) || (this.pwDsv != null) || (arrayOfString2[n].length() <= arrayOfInt1[n]))
              continue;
            arrayOfInt1[n] = arrayOfString2[n].length();
          }
          if (i3 != 0)
            continue;
          localArrayList.add(arrayOfString2);
        }
        if (this.pwDsv == null)
        {
          condlPrintln("<TABLE border='1'>", true);
          if (m > 1)
          {
            condlPrint(htmlRow(0) + LS + PRE_TD, true);
            for (i4 = 0; i4 < arrayOfString1.length; i4++)
            {
              condlPrint("<TD>" + arrayOfString1[i4] + "</TD>", true);
              condlPrint((i4 > 0 ? spaces(2) : "") + pad(arrayOfString1[i4], arrayOfInt1[i4], arrayOfBoolean1[i4], (i4 < arrayOfString1.length - 1) || (arrayOfBoolean1[i4] != 0)), false);
            }
            condlPrintln(LS + PRE_TR + "</TR>", true);
            condlPrintln("", false);
            if (!this.htmlMode)
            {
              for (i4 = 0; i4 < arrayOfString1.length; i4++)
                condlPrint((i4 > 0 ? spaces(2) : "") + divider(arrayOfInt1[i4]), false);
              condlPrintln("", false);
            }
          }
          for (i4 = 0; i4 < localArrayList.size(); i4++)
          {
            condlPrint(htmlRow(i4 % 2 == 0 ? 2 : 1) + LS + PRE_TD, true);
            arrayOfString2 = (String[])localArrayList.get(i4);
            for (i6 = 0; i6 < arrayOfString2.length; i6++)
            {
              condlPrint("<TD>" + arrayOfString2[i6] + "</TD>", true);
              condlPrint((i6 > 0 ? spaces(2) : "") + pad(arrayOfString2[i6], arrayOfInt1[i6], arrayOfBoolean1[i6], (i6 < arrayOfString2.length - 1) || (arrayOfBoolean1[i6] != 0)), false);
            }
            condlPrintln(LS + PRE_TR + "</TR>", true);
            condlPrintln("", false);
          }
          condlPrintln("</TABLE>", true);
          if (localArrayList.size() != 1)
            stdprintln(LS + this.rb.getString(SqltoolRB.ROWS_FETCHED, localArrayList.size()), true);
          condlPrintln("<HR>", true);
        }
        else
        {
          if (m > 0)
          {
            for (i4 = 0; i4 < arrayOfString1.length; i4++)
            {
              dsvSafe(arrayOfString1[i4]);
              this.pwDsv.print(arrayOfString1[i4]);
              if (i4 >= arrayOfString1.length - 1)
                continue;
              this.pwDsv.print(this.dsvColDelim);
            }
            this.pwDsv.print(this.dsvRowDelim);
          }
          for (i4 = 0; i4 < localArrayList.size(); i4++)
          {
            arrayOfString2 = (String[])localArrayList.get(i4);
            for (i6 = 0; i6 < arrayOfString2.length; i6++)
            {
              dsvSafe(arrayOfString2[i6]);
              this.pwDsv.print(arrayOfString2[i6] == null ? this.nullRepToken : arrayOfBoolean2[i6] != 0 ? "" : arrayOfString2[i6]);
              if (i6 >= arrayOfString2.length - 1)
                continue;
              this.pwDsv.print(this.dsvColDelim);
            }
            this.pwDsv.print(this.dsvRowDelim);
          }
          stdprintln(this.rb.getString(SqltoolRB.ROWS_FETCHED_DSV, localArrayList.size()));
        }
      }
      break;
    default:
      this.userVars.put("?", Integer.toString(j));
      if (this.fetchingVar != null)
      {
        this.userVars.put(this.fetchingVar, this.userVars.get("?"));
        updateUserSettings();
        this.fetchingVar = null;
      }
      if (j == 0)
        break;
      stdprintln(j == 1 ? this.rb.getString(SqltoolRB.ROW_UPDATE_SINGULAR) : this.rb.getString(SqltoolRB.ROW_UPDATE_MULTIPLE, j));
    }
  }

  private static String htmlRow(int paramInt)
  {
    switch (paramInt)
    {
    case 0:
      return PRE_TR + "<TR style='font-weight: bold;'>";
    case 1:
      return PRE_TR + "<TR style='background: #94d6ef; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
    case 2:
      return PRE_TR + "<TR style='background: silver; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
    }
    return null;
  }

  private static String divider(int paramInt)
  {
    return paramInt > "----------------------------------------------------------------------------------------------------------------------------------".length() ? "----------------------------------------------------------------------------------------------------------------------------------" : "----------------------------------------------------------------------------------------------------------------------------------".substring(0, paramInt);
  }

  private static String spaces(int paramInt)
  {
    return paramInt > "                                                                                                                                  ".length() ? "                                                                                                                                  " : "                                                                                                                                  ".substring(0, paramInt);
  }

  private static String pad(String paramString, int paramInt, boolean paramBoolean1, boolean paramBoolean2)
  {
    if (!paramBoolean2)
      return paramString;
    int i = paramInt - paramString.length();
    if (i < 1)
      return paramString;
    String str = spaces(i);
    return (paramBoolean1 ? str : "") + paramString + (paramBoolean1 ? "" : str);
  }

  private void showHistory()
    throws SqlFile.BadSpecial
  {
    if (this.history == null)
      throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
    if (this.history.size() < 1)
      throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_NONE));
    for (int i = 0; i < this.history.size(); i++)
    {
      this.psStd.println("#" + (i + this.oldestHist) + " or " + (i - this.history.size()) + ':');
      this.psStd.println((String)this.history.get(i));
    }
    if (this.buffer != null)
      this.psStd.println(this.rb.getString(SqltoolRB.EDITBUFFER_CONTENTS, this.buffer));
    this.psStd.println();
    this.psStd.println(this.rb.getString(SqltoolRB.BUFFER_INSTRUCTIONS));
  }

  private String commandFromHistory(int paramInt)
    throws SqlFile.BadSpecial
  {
    int i = paramInt;
    if (this.history == null)
      throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
    if (i == 0)
      throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_NUMBER_REQ));
    if (i > 0)
    {
      i -= this.oldestHist;
      if (i < 0)
        throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_BACKTO, this.oldestHist));
      if (i >= this.history.size())
        throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UPTO, this.history.size() + this.oldestHist - 1));
    }
    else
    {
      i += this.history.size();
      if (i < 0)
        throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_BACK, this.history.size()));
    }
    return (String)this.history.get(i);
  }

  private Integer historySearch(String paramString)
    throws SqlFile.BadSpecial
  {
    if (this.history == null)
      throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
    Pattern localPattern = Pattern.compile("(?ims)" + paramString);
    for (int i = this.history.size() - 1; i >= 0; i--)
      if (localPattern.matcher((String)this.history.get(i)).find())
        return new Integer(i + this.oldestHist);
    return null;
  }

  private void setBuf(String paramString)
  {
    this.buffer = new String(paramString);
  }

  private void historize()
  {
    if ((this.history == null) || (this.buffer == null))
      return;
    if ((this.history.size() > 0) && (this.history.get(this.history.size() - 1).equals(this.buffer)))
      return;
    this.history.add(this.buffer);
    if (this.history.size() <= this.maxHistoryLength)
      return;
    this.history.remove(0);
    this.oldestHist += 1;
  }

  private void describe(String paramString1, String paramString2)
    throws SQLException
  {
    String str = paramString2;
    ArrayList localArrayList = new ArrayList();
    String[] arrayOfString1 = { this.rb.getString(SqltoolRB.DESCRIBE_TABLE_NAME), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_DATATYPE), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_WIDTH), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_NONULLS) };
    int[] arrayOfInt = { 0, 0, 0, 0 };
    boolean[] arrayOfBoolean = { false, false, true, false };
    for (int i = 0; i < arrayOfString1.length; i++)
    {
      if ((this.htmlMode) || (arrayOfString1[i].length() <= arrayOfInt[i]))
        continue;
      arrayOfInt[i] = arrayOfString1[i].length();
    }
    Statement localStatement = this.curConn.createStatement();
    ResultSet localResultSet = null;
    try
    {
      localStatement.execute("SELECT * FROM " + paramString1 + " WHERE 1 = 2");
      localResultSet = localStatement.getResultSet();
      ResultSetMetaData localResultSetMetaData = localResultSet.getMetaData();
      int j = localResultSetMetaData.getColumnCount();
      String[] arrayOfString2;
      int m;
      for (int k = 0; k < j; k++)
      {
        arrayOfString2 = new String[4];
        arrayOfString2[0] = localResultSetMetaData.getColumnName(k + 1);
        if ((str != null) && (arrayOfString2[0].indexOf(str) < 0))
          continue;
        arrayOfString2[1] = localResultSetMetaData.getColumnTypeName(k + 1);
        arrayOfString2[2] = Integer.toString(localResultSetMetaData.getColumnDisplaySize(k + 1));
        arrayOfString2[3] = (localResultSetMetaData.isNullable(k + 1) == 1 ? "" : this.htmlMode ? "&nbsp;" : "*");
        localArrayList.add(arrayOfString2);
        for (m = 0; m < arrayOfString2.length; m++)
        {
          if (arrayOfString2[m].length() <= arrayOfInt[m])
            continue;
          arrayOfInt[m] = arrayOfString2[m].length();
        }
      }
      condlPrint("<TABLE border='1'>" + LS + htmlRow(0) + LS + PRE_TD, true);
      for (k = 0; k < arrayOfString1.length; k++)
      {
        condlPrint("<TD>" + arrayOfString1[k] + "</TD>", true);
        condlPrint((k > 0 ? spaces(2) : "") + pad(arrayOfString1[k], arrayOfInt[k], arrayOfBoolean[k], (k < arrayOfString1.length - 1) || (arrayOfBoolean[k] != 0)), false);
      }
      condlPrintln(LS + PRE_TR + "</TR>", true);
      condlPrintln("", false);
      if (!this.htmlMode)
      {
        for (k = 0; k < arrayOfString1.length; k++)
          condlPrint((k > 0 ? spaces(2) : "") + divider(arrayOfInt[k]), false);
        condlPrintln("", false);
      }
      for (k = 0; k < localArrayList.size(); k++)
      {
        condlPrint(htmlRow(k % 2 == 0 ? 2 : 1) + LS + PRE_TD, true);
        arrayOfString2 = (String[])localArrayList.get(k);
        for (m = 0; m < arrayOfString2.length; m++)
        {
          condlPrint("<TD>" + arrayOfString2[m] + "</TD>", true);
          condlPrint((m > 0 ? spaces(2) : "") + pad(arrayOfString2[m], arrayOfInt[m], arrayOfBoolean[m], (m < arrayOfString2.length - 1) || (arrayOfBoolean[m] != 0)), false);
        }
        condlPrintln(LS + PRE_TR + "</TR>", true);
        condlPrintln("", false);
      }
      condlPrintln(LS + "</TABLE>" + LS + "<HR>", true);
    }
    finally
    {
      try
      {
        if (localResultSet != null)
        {
          localResultSet.close();
          localResultSet = null;
        }
        localStatement.close();
      }
      catch (Exception localException)
      {
      }
    }
  }

  private boolean eval(String[] paramArrayOfString)
    throws SqlFile.BadSpecial
  {
    int i = (paramArrayOfString.length > 0) && (paramArrayOfString[0].equals("!")) ? 1 : 0;
    String[] arrayOfString = new String[i != 0 ? paramArrayOfString.length - 1 : paramArrayOfString.length];
    for (int j = 0; j < arrayOfString.length; j++)
    {
      String str = paramArrayOfString[(j + 0)];
      if ((str.length() > 1) && (str.charAt(0) == '*'))
        arrayOfString[j] = ((String)this.userVars.get(str.substring(1)));
      else
        arrayOfString[j] = paramArrayOfString[(j + 0)];
      if (arrayOfString[j] != null)
        continue;
      arrayOfString[j] = "";
    }
    if (arrayOfString.length == 1)
      return ((arrayOfString[0].length() > 0) && (!arrayOfString[0].equals("0")) ? 1 : 0) ^ i;
    if (arrayOfString.length == 3)
    {
      if (arrayOfString[1].equals("=="))
        return arrayOfString[0].equals(arrayOfString[2]) ^ i;
      if ((arrayOfString[1].equals("!=")) || (arrayOfString[1].equals("<>")) || (arrayOfString[1].equals("><")))
        return (!arrayOfString[0].equals(arrayOfString[2]) ? 1 : 0) ^ i;
      if (arrayOfString[1].equals(">"))
        return ((arrayOfString[0].length() > arrayOfString[2].length()) || ((arrayOfString[0].length() == arrayOfString[2].length()) && (arrayOfString[0].compareTo(arrayOfString[2]) > 0)) ? 1 : 0) ^ i;
      if (arrayOfString[1].equals("<"))
        return ((arrayOfString[2].length() > arrayOfString[0].length()) || ((arrayOfString[2].length() == arrayOfString[0].length()) && (arrayOfString[2].compareTo(arrayOfString[0]) > 0)) ? 1 : 0) ^ i;
    }
    throw new BadSpecial(this.rb.getString(SqltoolRB.LOGICAL_UNRECOGNIZED));
  }

  private void closeQueryOutputStream()
  {
    if (this.pwQuery == null)
      return;
    if (this.htmlMode)
    {
      this.pwQuery.println("</BODY></HTML>");
      this.pwQuery.flush();
    }
    this.pwQuery.close();
    this.pwQuery = null;
  }

  private void condlPrintln(String paramString, boolean paramBoolean)
  {
    if (((paramBoolean) && (!this.htmlMode)) || ((this.htmlMode) && (!paramBoolean)))
      return;
    this.psStd.println(paramString);
    if (this.pwQuery != null)
    {
      this.pwQuery.println(paramString);
      this.pwQuery.flush();
    }
  }

  private void condlPrint(String paramString, boolean paramBoolean)
  {
    if (((paramBoolean) && (!this.htmlMode)) || ((this.htmlMode) && (!paramBoolean)))
      return;
    this.psStd.print(paramString);
    if (this.pwQuery != null)
    {
      this.pwQuery.print(paramString);
      this.pwQuery.flush();
    }
  }

  private String formatNicely(Map paramMap, boolean paramBoolean)
  {
    StringBuffer localStringBuffer = new StringBuffer();
    Iterator localIterator = new TreeMap(paramMap).keySet().iterator();
    if (paramBoolean)
      appendLine(localStringBuffer, this.rb.getString(SqltoolRB.PL_LIST_PARENS));
    else
      appendLine(localStringBuffer, this.rb.getString(SqltoolRB.PL_LIST_LENGTHS));
    while (localIterator.hasNext())
    {
      String str1 = (String)localIterator.next();
      String str2 = (String)paramMap.get(str1);
      appendLine(localStringBuffer, "    " + str1 + ": " + (paramBoolean ? "(" + str2 + ')' : Integer.toString(str2.length())));
    }
    return localStringBuffer.toString();
  }

  private void dump(String paramString, File paramFile)
    throws IOException, SqlFile.BadSpecial
  {
    String str = (String)this.userVars.get(paramString);
    if (str == null)
      throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, paramString));
    OutputStreamWriter localOutputStreamWriter = this.charset == null ? new OutputStreamWriter(new FileOutputStream(paramFile)) : new OutputStreamWriter(new FileOutputStream(paramFile), this.charset);
    try
    {
      localOutputStreamWriter.write(str);
      if (str.length() > 0)
      {
        int i = str.charAt(str.length() - 1);
        if ((i != 10) && (i != 13))
          localOutputStreamWriter.write(LS);
      }
      localOutputStreamWriter.flush();
    }
    finally
    {
      localOutputStreamWriter.close();
    }
    stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, Long.toString(paramFile.length()), paramFile.toString()));
  }

  private void dump(File paramFile)
    throws IOException, SqlFile.BadSpecial
  {
    if (this.binBuffer == null)
      throw new BadSpecial(this.rb.getString(SqltoolRB.BINBUFFER_EMPTY));
    FileOutputStream localFileOutputStream = new FileOutputStream(paramFile);
    int i = 0;
    try
    {
      localFileOutputStream.write(this.binBuffer);
      i = this.binBuffer.length;
      this.binBuffer = null;
      localFileOutputStream.flush();
    }
    finally
    {
      localFileOutputStream.close();
    }
    stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, i, paramFile.toString()));
  }

  public String streamToString(InputStream paramInputStream, String paramString)
    throws IOException
  {
    try
    {
      byte[] arrayOfByte = null;
      int i = 0;
      try
      {
        arrayOfByte = new byte[paramInputStream.available()];
      }
      catch (RuntimeException localRuntimeException1)
      {
        throw new IOException(this.rb.getString(SqltoolRB.READ_TOOBIG));
      }
      int j;
      while ((i < arrayOfByte.length) && ((j = paramInputStream.read(arrayOfByte, i, arrayOfByte.length - i)) > 0))
        i += j;
      if (i != arrayOfByte.length)
        throw new IOException(this.rb.getString(SqltoolRB.READ_PARTIAL, i, arrayOfByte.length));
      try
      {
        String str = paramString == null ? new String(arrayOfByte) : new String(arrayOfByte, paramString);
        paramInputStream.close();
        return str;
      }
      catch (UnsupportedEncodingException localUnsupportedEncodingException)
      {
        throw new RuntimeException(localUnsupportedEncodingException);
      }
      catch (RuntimeException localRuntimeException2)
      {
        throw new IOException(this.rb.getString(SqltoolRB.READ_CONVERTFAIL));
      }
    }
    finally
    {
      paramInputStream.close();
    }
    throw localObject;
  }

  private void load(String paramString1, File paramFile, String paramString2)
    throws IOException
  {
    String str = streamToString(new FileInputStream(paramFile), paramString2);
    this.userVars.put(paramString1, str);
    updateUserSettings();
  }

  public static byte[] streamToBytes(InputStream paramInputStream)
    throws IOException
  {
    byte[] arrayOfByte = new byte[10240];
    ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
    int i;
    while ((i = paramInputStream.read(arrayOfByte)) > 0)
      localByteArrayOutputStream.write(arrayOfByte, 0, i);
    return localByteArrayOutputStream.toByteArray();
  }

  public static byte[] loadBinary(File paramFile)
    throws IOException
  {
    byte[] arrayOfByte1 = new byte[10240];
    ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
    FileInputStream localFileInputStream = new FileInputStream(paramFile);
    try
    {
      int i;
      while ((i = localFileInputStream.read(arrayOfByte1)) > 0)
        localByteArrayOutputStream.write(arrayOfByte1, 0, i);
    }
    finally
    {
      localFileInputStream.close();
    }
    byte[] arrayOfByte2 = localByteArrayOutputStream.toByteArray();
    return arrayOfByte2;
  }

  public static boolean canDisplayType(int paramInt)
  {
    switch (paramInt)
    {
    case 1111:
    case 2000:
    case 2002:
    case 2004:
      return false;
    }
    return true;
  }

  public static String sqlTypeToString(int paramInt)
  {
    switch (paramInt)
    {
    case 2003:
      return "ARRAY";
    case -5:
      return "BIGINT";
    case -2:
      return "BINARY";
    case -7:
      return "BIT";
    case 2004:
      return "BLOB";
    case 16:
      return "BOOLEAN";
    case 1:
      return "CHAR";
    case 2005:
      return "CLOB";
    case 70:
      return "DATALINK";
    case 91:
      return "DATE";
    case 3:
      return "DECIMAL";
    case 2001:
      return "DISTINCT";
    case 8:
      return "DOUBLE";
    case 6:
      return "FLOAT";
    case 4:
      return "INTEGER";
    case 2000:
      return "JAVA_OBJECT";
    case -4:
      return "LONGVARBINARY";
    case -1:
      return "LONGVARCHAR";
    case 0:
      return "NULL";
    case 2:
      return "NUMERIC";
    case 1111:
      return "OTHER";
    case 7:
      return "REAL";
    case 2006:
      return "REF";
    case 5:
      return "SMALLINT";
    case 2002:
      return "STRUCT";
    case 92:
      return "TIME";
    case 93:
      return "TIMESTAMP";
    case -6:
      return "TINYINT";
    case -3:
      return "VARBINARY";
    case 12:
      return "VARCHAR";
    }
    return "Unknown type " + paramInt;
  }

  public void dsvSafe(String paramString)
    throws SqlToolError
  {
    if ((this.pwDsv == null) || (this.dsvColDelim == null) || (this.dsvRowDelim == null) || (this.nullRepToken == null))
      throw new RuntimeException("Assertion failed.  \ndsvSafe called when DSV settings are incomplete");
    if (paramString == null)
      return;
    if (paramString.indexOf(this.dsvColDelim) > 0)
      throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_COLDELIM_PRESENT, this.dsvColDelim));
    if (paramString.indexOf(this.dsvRowDelim) > 0)
      throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_ROWDELIM_PRESENT, this.dsvRowDelim));
    if (paramString.trim().equals(this.nullRepToken))
      throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NULLREP_PRESENT, this.nullRepToken));
  }

  public static String convertEscapes(String paramString)
  {
    if (paramString == null)
      return null;
    return convertNumericEscapes(convertEscapes(convertEscapes(convertEscapes(convertEscapes(convertEscapes(paramString, "\\n", "\n"), "\\r", "\r"), "\\t", "\t"), "\\\\", "\\"), "\\f", "\f"));
  }

  private static String convertNumericEscapes(String paramString)
  {
    String str = paramString;
    int i = 0;
    for (char c = '0'; c <= '9'; c = (char)(c + '\001'))
    {
      while (((i = str.indexOf("\\" + c, i)) > -1) && (i < str.length() - 1))
        str = convertNumericEscape(paramString, i);
      while (((i = str.indexOf("\\x" + c, i)) > -1) && (i < str.length() - 1))
        str = convertNumericEscape(paramString, i);
      while (((i = str.indexOf("\\X" + c, i)) > -1) && (i < str.length() - 1))
        str = convertNumericEscape(paramString, i);
    }
    return str;
  }

  private static String convertNumericEscape(String paramString, int paramInt)
  {
    int i = -1;
    int j = -1;
    int k = -1;
    if (Character.toUpperCase(paramString.charAt(paramInt + 1)) == 'X')
    {
      j = paramInt + 2;
      k = 16;
      i = j + 2;
      if (i > paramString.length())
        i = paramString.length();
    }
    else
    {
      j = paramInt + 1;
      k = Character.toUpperCase(paramString.charAt(j)) == '0' ? 8 : 10;
      for (i = j + 1; (i < paramString.length()) && (Character.isDigit(paramString.charAt(i))); i++);
    }
    return paramString.substring(0, paramInt) + (char)Integer.parseInt(paramString.substring(j, i), k) + paramString.substring(i);
  }

  private static String convertEscapes(String paramString1, String paramString2, String paramString3)
  {
    String str = paramString1;
    int i = 0;
    int j = paramString2.length();
    while (((i = str.indexOf(paramString2, i)) > -1) && (i < str.length() - 1))
      str = str.substring(0, i) + paramString3 + str.substring(i + j);
    return str;
  }

  public void importDsv(String paramString1, String paramString2)
    throws SqlToolError
  {
    byte[] arrayOfByte = null;
    File localFile1 = new File(paramString1);
    TreeMap localTreeMap = null;
    if (this.dsvConstCols != null)
    {
      localTreeMap = new TreeMap();
      localObject1 = this.dsvConstCols.split("\\Q" + this.dsvColDelim + "\\E\\s*");
      for (int m = 0; m < localObject1.length; m++)
      {
        int i = localObject1[m].indexOf('=');
        String str1 = localObject1[m].substring(0, i).trim().toLowerCase();
        if (str1.trim().length() < 1)
          throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_CONSTCOLS_NULLCOL));
        localTreeMap.put(str1, localObject1[m].substring(i + 1));
      }
    }
    Object localObject1 = null;
    int k;
    if (this.dsvSkipCols != null)
    {
      localObject1 = new HashSet();
      String[] arrayOfString1 = this.dsvSkipCols.split("\\s*\\Q" + this.dsvColDelim + "\\E\\s*");
      for (k = 0; k < arrayOfString1.length; k++)
        ((Set)localObject1).add(arrayOfString1[k].toLowerCase());
    }
    if (!localFile1.canRead())
      throw new SqlToolError(this.rb.getString(SqltoolRB.FILE_READFAIL, localFile1.toString()));
    try
    {
      arrayOfByte = new byte[(int)localFile1.length()];
    }
    catch (RuntimeException localRuntimeException1)
    {
      throw new SqlToolError(this.rb.getString(SqltoolRB.READ_TOOBIG), localRuntimeException1);
    }
    int j = 0;
    FileInputStream localFileInputStream = null;
    try
    {
      localFileInputStream = new FileInputStream(localFile1);
      while ((j < arrayOfByte.length) && ((k = localFileInputStream.read(arrayOfByte, j, arrayOfByte.length - j)) > 0))
        j += k;
    }
    catch (IOException localIOException1)
    {
      throw new SqlToolError(localIOException1);
    }
    finally
    {
      if (localFileInputStream != null)
        try
        {
          localFileInputStream.close();
        }
        catch (IOException localIOException2)
        {
          errprintln(this.rb.getString(SqltoolRB.INPUTFILE_CLOSEFAIL) + ": " + localIOException2);
        }
    }
    if (j != arrayOfByte.length)
      throw new SqlToolError(this.rb.getString(SqltoolRB.READ_PARTIAL, j, arrayOfByte.length));
    String str2 = null;
    try
    {
      str2 = this.charset == null ? new String(arrayOfByte) : new String(arrayOfByte, this.charset);
    }
    catch (UnsupportedEncodingException localUnsupportedEncodingException)
    {
      throw new RuntimeException(localUnsupportedEncodingException);
    }
    catch (RuntimeException localRuntimeException2)
    {
      throw new SqlToolError(this.rb.getString(SqltoolRB.READ_CONVERTFAIL), localRuntimeException2);
    }
    ArrayList localArrayList1 = new ArrayList();
    String str4 = this.dsvTargetTable;
    int n = -1000;
    int i3 = 0;
    int i4 = -1;
    String str5 = null;
    int i5 = 0;
    String str7;
    while (true)
    {
      i4 = i4 < 0 ? 0 : n + this.dsvRowDelim.length();
      if (i4 > str2.length() - 2)
        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NONE));
      n = str2.indexOf(this.dsvRowDelim, i4);
      i3++;
      if (n < 0)
        n = str2.length();
      str5 = str2.substring(i4, n).trim();
      if ((str5.length() < 1) || ((paramString2 != null) && (str5.startsWith(paramString2))))
        continue;
      if (str5.startsWith("targettable="))
      {
        if (str4 != null)
          continue;
        str4 = str5.substring("targettable=".length()).trim();
        continue;
      }
      if (str5.equals("headerswitch{"))
      {
        if (str4 == null)
          throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NOSWITCHTARG, i3));
        i5 = 1;
        continue;
      }
      if (str5.equals("}"))
        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NOSWITCHMATCH, i3));
      if (i5 == 0)
        break;
      int i6 = str5.indexOf(':');
      if ((i6 < 1) || (i6 == str5.length() - 1))
        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NONSWITCHED, i3));
      str7 = str5.substring(0, i6).trim();
      if ((!str7.equals("*")) && (!str7.equalsIgnoreCase(str4)))
        continue;
      i4 = 1 + str2.indexOf(':', i4);
    }
    String str6 = str2.substring(i4, n);
    int i1 = i4;
    int i2 = -1;
    while (i2 != n)
    {
      i2 = str2.indexOf(this.dsvColDelim, i1);
      if ((i2 < 0) || (i2 > n))
        i2 = n;
      if (i2 - i1 < 1)
        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NOCOLHEADER, localArrayList1.size() + 1, i3));
      str7 = str2.substring(i1, i2).trim().toLowerCase();
      localArrayList1.add((str7.equals("-")) || ((localObject1 != null) && (((Set)localObject1).remove(str7))) || ((localTreeMap != null) && (localTreeMap.containsKey(str7))) ? (String)null : str7);
      i1 = i2 + this.dsvColDelim.length();
    }
    if ((localObject1 != null) && (((Set)localObject1).size() > 0))
      throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_SKIPCOLS_MISSING, localObject1.toString()));
    int i7 = 0;
    for (int i8 = 0; i8 < localArrayList1.size(); i8++)
    {
      if (localArrayList1.get(i8) == null)
        continue;
      i7 = 1;
      break;
    }
    if (i7 == 0)
      throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NOCOLSLEFT, this.dsvSkipCols));
    i8 = localArrayList1.size();
    if (localTreeMap != null)
      localArrayList1.addAll(localTreeMap.keySet());
    String[] arrayOfString2 = (String[])localArrayList1.toArray(new String[0]);
    if (str4 == null)
    {
      str4 = localFile1.getName();
      int i9 = str4.lastIndexOf('.');
      if (i9 > 0)
        str4 = str4.substring(0, i9);
    }
    StringBuffer localStringBuffer1 = new StringBuffer();
    ArrayList localArrayList2 = new ArrayList();
    int i10 = 0;
    for (int i11 = 0; i11 < arrayOfString2.length; i11++)
      if (arrayOfString2[i11] == null)
      {
        i10++;
      }
      else
      {
        if (localStringBuffer1.length() > 0)
          localStringBuffer1.append(", ");
        localStringBuffer1.append(arrayOfString2[i11]);
        localArrayList2.add(arrayOfString2[i11]);
      }
    boolean[] arrayOfBoolean1 = new boolean[arrayOfString2.length - i10];
    boolean[] arrayOfBoolean2 = new boolean[arrayOfBoolean1.length];
    boolean[] arrayOfBoolean3 = new boolean[arrayOfBoolean1.length];
    String[] arrayOfString3 = (String[])localArrayList2.toArray(new String[0]);
    StringBuffer localStringBuffer2 = new StringBuffer("INSERT INTO " + str4 + " (" + localStringBuffer1 + ") VALUES (");
    StringBuffer localStringBuffer3 = new StringBuffer("SELECT " + localStringBuffer1 + " FROM " + str4 + " WHERE 1 = 2");
    try
    {
      ResultSetMetaData localResultSetMetaData = this.curConn.createStatement().executeQuery(localStringBuffer3.toString()).getMetaData();
      if (localResultSetMetaData.getColumnCount() != arrayOfBoolean1.length)
        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_METADATA_MISMATCH));
      for (int i13 = 0; i13 < arrayOfBoolean1.length; i13++)
      {
        arrayOfBoolean1[i13] = true;
        arrayOfBoolean2[i13] = false;
        arrayOfBoolean3[i13] = false;
        switch (localResultSetMetaData.getColumnType(i13 + 1))
        {
        case 16:
          arrayOfBoolean3[i13] = true;
          break;
        case -4:
        case -3:
        case -1:
        case 12:
        case 2003:
        case 2004:
        case 2005:
          arrayOfBoolean1[i13] = false;
          break;
        case 91:
        case 92:
        case 93:
          arrayOfBoolean2[i13] = true;
        }
      }
    }
    catch (SQLException localSQLException1)
    {
      throw new SqlToolError(this.rb.getString(SqltoolRB.QUERY_METADATAFAIL, localStringBuffer3.toString()), localSQLException1);
    }
    for (int i12 = 0; i12 < arrayOfBoolean1.length; i12++)
    {
      if (i12 > 0)
        localStringBuffer2.append(", ");
      localStringBuffer2.append('?');
    }
    i12 = 0;
    File localFile2 = null;
    File localFile3 = null;
    PrintWriter localPrintWriter1 = null;
    PrintWriter localPrintWriter2 = null;
    if (this.dsvRejectFile != null)
      try
      {
        localFile2 = new File(this.dsvRejectFile);
        localPrintWriter1 = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(localFile2)) : new OutputStreamWriter(new FileOutputStream(localFile2), this.charset));
        localPrintWriter1.print(str6 + this.dsvRowDelim);
      }
      catch (IOException localIOException3)
      {
        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_REJECTFILE_SETUPFAIL, this.dsvRejectFile), localIOException3);
      }
    if (this.dsvRejectReport != null)
      try
      {
        localFile3 = new File(this.dsvRejectReport);
        localPrintWriter2 = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(localFile3)) : new OutputStreamWriter(new FileOutputStream(localFile3), this.charset));
        localPrintWriter2.println(this.rb.getString(SqltoolRB.REJECTREPORT_TOP, new String[] { new Date().toString(), localFile1.getPath(), localFile2 == null ? this.rb.getString(SqltoolRB.NONE) : localFile2.getPath(), localFile2 == null ? null : localFile2.getPath() }));
      }
      catch (IOException localIOException4)
      {
        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_REJECTREPORT_SETUPFAIL, this.dsvRejectReport), localIOException4);
      }
    int i14 = 0;
    int i15 = 0;
    PreparedStatement localPreparedStatement = null;
    int i16 = 0;
    try
    {
      try
      {
        localPreparedStatement = this.curConn.prepareStatement(localStringBuffer2.toString() + ')');
      }
      catch (SQLException localSQLException2)
      {
        throw new SqlToolError(this.rb.getString(SqltoolRB.INSERTION_PREPAREFAIL, localStringBuffer2.toString()), localSQLException2);
      }
      String[] arrayOfString4 = new String[arrayOfBoolean1.length];
      String str8 = null;
      label3250: 
      while (true)
        try
        {
          try
          {
            i4 = n + this.dsvRowDelim.length();
            if (i4 >= str2.length())
              break;
            n = str2.indexOf(this.dsvRowDelim, i4);
            i3++;
            if (n >= 0)
              continue;
            n = str2.length();
            str5 = str2.substring(i4, n).trim();
            if (str5.length() < 1)
              continue;
            if ((paramString2 == null) || (!str5.startsWith(paramString2)))
              continue;
            i15++;
            continue;
            if (i5 == 0)
              continue;
            if (!str5.equals("}"))
              continue;
            i5 = 0;
            continue;
            int i19 = str5.indexOf(':');
            if ((i19 >= 1) && (i19 != str5.length() - 1))
              continue;
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_MATCHERNONHEAD, i3));
            continue;
            i14++;
            i1 = i4;
            i2 = -1;
            int i17 = 0;
            int i18 = 0;
            if (i2 == n)
              continue;
            i2 = str2.indexOf(this.dsvColDelim, i1);
            if ((i2 >= 0) && (i2 <= n))
              continue;
            i2 = n;
            if (i17 != i8)
              continue;
            throw new RowError(this.rb.getString(SqltoolRB.DSV_COLCOUNT_MISMATCH, i8, 1 + i17));
            if (arrayOfString2[(i17++)] == null)
              continue;
            arrayOfString4[(i18++)] = str2.substring(i1, i2);
            i1 = i2 + this.dsvColDelim.length();
            continue;
            if (i17 >= i8)
              continue;
            throw new RowError(this.rb.getString(SqltoolRB.DSV_COLCOUNT_MISMATCH, i8, i17));
            if (localTreeMap == null)
              continue;
            Iterator localIterator = localTreeMap.values().iterator();
            if (!localIterator.hasNext())
              continue;
            arrayOfString4[(i18++)] = ((String)localIterator.next());
            continue;
            if (i18 == arrayOfString4.length)
              continue;
            throw new RowError(this.rb.getString(SqltoolRB.DSV_INSERTCOL_MISMATCH, arrayOfString4.length, i18));
            int i20 = 0;
            if (i20 >= arrayOfString4.length)
              continue;
            str8 = arrayOfString3[i20];
            if (arrayOfBoolean1[i20] == 0)
              continue;
            arrayOfString4[i20] = arrayOfString4[i20].trim();
            if (arrayOfBoolean2[i20] == 0)
              continue;
            if (((arrayOfString4[i20].length() >= 1) || (arrayOfBoolean1[i20] == 0)) && (!arrayOfString4[i20].equals(this.nullRepToken)))
              continue;
            localPreparedStatement.setTimestamp(i20 + 1, null);
            continue;
            String str3 = arrayOfString4[i20] + " 0:00:00";
            try
            {
              localPreparedStatement.setTimestamp(i20 + 1, Timestamp.valueOf(str3));
            }
            catch (IllegalArgumentException localIllegalArgumentException1)
            {
              throw new RowError(this.rb.getString(SqltoolRB.TIME_BAD, str3), localIllegalArgumentException1);
            }
            if (arrayOfBoolean3[i20] == 0)
              continue;
            if (((arrayOfString4[i20].length() >= 1) || (arrayOfBoolean1[i20] == 0)) && (!arrayOfString4[i20].equals(this.nullRepToken)))
              continue;
            localPreparedStatement.setNull(i20 + 1, 16);
            continue;
            try
            {
              localPreparedStatement.setBoolean(i20 + 1, Boolean.valueOf(arrayOfString4[i20]).booleanValue());
            }
            catch (IllegalArgumentException localIllegalArgumentException2)
            {
              throw new RowError(this.rb.getString(SqltoolRB.BOOLEAN_BAD, arrayOfString4[i20]), localIllegalArgumentException2);
            }
            localPreparedStatement.setString(i20 + 1, ((arrayOfString4[i20].length() < 1) && (arrayOfBoolean1[i20] != 0)) || (arrayOfString4[i20].equals(this.nullRepToken)) ? null : arrayOfString4[i20]);
            str8 = null;
            i20++;
            continue;
            k = localPreparedStatement.executeUpdate();
            if (k == 1)
              continue;
            throw new RowError(this.rb.getString(SqltoolRB.INPUTREC_MODIFIED, k));
            this.possiblyUncommitteds.set(true);
          }
          catch (SQLException localSQLException3)
          {
            throw new RowError(null, localSQLException3);
          }
          continue;
        }
        catch (RowError localRowError)
        {
          i12++;
          if ((localPrintWriter1 == null) && (localPrintWriter2 == null))
            continue;
          if (localPrintWriter1 == null)
            continue;
          localPrintWriter1.print(str2.substring(i4, n) + this.dsvRowDelim);
          if (localPrintWriter2 != null)
          {
            genRejectReportRecord(localPrintWriter2, i12, i3, str8, localRowError.getMessage(), localRowError.getCause());
            break label3250;
            i16 = 1;
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_RECIN_FAIL, i3, str8) + (localRowError.getMessage() == null ? "" : new StringBuffer().append("  ").append(localRowError.getMessage()).toString()), localRowError.getCause());
          }
        }
    }
    finally
    {
      String str9 = null;
      if (i14 > 0)
      {
        str9 = this.rb.getString(SqltoolRB.DSV_IMPORT_SUMMARY, new String[] { "'" + paramString2 + "'-", Integer.toString(i15), Integer.toString(i12), Integer.toString(i14 - i12), i16 != 0 ? "importAborted" : null });
        stdprintln(str9);
      }
      try
      {
        if ((i14 > i12) && (!this.curConn.getAutoCommit()))
          stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
      }
      catch (SQLException localSQLException4)
      {
        stdprintln(this.rb.getString(SqltoolRB.AUTOCOMMIT_FETCHFAIL));
        stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
      }
      if (localPrintWriter1 != null)
      {
        localPrintWriter1.flush();
        localPrintWriter1.close();
      }
      if ((localPrintWriter2 != null) && (i12 > 0))
      {
        localPrintWriter2.println(this.rb.getString(SqltoolRB.REJECTREPORT_BOTTOM, str9, revnum));
        localPrintWriter2.flush();
        localPrintWriter2.close();
      }
      if (i12 == 0)
      {
        if ((localFile2 != null) && (localFile2.exists()) && (!localFile2.delete()))
          errprintln(this.rb.getString(SqltoolRB.DSV_REJECTFILE_PURGEFAIL, localFile2.toString()));
        if ((localFile3 != null) && (!localFile3.delete()))
          errprintln(this.rb.getString(SqltoolRB.DSV_REJECTREPORT_PURGEFAIL, localFile2 == null ? null : localFile2.toString()));
      }
    }
  }

  public static void appendLine(StringBuffer paramStringBuffer, String paramString)
  {
    paramStringBuffer.append(paramString + LS);
  }

  private static String[] genWinArgs(String paramString)
  {
    ArrayList localArrayList = new ArrayList();
    localArrayList.add("cmd.exe");
    localArrayList.add("/y");
    localArrayList.add("/c");
    Matcher localMatcher = wincmdPattern.matcher(paramString);
    while (localMatcher.find())
      for (int i = 1; i <= localMatcher.groupCount(); i++)
      {
        if (localMatcher.group(i) == null)
          continue;
        if ((localMatcher.group(i).length() > 1) && (localMatcher.group(i).charAt(0) == '"'))
        {
          localArrayList.add(localMatcher.group(i).substring(1, localMatcher.group(i).length() - 1));
        }
        else
        {
          String[] arrayOfString = localMatcher.group(i).split("\\s+");
          for (int j = 0; j < arrayOfString.length; j++)
            localArrayList.add(arrayOfString[j]);
        }
      }
    return (String[])localArrayList.toArray(new String[0]);
  }

  private void genRejectReportRecord(PrintWriter paramPrintWriter, int paramInt1, int paramInt2, String paramString1, String paramString2, Throwable paramThrowable)
  {
    paramPrintWriter.println(this.rb.getString(SqltoolRB.REJECTREPORT_ROW, new String[] { (paramInt1 % 2 == 0 ? "even" : "odd") + "row", Integer.toString(paramInt1), Integer.toString(paramInt2), paramString1 == null ? "&nbsp;" : paramString1, (paramString2 == null ? "" : paramString2) + ((paramString2 == null) || (paramThrowable == null) ? "" : "<HR/>") + (((paramThrowable instanceof SQLException)) && (paramThrowable.getMessage() != null) ? paramThrowable.getMessage() : paramThrowable == null ? "" : paramThrowable.toString()) }));
  }

  static
  {
    if (System.getProperty("os.name").startsWith("Windows"))
      wincmdPattern = Pattern.compile("([^\"]+)?(\"[^\"]*\")?");
    revnum = null;
    revnum = "354";
    DEFAULT_CHARSET = null;
    nonVarChars = new char[] { ' ', '\t', '=', '}', '\n', '\r' };
    DEFAULT_ROW_DELIM = LS;
    listMDSchemaCols = new int[] { 1 };
    listMDIndexCols = new int[] { 2, 6, 3, 9, 4, 10, 11 };
    listMDTableCols = new int[][] { { 2, 3 }, { 2, 3 }, { 2, 3 } };
    oracleSysSchemas = new String[] { "SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN" };
    PRE_TR = spaces(4);
    PRE_TD = spaces(8);
  }

  private class RowError extends AppendableException
  {
    static final long serialVersionUID = 754346434606022750L;

    RowError(String arg2)
    {
      super();
    }

    RowError(Throwable arg2)
    {
      this(null, localThrowable);
    }

    RowError(String paramThrowable, Throwable arg3)
    {
      super(localThrowable);
    }
  }

  private class BadSubst extends Exception
  {
    static final long serialVersionUID = 7325933736897253269L;

    BadSubst(String arg2)
    {
      super();
    }
  }

  private class ContinueException extends SqlToolError
  {
    static final long serialVersionUID = 5064604160827106014L;

    public ContinueException()
    {
    }

    public ContinueException(String arg2)
    {
      super();
    }
  }

  private class BreakException extends SqlToolError
  {
    static final long serialVersionUID = 351150072817675994L;

    public BreakException()
    {
    }

    public BreakException(String arg2)
    {
      super();
    }
  }

  private class QuitNow extends SqlToolError
  {
    static final long serialVersionUID = 1811094258670900488L;

    public QuitNow(String arg2)
    {
      super();
    }

    public QuitNow()
    {
    }
  }

  private static class BadSpecial extends AppendableException
  {
    static final long serialVersionUID = 7162440064026570590L;

    BadSpecial(String paramString)
    {
      super();
      if (paramString == null)
        throw new RuntimeException("Must construct BadSpecials with non-null message");
    }

    BadSpecial(String paramString, Throwable paramThrowable)
    {
      super(paramThrowable);
      if (paramString == null)
        throw new RuntimeException("Must construct BadSpecials with non-null message");
    }
  }

  private static class BooleanBucket
  {
    private boolean bPriv = false;

    public void set(boolean paramBoolean)
    {
      this.bPriv = paramBoolean;
    }

    public boolean get()
    {
      return this.bPriv;
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.util.SqlFile
 * JD-Core Version:    0.6.0
 */