package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class RCData
{
  public static final String DEFAULT_JDBC_DRIVER = "org.hsqldb.jdbcDriver";
  private String defaultJdbcDriverName = "org.hsqldb.jdbcDriver";
  String id = null;
  String url = null;
  String username = null;
  String password = null;
  String driver = null;
  String charset = null;
  String truststore = null;
  String libpath = null;

  public void setDefaultJdbcDriver(String paramString)
  {
    this.defaultJdbcDriverName = paramString;
  }

  public String getDefaultJdbcDriverName()
  {
    return this.defaultJdbcDriverName;
  }

  public void report()
  {
    System.err.println("urlid: " + this.id + ", url: " + this.url + ", username: " + this.username + ", password: " + this.password);
  }

  public RCData(File paramFile, String paramString)
    throws Exception
  {
    if (paramFile == null)
      throw new IllegalArgumentException("RC file name not specified");
    if (!paramFile.canRead())
      throw new IOException("Please set up authentication file '" + paramFile + "'");
    StringTokenizer localStringTokenizer = null;
    int i = 0;
    int j = 0;
    BufferedReader localBufferedReader = new BufferedReader(new FileReader(paramFile));
    String str1;
    while ((str1 = localBufferedReader.readLine()) != null)
    {
      j++;
      str1 = str1.trim();
      if ((str1.length() == 0) || (str1.charAt(0) == '#'))
        continue;
      localStringTokenizer = new StringTokenizer(str1);
      String str2;
      String str3;
      if (localStringTokenizer.countTokens() == 1)
      {
        str2 = localStringTokenizer.nextToken();
        str3 = "";
      }
      else if (localStringTokenizer.countTokens() > 1)
      {
        str2 = localStringTokenizer.nextToken();
        str3 = localStringTokenizer.nextToken("").trim();
      }
      else
      {
        try
        {
          localBufferedReader.close();
        }
        catch (IOException localIOException1)
        {
        }
        throw new Exception("Corrupt line " + j + " in '" + paramFile + "':  " + str1);
      }
      if (paramString == null)
      {
        if (!str2.equals("urlid"))
          continue;
        System.out.println(str3);
        continue;
      }
      if (str2.equals("urlid"))
      {
        if (str3.equals(paramString))
        {
          if (this.id == null)
          {
            this.id = paramString;
            i = 1;
            continue;
          }
          try
          {
            localBufferedReader.close();
          }
          catch (IOException localIOException2)
          {
          }
          throw new Exception("Key '" + paramString + " redefined at" + " line " + j + " in '" + paramFile);
        }
        i = 0;
        continue;
      }
      if (i == 0)
        continue;
      if (str2.equals("url"))
      {
        this.url = str3;
        continue;
      }
      if (str2.equals("username"))
      {
        this.username = str3;
        continue;
      }
      if (str2.equals("driver"))
      {
        this.driver = str3;
        continue;
      }
      if (str2.equals("charset"))
      {
        this.charset = str3;
        continue;
      }
      if (str2.equals("truststore"))
      {
        this.truststore = str3;
        continue;
      }
      if (str2.equals("password"))
      {
        this.password = str3;
        continue;
      }
      if (str2.equals("libpath"))
      {
        this.libpath = str3;
        continue;
      }
      try
      {
        localBufferedReader.close();
      }
      catch (IOException localIOException3)
      {
      }
      throw new Exception("Bad line " + j + " in '" + paramFile + "':  " + str1);
    }
    try
    {
      localBufferedReader.close();
    }
    catch (IOException localIOException4)
    {
    }
    if (paramString == null)
      return;
    if ((this.url == null) || (this.username == null) || (this.password == null))
      throw new Exception("url or username or password not set for '" + paramString + "' in file '" + paramFile + "'");
    if (this.libpath != null)
      throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
  }

  public RCData(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6, String paramString7)
    throws Exception
  {
    this(paramString1, paramString2, paramString3, paramString4, paramString5, paramString6, paramString7, null);
  }

  public RCData(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6, String paramString7, String paramString8)
    throws Exception
  {
    this.id = paramString1;
    this.url = paramString2;
    this.username = paramString3;
    this.password = paramString4;
    this.driver = paramString5;
    this.charset = paramString6;
    this.truststore = paramString7;
    this.libpath = paramString8;
    if (paramString8 != null)
      throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
    if ((paramString1 == null) || (paramString2 == null) || (paramString3 == null) || (paramString4 == null))
      throw new Exception("id, url, username, or password was not set");
  }

  public Connection getConnection()
    throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException, MalformedURLException
  {
    return getConnection(null, null, null);
  }

  public Connection getConnection(String paramString1, String paramString2, String paramString3)
    throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException, SQLException
  {
    Properties localProperties = System.getProperties();
    if (paramString1 == null)
      paramString1 = this.driver == null ? "org.hsqldb.jdbcDriver" : this.driver;
    if ((paramString2 == null) && (this.charset != null))
      paramString2 = this.charset;
    if ((paramString3 == null) && (this.truststore != null))
      paramString3 = this.truststore;
    if (paramString2 == null)
      localProperties.remove("sqlfile.charset");
    else
      localProperties.put("sqlfile.charset", paramString2);
    if (paramString3 == null)
      localProperties.remove("javax.net.ssl.trustStore");
    else
      localProperties.put("javax.net.ssl.trustStore", paramString3);
    String str1 = null;
    try
    {
      str1 = expandSysPropVars(this.url);
    }
    catch (IllegalArgumentException localIllegalArgumentException1)
    {
      throw new MalformedURLException(localIllegalArgumentException1.getMessage() + " for URL '" + this.url + "'");
    }
    String str2 = null;
    try
    {
      str2 = expandSysPropVars(this.username);
    }
    catch (IllegalArgumentException localIllegalArgumentException2)
    {
      throw new MalformedURLException(localIllegalArgumentException2.getMessage() + " for user name '" + this.username + "'");
    }
    String str3 = null;
    try
    {
      str3 = expandSysPropVars(this.password);
    }
    catch (IllegalArgumentException localIllegalArgumentException3)
    {
      throw new MalformedURLException(localIllegalArgumentException3.getMessage() + " for password");
    }
    Class.forName(paramString1);
    return DriverManager.getConnection(str1, str2, str3);
  }

  public static String expandSysPropVars(String paramString)
  {
    int i;
    int j;
    String str2;
    for (String str1 = new String(paramString); ; str1 = str1.substring(0, i) + str2 + str1.substring(j + 1))
    {
      i = str1.indexOf("${");
      if (i < 0)
        break;
      j = str1.indexOf('}', i + 2);
      if (j < 0)
        break;
      String str3 = str1.substring(i + 2, j);
      if (str3.length() < 1)
        throw new IllegalArgumentException("Bad variable setting");
      str2 = System.getProperty(str3);
      if (str2 != null)
        continue;
      throw new IllegalArgumentException("No Java system property with name '" + str3 + "'");
    }
    return str1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.util.RCData
 * JD-Core Version:    0.6.0
 */