package org.hsqldb.store;

public class BitMap
{
  int defaultCapacity;
  int capacity;
  int[] map;

  public BitMap(int paramInt)
  {
    int i = paramInt / 32;
    if (paramInt % 32 != 0)
      i++;
    this.defaultCapacity = (this.capacity = i * 32);
    this.map = new int[i];
  }

  public void reset()
  {
    this.map = new int[this.defaultCapacity / 32];
    this.capacity = this.defaultCapacity;
  }

  public int set(int paramInt)
  {
    while (paramInt >= this.capacity)
      doubleCapacity();
    int i = paramInt >> 5;
    int j = -2147483648 >>> (paramInt & 0x1F);
    int k = this.map[i];
    int m = (k & j) == 0 ? 0 : 1;
    this.map[i] = (k | j);
    return m;
  }

  public int unset(int paramInt)
  {
    if (paramInt >= this.capacity)
      return 0;
    int i = paramInt >> 5;
    int j = -2147483648 >>> (paramInt & 0x1F);
    int k = this.map[i];
    int m = (k & j) == 0 ? 0 : 1;
    j ^= -1;
    this.map[i] = (k & j);
    return m;
  }

  public int get(int paramInt)
  {
    while (paramInt >= this.capacity)
      doubleCapacity();
    int i = paramInt >> 5;
    int j = -2147483648 >>> (paramInt & 0x1F);
    int k = this.map[i];
    return (k & j) == 0 ? 0 : 1;
  }

  public static int set(int paramInt1, int paramInt2)
  {
    int i = -2147483648 >>> paramInt2;
    return paramInt1 | i;
  }

  public static int unset(int paramInt1, int paramInt2)
  {
    int i = -2147483648 >>> paramInt2;
    i ^= -1;
    return paramInt1 & i;
  }

  public static boolean isSet(int paramInt1, int paramInt2)
  {
    int i = -2147483648 >>> paramInt2;
    return (paramInt1 & i) != 0;
  }

  private void doubleCapacity()
  {
    int[] arrayOfInt = new int[this.map.length * 2];
    this.capacity *= 2;
    System.arraycopy(this.map, 0, arrayOfInt, 0, this.map.length);
    this.map = arrayOfInt;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.store.BitMap
 * JD-Core Version:    0.6.0
 */