package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager.HsqlName;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.rowio.RowOutputBinary;

class ScriptWriterBinary extends ScriptWriterBase
{
  RowOutputBinary rowOut;

  ScriptWriterBinary(Database paramDatabase, String paramString, boolean paramBoolean1, boolean paramBoolean2)
    throws HsqlException
  {
    super(paramDatabase, paramString, paramBoolean1, paramBoolean2, false);
  }

  protected void initBuffers()
  {
    this.rowOut = new RowOutputBinary();
  }

  protected void writeSingleColumnResult(Result paramResult)
    throws IOException, HsqlException
  {
    Result.write(paramResult, this.rowOut, this.fileStreamOut);
  }

  protected void writeRow(Session paramSession, Table paramTable, Object[] paramArrayOfObject)
    throws IOException, HsqlException
  {
    this.rowOut.reset();
    this.rowOut.writeRow(paramArrayOfObject, paramTable);
    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
    this.tableRowCount += 1;
  }

  protected void writeTableInit(Table paramTable)
    throws HsqlException, IOException
  {
    this.tableRowCount = 0;
    this.rowOut.reset();
    this.rowOut.writeSize(0);
    this.rowOut.writeString(paramTable.getName().name);
    this.rowOut.writeIntData(1);
    this.rowOut.writeString(paramTable.getSchemaName());
    this.rowOut.writeIntData(this.rowOut.size(), 0);
    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
  }

  protected void writeTableTerm(Table paramTable)
    throws IOException
  {
    this.rowOut.reset();
    this.rowOut.writeSize(0);
    this.rowOut.writeIntData(this.tableRowCount);
    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
  }

  protected void writeDataTerm()
    throws IOException
  {
    this.rowOut.reset();
    this.rowOut.writeSize(0);
    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
  }

  public void writeLogStatement(Session paramSession, String paramString)
    throws IOException, HsqlException
  {
  }

  protected void addSessionId(Session paramSession)
    throws IOException
  {
  }

  public void writeDeleteStatement(Session paramSession, Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException, IOException
  {
  }

  public void writeSequenceStatement(Session paramSession, NumberSequence paramNumberSequence)
    throws HsqlException, IOException
  {
  }

  public void writeInsertStatement(Session paramSession, Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException, IOException
  {
  }

  public void writeCommitStatement(Session paramSession)
    throws HsqlException, IOException
  {
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.scriptio.ScriptWriterBinary
 * JD-Core Version:    0.6.0
 */