package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.persist.Logger;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputBinary;

class ScriptReaderBinary extends ScriptReaderBase
{
  private RowInputBinary rowIn = new RowInputBinary();
  protected DataInputStream dataStreamIn;

  ScriptReaderBinary(Database paramDatabase, String paramString)
    throws HsqlException, IOException
  {
    super(paramDatabase, paramString);
  }

  protected void openFile()
    throws IOException
  {
    InputStream localInputStream = this.db.isFilesInJar() ? getClass().getResourceAsStream(this.fileName) : this.db.getFileAccess().openInputStreamElement(this.fileName);
    this.dataStreamIn = new DataInputStream(new BufferedInputStream(localInputStream, 8192));
  }

  protected void readDDL(Session paramSession)
    throws IOException, HsqlException
  {
    Result localResult1 = Result.read(this.rowIn, this.dataStreamIn);
    Iterator localIterator = localResult1.iterator();
    while (localIterator.hasNext())
    {
      Object[] arrayOfObject = (Object[])localIterator.next();
      String str = (String)arrayOfObject[0];
      Result localResult2 = paramSession.sqlExecuteDirectNoPreChecks(str);
      if (!localResult2.isError())
        continue;
      this.db.logger.appLog.logContext(SimpleLog.LOG_ERROR, localResult2.getMainString());
      throw Trace.error(localResult2);
    }
  }

  protected void readExistingData(Session paramSession)
    throws IOException, HsqlException
  {
    while (true)
    {
      String str1 = readTableInit();
      if (str1 == null)
        break;
      String str2 = paramSession.getSchemaName(this.currentSchema);
      Table localTable = this.db.schemaManager.getUserTable(paramSession, str1, str2);
      int i = 0;
      for (i = 0; readRow(localTable); i++);
      int j = readTableTerm();
      if (i == j)
        continue;
      throw Trace.error(78, 96, new Object[] { str1, new Integer(i), new Integer(j) });
    }
  }

  protected boolean readRow(Table paramTable)
    throws IOException, HsqlException
  {
    boolean bool = readRow(this.rowIn, 0);
    if (!bool)
      return false;
    Object[] arrayOfObject = this.rowIn.readData(paramTable.getColumnTypes());
    paramTable.insertFromScript(arrayOfObject);
    return true;
  }

  protected int readTableTerm()
    throws IOException, HsqlException
  {
    return this.dataStreamIn.readInt();
  }

  protected String readTableInit()
    throws IOException, HsqlException
  {
    boolean bool = readRow(this.rowIn, 0);
    if (!bool)
      return null;
    String str = this.rowIn.readString();
    int i = this.rowIn.readIntData();
    if (i == 1)
      this.currentSchema = this.rowIn.readString();
    else
      this.currentSchema = null;
    if ((i != 0) && (i != 1))
      throw Trace.error(78, 97);
    return str;
  }

  boolean readRow(RowInputBase paramRowInputBase, int paramInt)
    throws IOException
  {
    try
    {
      int i = this.dataStreamIn.readInt();
      int j = 4;
      if (i == 0)
        return false;
      paramRowInputBase.resetRow(paramInt, i);
      this.dataStreamIn.readFully(paramRowInputBase.getBuffer(), j, i - j);
      return true;
    }
    catch (EOFException localEOFException)
    {
    }
    return false;
  }

  public boolean readLoggedStatement(Session paramSession)
    throws IOException
  {
    return false;
  }

  public void close()
  {
    try
    {
      this.dataStreamIn.close();
    }
    catch (IOException localIOException)
    {
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.scriptio.ScriptReaderBinary
 * JD-Core Version:    0.6.0
 */