package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CachedRow;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowOutputBinary extends RowOutputBase
{
  private static final int INT_STORE_SIZE = 4;
  int storageSize;

  public RowOutputBinary()
  {
  }

  public RowOutputBinary(int paramInt)
  {
    super(paramInt);
  }

  public RowOutputBinary(byte[] paramArrayOfByte)
  {
    super(paramArrayOfByte);
  }

  public void writeShortData(short paramShort)
  {
    writeShort(paramShort);
  }

  public void writeIntData(int paramInt)
  {
    writeInt(paramInt);
  }

  public void writeIntData(int paramInt1, int paramInt2)
  {
    int i = this.count;
    this.count = paramInt2;
    writeInt(paramInt1);
    if (this.count < i)
      this.count = i;
  }

  public void writeLongData(long paramLong)
  {
    writeLong(paramLong);
  }

  public void writeEnd()
  {
    while (this.count < this.storageSize)
      write(0);
  }

  public void writeSize(int paramInt)
  {
    this.storageSize = paramInt;
    writeInt(paramInt);
  }

  public void writeType(int paramInt)
  {
    writeShort(paramInt);
  }

  public void writeString(String paramString)
  {
    int i = this.count;
    writeInt(0);
    StringConverter.writeUTF(paramString, this);
    writeIntData(this.count - i - 4, i);
  }

  public int getSize(CachedRow paramCachedRow)
  {
    Object[] arrayOfObject = paramCachedRow.getData();
    int[] arrayOfInt = paramCachedRow.getTable().getColumnTypes();
    int i = paramCachedRow.getTable().getColumnCount();
    return 4 + getSize(arrayOfObject, i, arrayOfInt);
  }

  public static int getRowSize(CachedRow paramCachedRow)
  {
    Object[] arrayOfObject = paramCachedRow.getData();
    int[] arrayOfInt = paramCachedRow.getTable().getColumnTypes();
    int i = paramCachedRow.getTable().getColumnCount();
    return getSize(arrayOfObject, i, arrayOfInt);
  }

  protected void writeFieldType(int paramInt)
  {
    write(1);
  }

  protected void writeNull(int paramInt)
  {
    write(0);
  }

  protected void writeChar(String paramString, int paramInt)
  {
    writeString(paramString);
  }

  protected void writeSmallint(Number paramNumber)
  {
    writeShort(paramNumber.intValue());
  }

  protected void writeInteger(Number paramNumber)
  {
    writeInt(paramNumber.intValue());
  }

  protected void writeBigint(Number paramNumber)
  {
    writeLong(paramNumber.longValue());
  }

  protected void writeReal(Double paramDouble, int paramInt)
  {
    writeLong(Double.doubleToLongBits(paramDouble.doubleValue()));
  }

  protected void writeDecimal(BigDecimal paramBigDecimal)
  {
    int i = paramBigDecimal.scale();
    BigInteger localBigInteger = JavaSystem.getUnscaledValue(paramBigDecimal);
    byte[] arrayOfByte = localBigInteger.toByteArray();
    writeByteArray(arrayOfByte);
    writeInt(i);
  }

  protected void writeBit(Boolean paramBoolean)
  {
    write(paramBoolean.booleanValue() ? 1 : 0);
  }

  protected void writeDate(Date paramDate)
  {
    writeLong(paramDate.getTime());
  }

  protected void writeTime(Time paramTime)
  {
    writeLong(paramTime.getTime());
  }

  protected void writeTimestamp(Timestamp paramTimestamp)
  {
    writeLong(paramTimestamp.getTime());
    writeInt(paramTimestamp.getNanos());
  }

  protected void writeOther(JavaObject paramJavaObject)
  {
    writeByteArray(paramJavaObject.getBytes());
  }

  protected void writeBinary(Binary paramBinary, int paramInt)
  {
    writeByteArray(paramBinary.getBytes());
  }

  protected void writeByteArray(byte[] paramArrayOfByte)
  {
    writeInt(paramArrayOfByte.length);
    write(paramArrayOfByte, 0, paramArrayOfByte.length);
  }

  private static int getSize(Object[] paramArrayOfObject, int paramInt, int[] paramArrayOfInt)
  {
    int i = 0;
    for (int j = 0; j < paramInt; j++)
    {
      Object localObject = paramArrayOfObject[j];
      i++;
      if (localObject == null)
        continue;
      switch (paramArrayOfInt[j])
      {
      case -1:
      case 0:
      case 1:
      case 12:
      case 100:
        i += 4;
        i += StringConverter.getUTFSize((String)localObject);
        break;
      case -6:
      case 5:
        i += 2;
        break;
      case 4:
        i += 4;
        break;
      case -5:
      case 6:
      case 7:
      case 8:
        i += 8;
        break;
      case 2:
      case 3:
        i += 8;
        BigDecimal localBigDecimal = (BigDecimal)localObject;
        BigInteger localBigInteger = JavaSystem.getUnscaledValue(localBigDecimal);
        i += localBigInteger.toByteArray().length;
        break;
      case 16:
        i++;
        break;
      case 91:
      case 92:
        i += 8;
        break;
      case 93:
        i += 12;
        break;
      case -4:
      case -3:
      case -2:
        i += 4;
        i += ((Binary)localObject).getBytesLength();
        break;
      case 1111:
        JavaObject localJavaObject = (JavaObject)localObject;
        i += 4;
        i += localJavaObject.getBytesLength();
        break;
      default:
        Trace.printSystemOut("20 " + Types.getTypeString(paramArrayOfInt[j]));
      }
    }
    return i;
  }

  public void ensureRoom(int paramInt)
  {
    super.ensureRoom(paramInt);
  }

  public void reset()
  {
    super.reset();
    this.storageSize = 0;
  }

  public void reset(int paramInt)
  {
    super.reset(paramInt);
    this.storageSize = 0;
  }

  public void setBuffer(byte[] paramArrayOfByte)
  {
    this.buf = paramArrayOfByte;
    reset();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.rowio.RowOutputBinary
 * JD-Core Version:    0.6.0
 */