package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Tokenizer;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowInputTextLog extends RowInputBase
  implements RowInputInterface
{
  Tokenizer tokenizer = new Tokenizer();
  String tableName = null;
  String schemaName = null;
  int statementType;

  public RowInputTextLog()
  {
    super(new byte[0]);
  }

  public void setSource(String paramString)
    throws HsqlException
  {
    this.tokenizer.reset(paramString);
    this.statementType = 1;
    String str = this.tokenizer.getString();
    if (str.equals("INSERT"))
    {
      this.statementType = 3;
      this.tokenizer.getString();
      this.tableName = this.tokenizer.getString();
      this.tokenizer.getString();
    }
    else if (str.equals("DELETE"))
    {
      this.statementType = 2;
      this.tokenizer.getString();
      this.tableName = this.tokenizer.getString();
    }
    else if (str.equals("COMMIT"))
    {
      this.statementType = 5;
    }
    else if ((str.equals("SET")) && (this.tokenizer.isGetThis("SCHEMA")))
    {
      this.schemaName = this.tokenizer.getSimpleName();
      this.statementType = 7;
    }
  }

  public int getStatementType()
  {
    return this.statementType;
  }

  public String getTableName()
  {
    return this.tableName;
  }

  public String getSchemaName()
  {
    return this.schemaName;
  }

  protected String readField()
    throws IOException
  {
    try
    {
      this.tokenizer.getString();
      if (this.statementType == 2)
      {
        this.tokenizer.getString();
        this.tokenizer.getString();
      }
      String str = this.tokenizer.getString();
      if (this.tokenizer.getType() == 0)
        str = null;
      return str;
    }
    catch (HsqlException localHsqlException)
    {
    }
    throw new IOException(localHsqlException.getMessage());
  }

  protected String readNumberField()
    throws IOException
  {
    try
    {
      this.tokenizer.getString();
      if (this.statementType == 2)
      {
        this.tokenizer.getString();
        this.tokenizer.getString();
      }
      String str = this.tokenizer.getString();
      if ("-".equals(str))
        str = str + this.tokenizer.getString();
      else if (this.tokenizer.getType() == 0)
        str = null;
      return str;
    }
    catch (HsqlException localHsqlException)
    {
    }
    throw new IOException(localHsqlException.getMessage());
  }

  public String readString()
    throws IOException
  {
    String str = readField();
    return ValuePool.getString(str);
  }

  public short readShortData()
    throws IOException
  {
    String str = readNumberField();
    if (str == null)
      return 0;
    return Short.parseShort(str);
  }

  public int readIntData()
    throws IOException
  {
    String str = readNumberField();
    if (str == null)
      return 0;
    return Integer.parseInt(str);
  }

  public long readLongData()
    throws IOException
  {
    String str = readNumberField();
    if (str == null)
      return 0L;
    return Long.parseLong(str);
  }

  public int readType()
    throws IOException
  {
    return 0;
  }

  protected boolean checkNull()
  {
    return false;
  }

  protected String readChar(int paramInt)
    throws IOException
  {
    return readString();
  }

  protected Integer readSmallint()
    throws IOException, HsqlException
  {
    String str = readNumberField();
    if (str == null)
      return null;
    int i = Integer.parseInt(str);
    return ValuePool.getInt(i);
  }

  protected Integer readInteger()
    throws IOException, HsqlException
  {
    String str = readNumberField();
    if (str == null)
      return null;
    int i = Integer.parseInt(str);
    return ValuePool.getInt(i);
  }

  protected Long readBigint()
    throws IOException, HsqlException
  {
    String str = readNumberField();
    if (str == null)
      return null;
    long l = Long.parseLong(str);
    return ValuePool.getLong(l);
  }

  protected Double readReal(int paramInt)
    throws IOException, HsqlException
  {
    String str = readNumberField();
    if (str == null)
      return null;
    double d1 = JavaSystem.parseDouble(str);
    if (this.tokenizer.isGetThis("/"))
    {
      str = this.tokenizer.getString();
      double d2 = JavaSystem.parseDouble(str);
      if (d1 == 0.0D)
        d1 = (0.0D / 0.0D);
      else if (d1 == -1.0D)
        d1 = (-1.0D / 0.0D);
      else if (d1 == 1.0D)
        d1 = (1.0D / 0.0D);
    }
    return ValuePool.getDouble(Double.doubleToLongBits(d1));
  }

  protected BigDecimal readDecimal()
    throws IOException, HsqlException
  {
    String str = readNumberField();
    if (str == null)
      return null;
    BigDecimal localBigDecimal = new BigDecimal(str);
    return ValuePool.getBigDecimal(localBigDecimal);
  }

  protected Time readTime()
    throws IOException, HsqlException
  {
    String str = readField();
    if (str == null)
      return null;
    return HsqlDateTime.timeValue(str);
  }

  protected Date readDate()
    throws IOException, HsqlException
  {
    String str = readField();
    if (str == null)
      return null;
    return HsqlDateTime.dateValue(str);
  }

  protected Timestamp readTimestamp()
    throws IOException, HsqlException
  {
    String str = readField();
    if (str == null)
      return null;
    return HsqlDateTime.timestampValue(str);
  }

  protected Boolean readBit()
    throws IOException, HsqlException
  {
    String str = readField();
    if (str == null)
      return null;
    return str.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
  }

  protected Object readOther()
    throws IOException, HsqlException
  {
    String str = readField();
    if (str == null)
      return null;
    byte[] arrayOfByte = Column.hexToByteArray(str);
    return new JavaObject(arrayOfByte);
  }

  protected Binary readBinary(int paramInt)
    throws IOException, HsqlException
  {
    String str = readField();
    if (str == null)
      return null;
    return new Binary(Column.hexToByteArray(str), false);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.rowio.RowInputTextLog
 * JD-Core Version:    0.6.0
 */