package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowInputText extends RowInputBase
  implements RowInputInterface
{
  private String fieldSep;
  private String varSep;
  private String longvarSep;
  private int fieldSepLen;
  private int varSepLen;
  private int longvarSepLen;
  private boolean fieldSepEnd;
  private boolean varSepEnd;
  private boolean longvarSepEnd;
  private int textLen;
  protected String text;
  protected int line;
  protected int field;
  protected int next = 0;
  protected boolean allQuoted;

  public RowInputText(String paramString1, String paramString2, String paramString3, boolean paramBoolean)
  {
    super(new byte[0]);
    if (paramString1.endsWith("\n"))
    {
      this.fieldSepEnd = true;
      paramString1 = paramString1.substring(0, paramString1.length() - 1);
    }
    if (paramString2.endsWith("\n"))
    {
      this.varSepEnd = true;
      paramString2 = paramString2.substring(0, paramString2.length() - 1);
    }
    if (paramString3.endsWith("\n"))
    {
      this.longvarSepEnd = true;
      paramString3 = paramString3.substring(0, paramString3.length() - 1);
    }
    this.allQuoted = paramBoolean;
    this.fieldSep = paramString1;
    this.varSep = paramString2;
    this.longvarSep = paramString3;
    this.fieldSepLen = paramString1.length();
    this.varSepLen = paramString2.length();
    this.longvarSepLen = paramString3.length();
  }

  public void setSource(String paramString, int paramInt1, int paramInt2)
  {
    this.size = paramInt2;
    this.text = paramString;
    this.textLen = paramString.length();
    this.filePos = paramInt1;
    this.next = 0;
    this.line += 1;
    this.field = 0;
  }

  protected String getField(String paramString, int paramInt, boolean paramBoolean)
    throws IOException
  {
    String str = null;
    try
    {
      int i = this.next;
      this.field += 1;
      if (paramBoolean)
      {
        if ((this.next >= this.textLen) && (paramInt > 0))
          throw Trace.error(182);
        if (this.text.endsWith(paramString))
          this.next = (this.textLen - paramInt);
        else
          throw Trace.error(183);
      }
      else
      {
        this.next = this.text.indexOf(paramString, i);
        if (this.next == -1)
          this.next = this.textLen;
      }
      if (i > this.next)
        i = this.next;
      str = this.text.substring(i, this.next);
      this.next += paramInt;
      str = str.trim();
      if (str.length() == 0)
        str = null;
    }
    catch (Exception localException)
    {
      throw new IOException(Trace.getMessage(184, true, new Object[] { new Integer(this.field), localException.toString() }));
    }
    return str;
  }

  public String readString()
    throws IOException
  {
    return getField(this.fieldSep, this.fieldSepLen, this.fieldSepEnd);
  }

  private String readVarString()
    throws IOException
  {
    return getField(this.varSep, this.varSepLen, this.varSepEnd);
  }

  private String readLongVarString()
    throws IOException
  {
    return getField(this.longvarSep, this.longvarSepLen, this.longvarSepEnd);
  }

  public short readShortData()
    throws IOException
  {
    return (short)readIntData();
  }

  public int readIntData()
    throws IOException
  {
    String str = readString();
    if (str == null)
      return 0;
    str = str.trim();
    if (str.length() == 0)
      return 0;
    return Integer.parseInt(str);
  }

  public long readLongData()
    throws IOException
  {
    throw Trace.runtimeError(201, "RowInputText");
  }

  public int readType()
    throws IOException
  {
    return 0;
  }

  protected boolean checkNull()
  {
    return false;
  }

  protected String readChar(int paramInt)
    throws IOException
  {
    switch (paramInt)
    {
    case 1:
      return readString();
    case 12:
    case 100:
      return readVarString();
    case -1:
    }
    return readLongVarString();
  }

  protected Integer readSmallint()
    throws IOException, HsqlException
  {
    String str = readString();
    if (str == null)
      return null;
    str = str.trim();
    if (str.length() == 0)
      return null;
    return Integer.valueOf(str);
  }

  protected Integer readInteger()
    throws IOException, HsqlException
  {
    String str = readString();
    if (str == null)
      return null;
    str = str.trim();
    if (str.length() == 0)
      return null;
    return Integer.valueOf(str);
  }

  protected Long readBigint()
    throws IOException, HsqlException
  {
    String str = readString();
    if (str == null)
      return null;
    str = str.trim();
    if (str.length() == 0)
      return null;
    return Long.valueOf(str);
  }

  protected Double readReal(int paramInt)
    throws IOException, HsqlException
  {
    String str = readString();
    if (str == null)
      return null;
    str = str.trim();
    if (str.length() == 0)
      return null;
    return Double.valueOf(str);
  }

  protected BigDecimal readDecimal()
    throws IOException, HsqlException
  {
    String str = readString();
    if (str == null)
      return null;
    str = str.trim();
    if (str.length() == 0)
      return null;
    return new BigDecimal(str);
  }

  protected Time readTime()
    throws IOException, HsqlException
  {
    String str = readString();
    if (str == null)
      return null;
    str = str.trim();
    if (str.length() == 0)
      return null;
    return HsqlDateTime.timeValue(str);
  }

  protected Date readDate()
    throws IOException, HsqlException
  {
    String str = readString();
    if (str == null)
      return null;
    str = str.trim();
    if (str.length() == 0)
      return null;
    return HsqlDateTime.dateValue(str);
  }

  protected Timestamp readTimestamp()
    throws IOException, HsqlException
  {
    String str = readString();
    if (str == null)
      return null;
    str = str.trim();
    if (str.length() == 0)
      return null;
    return HsqlDateTime.timestampValue(str);
  }

  protected Boolean readBit()
    throws IOException, HsqlException
  {
    String str = readString();
    if (str == null)
      return null;
    str = str.trim();
    if (str.length() == 0)
      return null;
    return str.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
  }

  protected Object readOther()
    throws IOException, HsqlException
  {
    String str = readString();
    if (str == null)
      return null;
    str = str.trim();
    if (str.length() == 0)
      return null;
    byte[] arrayOfByte = Column.hexToByteArray(str);
    return new JavaObject(arrayOfByte);
  }

  protected Binary readBinary(int paramInt)
    throws IOException, HsqlException
  {
    String str = readString();
    if (str == null)
      return null;
    str = str.trim();
    if (str.length() == 0)
      return null;
    return new Binary(Column.hexToByteArray(str), false);
  }

  public int getLineNumber()
  {
    return this.line;
  }

  public void skippedLine()
  {
    this.line += 1;
  }

  public void reset()
  {
    this.text = "";
    this.textLen = 0;
    this.filePos = 0;
    this.next = 0;
    this.field = 0;
    this.line = 0;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.rowio.RowInputText
 * JD-Core Version:    0.6.0
 */