package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowInputBinary extends RowInputBase
  implements RowInputInterface
{
  private RowOutputBinary out;

  public RowInputBinary()
  {
  }

  public RowInputBinary(byte[] paramArrayOfByte)
  {
    super(paramArrayOfByte);
  }

  public RowInputBinary(RowOutputBinary paramRowOutputBinary)
  {
    super(paramRowOutputBinary.getBuffer());
    this.out = paramRowOutputBinary;
  }

  protected byte[] readByteArray()
    throws IOException
  {
    byte[] arrayOfByte = new byte[readInt()];
    readFully(arrayOfByte);
    return arrayOfByte;
  }

  public int readType()
    throws IOException
  {
    return readShort();
  }

  public short readShortData()
    throws IOException
  {
    return readShort();
  }

  public int readIntData()
    throws IOException
  {
    return readInt();
  }

  public long readLongData()
    throws IOException
  {
    return readLong();
  }

  public String readString()
    throws IOException
  {
    int i = readInt();
    String str = StringConverter.readUTF(this.buf, this.pos, i);
    str = ValuePool.getString(str);
    this.pos += i;
    return str;
  }

  protected boolean checkNull()
    throws IOException
  {
    int i = readByte();
    return i == 0;
  }

  protected String readChar(int paramInt)
    throws IOException
  {
    return readString();
  }

  protected Integer readSmallint()
    throws IOException, HsqlException
  {
    return ValuePool.getInt(readShort());
  }

  protected Integer readInteger()
    throws IOException, HsqlException
  {
    return ValuePool.getInt(readInt());
  }

  protected Long readBigint()
    throws IOException, HsqlException
  {
    return ValuePool.getLong(readLong());
  }

  protected Double readReal(int paramInt)
    throws IOException, HsqlException
  {
    return ValuePool.getDouble(readLong());
  }

  protected BigDecimal readDecimal()
    throws IOException, HsqlException
  {
    byte[] arrayOfByte = readByteArray();
    int i = readInt();
    BigInteger localBigInteger = new BigInteger(arrayOfByte);
    return ValuePool.getBigDecimal(new BigDecimal(localBigInteger, i));
  }

  protected Boolean readBit()
    throws IOException, HsqlException
  {
    return readBoolean() ? Boolean.TRUE : Boolean.FALSE;
  }

  protected Time readTime()
    throws IOException, HsqlException
  {
    return new Time(HsqlDateTime.getNormalisedTime(readLong()));
  }

  protected Date readDate()
    throws IOException, HsqlException
  {
    long l = HsqlDateTime.getNormalisedDate(readLong());
    return ValuePool.getDate(l);
  }

  protected Timestamp readTimestamp()
    throws IOException, HsqlException
  {
    return HsqlDateTime.timestampValue(readLong(), readInt());
  }

  protected Object readOther()
    throws IOException, HsqlException
  {
    return new JavaObject(readByteArray());
  }

  protected Binary readBinary(int paramInt)
    throws IOException, HsqlException
  {
    return new Binary(readByteArray(), false);
  }

  public void resetRow(int paramInt)
  {
    if (this.out != null)
    {
      this.out.reset(paramInt);
      this.buf = this.out.getBuffer();
    }
    super.reset();
  }

  public void resetRow(int paramInt1, int paramInt2)
    throws IOException
  {
    if (this.out != null)
    {
      this.out.reset(paramInt2);
      this.buf = this.out.getBuffer();
    }
    super.resetRow(paramInt1, paramInt2);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.rowio.RowInputBinary
 * JD-Core Version:    0.6.0
 */