package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.types.Binary;

public abstract class RowInputBase extends HsqlByteArrayInputStream
{
  static final int NO_POS = -1;
  protected int filePos = -1;
  protected int size;

  public RowInputBase()
  {
    this(new byte[4]);
  }

  public RowInputBase(byte[] paramArrayOfByte)
  {
    super(paramArrayOfByte);
    this.size = paramArrayOfByte.length;
  }

  public int getPos()
  {
    if (this.filePos == -1);
    return this.filePos;
  }

  public int getSize()
  {
    return this.size;
  }

  public abstract int readIntData()
    throws IOException;

  public abstract long readLongData()
    throws IOException;

  public abstract int readType()
    throws IOException;

  public abstract String readString()
    throws IOException;

  protected abstract boolean checkNull()
    throws IOException;

  protected abstract String readChar(int paramInt)
    throws IOException, HsqlException;

  protected abstract Integer readSmallint()
    throws IOException, HsqlException;

  protected abstract Integer readInteger()
    throws IOException, HsqlException;

  protected abstract Long readBigint()
    throws IOException, HsqlException;

  protected abstract Double readReal(int paramInt)
    throws IOException, HsqlException;

  protected abstract BigDecimal readDecimal()
    throws IOException, HsqlException;

  protected abstract Boolean readBit()
    throws IOException, HsqlException;

  protected abstract Time readTime()
    throws IOException, HsqlException;

  protected abstract Date readDate()
    throws IOException, HsqlException;

  protected abstract Timestamp readTimestamp()
    throws IOException, HsqlException;

  protected abstract Object readOther()
    throws IOException, HsqlException;

  protected abstract Binary readBinary(int paramInt)
    throws IOException, HsqlException;

  public Object[] readData(int[] paramArrayOfInt)
    throws IOException, HsqlException
  {
    int i = paramArrayOfInt.length;
    Object[] arrayOfObject = new Object[i];
    for (int k = 0; k < i; k++)
    {
      if (checkNull())
        continue;
      Object localObject = null;
      int j = paramArrayOfInt[k];
      switch (j)
      {
      case -1:
      case 0:
      case 1:
      case 12:
      case 100:
        localObject = readChar(j);
        break;
      case -6:
      case 5:
        localObject = readSmallint();
        break;
      case 4:
        localObject = readInteger();
        break;
      case -5:
        localObject = readBigint();
        break;
      case 6:
      case 7:
      case 8:
        localObject = readReal(j);
        break;
      case 2:
      case 3:
        localObject = readDecimal();
        break;
      case 91:
        localObject = readDate();
        break;
      case 92:
        localObject = readTime();
        break;
      case 93:
        localObject = readTimestamp();
        break;
      case 16:
        localObject = readBit();
        break;
      case 1111:
        localObject = readOther();
        break;
      case -4:
      case -3:
      case -2:
        localObject = readBinary(j);
        break;
      default:
        throw Trace.runtimeError(201, "RowInputBase " + Types.getTypeString(j));
      }
      arrayOfObject[k] = localObject;
    }
    return (Object)arrayOfObject;
  }

  public void resetRow(int paramInt1, int paramInt2)
    throws IOException
  {
    this.mark = 0;
    reset();
    if (this.buf.length < paramInt2)
      this.buf = new byte[paramInt2];
    this.filePos = paramInt1;
    this.size = (this.count = paramInt2);
    this.pos = 4;
    this.buf[0] = (byte)(paramInt2 >>> 24 & 0xFF);
    this.buf[1] = (byte)(paramInt2 >>> 16 & 0xFF);
    this.buf[2] = (byte)(paramInt2 >>> 8 & 0xFF);
    this.buf[3] = (byte)(paramInt2 >>> 0 & 0xFF);
  }

  public byte[] getBuffer()
  {
    return this.buf;
  }

  public int skipBytes(int paramInt)
    throws IOException
  {
    throw Trace.runtimeError(201, "RowInputBase");
  }

  public String readLine()
    throws IOException
  {
    throw Trace.runtimeError(201, "RowInputBase");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.rowio.RowInputBase
 * JD-Core Version:    0.6.0
 */