package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Database;

public class ScaledRAFileHybrid
  implements ScaledRAInterface
{
  final Database database;
  final String fileName;
  final boolean isReadOnly;
  final boolean wasNio;
  long maxLength;
  ScaledRAInterface store;

  public ScaledRAFileHybrid(Database paramDatabase, String paramString, boolean paramBoolean)
    throws IOException
  {
    this.database = paramDatabase;
    this.fileName = paramString;
    this.isReadOnly = paramBoolean;
    newStore(0L);
    this.wasNio = this.store.wasNio();
  }

  public long length()
    throws IOException
  {
    return this.store.length();
  }

  public void seek(long paramLong)
    throws IOException
  {
    checkSeek(paramLong);
    this.store.seek(paramLong);
  }

  public long getFilePointer()
    throws IOException
  {
    return this.store.getFilePointer();
  }

  public int read()
    throws IOException
  {
    checkLength(1);
    return this.store.read();
  }

  public void read(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
    throws IOException
  {
    checkLength(paramInt2);
    this.store.read(paramArrayOfByte, paramInt1, paramInt2);
  }

  public void write(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
    throws IOException
  {
    checkLength(paramInt2);
    this.store.write(paramArrayOfByte, paramInt1, paramInt2);
  }

  public int readInt()
    throws IOException
  {
    checkLength(4);
    return this.store.readInt();
  }

  public void writeInt(int paramInt)
    throws IOException
  {
    checkLength(4);
    this.store.writeInt(paramInt);
  }

  public long readLong()
    throws IOException
  {
    checkLength(8);
    return this.store.readLong();
  }

  public void writeLong(long paramLong)
    throws IOException
  {
    checkLength(8);
    this.store.writeLong(paramLong);
  }

  public void close()
    throws IOException
  {
    this.store.close();
  }

  public boolean isReadOnly()
  {
    return this.store.isReadOnly();
  }

  public boolean wasNio()
  {
    return this.wasNio;
  }

  public boolean canAccess(int paramInt)
  {
    return true;
  }

  public boolean canSeek(long paramLong)
  {
    return true;
  }

  public Database getDatabase()
  {
    return null;
  }

  private void checkLength(int paramInt)
    throws IOException
  {
    if (this.store.canAccess(paramInt))
      return;
    newStore(this.store.getFilePointer() + paramInt);
  }

  private void checkSeek(long paramLong)
    throws IOException
  {
    if (this.store.canSeek(paramLong))
      return;
    newStore(paramLong);
  }

  void newStore(long paramLong)
    throws IOException
  {
    long l = 0L;
    if (this.store != null)
    {
      l = this.store.getFilePointer();
      this.store.close();
    }
    if (paramLong <= 268435456L)
      try
      {
        this.store = new ScaledRAFileNIO(this.database, this.fileName, this.isReadOnly, (int)paramLong);
        this.store.seek(l);
        return;
      }
      catch (Throwable localThrowable)
      {
      }
    this.store = new ScaledRAFile(this.database, this.fileName, this.isReadOnly);
    this.store.seek(l);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.ScaledRAFileHybrid
 * JD-Core Version:    0.6.0
 */