package org.hsqldb.persist;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hsqldb.Database;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.Storage;

class ScaledRAFile
  implements ScaledRAInterface
{
  static final int DATA_FILE_RAF = 0;
  static final int DATA_FILE_NIO = 1;
  static final int DATA_FILE_JAR = 2;
  static final long MAX_NIO_LENGTH = 268435456L;
  final SimpleLog appLog;
  final RandomAccessFile file;
  private final boolean readOnly;
  final String fileName;
  boolean isNio;
  boolean bufferDirty = true;
  final byte[] buffer;
  final HsqlByteArrayInputStream ba;
  long bufferOffset;
  long seekPosition;
  long realPosition;
  static int cacheHit;

  static Storage newScaledRAFile(Database paramDatabase, String paramString1, boolean paramBoolean, int paramInt, String paramString2, String paramString3)
    throws FileNotFoundException, IOException
  {
    Object localObject;
    if (paramString2 != null)
      try
      {
        Class localClass = Class.forName(paramString2);
        localObject = localClass.getConstructor(new Class[] { String.class, Boolean.class, Object.class });
        return (Storage)((Constructor)localObject).newInstance(new Object[] { paramString1, new Boolean(paramBoolean), paramString3 });
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        throw new IOException();
      }
      catch (NoSuchMethodException localNoSuchMethodException)
      {
        throw new IOException();
      }
      catch (InstantiationException localInstantiationException)
      {
        throw new IOException();
      }
      catch (IllegalAccessException localIllegalAccessException)
      {
        throw new IOException();
      }
      catch (InvocationTargetException localInvocationTargetException)
      {
        throw new IOException();
      }
    if (paramInt == 2)
      return new ScaledRAFileInJar(paramString1);
    if (paramInt == 0)
      return new ScaledRAFile(paramDatabase, paramString1, paramBoolean);
    RandomAccessFile localRandomAccessFile = new RandomAccessFile(paramString1, paramBoolean ? "r" : "rw");
    if (localRandomAccessFile.length() > 268435456L)
      return new ScaledRAFile(paramDatabase, paramString1, localRandomAccessFile, paramBoolean);
    localRandomAccessFile.close();
    try
    {
      Class.forName("java.nio.MappedByteBuffer");
      localObject = Class.forName("org.hsqldb.persist.ScaledRAFileHybrid");
      Constructor localConstructor = ((Class)localObject).getConstructor(new Class[] { Database.class, String.class, Boolean.TYPE });
      return (ScaledRAInterface)localConstructor.newInstance(new Object[] { paramDatabase, paramString1, new Boolean(paramBoolean) });
    }
    catch (Exception localException)
    {
    }
    return (Storage)new ScaledRAFile(paramDatabase, paramString1, paramBoolean);
  }

  ScaledRAFile(Database paramDatabase, String paramString, RandomAccessFile paramRandomAccessFile, boolean paramBoolean)
    throws FileNotFoundException, IOException
  {
    this.appLog = paramDatabase.logger.appLog;
    this.readOnly = paramBoolean;
    this.fileName = paramString;
    this.file = paramRandomAccessFile;
    int i = paramDatabase.getProperties().getIntegerProperty("hsqldb.raf_buffer_scale", 12, 8, 13);
    int j = 1 << i;
    this.buffer = new byte[j];
    this.ba = new HsqlByteArrayInputStream(this.buffer);
  }

  ScaledRAFile(Database paramDatabase, String paramString, boolean paramBoolean)
    throws FileNotFoundException, IOException
  {
    this.appLog = paramDatabase.logger.appLog;
    this.readOnly = paramBoolean;
    this.fileName = paramString;
    this.file = new RandomAccessFile(paramString, paramBoolean ? "r" : "rw");
    int i = paramDatabase.getProperties().getIntegerProperty("hsqldb.raf_buffer_scale", 12);
    int j = 1 << i;
    this.buffer = new byte[j];
    this.ba = new HsqlByteArrayInputStream(this.buffer);
  }

  public long length()
    throws IOException
  {
    return this.file.length();
  }

  public void seek(long paramLong)
    throws IOException
  {
    if ((!this.readOnly) && (this.file.length() < paramLong))
    {
      long l1 = paramLong - this.file.length();
      if (l1 > 262144L)
        l1 = 262144L;
      byte[] arrayOfByte = new byte[(int)l1];
      try
      {
        long l2 = this.file.length();
        while (l2 < paramLong - l1)
        {
          this.file.seek(l2);
          this.file.write(arrayOfByte, 0, (int)l1);
          l2 += l1;
        }
        this.file.seek(l2);
        this.file.write(arrayOfByte, 0, (int)(paramLong - l2));
        this.realPosition = paramLong;
      }
      catch (IOException localIOException)
      {
        this.appLog.logContext(localIOException, null);
        throw localIOException;
      }
    }
    this.seekPosition = paramLong;
  }

  public long getFilePointer()
    throws IOException
  {
    return this.seekPosition;
  }

  private void readIntoBuffer()
    throws IOException
  {
    long l1 = this.seekPosition;
    long l2 = l1 % this.buffer.length;
    long l3 = this.file.length();
    long l4 = l3 - (l1 - l2);
    try
    {
      if (l4 <= 0L)
        throw new IOException("read beyond end of file");
      if (l4 > this.buffer.length)
        l4 = this.buffer.length;
      this.file.seek(l1 - l2);
      this.file.readFully(this.buffer, 0, (int)l4);
      this.bufferOffset = (l1 - l2);
      this.realPosition = (this.bufferOffset + l4);
      this.bufferDirty = false;
    }
    catch (IOException localIOException)
    {
      resetPointer();
      this.appLog.logContext(localIOException, "" + this.realPosition + " " + l4);
      throw localIOException;
    }
  }

  public int read()
    throws IOException
  {
    try
    {
      long l = this.file.length();
      if (this.seekPosition >= l)
        return -1;
      if ((this.bufferDirty) || (this.seekPosition < this.bufferOffset) || (this.seekPosition >= this.bufferOffset + this.buffer.length))
        readIntoBuffer();
      else
        cacheHit += 1;
      this.ba.reset();
      this.ba.skip(this.seekPosition - this.bufferOffset);
      int i = this.ba.read();
      this.seekPosition += 1L;
      return i;
    }
    catch (IOException localIOException)
    {
      resetPointer();
      this.appLog.logContext(localIOException, null);
    }
    throw localIOException;
  }

  public long readLong()
    throws IOException
  {
    try
    {
      if ((this.bufferDirty) || (this.seekPosition < this.bufferOffset) || (this.seekPosition >= this.bufferOffset + this.buffer.length))
        readIntoBuffer();
      else
        cacheHit += 1;
      this.ba.reset();
      if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset))
        throw new EOFException();
      long l;
      try
      {
        l = this.ba.readLong();
      }
      catch (EOFException localEOFException)
      {
        this.file.seek(this.seekPosition);
        l = this.file.readLong();
        this.realPosition = this.file.getFilePointer();
      }
      this.seekPosition += 8L;
      return l;
    }
    catch (IOException localIOException)
    {
      resetPointer();
      this.appLog.logContext(localIOException, null);
    }
    throw localIOException;
  }

  public int readInt()
    throws IOException
  {
    try
    {
      if ((this.bufferDirty) || (this.seekPosition < this.bufferOffset) || (this.seekPosition >= this.bufferOffset + this.buffer.length))
        readIntoBuffer();
      else
        cacheHit += 1;
      this.ba.reset();
      if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset))
        throw new EOFException();
      int i;
      try
      {
        i = this.ba.readInt();
      }
      catch (EOFException localEOFException)
      {
        this.file.seek(this.seekPosition);
        i = this.file.readInt();
        this.realPosition = this.file.getFilePointer();
      }
      this.seekPosition += 4L;
      return i;
    }
    catch (IOException localIOException)
    {
      resetPointer();
      this.appLog.logContext(localIOException, null);
    }
    throw localIOException;
  }

  public void read(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
    throws IOException
  {
    try
    {
      if ((this.bufferDirty) || (this.seekPosition < this.bufferOffset) || (this.seekPosition >= this.bufferOffset + this.buffer.length))
        readIntoBuffer();
      else
        cacheHit += 1;
      this.ba.reset();
      if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset))
        throw new EOFException();
      int i = this.ba.read(paramArrayOfByte, paramInt1, paramInt2);
      this.seekPosition += i;
      if (i < paramInt2)
      {
        if (this.seekPosition != this.realPosition)
          this.file.seek(this.seekPosition);
        this.file.readFully(paramArrayOfByte, paramInt1 + i, paramInt2 - i);
        this.seekPosition += paramInt2 - i;
        this.realPosition = this.seekPosition;
      }
    }
    catch (IOException localIOException)
    {
      resetPointer();
      this.appLog.logContext(localIOException, null);
      throw localIOException;
    }
  }

  public void write(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
    throws IOException
  {
    try
    {
      if (this.realPosition != this.seekPosition)
      {
        this.file.seek(this.seekPosition);
        this.realPosition = this.seekPosition;
      }
      if ((this.seekPosition >= this.bufferOffset) && (this.seekPosition < this.bufferOffset + this.buffer.length))
        this.bufferDirty = true;
      this.file.write(paramArrayOfByte, paramInt1, paramInt2);
      this.seekPosition += paramInt2;
      this.realPosition = this.seekPosition;
    }
    catch (IOException localIOException)
    {
      resetPointer();
      this.appLog.logContext(localIOException, null);
      throw localIOException;
    }
  }

  public void writeInt(int paramInt)
    throws IOException
  {
    try
    {
      if (this.realPosition != this.seekPosition)
      {
        this.file.seek(this.seekPosition);
        this.realPosition = this.seekPosition;
      }
      if ((this.seekPosition >= this.bufferOffset) && (this.seekPosition < this.bufferOffset + this.buffer.length))
        this.bufferDirty = true;
      this.file.writeInt(paramInt);
      this.seekPosition += 4L;
      this.realPosition = this.seekPosition;
    }
    catch (IOException localIOException)
    {
      resetPointer();
      this.appLog.logContext(localIOException, null);
      throw localIOException;
    }
  }

  public void writeLong(long paramLong)
    throws IOException
  {
    try
    {
      if (this.realPosition != this.seekPosition)
      {
        this.file.seek(this.seekPosition);
        this.realPosition = this.seekPosition;
      }
      if ((this.seekPosition >= this.bufferOffset) && (this.seekPosition < this.bufferOffset + this.buffer.length))
        this.bufferDirty = true;
      this.file.writeLong(paramLong);
      this.seekPosition += 8L;
      this.realPosition = this.seekPosition;
    }
    catch (IOException localIOException)
    {
      resetPointer();
      this.appLog.logContext(localIOException, null);
      throw localIOException;
    }
  }

  public void close()
    throws IOException
  {
    Trace.printSystemOut("cache hit " + cacheHit);
    this.file.close();
  }

  public boolean isReadOnly()
  {
    return this.readOnly;
  }

  public boolean wasNio()
  {
    return false;
  }

  public boolean canAccess(int paramInt)
  {
    return true;
  }

  public boolean canSeek(long paramLong)
  {
    return true;
  }

  public Database getDatabase()
  {
    return null;
  }

  private void resetPointer()
  {
    try
    {
      this.bufferDirty = true;
      this.file.seek(this.seekPosition);
      this.realPosition = this.seekPosition;
    }
    catch (Throwable localThrowable)
    {
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.ScaledRAFile
 * JD-Core Version:    0.6.0
 */