package org.hsqldb.persist;

import java.util.Enumeration;
import java.util.Properties;
import org.hsqldb.Collation;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.TransactionManager;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.store.ValuePool;

public class HsqlDatabaseProperties extends HsqlProperties
{
  public static final int indexName = 0;
  public static final int indexAccess = 1;
  public static final int indexClass = 2;
  public static final int indexIsRange = 3;
  public static final int indexDefaultValue = 4;
  public static final int indexRangeLow = 5;
  public static final int indexRangeHigh = 6;
  public static final int indexValues = 7;
  public static final int indexLimit = 8;
  private static final int SET_PROPERTY = 0;
  private static final int SQL_PROPERTY = 1;
  private static final int FILE_PROPERTY = 2;
  public static final int FILES_NOT_MODIFIED = 0;
  public static final int FILES_MODIFIED = 1;
  public static final int FILES_NEW = 2;
  private static final String MODIFIED_NO = "no";
  private static final String MODIFIED_YES = "yes";
  private static final String MODIFIED_NEW = "no-new-files";
  private static HashMap meta = new HashMap();
  public static final String VERSION_STRING_1_7_0 = "1.7.0";
  public static final String VERSION_STRING_1_8_0 = "1.8.0";
  public static final String FIRST_COMPATIBLE_VERSION = "1.8.0";
  public static final String THIS_VERSION = "1.8.0";
  public static final String THIS_FULL_VERSION = "1.8.0.8";
  public static final String THIS_CACHE_VERSION = "1.7.0";
  public static final String PRODUCT_NAME = "HSQL Database Engine";
  public static final int MAJOR = 1;
  public static final int MINOR = 8;
  public static final int REVISION = 0;
  public static final String db_version = "version";
  private static final String db_readonly = "readonly";
  private static final String db_modified = "modified";
  private static final String runtime_gc_interval = "runtime.gc_interval";
  public static final String hsqldb_applog = "hsqldb.applog";
  public static final String hsqldb_cache_file_scale = "hsqldb.cache_file_scale";
  public static final String hsqldb_cache_free_count_scale = "hsqldb.cache_free_count_scale";
  public static final String hsqldb_cache_scale = "hsqldb.cache_scale";
  public static final String hsqldb_cache_size_scale = "hsqldb.cache_size_scale";
  public static final String hsqldb_cache_version = "hsqldb.cache_version";
  private static final String hsqldb_catalogs = "hsqldb.catalogs";
  public static final String hsqldb_compatible_version = "hsqldb.compatible_version";
  public static final String hsqldb_default_table_type = "hsqldb.default_table_type";
  public static final String hsqldb_defrag_limit = "hsqldb.defrag_limit";
  private static final String hsqldb_files_readonly = "hsqldb.files_readonly";
  public static final String hsqldb_log_size = "hsqldb.log_size";
  public static final String hsqldb_nio_data_file = "hsqldb.nio_data_file";
  public static final String hsqldb_max_nio_scale = "hsqldb.max_nio_scale";
  public static final String hsqldb_raf_buffer_scale = "hsqldb.raf_buffer_scale";
  private static final String hsqldb_original_version = "hsqldb.original_version";
  public static final String hsqldb_script_format = "hsqldb.script_format";
  private static final String sql_compare_in_locale = "sql.compare_in_locale";
  private static final String sql_enforce_strict_size = "sql.enforce_strict_size";
  public static final String sql_tx_no_multi_write = "sql.tx_no_multi_rewrite";
  public static final String textdb_cache_scale = "textdb.cache_scale";
  public static final String textdb_cache_size_scale = "textdb.cache_size_scale";
  public static final String textdb_all_quoted = "textdb.all_quoted";
  public static final String textdb_allow_full_path = "textdb.allow_full_path";
  public static final String textdb_encoding = "textdb.encoding";
  public static final String textdb_ignore_first = "textdb.ignore_first";
  public static final String textdb_quoted = "textdb.quoted";
  public static final String textdb_fs = "textdb.fs";
  public static final String textdb_vs = "textdb.vs";
  public static final String textdb_lvs = "textdb.lvs";
  private Database database;

  public HsqlDatabaseProperties(Database paramDatabase)
  {
    super(paramDatabase.getPath(), paramDatabase.getFileAccess(), paramDatabase.isFilesInJar());
    this.database = paramDatabase;
    setProperty("sql.enforce_strict_size", false);
    setProperty("version", "1.8.0");
    setProperty("hsqldb.compatible_version", "1.8.0");
    setProperty("hsqldb.cache_version", "1.7.0");
    setProperty("hsqldb.original_version", "1.8.0");
    setProperty("runtime.gc_interval", 0);
    setProperty("hsqldb.cache_file_scale", 1);
    setProperty("hsqldb.cache_size_scale", 8);
    setProperty("hsqldb.cache_scale", 14);
    setProperty("hsqldb.log_size", 200);
    setProperty("hsqldb.script_format", 0);
    setProperty("readonly", false);
    setProperty("modified", "no-new-files");
    setProperty("hsqldb.nio_data_file", true);
    setProperty("hsqldb.default_table_type", "memory");
    if (paramDatabase.isStoredFileAccess())
    {
      setProperty("hsqldb.default_table_type", "cached");
      setProperty("hsqldb.cache_scale", 13);
      setProperty("hsqldb.log_size", 10);
      setProperty("sql.enforce_strict_size", true);
      setProperty("hsqldb.nio_data_file", false);
    }
  }

  public boolean load()
    throws HsqlException
  {
    if (!DatabaseURL.isFileBasedDatabaseType(this.database.getType()))
      return true;
    boolean bool;
    try
    {
      bool = super.load();
    }
    catch (Exception localException)
    {
      throw Trace.error(29, 116, new Object[] { this.fileName, localException });
    }
    if (!bool)
      return false;
    filterLoadedProperties();
    String str = getProperty("hsqldb.compatible_version");
    int i = str.substring(0, 5).compareTo("1.8.0");
    Trace.check(i <= 0, 30);
    str = getProperty("version");
    if (str.charAt(2) == '6')
      setProperty("hsqldb.cache_version", "1.6.0");
    org.hsqldb.lib.java.JavaSystem.gcFrequency = getIntegerProperty("runtime.gc_interval", 0);
    return true;
  }

  public void setDatabaseVariables()
  {
    if (isPropertyTrue("readonly"))
      this.database.setReadOnly();
    if (isPropertyTrue("hsqldb.files_readonly"))
      this.database.setFilesReadOnly();
    this.database.sqlEnforceStrictSize = isPropertyTrue("sql.enforce_strict_size");
    if (isPropertyTrue("sql.compare_in_locale"))
    {
      this.stringProps.remove("sql.compare_in_locale");
      this.database.collation.setCollationAsLocale();
    }
    this.database.txManager.setReWriteProtection(isPropertyTrue("sql.tx_no_multi_rewrite"));
    this.database.setMetaDirty(false);
  }

  public void save()
    throws HsqlException
  {
    if ((!DatabaseURL.isFileBasedDatabaseType(this.database.getType())) || (this.database.isFilesReadOnly()) || (this.database.isFilesInJar()))
      return;
    try
    {
      super.save(this.fileName + ".properties" + ".new");
      this.fa.renameElement(this.fileName + ".properties" + ".new", this.fileName + ".properties");
    }
    catch (Exception localException)
    {
      this.database.logger.appLog.logContext(SimpleLog.LOG_ERROR, "failed");
      throw Trace.error(29, 116, new Object[] { this.fileName, localException });
    }
  }

  void filterLoadedProperties()
  {
    Enumeration localEnumeration = this.stringProps.propertyNames();
    while (localEnumeration.hasMoreElements())
    {
      String str = (String)localEnumeration.nextElement();
      boolean bool = meta.containsKey(str);
      if (bool)
        continue;
      this.stringProps.remove(str);
    }
  }

  public void setURLProperties(HsqlProperties paramHsqlProperties)
  {
    if (paramHsqlProperties != null)
    {
      Enumeration localEnumeration = paramHsqlProperties.propertyNames();
      while (localEnumeration.hasMoreElements())
      {
        String str = (String)localEnumeration.nextElement();
        Object[] arrayOfObject = (Object[])meta.get(str);
        if ((arrayOfObject == null) || ((!"readonly".equals(str)) && (((Integer)arrayOfObject[1]).intValue() != 0)))
          continue;
        setProperty(str, paramHsqlProperties.getProperty(str));
      }
    }
  }

  public Set getUserDefinedPropertyData()
  {
    HashSet localHashSet = new HashSet();
    Iterator localIterator = meta.values().iterator();
    while (localIterator.hasNext())
    {
      Object[] arrayOfObject = (Object[])localIterator.next();
      if (((Integer)arrayOfObject[1]).intValue() != 0)
        continue;
      localHashSet.add(arrayOfObject);
    }
    return localHashSet;
  }

  public boolean isUserDefinedProperty(String paramString)
  {
    Object[] arrayOfObject = (Object[])meta.get(paramString);
    return (arrayOfObject != null) && (((Integer)arrayOfObject[1]).intValue() == 0);
  }

  public boolean isBoolean(String paramString)
  {
    Object[] arrayOfObject = (Object[])meta.get(paramString);
    return (arrayOfObject != null) && (arrayOfObject[2].equals("boolean")) && (((Integer)arrayOfObject[1]).intValue() == 0);
  }

  public boolean isIntegral(String paramString)
  {
    Object[] arrayOfObject = (Object[])meta.get(paramString);
    return (arrayOfObject != null) && (arrayOfObject[2].equals("int")) && (((Integer)arrayOfObject[1]).intValue() == 0);
  }

  public boolean isString(String paramString)
  {
    Object[] arrayOfObject = (Object[])meta.get(paramString);
    return (arrayOfObject != null) && (arrayOfObject[2].equals("java.lang.String")) && (((Integer)arrayOfObject[1]).intValue() == 0);
  }

  public String setDatabaseProperty(String paramString1, String paramString2)
    throws HsqlException
  {
    Object[] arrayOfObject = (Object[])meta.get(paramString1);
    paramString2 = super.setProperty(paramString1, paramString2);
    return paramString2;
  }

  public int getDefaultWriteDelay()
  {
    return this.database.isStoredFileAccess() ? 2000 : 10000;
  }

  public void setDBModified(int paramInt)
    throws HsqlException
  {
    String str = "no";
    if (paramInt == 1)
      str = "yes";
    else if (paramInt == 2)
      str = "no-new-files";
    setProperty("modified", str);
    save();
  }

  public int getDBModified()
    throws HsqlException
  {
    String str = getProperty("modified");
    if ("yes".equals(str))
      return 1;
    if ("no-new-files".equals(str))
      return 2;
    return 0;
  }

  private static Object[] getMeta(String paramString1, int paramInt, String paramString2)
  {
    Object[] arrayOfObject = new Object[8];
    arrayOfObject[0] = paramString1;
    arrayOfObject[1] = ValuePool.getInt(paramInt);
    arrayOfObject[2] = "java.lang.String";
    arrayOfObject[4] = paramString2;
    return arrayOfObject;
  }

  private static Object[] getMeta(String paramString, int paramInt, boolean paramBoolean)
  {
    Object[] arrayOfObject = new Object[8];
    arrayOfObject[0] = paramString;
    arrayOfObject[1] = ValuePool.getInt(paramInt);
    arrayOfObject[2] = "boolean";
    arrayOfObject[4] = (paramBoolean ? Boolean.TRUE : Boolean.FALSE);
    return arrayOfObject;
  }

  private static Object[] getMeta(String paramString, int paramInt1, int paramInt2, byte[] paramArrayOfByte)
  {
    Object[] arrayOfObject = new Object[8];
    arrayOfObject[0] = paramString;
    arrayOfObject[1] = ValuePool.getInt(paramInt1);
    arrayOfObject[2] = "int";
    arrayOfObject[4] = ValuePool.getInt(paramInt2);
    arrayOfObject[7] = paramArrayOfByte;
    return arrayOfObject;
  }

  private static Object[] getMeta(String paramString, int paramInt1, int paramInt2, int paramInt3, int paramInt4)
  {
    Object[] arrayOfObject = new Object[8];
    arrayOfObject[0] = paramString;
    arrayOfObject[1] = ValuePool.getInt(paramInt1);
    arrayOfObject[2] = "int";
    arrayOfObject[4] = ValuePool.getInt(paramInt2);
    arrayOfObject[3] = Boolean.TRUE;
    arrayOfObject[5] = ValuePool.getInt(paramInt3);
    arrayOfObject[6] = ValuePool.getInt(paramInt4);
    return arrayOfObject;
  }

  static
  {
    meta.put("version", getMeta("version", 2, null));
    meta.put("hsqldb.compatible_version", getMeta("hsqldb.compatible_version", 2, null));
    meta.put("hsqldb.cache_version", getMeta("hsqldb.cache_version", 2, null));
    meta.put("hsqldb.original_version", getMeta("hsqldb.original_version", 2, null));
    meta.put("modified", getMeta("modified", 2, null));
    meta.put("hsqldb.default_table_type", getMeta("hsqldb.default_table_type", 0, "memory"));
    meta.put("textdb.fs", getMeta("textdb.fs", 0, ","));
    meta.put("textdb.vs", getMeta("textdb.vs", 0, null));
    meta.put("textdb.lvs", getMeta("textdb.lvs", 0, null));
    meta.put("textdb.encoding", getMeta("textdb.encoding", 0, null));
    meta.put("readonly", getMeta("readonly", 2, false));
    meta.put("hsqldb.files_readonly", getMeta("hsqldb.files_readonly", 2, false));
    meta.put("textdb.allow_full_path", getMeta("textdb.allow_full_path", 2, false));
    meta.put("hsqldb.nio_data_file", getMeta("hsqldb.nio_data_file", 0, false));
    meta.put("hsqldb.catalogs", getMeta("hsqldb.catalogs", 0, false));
    meta.put("sql.enforce_strict_size", getMeta("sql.enforce_strict_size", 0, false));
    meta.put("sql.tx_no_multi_rewrite", getMeta("sql.tx_no_multi_rewrite", 0, false));
    meta.put("textdb.quoted", getMeta("textdb.quoted", 0, false));
    meta.put("textdb.all_quoted", getMeta("textdb.all_quoted", 0, false));
    meta.put("textdb.ignore_first", getMeta("textdb.ignore_first", 0, false));
    meta.put("hsqldb.applog", getMeta("hsqldb.applog", 0, 0, new byte[] { 0, 1, 2 }));
    meta.put("hsqldb.cache_file_scale", getMeta("hsqldb.cache_file_scale", 0, 1, new byte[] { 1, 8 }));
    meta.put("hsqldb.script_format", getMeta("hsqldb.script_format", 0, 0, new byte[] { 0, 1, 3 }));
    meta.put("hsqldb.log_size", getMeta("hsqldb.log_size", 1, 0, 0, 16000));
    meta.put("hsqldb.defrag_limit", getMeta("hsqldb.defrag_limit", 1, 200, 0, 16000));
    meta.put("runtime.gc_interval", getMeta("runtime.gc_interval", 0, 0, 0, 1000000));
    meta.put("hsqldb.cache_free_count_scale", getMeta("hsqldb.cache_free_count_scale", 0, 9, 6, 12));
    meta.put("hsqldb.cache_scale", getMeta("hsqldb.cache_scale", 0, 14, 8, 18));
    meta.put("hsqldb.cache_size_scale", getMeta("hsqldb.cache_size_scale", 0, 10, 6, 20));
    meta.put("hsqldb.max_nio_scale", getMeta("hsqldb.max_nio_scale", 0, 28, 24, 31));
    meta.put("hsqldb.raf_buffer_scale", getMeta("hsqldb.raf_buffer_scale", 0, 12, 8, 13));
    meta.put("textdb.cache_scale", getMeta("textdb.cache_scale", 0, 10, 8, 16));
    meta.put("textdb.cache_size_scale", getMeta("textdb.cache_size_scale", 0, 10, 6, 20));
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.HsqlDatabaseProperties
 * JD-Core Version:    0.6.0
 */