package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class ZipUnzipFile
{
  private static final int COPY_BLOCK_SIZE = 65536;

  public static void compressFile(String paramString1, String paramString2, FileAccess paramFileAccess)
    throws IOException
  {
    InputStream localInputStream = null;
    DeflaterOutputStream localDeflaterOutputStream = null;
    int i = 0;
    if (!paramFileAccess.isStreamElement(paramString1))
      return;
    try
    {
      byte[] arrayOfByte = new byte[65536];
      localInputStream = paramFileAccess.openInputStreamElement(paramString1);
      localDeflaterOutputStream = new DeflaterOutputStream(paramFileAccess.openOutputStreamElement(paramString2), new Deflater(1), 65536);
      while (true)
      {
        int j = localInputStream.read(arrayOfByte, 0, 65536);
        if (j == -1)
          break;
        localDeflaterOutputStream.write(arrayOfByte, 0, j);
      }
      i = 1;
    }
    catch (Throwable localThrowable1)
    {
      throw FileUtil.toIOException(localThrowable1);
    }
    finally
    {
      try
      {
        if (localInputStream != null)
          localInputStream.close();
        if (localDeflaterOutputStream != null)
        {
          localDeflaterOutputStream.finish();
          localDeflaterOutputStream.close();
        }
        if ((i == 0) && (paramFileAccess.isStreamElement(paramString2)))
          paramFileAccess.removeElement(paramString2);
      }
      catch (Throwable localThrowable2)
      {
        throw FileUtil.toIOException(localThrowable2);
      }
    }
  }

  public static void decompressFile(String paramString1, String paramString2, FileAccess paramFileAccess)
    throws IOException
  {
    InflaterInputStream localInflaterInputStream = null;
    OutputStream localOutputStream = null;
    int i = 0;
    try
    {
      if (!paramFileAccess.isStreamElement(paramString1))
        jsr 106;
      paramFileAccess.removeElement(paramString2);
      localInflaterInputStream = new InflaterInputStream(paramFileAccess.openInputStreamElement(paramString1), new Inflater());
      localOutputStream = paramFileAccess.openOutputStreamElement(paramString2);
      byte[] arrayOfByte = new byte[65536];
      while (true)
      {
        int j = localInflaterInputStream.read(arrayOfByte, 0, 65536);
        if (j == -1)
          break;
        localOutputStream.write(arrayOfByte, 0, j);
      }
      i = 1;
    }
    catch (Throwable localThrowable1)
    {
      throw FileUtil.toIOException(localThrowable1);
    }
    finally
    {
      try
      {
        if (localInflaterInputStream != null)
          localInflaterInputStream.close();
        if (localOutputStream != null)
          localOutputStream.close();
        if ((i == 0) && (paramFileAccess.isStreamElement(paramString2)))
          paramFileAccess.removeElement(paramString2);
      }
      catch (Throwable localThrowable2)
      {
        throw FileUtil.toIOException(localThrowable2);
      }
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.ZipUnzipFile
 * JD-Core Version:    0.6.0
 */