package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.store.BaseHashMap;

public class IntKeyLongValueHashMap extends BaseHashMap
{
  public IntKeyLongValueHashMap()
  {
    this(16, 0.75F);
  }

  public IntKeyLongValueHashMap(int paramInt)
    throws IllegalArgumentException
  {
    this(paramInt, 0.75F);
  }

  public IntKeyLongValueHashMap(int paramInt, float paramFloat)
    throws IllegalArgumentException
  {
    super(paramInt, paramFloat, 1, 2, false);
  }

  public long get(int paramInt)
    throws NoSuchElementException
  {
    int i = getLookup(paramInt);
    if (i != -1)
      return this.longValueTable[i];
    throw new NoSuchElementException();
  }

  public long get(int paramInt1, int paramInt2)
  {
    int i = getLookup(paramInt1);
    if (i != -1)
      return this.longValueTable[i];
    return paramInt2;
  }

  public boolean get(int paramInt, long[] paramArrayOfLong)
  {
    int i = getLookup(paramInt);
    if (i != -1)
    {
      paramArrayOfLong[0] = this.longValueTable[i];
      return true;
    }
    return false;
  }

  public boolean put(int paramInt1, int paramInt2)
  {
    int i = size();
    super.addOrRemove(paramInt1, paramInt2, null, null, false);
    return i != size();
  }

  public boolean remove(int paramInt)
  {
    int i = size();
    super.addOrRemove(paramInt, 0L, null, null, true);
    return i != size();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.IntKeyLongValueHashMap
 * JD-Core Version:    0.6.0
 */