package org.hsqldb.lib;

public class HsqlLinkedList extends BaseList
  implements HsqlList
{
  private Node first = new Node(null, null);
  private Node last = this.first;

  public HsqlLinkedList()
  {
    this.elementCount = 0;
  }

  public void add(int paramInt, Object paramObject)
  {
    if (paramInt == size())
    {
      add(paramObject);
    }
    else
    {
      if (paramInt > size())
        throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + " > " + size());
      Node localNode1 = getInternal(paramInt);
      Node localNode2 = new Node(localNode1.data, localNode1.next);
      localNode1.data = paramObject;
      localNode1.next = localNode2;
      this.elementCount += 1;
      if (this.last == localNode1)
        this.last = localNode2;
    }
  }

  public boolean add(Object paramObject)
  {
    this.last.next = new Node(paramObject, null);
    this.last = this.last.next;
    this.elementCount += 1;
    return true;
  }

  public void clear()
  {
    this.first.next = null;
  }

  public Object get(int paramInt)
  {
    return getInternal(paramInt).data;
  }

  public Object remove(int paramInt)
  {
    if (paramInt >= size())
      throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + " >= " + size());
    Node localNode1;
    if (paramInt == 0)
      localNode1 = this.first;
    else
      localNode1 = getInternal(paramInt - 1);
    Node localNode2 = localNode1.next;
    localNode1.next = localNode2.next;
    this.elementCount -= 1;
    if (this.last == localNode2)
      this.last = localNode1;
    return localNode2.data;
  }

  public Object set(int paramInt, Object paramObject)
  {
    Node localNode = getInternal(paramInt);
    Object localObject = localNode.data;
    localNode.data = paramObject;
    return localObject;
  }

  public final int size()
  {
    return this.elementCount;
  }

  protected final Node getInternal(int paramInt)
  {
    if (paramInt >= size())
      throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + " >= " + size());
    if (paramInt < 0)
      throw new IndexOutOfBoundsException("Index out of bounds: " + paramInt + " < 0");
    if (paramInt == 0)
      return this.first.next;
    if (paramInt == size() - 1)
      return this.last;
    Node localNode = this.first.next;
    for (int i = 0; i < paramInt; i++)
      localNode = localNode.next;
    return localNode;
  }

  private static class Node
  {
    public Node next;
    public Object data;

    public Node()
    {
      this.next = null;
      this.data = null;
    }

    public Node(Object paramObject)
    {
      this.next = null;
      this.data = paramObject;
    }

    public Node(Object paramObject, Node paramNode)
    {
      this.next = paramNode;
      this.data = paramObject;
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.HsqlLinkedList
 * JD-Core Version:    0.6.0
 */