package org.hsqldb.lib;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.hsqldb.lib.java.JavaSystem;

public class FileUtil
  implements FileAccess
{
  private static FileUtil fileUtil;
  public static final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
  public static final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
  static final Random random = new Random(System.currentTimeMillis());

  public static FileUtil getDefaultInstance()
  {
    if (fileUtil == null)
      fileUtil = new FileUtil();
    return fileUtil;
  }

  public boolean isStreamElement(String paramString)
  {
    return new File(paramString).exists();
  }

  public InputStream openInputStreamElement(String paramString)
    throws IOException
  {
    try
    {
      return new FileInputStream(new File(paramString));
    }
    catch (Throwable localThrowable)
    {
    }
    throw toIOException(localThrowable);
  }

  public void createParentDirs(String paramString)
  {
    makeParentDirectories(new File(paramString));
  }

  public void removeElement(String paramString)
  {
    if (isStreamElement(paramString))
      delete(paramString);
  }

  public void renameElement(String paramString1, String paramString2)
  {
    renameOverwrite(paramString1, paramString2);
  }

  public OutputStream openOutputStreamElement(String paramString)
    throws IOException
  {
    return new FileOutputStream(new File(paramString));
  }

  public static void delete(String paramString)
  {
    new File(paramString).delete();
  }

  public static void deleteOnExit(File paramFile)
  {
    JavaSystem.deleteOnExit(paramFile);
  }

  public static boolean exists(String paramString)
  {
    return new File(paramString).exists();
  }

  public static boolean exists(String paramString, boolean paramBoolean, Class paramClass)
  {
    if ((paramString == null) || (paramString.length() == 0))
      return false;
    return paramBoolean ? false : null != paramClass.getResource(paramString) ? true : exists(paramString);
  }

  public static void renameOverwrite(String paramString1, String paramString2)
  {
    delete(paramString2);
    if (exists(paramString1))
    {
      File localFile = new File(paramString1);
      localFile.renameTo(new File(paramString2));
    }
  }

  public static IOException toIOException(Throwable paramThrowable)
  {
    if ((paramThrowable instanceof IOException))
      return (IOException)paramThrowable;
    return new IOException(paramThrowable.toString());
  }

  public static String absolutePath(String paramString)
  {
    return new File(paramString).getAbsolutePath();
  }

  public static File canonicalFile(File paramFile)
    throws IOException
  {
    return new File(paramFile.getCanonicalPath());
  }

  public static File canonicalFile(String paramString)
    throws IOException
  {
    return new File(new File(paramString).getCanonicalPath());
  }

  public static String canonicalPath(File paramFile)
    throws IOException
  {
    return paramFile.getCanonicalPath();
  }

  public static String canonicalPath(String paramString)
    throws IOException
  {
    return new File(paramString).getCanonicalPath();
  }

  public static String canonicalOrAbsolutePath(String paramString)
  {
    try
    {
      return canonicalPath(paramString);
    }
    catch (Exception localException)
    {
    }
    return absolutePath(paramString);
  }

  public static void makeParentDirectories(File paramFile)
  {
    String str = paramFile.getParent();
    if (str != null)
    {
      new File(str).mkdirs();
    }
    else
    {
      str = paramFile.getPath();
      int i = str.lastIndexOf('/');
      if (i > 0)
      {
        str = str.substring(0, i);
        new File(str).mkdirs();
      }
    }
  }

  public FileAccess.FileSync getFileSync(OutputStream paramOutputStream)
    throws IOException
  {
    return new FileSync((FileOutputStream)paramOutputStream);
  }

  public class FileSync
    implements FileAccess.FileSync
  {
    FileDescriptor outDescriptor;

    FileSync(FileOutputStream arg2)
      throws IOException
    {
      Object localObject;
      this.outDescriptor = localObject.getFD();
    }

    public void sync()
      throws IOException
    {
      this.outDescriptor.sync();
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.FileUtil
 * JD-Core Version:    0.6.0
 */