package org.hsqldb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.SessionInterface;
import org.hsqldb.Trace;

public class jdbcStatement
  implements Statement
{
  volatile boolean isClosed;
  private boolean isEscapeProcessing = true;
  protected jdbcConnection connection;
  protected int maxRows;
  protected Result resultIn;
  protected int rsType = 1003;
  protected Result resultOut = new Result(65547);
  protected Result batchResultOut = null;

  public ResultSet executeQuery(String paramString)
    throws SQLException
  {
    checkClosed();
    this.connection.clearWarningsNoCheck();
    fetchResult(paramString);
    return new jdbcResultSet(this, this.resultIn, this.connection.connProperties, this.connection.isNetConn);
  }

  public int executeUpdate(String paramString)
    throws SQLException
  {
    checkClosed();
    this.connection.clearWarningsNoCheck();
    fetchResult(paramString);
    if ((this.resultIn == null) || (this.resultIn.isData()))
      throw new SQLException(Trace.getMessage(142));
    if (this.resultIn.isError())
      Util.throwError(this.resultIn);
    return this.resultIn.getUpdateCount();
  }

  public synchronized void close()
    throws SQLException
  {
    if (this.isClosed)
      return;
    this.batchResultOut = null;
    this.connection = null;
    this.resultIn = null;
    this.resultOut = null;
    this.isClosed = true;
  }

  public int getMaxFieldSize()
    throws SQLException
  {
    checkClosed();
    return 0;
  }

  public void setMaxFieldSize(int paramInt)
    throws SQLException
  {
    checkClosed();
    if (paramInt < 0)
      throw Util.sqlException(62);
  }

  public int getMaxRows()
    throws SQLException
  {
    checkClosed();
    return this.maxRows;
  }

  public void setMaxRows(int paramInt)
    throws SQLException
  {
    checkClosed();
    if (paramInt < 0)
      throw Util.sqlException(62);
    this.maxRows = paramInt;
  }

  public void setEscapeProcessing(boolean paramBoolean)
    throws SQLException
  {
    checkClosed();
    this.isEscapeProcessing = paramBoolean;
  }

  public int getQueryTimeout()
    throws SQLException
  {
    checkClosed();
    return 0;
  }

  public void setQueryTimeout(int paramInt)
    throws SQLException
  {
    checkClosed();
    if (paramInt < 0)
      throw Util.sqlException(62);
  }

  public void cancel()
    throws SQLException
  {
    checkClosed();
  }

  public SQLWarning getWarnings()
    throws SQLException
  {
    checkClosed();
    return null;
  }

  public void clearWarnings()
    throws SQLException
  {
    checkClosed();
  }

  public void setCursorName(String paramString)
    throws SQLException
  {
    checkClosed();
  }

  public boolean execute(String paramString)
    throws SQLException
  {
    checkClosed();
    this.connection.clearWarningsNoCheck();
    fetchResult(paramString);
    return this.resultIn.isData();
  }

  public ResultSet getResultSet()
    throws SQLException
  {
    checkClosed();
    return (this.resultIn == null) || (!this.resultIn.isData()) ? null : new jdbcResultSet(this, this.resultIn, this.connection.connProperties, this.connection.isNetConn);
  }

  public int getUpdateCount()
    throws SQLException
  {
    return (this.resultIn == null) || (this.resultIn.isData()) ? -1 : this.resultIn.getUpdateCount();
  }

  public boolean getMoreResults()
    throws SQLException
  {
    checkClosed();
    this.resultIn = null;
    return false;
  }

  public void setFetchDirection(int paramInt)
    throws SQLException
  {
    checkClosed();
    if (paramInt != 1000)
      throw Util.notSupported();
  }

  public int getFetchDirection()
    throws SQLException
  {
    checkClosed();
    return 1000;
  }

  public void setFetchSize(int paramInt)
    throws SQLException
  {
    checkClosed();
  }

  public int getFetchSize()
    throws SQLException
  {
    checkClosed();
    return 0;
  }

  public int getResultSetConcurrency()
    throws SQLException
  {
    checkClosed();
    return 1007;
  }

  public int getResultSetType()
    throws SQLException
  {
    return this.rsType;
  }

  public void addBatch(String paramString)
    throws SQLException
  {
    checkClosed();
    if (this.isEscapeProcessing)
      paramString = this.connection.nativeSQL(paramString);
    if (this.batchResultOut == null)
      this.batchResultOut = new Result(8, new int[] { 12 }, 0);
    this.batchResultOut.add(new Object[] { paramString });
  }

  public void clearBatch()
    throws SQLException
  {
    checkClosed();
    if (this.batchResultOut != null)
      this.batchResultOut.clear();
  }

  public int[] executeBatch()
    throws SQLException
  {
    checkClosed();
    this.connection.clearWarningsNoCheck();
    if (this.batchResultOut == null)
      this.batchResultOut = new Result(8, new int[] { 12 }, 0);
    int i = this.batchResultOut.getSize();
    try
    {
      this.resultIn = this.connection.sessionProxy.execute(this.batchResultOut);
    }
    catch (HsqlException localHsqlException)
    {
      this.batchResultOut.clear();
      throw Util.sqlException(localHsqlException);
    }
    this.batchResultOut.clear();
    if (this.resultIn.isError())
      Util.throwError(this.resultIn);
    int[] arrayOfInt = this.resultIn.getUpdateCounts();
    if (arrayOfInt.length != i)
      throw new BatchUpdateException("failed batch", arrayOfInt);
    return arrayOfInt;
  }

  public Connection getConnection()
    throws SQLException
  {
    checkClosed();
    return this.connection;
  }

  public boolean getMoreResults(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public ResultSet getGeneratedKeys()
    throws SQLException
  {
    throw Util.notSupported();
  }

  public int executeUpdate(String paramString, int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public int executeUpdate(String paramString, int[] paramArrayOfInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public int executeUpdate(String paramString, String[] paramArrayOfString)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public boolean execute(String paramString, int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public boolean execute(String paramString, int[] paramArrayOfInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public boolean execute(String paramString, String[] paramArrayOfString)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public int getResultSetHoldability()
    throws SQLException
  {
    return 1;
  }

  jdbcStatement(jdbcConnection paramjdbcConnection, int paramInt)
  {
    this.connection = paramjdbcConnection;
    this.rsType = paramInt;
  }

  synchronized boolean isClosed()
  {
    return this.isClosed;
  }

  void checkClosed()
    throws SQLException
  {
    if (this.isClosed)
      throw Util.sqlException(126);
    if (this.connection.isClosed)
      throw Util.sqlException(2);
  }

  private void fetchResult(String paramString)
    throws SQLException
  {
    if (this.isEscapeProcessing)
      paramString = this.connection.nativeSQL(paramString);
    this.resultIn = null;
    this.resultOut.setMainString(paramString);
    this.resultOut.setMaxRows(this.maxRows);
    try
    {
      this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
      if (this.resultIn.isError())
        throw new HsqlException(this.resultIn);
    }
    catch (HsqlException localHsqlException)
    {
      throw Util.sqlException(localHsqlException);
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.jdbcStatement
 * JD-Core Version:    0.6.0
 */