package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Result.ResultMetaData;
import org.hsqldb.SessionInterface;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class jdbcPreparedStatement extends jdbcStatement
  implements PreparedStatement
{
  protected Object[] parameterValues;
  protected boolean[] parameterSet;
  protected boolean[] parameterStream;
  protected int[] parameterTypes;
  protected int[] parameterModes;
  protected int[] streamLengths;
  protected boolean hasStreams;
  protected Result rsmdDescriptor;
  protected Result pmdDescriptor;
  protected jdbcResultSetMetaData rsmd;
  protected Object pmd;
  protected String sql;
  protected int statementID;
  protected boolean isRowCount;

  public void setEscapeProcessing(boolean paramBoolean)
    throws SQLException
  {
    checkClosed();
  }

  public boolean execute()
    throws SQLException
  {
    checkClosed();
    this.connection.clearWarningsNoCheck();
    this.resultIn = null;
    try
    {
      this.resultOut.setMaxRows(this.maxRows);
      this.resultOut.setParameterData(this.parameterValues);
      this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
    }
    catch (HsqlException localHsqlException)
    {
      throw Util.sqlException(localHsqlException);
    }
    if (this.resultIn.isError())
      Util.throwError(this.resultIn);
    return this.resultIn.isData();
  }

  public ResultSet executeQuery()
    throws SQLException
  {
    checkClosed();
    this.connection.clearWarningsNoCheck();
    checkIsRowCount(false);
    checkParametersSet();
    this.resultIn = null;
    try
    {
      this.resultOut.setMaxRows(this.maxRows);
      this.resultOut.setParameterData(this.parameterValues);
      this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
    }
    catch (HsqlException localHsqlException)
    {
      throw Util.sqlException(localHsqlException);
    }
    if (this.resultIn.isError())
    {
      Util.throwError(this.resultIn);
    }
    else if (!this.resultIn.isData())
    {
      String str = "Expected but did not recieve a result set";
      throw Util.sqlException(85, str);
    }
    return new jdbcResultSet(this, this.resultIn, this.connection.connProperties, this.connection.isNetConn);
  }

  public int executeUpdate()
    throws SQLException
  {
    checkClosed();
    this.connection.clearWarningsNoCheck();
    checkIsRowCount(true);
    checkParametersSet();
    this.resultIn = null;
    try
    {
      this.resultOut.setParameterData(this.parameterValues);
      this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
    }
    catch (HsqlException localHsqlException)
    {
      throw Util.sqlException(localHsqlException);
    }
    if (this.resultIn.isError())
    {
      Util.throwError(this.resultIn);
    }
    else if (this.resultIn.mode != 1)
    {
      String str = "Expected but did not recieve a row update count";
      throw Util.sqlException(85, str);
    }
    return this.resultIn.getUpdateCount();
  }

  public int[] executeBatch()
    throws SQLException
  {
    if (this.batchResultOut == null)
      this.batchResultOut = new Result(9, this.parameterTypes, this.statementID);
    return super.executeBatch();
  }

  public void setNull(int paramInt1, int paramInt2)
    throws SQLException
  {
    setParameter(paramInt1, null);
  }

  public void setBoolean(int paramInt, boolean paramBoolean)
    throws SQLException
  {
    Boolean localBoolean = paramBoolean ? Boolean.TRUE : Boolean.FALSE;
    setParameter(paramInt, localBoolean);
  }

  public void setByte(int paramInt, byte paramByte)
    throws SQLException
  {
    setIntParameter(paramInt, paramByte);
  }

  public void setShort(int paramInt, short paramShort)
    throws SQLException
  {
    setIntParameter(paramInt, paramShort);
  }

  public void setInt(int paramInt1, int paramInt2)
    throws SQLException
  {
    setIntParameter(paramInt1, paramInt2);
  }

  public void setLong(int paramInt, long paramLong)
    throws SQLException
  {
    setLongParameter(paramInt, paramLong);
  }

  public void setFloat(int paramInt, float paramFloat)
    throws SQLException
  {
    setDouble(paramInt, paramFloat);
  }

  public void setDouble(int paramInt, double paramDouble)
    throws SQLException
  {
    Double localDouble = new Double(paramDouble);
    setParameter(paramInt, localDouble);
  }

  public void setBigDecimal(int paramInt, BigDecimal paramBigDecimal)
    throws SQLException
  {
    setParameter(paramInt, paramBigDecimal);
  }

  public void setString(int paramInt, String paramString)
    throws SQLException
  {
    setParameter(paramInt, paramString);
  }

  public void setBytes(int paramInt, byte[] paramArrayOfByte)
    throws SQLException
  {
    setParameter(paramInt, paramArrayOfByte);
  }

  public void setDate(int paramInt, java.sql.Date paramDate)
    throws SQLException
  {
    setParameter(paramInt, paramDate);
  }

  public void setTime(int paramInt, Time paramTime)
    throws SQLException
  {
    setParameter(paramInt, paramTime);
  }

  public void setTimestamp(int paramInt, Timestamp paramTimestamp)
    throws SQLException
  {
    setParameter(paramInt, paramTimestamp);
  }

  public void setAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
    throws SQLException
  {
    checkSetParameterIndex(paramInt1, true);
    String str;
    if (paramInputStream == null)
    {
      str = "input stream is null";
      throw Util.sqlException(62, str);
    }
    try
    {
      str = StringConverter.inputStreamToString(paramInputStream, paramInt2);
      setParameter(paramInt1, str);
    }
    catch (IOException localIOException)
    {
      throw Util.sqlException(81);
    }
  }

  /** @deprecated */
  public void setUnicodeStream(int paramInt1, InputStream paramInputStream, int paramInt2)
    throws SQLException
  {
    checkSetParameterIndex(paramInt1, true);
    String str = null;
    if (paramInputStream == null)
      str = "input stream is null";
    else if (paramInt2 % 2 != 0)
      str = "odd length argument";
    if (str != null)
      throw Util.sqlException(62, str);
    int i = paramInt2 / 2;
    int j = 0;
    StringBuffer localStringBuffer = new StringBuffer();
    try
    {
      while (j < i)
      {
        int k = paramInputStream.read();
        if (k == -1)
          break;
        int m = paramInputStream.read();
        if (m == -1)
          break;
        localStringBuffer.append((char)(k << 8 | m));
        j++;
      }
    }
    catch (IOException localIOException)
    {
      throw Util.sqlException(19);
    }
    setParameter(paramInt1, localStringBuffer.toString());
  }

  public void setBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
    throws SQLException
  {
    checkSetParameterIndex(paramInt1, true);
    if (paramInputStream == null)
      throw Util.sqlException(Trace.error(62, 176));
    HsqlByteArrayOutputStream localHsqlByteArrayOutputStream = null;
    try
    {
      localHsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
      int i = 2048;
      byte[] arrayOfByte = new byte[i];
      int j = paramInt2;
      while (j > 0)
      {
        int k = paramInputStream.read(arrayOfByte, 0, j > i ? i : j);
        if (k == -1)
          break;
        localHsqlByteArrayOutputStream.write(arrayOfByte, 0, k);
        j -= k;
      }
      setParameter(paramInt1, localHsqlByteArrayOutputStream.toByteArray());
    }
    catch (IOException localIOException1)
    {
      throw Util.sqlException(34, localIOException1.toString());
    }
    finally
    {
      if (localHsqlByteArrayOutputStream != null)
        try
        {
          localHsqlByteArrayOutputStream.close();
        }
        catch (IOException localIOException2)
        {
        }
    }
  }

  public void clearParameters()
    throws SQLException
  {
    checkClosed();
    ArrayUtil.fillArray(this.parameterValues, null);
    ArrayUtil.clearArray(90, this.parameterSet, 0, this.parameterSet.length);
    if (this.parameterStream != null)
      ArrayUtil.clearArray(90, this.parameterStream, 0, this.parameterStream.length);
  }

  public void setObject(int paramInt1, Object paramObject, int paramInt2, int paramInt3)
    throws SQLException
  {
    setObject(paramInt1, paramObject);
  }

  public void setObject(int paramInt1, Object paramObject, int paramInt2)
    throws SQLException
  {
    setObject(paramInt1, paramObject);
  }

  public void setObject(int paramInt, Object paramObject)
    throws SQLException
  {
    setParameter(paramInt, paramObject);
  }

  public void addBatch()
    throws SQLException
  {
    checkClosed();
    int i = this.parameterValues.length;
    Object[] arrayOfObject = new Object[i];
    checkParametersSet();
    System.arraycopy(this.parameterValues, 0, arrayOfObject, 0, i);
    if (this.batchResultOut == null)
      this.batchResultOut = new Result(9, this.parameterTypes, this.statementID);
    this.batchResultOut.add(arrayOfObject);
  }

  public void setCharacterStream(int paramInt1, Reader paramReader, int paramInt2)
    throws SQLException
  {
    checkSetParameterIndex(paramInt1, true);
    if (paramReader == null)
    {
      localObject = "reader is null";
      throw Util.sqlException(62, (String)localObject);
    }
    Object localObject = new StringBuffer();
    char[] arrayOfChar = new char[2048];
    try
    {
      int i = paramInt2;
      while (i > 0)
      {
        int j = paramReader.read(arrayOfChar, 0, i > 2048 ? 2048 : i);
        if (j == -1)
          break;
        ((StringBuffer)localObject).append(arrayOfChar, 0, j);
        i -= j;
      }
    }
    catch (IOException localIOException)
    {
      throw Util.sqlException(19, localIOException.toString());
    }
    setParameter(paramInt1, ((StringBuffer)localObject).toString());
  }

  public void setRef(int paramInt, Ref paramRef)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void setBlob(int paramInt, Blob paramBlob)
    throws SQLException
  {
    if ((paramBlob instanceof jdbcBlob))
    {
      setParameter(paramInt, ((jdbcBlob)paramBlob).data);
      return;
    }
    if (paramBlob == null)
    {
      setParameter(paramInt, null);
      return;
    }
    checkSetParameterIndex(paramInt, false);
    long l = paramBlob.length();
    if (l > 2147483647L)
    {
      localObject1 = "Maximum Blob input octet length exceeded: " + l;
      throw Util.sqlException(34, (String)localObject1);
    }
    Object localObject1 = null;
    try
    {
      localObject1 = new HsqlByteArrayOutputStream();
      InputStream localInputStream = paramBlob.getBinaryStream();
      int i = 2048;
      byte[] arrayOfByte = new byte[i];
      int j = (int)l;
      while (j > 0)
      {
        int k = localInputStream.read(arrayOfByte, 0, j > i ? i : j);
        if (k == -1)
          break;
        ((HsqlByteArrayOutputStream)localObject1).write(arrayOfByte, 0, k);
        j -= k;
      }
      setParameter(paramInt, ((HsqlByteArrayOutputStream)localObject1).toByteArray());
    }
    catch (IOException localIOException1)
    {
      throw Util.sqlException(34, localIOException1.toString());
    }
    finally
    {
      if (localObject1 != null)
        try
        {
          ((HsqlByteArrayOutputStream)localObject1).close();
        }
        catch (IOException localIOException2)
        {
        }
    }
  }

  public void setClob(int paramInt, Clob paramClob)
    throws SQLException
  {
    if ((paramClob instanceof jdbcClob))
    {
      setParameter(paramInt, ((jdbcClob)paramClob).data);
      return;
    }
    if (paramClob == null)
    {
      setParameter(paramInt, null);
      return;
    }
    checkSetParameterIndex(paramInt, false);
    long l = paramClob.length();
    if (l > 2147483647L)
    {
      localObject = "Max Clob input character length exceeded: " + l;
      throw Util.sqlException(34, (String)localObject);
    }
    Object localObject = paramClob.getCharacterStream();
    StringBuffer localStringBuffer = new StringBuffer();
    char[] arrayOfChar = new char[2048];
    try
    {
      int i = (int)l;
      while (i > 0)
      {
        int j = ((Reader)localObject).read(arrayOfChar, 0, i > 2048 ? 2048 : i);
        if (j == -1)
          break;
        localStringBuffer.append(arrayOfChar, 0, j);
        i -= j;
      }
    }
    catch (IOException localIOException)
    {
      throw Util.sqlException(19, localIOException.toString());
    }
    setParameter(paramInt, localStringBuffer.toString());
  }

  public void setArray(int paramInt, Array paramArray)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public ResultSetMetaData getMetaData()
    throws SQLException
  {
    checkClosed();
    if (this.isRowCount)
      return null;
    if (this.rsmd == null)
      this.rsmd = new jdbcResultSetMetaData(this.rsmdDescriptor, this.connection.connProperties);
    return this.rsmd;
  }

  public void setDate(int paramInt, java.sql.Date paramDate, Calendar paramCalendar)
    throws SQLException
  {
    String str;
    try
    {
      str = HsqlDateTime.getDateString(paramDate, paramCalendar);
    }
    catch (Exception localException)
    {
      throw Util.sqlException(7, localException.toString());
    }
    setParameter(paramInt, str);
  }

  public void setTime(int paramInt, Time paramTime, Calendar paramCalendar)
    throws SQLException
  {
    String str;
    try
    {
      str = HsqlDateTime.getTimeString(paramTime, paramCalendar);
    }
    catch (Exception localException)
    {
      throw Util.sqlException(7, localException.toString());
    }
    setParameter(paramInt, str);
  }

  public void setTimestamp(int paramInt, Timestamp paramTimestamp, Calendar paramCalendar)
    throws SQLException
  {
    checkSetParameterIndex(paramInt, false);
    if ((paramCalendar != null) && (paramTimestamp != null))
    {
      int i = paramTimestamp.getNanos();
      paramTimestamp = new Timestamp(HsqlDateTime.getTimeInMillis(paramTimestamp, paramCalendar, null));
      paramTimestamp.setNanos(i);
    }
    setParameter(paramInt, paramTimestamp);
  }

  public void setNull(int paramInt1, int paramInt2, String paramString)
    throws SQLException
  {
    setParameter(paramInt1, null);
  }

  public void setURL(int paramInt, URL paramURL)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public ParameterMetaData getParameterMetaData()
    throws SQLException
  {
    checkClosed();
    if (this.pmd == null)
      this.pmd = new jdbcParameterMetaData(this.pmdDescriptor);
    return (ParameterMetaData)this.pmd;
  }

  jdbcPreparedStatement(jdbcConnection paramjdbcConnection, String paramString, int paramInt)
    throws HsqlException, SQLException
  {
    super(paramjdbcConnection, paramInt);
    paramString = paramjdbcConnection.nativeSQL(paramString);
    this.resultOut.setResultType(65555);
    this.resultOut.setMainString(paramString);
    Result localResult = this.connection.sessionProxy.execute(this.resultOut);
    if (localResult.isError())
      Util.throwError(localResult);
    Iterator localIterator = localResult.iterator();
    try
    {
      Object[] arrayOfObject = (Object[])localIterator.next();
      this.statementID = ((Result)arrayOfObject[0]).getStatementID();
      arrayOfObject = (Object[])localIterator.next();
      this.rsmdDescriptor = ((Result)arrayOfObject[0]);
      this.isRowCount = (this.rsmdDescriptor.mode == 1);
      arrayOfObject = (Object[])localIterator.next();
      this.pmdDescriptor = ((Result)arrayOfObject[0]);
      this.parameterTypes = this.pmdDescriptor.metaData.getParameterTypes();
      this.parameterValues = new Object[this.parameterTypes.length];
      this.parameterSet = new boolean[this.parameterTypes.length];
      this.parameterModes = this.pmdDescriptor.metaData.paramMode;
    }
    catch (Exception localException)
    {
      throw Trace.error(40, localException.toString());
    }
    this.resultOut = new Result(65548, this.parameterTypes, this.statementID);
    this.sql = paramString;
  }

  protected void checkIsRowCount(boolean paramBoolean)
    throws SQLException
  {
    if (paramBoolean != this.isRowCount)
    {
      int i = paramBoolean ? 154 : 155;
      throw Util.sqlException(i);
    }
  }

  protected void checkSetParameterIndex(int paramInt, boolean paramBoolean)
    throws SQLException
  {
    checkClosed();
    if ((paramInt < 1) || (paramInt > this.parameterValues.length))
    {
      String str = "parameter index out of range: " + paramInt;
      throw Util.sqlException(62, str);
    }
    if (paramBoolean)
    {
      if (this.parameterStream == null)
        this.parameterStream = new boolean[this.parameterTypes.length];
      this.parameterStream[(paramInt - 1)] = true;
      this.parameterSet[(paramInt - 1)] = false;
    }
    else
    {
      this.parameterSet[(paramInt - 1)] = true;
    }
  }

  private void checkParametersSet()
    throws SQLException
  {
  }

  private void setParameter(int paramInt, Object paramObject)
    throws SQLException
  {
    checkSetParameterIndex(paramInt, false);
    paramInt--;
    if (paramObject == null)
    {
      this.parameterValues[paramInt] = null;
      return;
    }
    int i = this.parameterTypes[paramInt];
    try
    {
      long l;
      switch (i)
      {
      case 1111:
        paramObject = new JavaObject((Serializable)paramObject);
        break;
      case -4:
      case -3:
      case -2:
        if (!(paramObject instanceof byte[]))
          throw Util.sqlException(Trace.error(95));
        paramObject = new Binary((byte[])paramObject, !this.connection.isNetConn);
        break;
      case 91:
        if ((paramObject instanceof java.util.Date))
        {
          l = HsqlDateTime.getNormalisedDate(((java.util.Date)paramObject).getTime());
          paramObject = new java.sql.Date(l);
        }
        else
        {
          paramObject = Column.convertObject(paramObject, i);
        }
        break;
      case 92:
        if ((paramObject instanceof java.util.Date))
        {
          l = HsqlDateTime.getNormalisedTime(((java.util.Date)paramObject).getTime());
          paramObject = new Time(l);
        }
        else
        {
          paramObject = Column.convertObject(paramObject, i);
        }
        break;
      case 93:
        if ((paramObject instanceof Timestamp))
        {
          l = ((Timestamp)paramObject).getTime();
          int j = ((Timestamp)paramObject).getNanos();
          paramObject = new Timestamp(l);
          ((Timestamp)paramObject).setNanos(j);
        }
        else
        {
          paramObject = Column.convertObject(paramObject, i);
        }
        break;
      default:
        paramObject = Column.convertObject(paramObject, i);
      }
    }
    catch (HsqlException localHsqlException)
    {
      Util.throwError(localHsqlException);
    }
    this.parameterValues[paramInt] = paramObject;
  }

  private void setIntParameter(int paramInt1, int paramInt2)
    throws SQLException
  {
    checkSetParameterIndex(paramInt1, false);
    int i = this.parameterTypes[(paramInt1 - 1)];
    switch (i)
    {
    case -6:
    case 4:
    case 5:
      Integer localInteger = new Integer(paramInt2);
      this.parameterValues[(paramInt1 - 1)] = localInteger;
      break;
    default:
      setLongParameter(paramInt1, paramInt2);
    }
  }

  private void setLongParameter(int paramInt, long paramLong)
    throws SQLException
  {
    checkSetParameterIndex(paramInt, false);
    int i = this.parameterTypes[(paramInt - 1)];
    switch (i)
    {
    case -5:
      Long localLong = new Long(paramLong);
      this.parameterValues[(paramInt - 1)] = localLong;
      break;
    case -2:
    case 1111:
      throw Util.sqlException(Trace.error(95));
    default:
      setParameter(paramInt, new Long(paramLong));
    }
  }

  public void addBatch(String paramString)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public ResultSet executeQuery(String paramString)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public boolean execute(String paramString)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public int executeUpdate(String paramString)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public synchronized void close()
    throws SQLException
  {
    if (isClosed())
      return;
    Object localObject = null;
    try
    {
      if (!this.connection.isClosed)
        this.connection.sessionProxy.execute(Result.newFreeStmtRequest(this.statementID));
    }
    catch (HsqlException localHsqlException)
    {
      localObject = localHsqlException;
    }
    this.parameterValues = null;
    this.parameterSet = null;
    this.parameterStream = null;
    this.parameterTypes = null;
    this.parameterModes = null;
    this.rsmdDescriptor = null;
    this.pmdDescriptor = null;
    this.rsmd = null;
    this.pmd = null;
    super.close();
    if (localObject != null)
      throw Util.sqlException(localObject);
  }

  public String toString()
  {
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append(super.toString());
    String str = this.sql;
    Object[] arrayOfObject = this.parameterValues;
    if ((str == null) || (arrayOfObject == null))
    {
      localStringBuffer.append("[closed]");
      return localStringBuffer.toString();
    }
    localStringBuffer.append("[sql=[").append(str).append("]");
    if (arrayOfObject.length > 0)
    {
      localStringBuffer.append(", parameters=[");
      for (int i = 0; i < arrayOfObject.length; i++)
      {
        localStringBuffer.append('[');
        localStringBuffer.append(arrayOfObject[i]);
        localStringBuffer.append("], ");
      }
      localStringBuffer.setLength(localStringBuffer.length() - 2);
      localStringBuffer.append(']');
    }
    localStringBuffer.append(']');
    return localStringBuffer.toString();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.jdbcPreparedStatement
 * JD-Core Version:    0.6.0
 */