package org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.hsqldb.Result;
import org.hsqldb.Result.ResultMetaData;
import org.hsqldb.Types;

public class jdbcParameterMetaData
  implements ParameterMetaData
{
  Result.ResultMetaData rmd;
  int[] types;
  int[] modes;
  boolean[] isIdentity;
  int[] nullability;
  String[] classNames;
  int parameterCount;

  jdbcParameterMetaData(Result paramResult)
    throws SQLException
  {
    if (paramResult == null)
    {
      this.parameterCount = 0;
      return;
    }
    this.rmd = paramResult.metaData;
    this.types = this.rmd.colTypes;
    this.parameterCount = this.types.length;
    this.nullability = this.rmd.colNullable;
    this.isIdentity = this.rmd.isIdentity;
    this.classNames = this.rmd.classNames;
    this.modes = this.rmd.paramMode;
  }

  void checkRange(int paramInt)
    throws SQLException
  {
    if ((paramInt < 1) || (paramInt > this.parameterCount))
    {
      String str = paramInt + " is out of range";
      throw Util.sqlException(62, str);
    }
  }

  public String getParameterClassName(int paramInt)
    throws SQLException
  {
    checkRange(paramInt);
    paramInt--;
    return this.classNames[paramInt];
  }

  public int getParameterCount()
    throws SQLException
  {
    return this.parameterCount;
  }

  public int getParameterMode(int paramInt)
    throws SQLException
  {
    checkRange(paramInt);
    paramInt--;
    return this.modes[paramInt];
  }

  public int getParameterType(int paramInt)
    throws SQLException
  {
    checkRange(paramInt);
    paramInt--;
    int i = this.types[paramInt];
    return i == 100 ? 12 : i;
  }

  public String getParameterTypeName(int paramInt)
    throws SQLException
  {
    checkRange(paramInt);
    paramInt--;
    return Types.getTypeName(this.types[paramInt]);
  }

  public int getPrecision(int paramInt)
    throws SQLException
  {
    checkRange(paramInt);
    paramInt--;
    return Types.getPrecision(this.types[paramInt]);
  }

  public int getScale(int paramInt)
    throws SQLException
  {
    checkRange(paramInt);
    return 0;
  }

  public int isNullable(int paramInt)
    throws SQLException
  {
    checkRange(paramInt);
    paramInt--;
    return this.nullability[paramInt];
  }

  public boolean isSigned(int paramInt)
    throws SQLException
  {
    checkRange(paramInt);
    paramInt--;
    Boolean localBoolean = Types.isUnsignedAttribute(this.types[paramInt]);
    return (localBoolean != null) && (!localBoolean.booleanValue()) && (this.isIdentity[paramInt] == 0);
  }

  public String toString()
  {
    try
    {
      return toStringImpl();
    }
    catch (Throwable localThrowable)
    {
    }
    return super.toString() + "[toStringImpl_exception=" + localThrowable + "]";
  }

  private String toStringImpl()
    throws Exception
  {
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append(super.toString());
    int i = getParameterCount();
    if (i == 0)
    {
      localStringBuffer.append("[parameterCount=0]");
      return localStringBuffer.toString();
    }
    Method[] arrayOfMethod = getClass().getDeclaredMethods();
    localStringBuffer.append('[');
    int j = arrayOfMethod.length;
    for (int k = 0; k < i; k++)
    {
      localStringBuffer.append('\n');
      localStringBuffer.append("    parameter_");
      localStringBuffer.append(k + 1);
      localStringBuffer.append('=');
      localStringBuffer.append('[');
      for (int m = 0; m < j; m++)
      {
        Method localMethod = arrayOfMethod[m];
        if ((!Modifier.isPublic(localMethod.getModifiers())) || (localMethod.getParameterTypes().length != 1))
          continue;
        localStringBuffer.append(localMethod.getName());
        localStringBuffer.append('=');
        localStringBuffer.append(localMethod.invoke(this, new Object[] { new Integer(k + 1) }));
        if (m + 1 >= j)
          continue;
        localStringBuffer.append(',');
        localStringBuffer.append(' ');
      }
      localStringBuffer.append(']');
      if (k + 1 >= i)
        continue;
      localStringBuffer.append(',');
      localStringBuffer.append(' ');
    }
    localStringBuffer.append('\n');
    localStringBuffer.append(']');
    return localStringBuffer.toString();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.jdbcParameterMetaData
 * JD-Core Version:    0.6.0
 */