package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Result.ResultMetaData;
import org.hsqldb.lib.IntValueHashMap;

public class jdbcCallableStatement extends jdbcPreparedStatement
  implements CallableStatement
{
  private IntValueHashMap parameterNameMap = new IntValueHashMap();

  public jdbcCallableStatement(jdbcConnection paramjdbcConnection, String paramString, int paramInt)
    throws HsqlException, SQLException
  {
    super(paramjdbcConnection, paramString, paramInt);
    if ((this.pmdDescriptor != null) && (this.pmdDescriptor.metaData != null))
    {
      String[] arrayOfString = this.pmdDescriptor.metaData.colNames;
      for (int i = 0; i < arrayOfString.length; i++)
      {
        String str = arrayOfString[i];
        if ((str == null) || (str.length() == 0))
          continue;
        this.parameterNameMap.put(str, i);
      }
    }
  }

  int findParameterIndex(String paramString)
    throws SQLException
  {
    checkClosed();
    int i = this.parameterNameMap.get(paramString, -1);
    if (i >= 0)
      return i + 1;
    throw Util.sqlException(28, paramString);
  }

  public void close()
    throws SQLException
  {
    if (isClosed())
      return;
    this.parameterNameMap = null;
    super.close();
  }

  private void checkGetParameterIndex(int paramInt)
    throws SQLException
  {
    checkClosed();
    if ((paramInt < 1) || (paramInt > this.parameterModes.length))
    {
      String str = "Parameter index out of bounds: " + paramInt;
      throw Util.sqlException(62, str);
    }
  }

  public void registerOutParameter(int paramInt1, int paramInt2)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void registerOutParameter(int paramInt1, int paramInt2, int paramInt3)
    throws SQLException
  {
    registerOutParameter(paramInt1, paramInt2);
  }

  public boolean wasNull()
    throws SQLException
  {
    throw Util.notSupported();
  }

  public String getString(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public boolean getBoolean(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public byte getByte(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public short getShort(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public int getInt(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public long getLong(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public float getFloat(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public double getDouble(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  /** @deprecated */
  public BigDecimal getBigDecimal(int paramInt1, int paramInt2)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public byte[] getBytes(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Date getDate(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Time getTime(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Timestamp getTimestamp(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Object getObject(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public BigDecimal getBigDecimal(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Object getObject(int paramInt, Map paramMap)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Ref getRef(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Blob getBlob(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Clob getClob(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Array getArray(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Date getDate(int paramInt, Calendar paramCalendar)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Time getTime(int paramInt, Calendar paramCalendar)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void registerOutParameter(int paramInt1, int paramInt2, String paramString)
    throws SQLException
  {
    registerOutParameter(paramInt1, paramInt2);
  }

  public void registerOutParameter(String paramString, int paramInt)
    throws SQLException
  {
    registerOutParameter(findParameterIndex(paramString), paramInt);
  }

  public void registerOutParameter(String paramString, int paramInt1, int paramInt2)
    throws SQLException
  {
    registerOutParameter(findParameterIndex(paramString), paramInt1);
  }

  public void registerOutParameter(String paramString1, int paramInt, String paramString2)
    throws SQLException
  {
    registerOutParameter(findParameterIndex(paramString1), paramInt);
  }

  public URL getURL(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void setURL(String paramString, URL paramURL)
    throws SQLException
  {
    setURL(findParameterIndex(paramString), paramURL);
  }

  public void setNull(String paramString, int paramInt)
    throws SQLException
  {
    setNull(findParameterIndex(paramString), paramInt);
  }

  public void setBoolean(String paramString, boolean paramBoolean)
    throws SQLException
  {
    setBoolean(findParameterIndex(paramString), paramBoolean);
  }

  public void setByte(String paramString, byte paramByte)
    throws SQLException
  {
    setByte(findParameterIndex(paramString), paramByte);
  }

  public void setShort(String paramString, short paramShort)
    throws SQLException
  {
    setShort(findParameterIndex(paramString), paramShort);
  }

  public void setInt(String paramString, int paramInt)
    throws SQLException
  {
    setInt(findParameterIndex(paramString), paramInt);
  }

  public void setLong(String paramString, long paramLong)
    throws SQLException
  {
    setLong(findParameterIndex(paramString), paramLong);
  }

  public void setFloat(String paramString, float paramFloat)
    throws SQLException
  {
    setFloat(findParameterIndex(paramString), paramFloat);
  }

  public void setDouble(String paramString, double paramDouble)
    throws SQLException
  {
    setDouble(findParameterIndex(paramString), paramDouble);
  }

  public void setBigDecimal(String paramString, BigDecimal paramBigDecimal)
    throws SQLException
  {
    setBigDecimal(findParameterIndex(paramString), paramBigDecimal);
  }

  public void setString(String paramString1, String paramString2)
    throws SQLException
  {
    setString(findParameterIndex(paramString1), paramString2);
  }

  public void setBytes(String paramString, byte[] paramArrayOfByte)
    throws SQLException
  {
    setBytes(findParameterIndex(paramString), paramArrayOfByte);
  }

  public void setDate(String paramString, Date paramDate)
    throws SQLException
  {
    setDate(findParameterIndex(paramString), paramDate);
  }

  public void setTime(String paramString, Time paramTime)
    throws SQLException
  {
    setTime(findParameterIndex(paramString), paramTime);
  }

  public void setTimestamp(String paramString, Timestamp paramTimestamp)
    throws SQLException
  {
    setTimestamp(findParameterIndex(paramString), paramTimestamp);
  }

  public void setAsciiStream(String paramString, InputStream paramInputStream, int paramInt)
    throws SQLException
  {
    setAsciiStream(findParameterIndex(paramString), paramInputStream, paramInt);
  }

  public void setBinaryStream(String paramString, InputStream paramInputStream, int paramInt)
    throws SQLException
  {
    setBinaryStream(findParameterIndex(paramString), paramInputStream, paramInt);
  }

  public void setObject(String paramString, Object paramObject, int paramInt1, int paramInt2)
    throws SQLException
  {
    setObject(findParameterIndex(paramString), paramObject, paramInt1, paramInt2);
  }

  public void setObject(String paramString, Object paramObject, int paramInt)
    throws SQLException
  {
    setObject(findParameterIndex(paramString), paramObject, paramInt);
  }

  public void setObject(String paramString, Object paramObject)
    throws SQLException
  {
    setObject(findParameterIndex(paramString), paramObject);
  }

  public void setCharacterStream(String paramString, Reader paramReader, int paramInt)
    throws SQLException
  {
    setCharacterStream(findParameterIndex(paramString), paramReader, paramInt);
  }

  public void setDate(String paramString, Date paramDate, Calendar paramCalendar)
    throws SQLException
  {
    setDate(findParameterIndex(paramString), paramDate, paramCalendar);
  }

  public void setTime(String paramString, Time paramTime, Calendar paramCalendar)
    throws SQLException
  {
    setTime(findParameterIndex(paramString), paramTime, paramCalendar);
  }

  public void setTimestamp(String paramString, Timestamp paramTimestamp, Calendar paramCalendar)
    throws SQLException
  {
    setTimestamp(findParameterIndex(paramString), paramTimestamp, paramCalendar);
  }

  public void setNull(String paramString1, int paramInt, String paramString2)
    throws SQLException
  {
    setNull(findParameterIndex(paramString1), paramInt, paramString2);
  }

  public String getString(String paramString)
    throws SQLException
  {
    return getString(findParameterIndex(paramString));
  }

  public boolean getBoolean(String paramString)
    throws SQLException
  {
    return getBoolean(findParameterIndex(paramString));
  }

  public byte getByte(String paramString)
    throws SQLException
  {
    return getByte(findParameterIndex(paramString));
  }

  public short getShort(String paramString)
    throws SQLException
  {
    return getShort(findParameterIndex(paramString));
  }

  public int getInt(String paramString)
    throws SQLException
  {
    return getInt(findParameterIndex(paramString));
  }

  public long getLong(String paramString)
    throws SQLException
  {
    return getLong(findParameterIndex(paramString));
  }

  public float getFloat(String paramString)
    throws SQLException
  {
    return getFloat(findParameterIndex(paramString));
  }

  public double getDouble(String paramString)
    throws SQLException
  {
    return getDouble(findParameterIndex(paramString));
  }

  public byte[] getBytes(String paramString)
    throws SQLException
  {
    return getBytes(findParameterIndex(paramString));
  }

  public Date getDate(String paramString)
    throws SQLException
  {
    return getDate(findParameterIndex(paramString));
  }

  public Time getTime(String paramString)
    throws SQLException
  {
    return getTime(findParameterIndex(paramString));
  }

  public Timestamp getTimestamp(String paramString)
    throws SQLException
  {
    return getTimestamp(findParameterIndex(paramString));
  }

  public Object getObject(String paramString)
    throws SQLException
  {
    return getObject(findParameterIndex(paramString));
  }

  public BigDecimal getBigDecimal(String paramString)
    throws SQLException
  {
    return getBigDecimal(findParameterIndex(paramString));
  }

  public Object getObject(String paramString, Map paramMap)
    throws SQLException
  {
    return getObject(findParameterIndex(paramString), paramMap);
  }

  public Ref getRef(String paramString)
    throws SQLException
  {
    return getRef(findParameterIndex(paramString));
  }

  public Blob getBlob(String paramString)
    throws SQLException
  {
    return getBlob(findParameterIndex(paramString));
  }

  public Clob getClob(String paramString)
    throws SQLException
  {
    return getClob(findParameterIndex(paramString));
  }

  public Array getArray(String paramString)
    throws SQLException
  {
    return getArray(findParameterIndex(paramString));
  }

  public Date getDate(String paramString, Calendar paramCalendar)
    throws SQLException
  {
    return getDate(findParameterIndex(paramString), paramCalendar);
  }

  public Time getTime(String paramString, Calendar paramCalendar)
    throws SQLException
  {
    return getTime(findParameterIndex(paramString), paramCalendar);
  }

  public Timestamp getTimestamp(String paramString, Calendar paramCalendar)
    throws SQLException
  {
    return getTimestamp(findParameterIndex(paramString), paramCalendar);
  }

  public URL getURL(String paramString)
    throws SQLException
  {
    return getURL(findParameterIndex(paramString));
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.jdbcCallableStatement
 * JD-Core Version:    0.6.0
 */