package org.hsqldb;

import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.resources.BundleHandler;

public class WebServer extends Server
{
  static int webBundleHandle = BundleHandler.getBundleHandle("webserver", null);

  public WebServer()
  {
    super(0);
  }

  public static void main(String[] paramArrayOfString)
  {
    String str = FileUtil.canonicalOrAbsolutePath("webserver");
    HsqlProperties localHsqlProperties1 = ServerConfiguration.getPropertiesFromFile(str);
    HsqlProperties localHsqlProperties2 = localHsqlProperties1 == null ? new HsqlProperties() : localHsqlProperties1;
    HsqlProperties localHsqlProperties3 = null;
    try
    {
      localHsqlProperties3 = HsqlProperties.argArrayToProps(paramArrayOfString, "server");
    }
    catch (ArrayIndexOutOfBoundsException localArrayIndexOutOfBoundsException)
    {
      printHelp("webserver.help");
      return;
    }
    if (localHsqlProperties3 != null)
    {
      if (localHsqlProperties3.getErrorKeys().length != 0)
      {
        printHelp("webserver.help");
        return;
      }
      localHsqlProperties2.addProperties(localHsqlProperties3);
    }
    ServerConfiguration.translateDefaultDatabaseProperty(localHsqlProperties2);
    ServerConfiguration.translateDefaultNoSystemExitProperty(localHsqlProperties2);
    WebServer localWebServer = new WebServer();
    try
    {
      localWebServer.setProperties(localHsqlProperties2);
    }
    catch (Exception localException)
    {
      localWebServer.printError("Failed to set properties");
      localWebServer.printStackTrace(localException);
      return;
    }
    localWebServer.print("Startup sequence initiated from main() method");
    if (localHsqlProperties1 != null)
    {
      localWebServer.print("Loaded properties from [" + str + ".properties]");
    }
    else
    {
      localWebServer.print("Could not load properties from file");
      localWebServer.print("Using cli/default properties only");
    }
    localWebServer.start();
  }

  public String getDefaultWebPage()
  {
    return this.serverProperties.getProperty("server.default_page");
  }

  public String getHelpString()
  {
    return BundleHandler.getString(serverBundleHandle, "webserver.help");
  }

  public String getProductName()
  {
    return "HSQLDB web server";
  }

  public String getProtocol()
  {
    return isTls() ? "HTTPS" : "HTTP";
  }

  public String getWebRoot()
  {
    return this.serverProperties.getProperty("server.root");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.WebServer
 * JD-Core Version:    0.6.0
 */