package org.hsqldb;

import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;

class UserManager
  implements GrantConstants
{
  User sysUser = null;
  private HashMappedList userList;
  private GranteeManager granteeManager;

  UserManager(Database paramDatabase)
    throws HsqlException
  {
    this.granteeManager = paramDatabase.getGranteeManager();
    this.userList = new HashMappedList();
    createUser("PUBLIC", null);
    this.sysUser = createUser("_SYSTEM", null);
    this.sysUser.getGrantee().setAdminDirect();
  }

  User createUser(String paramString1, String paramString2)
    throws HsqlException
  {
    if (paramString1 == null)
      Trace.doAssert(false, Trace.getMessage(236));
    Grantee localGrantee = this.granteeManager.addGrantee(paramString1);
    User localUser = new User(paramString1, paramString2, localGrantee);
    if ("_SYSTEM".equals(paramString1))
      return localUser;
    boolean bool = this.userList.add(paramString1, localUser);
    if (!bool)
      throw Trace.error(36, paramString1);
    return localUser;
  }

  void dropUser(String paramString)
    throws HsqlException
  {
    boolean bool1 = GranteeManager.isReserved(paramString);
    Trace.check(!bool1, 231, paramString);
    boolean bool2 = this.granteeManager.removeGrantee(paramString);
    Trace.check(bool2, 232, paramString);
    User localUser = (User)this.userList.remove(paramString);
    Trace.check(localUser != null, 37, paramString);
  }

  User getUser(String paramString1, String paramString2)
    throws HsqlException
  {
    if (paramString1 == null)
      paramString1 = "";
    if (paramString2 == null)
      paramString2 = "";
    if (paramString1.equals("PUBLIC"))
      throw Trace.error(33);
    paramString1 = paramString1.toUpperCase();
    paramString2 = paramString2.toUpperCase();
    User localUser = get(paramString1);
    localUser.checkPassword(paramString2);
    return localUser;
  }

  HashMappedList getUsers()
  {
    return this.userList;
  }

  boolean exists(String paramString)
  {
    return this.userList.get(paramString) != null;
  }

  User get(String paramString)
    throws HsqlException
  {
    User localUser = (User)this.userList.get(paramString);
    if (localUser == null)
      throw Trace.error(37, paramString);
    return localUser;
  }

  HsqlArrayList listVisibleUsers(Session paramSession, boolean paramBoolean)
  {
    HsqlArrayList localHsqlArrayList = new HsqlArrayList();
    boolean bool = paramSession.isAdmin();
    String str1 = paramSession.getUsername();
    if ((this.userList == null) || (this.userList.size() == 0))
      return localHsqlArrayList;
    for (int i = 0; i < this.userList.size(); i++)
    {
      User localUser = (User)this.userList.get(i);
      if (localUser == null)
        continue;
      String str2 = localUser.getName();
      if ("PUBLIC".equals(str2))
      {
        if (!paramBoolean)
          continue;
        localHsqlArrayList.add(localUser);
      }
      else if (bool)
      {
        localHsqlArrayList.add(localUser);
      }
      else
      {
        if (!str1.equals(str2))
          continue;
        localHsqlArrayList.add(localUser);
      }
    }
    return localHsqlArrayList;
  }

  static String[] getRightsArray(int paramInt)
  {
    return GranteeManager.getRightsArray(paramInt);
  }

  void removeDbObject(Object paramObject)
  {
    this.granteeManager.removeDbObject(paramObject);
  }

  User getSysUser()
  {
    return this.sysUser;
  }

  public synchronized void removeSchemaReference(SchemaManager.Schema paramSchema)
  {
    for (int i = 0; i < this.userList.size(); i++)
    {
      User localUser = (User)this.userList.get(i);
      if (localUser.getInitialSchema() != paramSchema.name)
        continue;
      localUser.setInitialSchema(null);
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.UserManager
 * JD-Core Version:    0.6.0
 */