package org.hsqldb;

import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.IntValueHashMap;

public class User
{
  private boolean isSys;
  private boolean isPublic;
  private String sName;
  private String sPassword;
  private HsqlNameManager.HsqlName initialSchema = null;
  private Grantee grantee;

  User(String paramString1, String paramString2, Grantee paramGrantee)
    throws HsqlException
  {
    this.sName = paramString1;
    this.grantee = paramGrantee;
    int i = (this.grantee != null) || (GranteeManager.isReserved(paramString1)) ? 1 : 0;
    if (i == 0)
      Trace.doAssert(false, Trace.getMessage(234) + ": " + paramString1);
    setPassword(paramString2);
    this.isSys = paramString1.equals("_SYSTEM");
    this.isPublic = paramString1.equals("PUBLIC");
  }

  String getName()
  {
    return this.sName;
  }

  void setPassword(String paramString)
    throws HsqlException
  {
    this.sPassword = paramString;
  }

  void checkPassword(String paramString)
    throws HsqlException
  {
    Trace.check(paramString.equals(this.sPassword), 33);
  }

  boolean isSys()
  {
    return this.isSys;
  }

  HsqlNameManager.HsqlName getInitialSchema()
  {
    return this.initialSchema;
  }

  void setInitialSchema(HsqlNameManager.HsqlName paramHsqlName)
  {
    this.initialSchema = paramHsqlName;
  }

  boolean isPublic()
  {
    return this.isPublic;
  }

  String getAlterUserDDL()
  {
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append("ALTER").append(' ');
    localStringBuffer.append("USER").append(' ');
    localStringBuffer.append(this.sName).append(' ');
    localStringBuffer.append("SET").append(' ');
    localStringBuffer.append("PASSWORD").append(' ');
    localStringBuffer.append('"').append(this.sPassword).append('"');
    return localStringBuffer.toString();
  }

  String getCreateUserDDL()
  {
    StringBuffer localStringBuffer = new StringBuffer(64);
    localStringBuffer.append("CREATE").append(' ');
    localStringBuffer.append("USER").append(' ');
    localStringBuffer.append(this.sName).append(' ');
    localStringBuffer.append("PASSWORD").append(' ');
    localStringBuffer.append('"').append(this.sPassword).append('"');
    return localStringBuffer.toString();
  }

  public String getConnectStatement()
  {
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append("CONNECT").append(' ');
    localStringBuffer.append("USER").append(' ');
    localStringBuffer.append(this.sName);
    return localStringBuffer.toString();
  }

  Grantee getGrantee()
  {
    return this.grantee;
  }

  void setGrantee(Grantee paramGrantee)
    throws HsqlException
  {
    if (this.grantee != null)
      Trace.doAssert(false, Trace.getMessage(235) + ": " + this.sName);
    this.grantee = paramGrantee;
  }

  boolean isAdmin()
  {
    return this.grantee.isAdmin();
  }

  String[] listGrantedTablePrivileges(HsqlNameManager.HsqlName paramHsqlName)
  {
    return this.grantee.listGrantedTablePrivileges(paramHsqlName);
  }

  HashSet getGrantedClassNames(boolean paramBoolean)
    throws HsqlException
  {
    return this.grantee.getGrantedClassNames(paramBoolean);
  }

  IntValueHashMap getRights()
  {
    return this.grantee.getRights();
  }

  void checkAdmin()
    throws HsqlException
  {
    this.grantee.checkAdmin();
  }

  void check(HsqlNameManager.HsqlName paramHsqlName, int paramInt)
    throws HsqlException
  {
    this.grantee.check(paramHsqlName, paramInt);
  }

  void check(String paramString)
    throws HsqlException
  {
    this.grantee.check(paramString);
  }

  boolean isAccessible(HsqlNameManager.HsqlName paramHsqlName, int paramInt)
    throws HsqlException
  {
    return this.grantee.isAccessible(paramHsqlName, paramInt);
  }

  boolean isAccessible(String paramString)
    throws HsqlException
  {
    return this.grantee.isAccessible(paramString);
  }

  boolean isAccessible(HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    return this.grantee.isAccessible(paramHsqlName);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.User
 * JD-Core Version:    0.6.0
 */