package org.hsqldb;

import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongKeyIntValueHashMap;

public class TransactionManager
{
  LongKeyIntValueHashMap rowSessionMap;
  boolean reWriteProtect;
  Database database;
  private long globalActionTimestamp = 0L;

  TransactionManager(Database paramDatabase)
  {
    this.database = paramDatabase;
    this.rowSessionMap = new LongKeyIntValueHashMap(true);
  }

  public void setReWriteProtection(boolean paramBoolean)
  {
    this.reWriteProtect = paramBoolean;
  }

  void checkDelete(Session paramSession, Row paramRow)
    throws HsqlException
  {
  }

  void checkDelete(Session paramSession, HashMappedList paramHashMappedList)
    throws HsqlException
  {
    if (!this.reWriteProtect)
      return;
    int i = paramSession.getId();
    int j = 0;
    int k = paramHashMappedList.size();
    while (j < k)
    {
      Row localRow = (Row)paramHashMappedList.getKey(j);
      long l = localRow.getId();
      if (this.rowSessionMap.get(l, i) != i)
        throw Trace.error(117, 122);
      j++;
    }
  }

  void checkDelete(Session paramSession, HsqlArrayList paramHsqlArrayList)
    throws HsqlException
  {
    if (!this.reWriteProtect)
      return;
    int i = paramSession.getId();
    int j = 0;
    int k = paramHsqlArrayList.size();
    while (j < k)
    {
      Row localRow = (Row)paramHsqlArrayList.get(j);
      long l = localRow.getId();
      if (this.rowSessionMap.get(l, i) != i)
        throw Trace.error(117, 122);
      j++;
    }
  }

  void commit(Session paramSession)
  {
    Object[] arrayOfObject = paramSession.rowActionList.getArray();
    int i = paramSession.rowActionList.size();
    for (int j = 0; j < i; j++)
    {
      Transaction localTransaction = (Transaction)arrayOfObject[j];
      long l = localTransaction.row.getId();
      localTransaction.commit(paramSession);
      this.rowSessionMap.remove(l);
    }
    paramSession.rowActionList.clear();
    paramSession.savepoints.clear();
  }

  synchronized void rollback(Session paramSession)
  {
    rollbackTransactions(paramSession, 0, false);
    paramSession.savepoints.clear();
  }

  void rollbackSavepoint(Session paramSession, String paramString)
    throws HsqlException
  {
    int i = paramSession.savepoints.getIndex(paramString);
    if (i < 0)
      throw Trace.error(44, paramString);
    Integer localInteger = (Integer)paramSession.savepoints.get(i);
    int j = localInteger.intValue();
    rollbackTransactions(paramSession, j, false);
    while (paramSession.savepoints.size() > i)
      paramSession.savepoints.remove(paramSession.savepoints.size() - 1);
  }

  void rollbackTransactions(Session paramSession, int paramInt, boolean paramBoolean)
  {
    Object[] arrayOfObject = paramSession.rowActionList.getArray();
    int i = paramSession.rowActionList.size();
    Transaction localTransaction;
    for (int j = i - 1; j >= paramInt; j--)
    {
      localTransaction = (Transaction)arrayOfObject[j];
      localTransaction.rollback(paramSession, paramBoolean);
    }
    for (j = paramInt; j < i; j++)
    {
      localTransaction = (Transaction)arrayOfObject[j];
      long l = localTransaction.row.getId();
      this.rowSessionMap.remove(l);
    }
    paramSession.rowActionList.setSize(paramInt);
  }

  void addTransaction(Session paramSession, Transaction paramTransaction)
  {
    if (this.reWriteProtect)
      this.rowSessionMap.put(paramTransaction.row.getId(), paramSession.getId());
  }

  long nextActionTimestamp()
  {
    this.globalActionTimestamp += 1L;
    return this.globalActionTimestamp;
  }

  Transaction[] getTransactionList()
  {
    Session[] arrayOfSession = this.database.sessionManager.getAllSessions();
    int[] arrayOfInt = new int[arrayOfSession.length];
    int i = 0;
    int j = 0;
    for (int k = 0; k < arrayOfSession.length; k++)
      j += arrayOfSession[k].getTransactionSize();
    Transaction[] arrayOfTransaction = new Transaction[j];
    label236: 
    while (true)
    {
      j = 0;
      long l = 9223372036854775807L;
      int m = 0;
      for (int n = 0; n < arrayOfSession.length; n++)
      {
        int i1 = arrayOfSession[n].getTransactionSize();
        if (arrayOfInt[n] >= i1)
          continue;
        Transaction localTransaction2 = (Transaction)arrayOfSession[n].rowActionList.get(arrayOfInt[n]);
        if (localTransaction2.SCN < l)
        {
          l = localTransaction2.SCN;
          m = n;
        }
        j = 1;
      }
      if (j == 0)
        break;
      HsqlArrayList localHsqlArrayList = arrayOfSession[m].rowActionList;
      while (true)
      {
        if (arrayOfInt[m] >= localHsqlArrayList.size())
          break label236;
        Transaction localTransaction1 = (Transaction)localHsqlArrayList.get(arrayOfInt[m]);
        if (localTransaction1.SCN == l + 1L)
          l += 1L;
        if (localTransaction1.SCN != l)
          break;
        arrayOfTransaction[(i++)] = localTransaction1;
        arrayOfInt[m] += 1;
      }
    }
    return arrayOfTransaction;
  }

  public DoubleIntIndex getTransactionIDList()
  {
    Session[] arrayOfSession = this.database.sessionManager.getAllSessions();
    DoubleIntIndex localDoubleIntIndex = new DoubleIntIndex(10, false);
    localDoubleIntIndex.setKeysSearchTarget();
    for (int i = 0; i < arrayOfSession.length; i++)
    {
      HsqlArrayList localHsqlArrayList = arrayOfSession[i].rowActionList;
      int j = 0;
      int k = localHsqlArrayList.size();
      while (j < k)
      {
        Transaction localTransaction = (Transaction)localHsqlArrayList.get(j);
        if (localTransaction.tTable.getTableType() == 4)
          localDoubleIntIndex.addUnique(localTransaction.row.getPos(), 0);
        j++;
      }
    }
    return localDoubleIntIndex;
  }

  public void convertTransactionIDs(DoubleIntIndex paramDoubleIntIndex)
  {
    Session[] arrayOfSession = this.database.sessionManager.getAllSessions();
    for (int i = 0; i < arrayOfSession.length; i++)
    {
      HsqlArrayList localHsqlArrayList = arrayOfSession[i].rowActionList;
      int j = 0;
      int k = localHsqlArrayList.size();
      while (j < k)
      {
        Transaction localTransaction = (Transaction)localHsqlArrayList.get(j);
        if (localTransaction.tTable.getTableType() == 4)
        {
          int m = paramDoubleIntIndex.lookupFirstEqual(localTransaction.row.getPos());
          localTransaction.row.setPos(m);
        }
        j++;
      }
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.TransactionManager
 * JD-Core Version:    0.6.0
 */