package org.hsqldb;

import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;

final class TableFilter
{
  static final int CONDITION_NONE = -1;
  static final int CONDITION_UNORDERED = 0;
  static final int CONDITION_START_END = 1;
  static final int CONDITION_START = 2;
  static final int CONDITION_END = 3;
  static final int CONDITION_OUTER = 4;
  Table filterTable;
  private String tableAlias;
  HashMappedList columnAliases;
  Index filterIndex;
  private Object[] emptyData;
  boolean[] usedColumns;
  private Expression eStart;
  private Expression eEnd;
  Expression eAnd;
  boolean isOuterJoin;
  boolean isAssigned;
  boolean isMultiFindFirst;
  Expression[] findFirstExpressions;
  private RowIterator it;
  Object[] currentData;
  Row currentRow;
  Object[] currentJoinData;
  boolean nonJoinIsNull;
  boolean isCurrentOuter;

  TableFilter(Table paramTable, String paramString, HashMappedList paramHashMappedList, boolean paramBoolean)
  {
    this.filterTable = paramTable;
    this.tableAlias = (paramString == null ? paramTable.getName().name : paramString);
    this.columnAliases = paramHashMappedList;
    this.isOuterJoin = paramBoolean;
    this.emptyData = this.filterTable.getEmptyRowData();
    this.usedColumns = this.filterTable.getNewColumnCheckList();
  }

  String getName()
  {
    return this.tableAlias;
  }

  Table getTable()
  {
    return this.filterTable;
  }

  static int getConditionType(Expression paramExpression)
  {
    int i = paramExpression.getType();
    switch (i)
    {
    case 26:
    case 27:
      return 0;
    case 30:
      return paramExpression.isQueryCorrelated ? -1 : 0;
    case 21:
    case 34:
      return 1;
    case 22:
    case 23:
      return 2;
    case 24:
    case 25:
      return 3;
    case 28:
    case 29:
    case 31:
    case 32:
    case 33:
    }
    return -1;
  }

  void setConditions(Session paramSession, Expression paramExpression)
    throws HsqlException
  {
    setCondition(paramSession, paramExpression);
    if (this.filterIndex == null)
      this.filterIndex = this.filterTable.getPrimaryIndex();
    if ((this.filterIndex.getVisibleColumns() == 1) || (this.eStart == null) || (this.eAnd == null) || (this.eStart.exprType != 21))
      return;
    boolean[] arrayOfBoolean = this.filterTable.getNewColumnCheckList();
    Expression[] arrayOfExpression = new Expression[arrayOfBoolean.length];
    int i = this.eStart.getArg().getColumnNr();
    arrayOfBoolean[i] = true;
    arrayOfExpression[i] = this.eStart.getArg2();
    this.eAnd.getEquiJoinColumns(this, arrayOfBoolean, arrayOfExpression);
    if (ArrayUtil.containsAllTrueElements(arrayOfBoolean, this.filterIndex.colCheck))
    {
      this.isMultiFindFirst = true;
      this.findFirstExpressions = arrayOfExpression;
    }
  }

  private void setCondition(Session paramSession, Expression paramExpression)
    throws HsqlException
  {
    int i = paramExpression.getType();
    Expression localExpression1 = paramExpression.getArg();
    Expression localExpression2 = paramExpression.getArg2();
    this.isAssigned = true;
    if (i == 28)
    {
      setCondition(paramSession, localExpression1);
      setCondition(paramSession, localExpression2);
      return;
    }
    if ((i == 29) && (this.isOuterJoin) && (paramExpression.isInJoin) && (paramExpression.outerFilter == this))
    {
      addAndCondition(paramExpression);
      paramExpression.setTrue();
      return;
    }
    int j = getConditionType(paramExpression);
    if (j == -1)
      return;
    if ((localExpression1.getFilter() == this) && (localExpression2.getFilter() == this))
    {
      j = 0;
    }
    else if (localExpression1.getFilter() == this)
    {
      if ((!paramExpression.isInJoin) && (this.isOuterJoin))
        return;
    }
    else
    {
      if ((localExpression2.getFilter() == this) && (j != 0))
      {
        paramExpression.swapCondition();
        setCondition(paramSession, paramExpression);
        return;
      }
      if (localExpression1.outerFilter == this)
        j = 4;
      else
        return;
    }
    if (!localExpression2.isResolved())
      return;
    if ((localExpression1.outerFilter != null) && (localExpression1.outerFilter != this))
      return;
    if (j == 0)
    {
      addAndCondition(paramExpression);
      return;
    }
    if (j == 4)
    {
      addAndCondition(paramExpression);
      return;
    }
    int k = localExpression1.getColumnNr();
    Index localIndex = this.filterTable.getIndexForColumn(paramSession, k);
    if ((localIndex == null) || ((this.filterIndex != localIndex) && (this.filterIndex != null)))
    {
      addAndCondition(paramExpression);
      return;
    }
    this.filterIndex = localIndex;
    switch (j)
    {
    case 1:
      if ((this.eStart != null) || (this.eEnd != null))
      {
        addAndCondition(paramExpression);
        return;
      }
      this.eStart = new Expression(paramExpression);
      this.eEnd = this.eStart;
      break;
    case 2:
      if (this.eStart != null)
      {
        addAndCondition(paramExpression);
        return;
      }
      this.eStart = new Expression(paramExpression);
      break;
    case 3:
      if (this.eEnd != null)
      {
        addAndCondition(paramExpression);
        return;
      }
      this.eEnd = new Expression(paramExpression);
    }
    paramExpression.setTrue();
  }

  boolean findFirst(Session paramSession)
    throws HsqlException
  {
    this.nonJoinIsNull = false;
    this.isCurrentOuter = false;
    if (this.filterIndex == null)
      this.filterIndex = this.filterTable.getPrimaryIndex();
    int k;
    if (this.isMultiFindFirst)
    {
      int i = 1;
      int[] arrayOfInt = this.filterTable.getColumnTypes();
      this.currentJoinData = this.filterTable.getEmptyRowData();
      for (k = 0; k < this.findFirstExpressions.length; k++)
      {
        Expression localExpression = this.findFirstExpressions[k];
        if (localExpression == null)
          continue;
        Object localObject2 = localExpression.getValue(paramSession);
        if (Column.compareToTypeRange(localObject2, arrayOfInt[k]) != 0)
        {
          i = 0;
          break;
        }
        localObject2 = Column.convertObject(localObject2, arrayOfInt[k]);
        this.currentJoinData[k] = localExpression.getValue(paramSession, arrayOfInt[k]);
      }
      this.it = (i != 0 ? this.filterIndex.findFirstRow(paramSession, this.currentJoinData) : this.filterIndex.emptyIterator());
      if (!this.it.hasNext())
        ArrayUtil.clearArray(76, this.currentJoinData, 0, this.currentJoinData.length);
    }
    else if (this.eStart == null)
    {
      this.it = (this.eEnd == null ? this.filterIndex.firstRow(paramSession) : this.filterIndex.findFirstRowNotNull(paramSession));
    }
    else
    {
      Object localObject1 = this.eStart.getArg2().getValue(paramSession);
      int j = this.eStart.getArg2().getDataType();
      k = this.eStart.getArg().getDataType();
      this.it = getFirstIterator(paramSession, this.eStart.getType(), localObject1, j, this.filterIndex, k);
    }
    while (true)
    {
      this.currentRow = this.it.next();
      if (this.currentRow == null)
        break;
      this.currentData = this.currentRow.getData();
      if ((this.eEnd != null) && (!this.eEnd.testCondition(paramSession)))
        break;
      if ((this.eAnd == null) || (this.eAnd.testCondition(paramSession)))
        return true;
    }
    this.currentRow = null;
    this.currentData = this.emptyData;
    return false;
  }

  static RowIterator getFirstIterator(Session paramSession, int paramInt1, Object paramObject, int paramInt2, Index paramIndex, int paramInt3)
    throws HsqlException
  {
    int i = 0;
    if (paramInt3 != paramInt2)
      i = Column.compareToTypeRange(paramObject, paramInt3);
    RowIterator localRowIterator;
    if (i == 0)
    {
      paramObject = Column.convertObject(paramObject, paramInt3);
      localRowIterator = paramIndex.findFirstRow(paramSession, paramObject, paramInt1);
    }
    else
    {
      switch (paramInt1)
      {
      case 22:
      case 23:
        if (i >= 0)
          break;
        localRowIterator = paramIndex.findFirstRowNotNull(paramSession);
        break;
      }
      localRowIterator = paramIndex.emptyIterator();
    }
    return localRowIterator;
  }

  boolean next(Session paramSession)
    throws HsqlException
  {
    int i = 0;
    this.nonJoinIsNull = false;
    this.isCurrentOuter = false;
    while (true)
    {
      this.currentRow = this.it.next();
      if (this.currentRow == null)
        break;
      this.currentData = this.currentRow.getData();
      if ((this.eEnd != null) && (!this.eEnd.testCondition(paramSession)))
        break;
      if ((this.eAnd != null) && (!this.eAnd.testCondition(paramSession)))
        continue;
      i = 1;
    }
    if (i != 0)
      return true;
    this.currentRow = null;
    this.currentData = this.emptyData;
    return false;
  }

  boolean nextOuter(Session paramSession)
    throws HsqlException
  {
    this.nonJoinIsNull = false;
    this.isCurrentOuter = true;
    this.currentData = this.emptyData;
    this.currentRow = null;
    return (this.eAnd == null) || ((this.eAnd.getFilter() != this) && (this.eAnd.isInJoin)) || (this.eAnd.testCondition(paramSession));
  }

  private void addAndCondition(Expression paramExpression)
  {
    Expression localExpression1 = new Expression(paramExpression);
    if (this.eAnd == null)
    {
      this.eAnd = localExpression1;
    }
    else
    {
      Expression localExpression2 = new Expression(28, this.eAnd, localExpression1);
      this.eAnd = localExpression2;
    }
    paramExpression.setTrue();
  }

  void setAsCheckFilter()
  {
    this.filterIndex = null;
  }

  public String describe(Session paramSession)
  {
    StringBuffer localStringBuffer = new StringBuffer();
    Object localObject = this.filterIndex;
    Index localIndex = this.filterTable.getPrimaryIndex();
    int[] arrayOfInt = this.filterTable.getPrimaryKey();
    int i = 0;
    int j = (this.eStart == null) && (this.eEnd == null) ? 1 : 0;
    if (localObject == null)
      localObject = localIndex;
    if ((localObject == localIndex) && (arrayOfInt.length == 0))
    {
      i = 1;
      j = 1;
    }
    localStringBuffer.append(super.toString()).append('\n');
    localStringBuffer.append("table=[").append(this.filterTable.getName().name).append("]\n");
    localStringBuffer.append("alias=[").append(this.tableAlias).append("]\n");
    localStringBuffer.append("access=[").append(j != 0 ? "FULL SCAN" : "INDEX PRED").append("]\n");
    localStringBuffer.append("index=[");
    localStringBuffer.append(((Index)localObject).getName() == null ? "UNNAMED" : localObject == null ? "NONE" : ((Index)localObject).getName().name);
    localStringBuffer.append(i != 0 ? "[HIDDEN]]\n" : "]\n");
    localStringBuffer.append("isOuterJoin=[").append(this.isOuterJoin).append("]\n");
    String str = this.eStart == null ? "null" : this.eStart.describe(paramSession);
    localStringBuffer.append("eStart=[").append(str).append("]\n");
    str = this.eEnd == null ? "null" : this.eEnd.describe(paramSession);
    localStringBuffer.append("eEnd=[").append(str).append("]\n");
    str = this.eAnd == null ? "null" : this.eAnd.describe(paramSession);
    localStringBuffer.append("eAnd=[").append(str).append("]");
    return (String)localStringBuffer.toString();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.TableFilter
 * JD-Core Version:    0.6.0
 */