package org.hsqldb;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import org.hsqldb.lib.HashSet;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

class ServerConnection
  implements Runnable
{
  boolean keepAlive;
  private String user;
  private String password;
  int dbID;
  private volatile Session session;
  private Socket socket;
  private Server server;
  private DataInputStream dataInput;
  private BufferedOutputStream dataOutput;
  private static int mCurrentThread = 0;
  private int mThread;
  static final int BUFFER_SIZE = 4096;
  final byte[] mainBuffer = new byte[4096];
  RowOutputBinary rowOut = new RowOutputBinary(4096);
  RowInputBinary rowIn = new RowInputBinary(this.rowOut);
  Thread runnerThread;

  ServerConnection(Socket paramSocket, Server paramServer)
  {
    this.socket = paramSocket;
    this.server = paramServer;
    synchronized (ServerConnection.class)
    {
      this.mThread = (mCurrentThread++);
    }
    synchronized (paramServer.serverConnSet)
    {
      paramServer.serverConnSet.add(this);
    }
  }

  void signalClose()
  {
    this.keepAlive = false;
    if (!Thread.currentThread().equals(this.runnerThread))
      close();
  }

  private void close()
  {
    if (this.session != null)
    {
      this.session.close();
      this.session = null;
    }
    try
    {
      this.socket.close();
    }
    catch (IOException localIOException)
    {
    }
    this.socket = null;
    synchronized (this.server.serverConnSet)
    {
      this.server.serverConnSet.remove(this);
    }
  }

  private void init()
  {
    this.runnerThread = Thread.currentThread();
    this.keepAlive = true;
    try
    {
      this.socket.setTcpNoDelay(true);
      this.dataInput = new DataInputStream(this.socket.getInputStream());
      this.dataOutput = new BufferedOutputStream(this.socket.getOutputStream());
      Result localResult1 = Result.read(this.rowIn, this.dataInput);
      Result localResult2;
      try
      {
        this.dbID = this.server.getDBID(localResult1.subSubString);
        this.user = localResult1.getMainString();
        this.password = localResult1.getSubString();
        if (!this.server.isSilent())
          this.server.printWithThread(this.mThread + ":trying to connect user " + this.user);
        this.session = DatabaseManager.newSession(this.dbID, localResult1.getMainString(), localResult1.getSubString());
        localResult2 = new Result(1);
        localResult2.databaseID = this.session.getDatabase().databaseID;
        localResult2.sessionID = this.session.getId();
      }
      catch (HsqlException localHsqlException)
      {
        this.session = null;
        localResult2 = new Result(localHsqlException, null);
      }
      catch (RuntimeException localRuntimeException)
      {
        this.session = null;
        localResult2 = new Result(localRuntimeException, null);
      }
      Result.write(localResult2, this.rowOut, this.dataOutput);
      return;
    }
    catch (Exception localException)
    {
      this.server.printWithThread(this.mThread + ":couldn't connect " + this.user);
      close();
    }
  }

  public void run()
  {
    init();
    if (this.session != null)
      try
      {
        while (this.keepAlive)
        {
          Result localResult1 = Result.read(this.rowIn, this.dataInput);
          this.server.printRequest(this.mThread, localResult1);
          Result localResult2;
          if (localResult1.mode == 10)
            localResult2 = resetSession();
          else
            localResult2 = this.session.execute(localResult1);
          Result.write(localResult2, this.rowOut, this.dataOutput);
          this.rowOut.setBuffer(this.mainBuffer);
          this.rowIn.resetRow(this.mainBuffer.length);
        }
      }
      catch (IOException localIOException)
      {
        this.server.printWithThread(this.mThread + ":disconnected " + this.user);
      }
      catch (HsqlException localHsqlException)
      {
        this.server.printStackTrace(localHsqlException);
      }
    close();
  }

  private Result resetSession()
  {
    if (!this.server.isSilent())
      this.server.printWithThread(this.mThread + ":trying to connect user " + this.user);
    Result localResult;
    try
    {
      this.session.close();
      this.session = DatabaseManager.newSession(this.dbID, this.user, this.password);
      localResult = new Result(1);
      localResult.databaseID = this.session.getDatabase().databaseID;
      localResult.sessionID = this.session.getId();
    }
    catch (HsqlException localHsqlException)
    {
      this.session = null;
      localResult = new Result(localHsqlException, null);
    }
    return localResult;
  }

  String getConnectionThreadName()
  {
    return "HSQLDB Connection @" + Integer.toString(hashCode(), 16);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.ServerConnection
 * JD-Core Version:    0.6.0
 */