package org.hsqldb;

import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.persist.Logger;

public class SchemaManager
{
  static final String SYSTEM_SCHEMA = "SYSTEM_SCHEMA";
  static final String DEFINITION_SCHEMA = "DEFINITION_SCHEMA";
  static final String INFORMATION_SCHEMA = "INFORMATION_SCHEMA";
  static final String PUBLIC_SCHEMA = "PUBLIC";
  static HsqlNameManager.HsqlName INFORMATION_SCHEMA_HSQLNAME = HsqlNameManager.newHsqlSystemObjectName("INFORMATION_SCHEMA");
  static HsqlNameManager.HsqlName SYSTEM_SCHEMA_HSQLNAME = HsqlNameManager.newHsqlSystemObjectName("SYSTEM_SCHEMA");
  Database database;
  HsqlNameManager.HsqlName defaultSchemaHsqlName;
  HashMappedList schemaMap = new HashMappedList();

  SchemaManager(Database paramDatabase)
  {
    this.database = paramDatabase;
    Schema localSchema = new Schema("PUBLIC", false);
    this.defaultSchemaHsqlName = localSchema.name;
    this.schemaMap.put("PUBLIC", localSchema);
  }

  void createSchema(String paramString, boolean paramBoolean)
    throws HsqlException
  {
    if (("DEFINITION_SCHEMA".equals(paramString)) || ("INFORMATION_SCHEMA".equals(paramString)) || ("SYSTEM_SCHEMA".equals(paramString)))
      throw Trace.error(227);
    Schema localSchema = new Schema(paramString, paramBoolean);
    this.schemaMap.add(paramString, localSchema);
  }

  void dropSchema(String paramString, boolean paramBoolean)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString);
    if (localSchema == null)
      throw Trace.error(227);
    if ((!paramBoolean) && (!localSchema.isEmpty()))
      throw Trace.error(228);
    Iterator localIterator = localSchema.tablesIterator();
    while (localIterator.hasNext())
    {
      localObject = (Table)localIterator.next();
      this.database.getUserManager().removeDbObject(((Table)localObject).getName());
      ((Table)localObject).drop();
    }
    Object localObject = localSchema.sequencesIterator();
    while (localIterator.hasNext())
    {
      NumberSequence localNumberSequence = (NumberSequence)((Iterator)localObject).next();
      this.database.getUserManager().removeDbObject(localNumberSequence.getName());
    }
    localSchema.clearStructures();
    this.schemaMap.remove(paramString);
    if (this.defaultSchemaHsqlName.name.equals(paramString))
    {
      if (this.schemaMap.isEmpty())
        localSchema = new Schema("PUBLIC", false);
      else
        localSchema = (Schema)this.schemaMap.get(0);
      this.defaultSchemaHsqlName = localSchema.name;
      this.schemaMap.put(this.defaultSchemaHsqlName.name, localSchema);
    }
    this.database.getUserManager().removeSchemaReference(localSchema);
    this.database.getSessionManager().removeSchemaReference(localSchema);
  }

  void renameSchema(String paramString1, String paramString2, boolean paramBoolean)
    throws HsqlException
  {
    Schema localSchema1 = (Schema)this.schemaMap.get(paramString1);
    Schema localSchema2 = (Schema)this.schemaMap.get(paramString2);
    if ((localSchema1 == null) || (localSchema2 != null) || ("INFORMATION_SCHEMA".equals(paramString2)))
      throw Trace.error(227, localSchema1 == null ? paramString1 : paramString2);
    localSchema1.name.rename(paramString2, paramBoolean);
    int i = this.schemaMap.getIndex(paramString1);
    this.schemaMap.set(i, paramString2, localSchema1);
  }

  void clearStructures()
  {
    Iterator localIterator = this.schemaMap.values().iterator();
    while (localIterator.hasNext())
    {
      Schema localSchema = (Schema)localIterator.next();
      localSchema.clearStructures();
    }
  }

  public Iterator userSchemaNameIterator()
  {
    return this.schemaMap.keySet().iterator();
  }

  HsqlNameManager.HsqlName toSchemaHsqlName(String paramString)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString);
    return localSchema == null ? null : localSchema.name;
  }

  HsqlNameManager.HsqlName getDefaultSchemaHsqlName()
  {
    return this.defaultSchemaHsqlName;
  }

  public String getDefaultSchemaName()
  {
    return this.defaultSchemaHsqlName.name;
  }

  boolean schemaExists(String paramString)
  {
    if ("INFORMATION_SCHEMA".equals(paramString))
      return true;
    return this.schemaMap.containsKey(paramString);
  }

  HsqlNameManager.HsqlName getSchemaHsqlName(String paramString)
    throws HsqlException
  {
    if (paramString == null)
      return this.defaultSchemaHsqlName;
    if ("INFORMATION_SCHEMA".equals(paramString))
      return INFORMATION_SCHEMA_HSQLNAME;
    Schema localSchema = (Schema)this.schemaMap.get(paramString);
    if (localSchema == null)
      throw Trace.error(227, paramString);
    return localSchema.name;
  }

  String getSchemaName(String paramString)
    throws HsqlException
  {
    return getSchemaHsqlName(paramString).name;
  }

  Iterator fullSchemaNamesIterator()
  {
    return new WrapperIterator(new WrapperIterator("INFORMATION_SCHEMA"), this.schemaMap.keySet().iterator());
  }

  public boolean isSystemSchema(HsqlNameManager.HsqlName paramHsqlName)
  {
    return (INFORMATION_SCHEMA_HSQLNAME.equals(paramHsqlName)) || (SYSTEM_SCHEMA_HSQLNAME.equals(paramHsqlName));
  }

  public Iterator tablesIterator(String paramString)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString);
    return localSchema.tablesIterator();
  }

  public Iterator allTablesIterator()
  {
    Iterator localIterator1 = userSchemaNameIterator();
    Iterator localIterator2;
    for (WrapperIterator localWrapperIterator = new WrapperIterator(); localIterator1.hasNext(); localWrapperIterator = new WrapperIterator(localWrapperIterator, localIterator2))
    {
      String str = (String)localIterator1.next();
      localIterator2 = tablesIterator(str);
    }
    return localWrapperIterator;
  }

  Iterator sequenceIterator(String paramString)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString);
    return localSchema.sequencesIterator();
  }

  public Iterator allSequencesIterator()
  {
    Iterator localIterator = this.schemaMap.values().iterator();
    Schema localSchema;
    for (WrapperIterator localWrapperIterator = new WrapperIterator(); localIterator.hasNext(); localWrapperIterator = new WrapperIterator(localWrapperIterator, localSchema.sequencesIterator()))
      localSchema = (Schema)localIterator.next();
    return localWrapperIterator;
  }

  public HsqlArrayList getAllTables()
  {
    Iterator localIterator = userSchemaNameIterator();
    HsqlArrayList localHsqlArrayList = new HsqlArrayList();
    while (localIterator.hasNext())
    {
      String str = (String)localIterator.next();
      HashMappedList localHashMappedList = getTables(str);
      localHsqlArrayList.addAll(localHashMappedList.values());
    }
    return localHsqlArrayList;
  }

  public HashMappedList getTables(String paramString)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString);
    return localSchema.tableList;
  }

  void checkUserViewNotExists(Session paramSession, String paramString1, String paramString2)
    throws HsqlException
  {
    int i = this.database.schemaManager.findUserTable(paramSession, paramString1, paramString2) != null ? 1 : 0;
    if (i != 0)
      throw Trace.error(52, paramString1);
  }

  void checkUserTableNotExists(Session paramSession, String paramString1, String paramString2)
    throws HsqlException
  {
    int i = findUserTable(paramSession, paramString1, paramString2) != null ? 1 : 0;
    if (i != 0)
      throw Trace.error(21, paramString1);
  }

  public Table getTable(Session paramSession, String paramString1, String paramString2)
    throws HsqlException
  {
    Table localTable = findUserTable(paramSession, paramString1, paramString2);
    if (localTable == null)
    {
      if (!"INFORMATION_SCHEMA".equals(paramString2))
        throw Trace.error(22);
      if (this.database.dbInfo != null)
        localTable = this.database.dbInfo.getSystemTable(paramSession, paramString1);
    }
    if (localTable == null)
      throw Trace.error(22, paramString1);
    return localTable;
  }

  public Table getUserTable(Session paramSession, String paramString1, String paramString2)
    throws HsqlException
  {
    Table localTable = findUserTable(paramSession, paramString1, paramString2);
    if (localTable == null)
      throw Trace.error(22, paramString1);
    return localTable;
  }

  Table findUserTable(Session paramSession, String paramString1, String paramString2)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString2);
    if (localSchema == null)
      return null;
    int i = 0;
    int j = localSchema.tableList.size();
    while (i < j)
    {
      Table localTable = (Table)localSchema.tableList.get(i);
      if (localTable.equals(paramSession, paramString1))
        return localTable;
      i++;
    }
    return null;
  }

  void linkTable(Table paramTable)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramTable.getSchemaName());
    localSchema.tableList.add(paramTable.getName().name, paramTable);
  }

  NumberSequence getSequence(String paramString1, String paramString2)
    throws HsqlException
  {
    NumberSequence localNumberSequence = findSequence(paramString1, paramString2);
    if (localNumberSequence == null)
      throw Trace.error(191, paramString1);
    return localNumberSequence;
  }

  public NumberSequence findSequence(String paramString1, String paramString2)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString2);
    NumberSequence localNumberSequence = localSchema.sequenceManager.getSequence(paramString1);
    return localNumberSequence;
  }

  Table findUserTableForIndex(Session paramSession, String paramString1, String paramString2)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString2);
    HsqlNameManager.HsqlName localHsqlName = localSchema.indexNameList.getOwner(paramString1);
    if (localHsqlName == null)
      return null;
    return findUserTable(paramSession, localHsqlName.name, paramString2);
  }

  int getTableIndex(Table paramTable)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramTable.getSchemaName());
    int i = 0;
    int j = localSchema.tableList.size();
    while (i < j)
    {
      Table localTable = (Table)localSchema.tableList.get(i);
      if (localTable == paramTable)
        return i;
      i++;
    }
    return -1;
  }

  void dropIndex(Session paramSession, String paramString1, String paramString2, boolean paramBoolean)
    throws HsqlException
  {
    Table localTable = findUserTableForIndex(paramSession, paramString1, paramString2);
    if (localTable == null)
    {
      if (paramBoolean)
        return;
      throw Trace.error(26, paramString1);
    }
    localTable.checkDropIndex(paramString1, null, false);
    paramSession.commit();
    paramSession.setScripting(true);
    TableWorks localTableWorks = new TableWorks(paramSession, localTable);
    localTableWorks.dropIndex(paramString1);
  }

  void checkTriggerExists(String paramString1, String paramString2, boolean paramBoolean)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString2);
    boolean bool = localSchema.triggerNameList.containsName(paramString1);
    if (bool != paramBoolean)
    {
      int i = paramBoolean ? 43 : 164;
      throw Trace.error(i, paramString1);
    }
  }

  void registerTriggerName(String paramString, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramHsqlName.schema.name);
    localSchema.triggerNameList.addName(paramString, paramHsqlName, 164);
  }

  void checkIndexExists(String paramString1, String paramString2, boolean paramBoolean)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString2);
    boolean bool = localSchema.indexNameList.containsName(paramString1);
    if (bool != paramBoolean)
    {
      int i = paramBoolean ? 26 : 23;
      throw Trace.error(i, paramString1);
    }
  }

  void registerIndexName(String paramString, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramHsqlName.schema.name);
    localSchema.indexNameList.addName(paramString, paramHsqlName, 23);
  }

  void removeIndexName(String paramString, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramHsqlName.schema.name);
    localSchema.indexNameList.removeName(paramString);
  }

  void removeIndexNames(HsqlNameManager.HsqlName paramHsqlName)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramHsqlName.schema.name);
    localSchema.indexNameList.removeOwner(paramHsqlName);
  }

  void renameIndex(String paramString1, String paramString2, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramHsqlName.schema.name);
    localSchema.indexNameList.rename(paramString1, paramString2, 23);
  }

  void checkConstraintExists(String paramString1, String paramString2, boolean paramBoolean)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString2);
    boolean bool = localSchema.constraintNameList.containsName(paramString1);
    if (bool != paramBoolean)
    {
      int i = paramBoolean ? 61 : 60;
      throw Trace.error(i, paramString1);
    }
  }

  void registerConstraintName(String paramString, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramHsqlName.schema.name);
    localSchema.constraintNameList.addName(paramString, paramHsqlName, 60);
  }

  void removeConstraintName(String paramString, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramHsqlName.schema.name);
    localSchema.constraintNameList.removeName(paramString);
  }

  void removeConstraintNames(HsqlNameManager.HsqlName paramHsqlName)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramHsqlName.schema.name);
    localSchema.constraintNameList.removeOwner(paramHsqlName);
  }

  NumberSequence createSequence(HsqlNameManager.HsqlName paramHsqlName, long paramLong1, long paramLong2, int paramInt)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramHsqlName.schema.name);
    return localSchema.sequenceManager.createSequence(paramHsqlName, paramLong1, paramLong2, paramInt);
  }

  void dropSequence(NumberSequence paramNumberSequence)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramNumberSequence.getSchemaName());
    localSchema.sequenceManager.dropSequence(paramNumberSequence.getName().name);
  }

  void logSequences(Session paramSession, Logger paramLogger)
    throws HsqlException
  {
    int i = 0;
    int j = this.schemaMap.size();
    while (i < j)
    {
      Schema localSchema = (Schema)this.schemaMap.get(i);
      localSchema.sequenceManager.logSequences(paramSession, paramLogger);
      i++;
    }
  }

  void clearTempTables(Session paramSession, Table paramTable)
  {
    Session[] arrayOfSession = this.database.sessionManager.getAllSessions();
    Index[] arrayOfIndex = paramTable.getIndexes();
    for (int i = 0; i < arrayOfSession.length; i++)
    {
      if (arrayOfSession[i] == paramSession)
        continue;
      for (int j = 0; j < arrayOfIndex.length; j++)
        arrayOfSession[i].dropIndex(arrayOfIndex[j].getName(), false);
    }
  }

  void dropTable(Session paramSession, String paramString1, String paramString2, boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3)
    throws HsqlException
  {
    Table localTable = null;
    int i = -1;
    Schema localSchema = (Schema)this.schemaMap.get(paramString2);
    for (int j = 0; j < localSchema.tableList.size(); j++)
    {
      localTable = (Table)localSchema.tableList.get(j);
      if ((localTable.equals(paramSession, paramString1)) && (paramBoolean2 == localTable.isView()))
      {
        i = j;
        break;
      }
      localTable = null;
    }
    if (i == -1)
    {
      if (paramBoolean1)
        return;
      throw Trace.error(paramBoolean2 ? 53 : 22, paramString1);
    }
    paramSession.checkAdmin();
    paramSession.checkDDLWrite();
    paramSession.commit();
    dropTable(localTable, paramBoolean3);
    paramSession.setScripting(true);
  }

  void dropTable(Table paramTable, boolean paramBoolean)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramTable.getSchemaName());
    int i = localSchema.tableList.getIndex(paramTable.getName().name);
    if (paramTable.isView())
    {
      checkCascadeDropViews((View)paramTable, paramBoolean);
    }
    else
    {
      checkCascadeDropReferenced(paramTable, paramBoolean);
      checkCascadeDropViews(paramTable, paramBoolean);
    }
    paramTable = (Table)localSchema.tableList.remove(i);
    removeExportedKeys(paramTable);
    this.database.getUserManager().removeDbObject(paramTable.getName());
    localSchema.triggerNameList.removeOwner(paramTable.tableName);
    localSchema.indexNameList.removeOwner(paramTable.tableName);
    localSchema.constraintNameList.removeOwner(paramTable.tableName);
    paramTable.dropTriggers();
    paramTable.drop();
  }

  void setTable(int paramInt, Table paramTable)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramTable.getSchemaName());
    localSchema.tableList.set(paramInt, paramTable.getName().name, paramTable);
  }

  void renameTable(Session paramSession, Table paramTable, String paramString, boolean paramBoolean)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramTable.tableName.schema.name);
    int i = localSchema.tableList.getIndex(paramTable.tableName.name);
    checkCascadeDropViews(paramTable, false);
    paramTable.rename(paramSession, paramString, paramBoolean);
    localSchema.tableList.setKey(i, paramString);
  }

  private void checkCascadeDropReferenced(Table paramTable, boolean paramBoolean)
    throws HsqlException
  {
    Constraint[] arrayOfConstraint = paramTable.getConstraints();
    Constraint localConstraint1 = null;
    Table localTable = null;
    int i = 0;
    for (int j = arrayOfConstraint.length - 1; j >= 0; j--)
    {
      localConstraint1 = arrayOfConstraint[j];
      if (localConstraint1.getType() != 1)
        continue;
      localTable = localConstraint1.getRef();
      i = (localTable != null) && (paramTable.equals(localTable)) ? 1 : 0;
      if (i != 0)
        continue;
      if (paramBoolean)
      {
        Constraint localConstraint2 = localTable.getConstraint(localConstraint1.getFkName());
        TableWorks localTableWorks = new TableWorks(null, localTable);
        localTableWorks.dropFKConstraint(localConstraint2);
        arrayOfConstraint = paramTable.constraintList;
        j = arrayOfConstraint.length;
      }
      else
      {
        throw Trace.error(193, 101, new Object[] { localConstraint1.getName().name, localTable.getName().name });
      }
    }
  }

  void checkCascadeDropViews(View paramView, boolean paramBoolean)
    throws HsqlException
  {
    View[] arrayOfView = getViewsWithView(paramView);
    if (arrayOfView != null)
    {
      if (paramBoolean)
        for (int i = arrayOfView.length - 1; i >= 0; i--)
          dropTable(arrayOfView[i], paramBoolean);
      throw Trace.error(194, arrayOfView[0].getName().name);
    }
  }

  void checkCascadeDropViews(Table paramTable, boolean paramBoolean)
    throws HsqlException
  {
    View[] arrayOfView = getViewsWithTable(paramTable, null);
    if (arrayOfView != null)
    {
      if (paramBoolean)
        for (int i = arrayOfView.length - 1; i >= 0; i--)
          dropTable(arrayOfView[i], paramBoolean);
      throw Trace.error(194, arrayOfView[0].getName().name);
    }
  }

  void checkCascadeDropViews(NumberSequence paramNumberSequence, boolean paramBoolean)
    throws HsqlException
  {
    View[] arrayOfView = getViewsWithSequence(paramNumberSequence);
    if (arrayOfView != null)
    {
      if (paramBoolean)
        for (int i = arrayOfView.length - 1; i >= 0; i--)
          dropTable(arrayOfView[i], paramBoolean);
      throw Trace.error(186, arrayOfView[0].getName().name);
    }
  }

  void checkColumnIsInView(Table paramTable, String paramString)
    throws HsqlException
  {
    View[] arrayOfView = getViewsWithTable(paramTable, paramString);
    if (arrayOfView != null)
      throw Trace.error(197, arrayOfView[0].getName().name);
  }

  private View[] getViewsWithView(View paramView)
  {
    HsqlArrayList localHsqlArrayList = null;
    Schema localSchema = (Schema)this.schemaMap.get(paramView.getSchemaName());
    for (int i = 0; i < localSchema.tableList.size(); i++)
    {
      Table localTable = (Table)localSchema.tableList.get(i);
      if (!localTable.isView())
        continue;
      boolean bool = ((View)localTable).hasView(paramView);
      if (!bool)
        continue;
      if (localHsqlArrayList == null)
        localHsqlArrayList = new HsqlArrayList();
      localHsqlArrayList.add(localTable);
    }
    return localHsqlArrayList == null ? null : (View[])localHsqlArrayList.toArray(new View[localHsqlArrayList.size()]);
  }

  private View[] getViewsWithTable(Table paramTable, String paramString)
  {
    HsqlArrayList localHsqlArrayList = null;
    Iterator localIterator = allTablesIterator();
    while (localIterator.hasNext())
    {
      Table localTable = (Table)localIterator.next();
      if (!localTable.isView())
        continue;
      boolean bool = paramString == null ? ((View)localTable).hasTable(paramTable) : ((View)localTable).hasColumn(paramTable, paramString);
      if (!bool)
        continue;
      if (localHsqlArrayList == null)
        localHsqlArrayList = new HsqlArrayList();
      localHsqlArrayList.add(localTable);
    }
    return localHsqlArrayList == null ? null : (View[])localHsqlArrayList.toArray(new View[localHsqlArrayList.size()]);
  }

  View[] getViewsWithSequence(NumberSequence paramNumberSequence)
  {
    HsqlArrayList localHsqlArrayList = null;
    Iterator localIterator = allTablesIterator();
    while (localIterator.hasNext())
    {
      Table localTable = (Table)localIterator.next();
      if (!localTable.isView())
        continue;
      boolean bool = ((View)localTable).hasSequence(paramNumberSequence);
      if (!bool)
        continue;
      if (localHsqlArrayList == null)
        localHsqlArrayList = new HsqlArrayList();
      localHsqlArrayList.add(localTable);
    }
    return localHsqlArrayList == null ? null : (View[])localHsqlArrayList.toArray(new View[localHsqlArrayList.size()]);
  }

  void recompileViews(Table paramTable)
    throws HsqlException
  {
    View[] arrayOfView = getViewsWithTable(paramTable, null);
    if (arrayOfView != null)
      for (int i = 0; i < arrayOfView.length; i++)
      {
        String str = arrayOfView[i].compileTimeSchema.name;
        if (!schemaExists(str))
          str = null;
        Session localSession = this.database.sessionManager.getSysSession(str, false);
        arrayOfView[i].compile(localSession);
      }
  }

  void removeExportedKeys(Table paramTable)
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramTable.getSchemaName());
    for (int i = 0; i < localSchema.tableList.size(); i++)
    {
      Table localTable1 = (Table)localSchema.tableList.get(i);
      for (int j = localTable1.constraintList.length - 1; j >= 0; j--)
      {
        Table localTable2 = localTable1.constraintList[j].getRef();
        if (paramTable != localTable2)
          continue;
        localTable1.constraintList = ((Constraint[])ArrayUtil.toAdjustedArray(localTable1.constraintList, null, j, -1));
      }
    }
  }

  void dropTrigger(Session paramSession, String paramString1, String paramString2)
    throws HsqlException
  {
    Schema localSchema = (Schema)this.schemaMap.get(paramString2);
    boolean bool = localSchema.triggerNameList.containsName(paramString1);
    Trace.check(bool, 43, paramString1);
    HsqlNameManager.HsqlName localHsqlName = (HsqlNameManager.HsqlName)localSchema.triggerNameList.removeName(paramString1);
    Table localTable = findUserTable(paramSession, localHsqlName.name, paramString2);
    localTable.dropTrigger(paramString1);
    paramSession.setScripting(true);
  }

  public class Schema
  {
    HsqlNameManager.HsqlName name;
    DatabaseObjectNames triggerNameList;
    DatabaseObjectNames constraintNameList;
    DatabaseObjectNames indexNameList;
    SequenceManager sequenceManager;
    HashMappedList tableList;

    Schema(String paramBoolean, boolean arg3)
    {
      boolean bool;
      this.name = SchemaManager.this.database.nameManager.newHsqlName(paramBoolean, bool);
      this.triggerNameList = new DatabaseObjectNames();
      this.indexNameList = new DatabaseObjectNames();
      this.constraintNameList = new DatabaseObjectNames();
      this.sequenceManager = new SequenceManager();
      this.tableList = new HashMappedList();
    }

    boolean isEmpty()
    {
      return (this.sequenceManager.sequenceMap.isEmpty()) && (this.tableList.isEmpty());
    }

    Iterator tablesIterator()
    {
      return this.tableList.values().iterator();
    }

    Iterator sequencesIterator()
    {
      return this.sequenceManager.sequenceMap.values().iterator();
    }

    void clearStructures()
    {
      if (this.tableList != null)
        for (int i = 0; i < this.tableList.size(); i++)
        {
          Table localTable = (Table)this.tableList.get(i);
          localTable.dropTriggers();
        }
      this.triggerNameList = null;
      this.indexNameList = null;
      this.constraintNameList = null;
      this.sequenceManager = null;
      this.tableList = null;
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.SchemaManager
 * JD-Core Version:    0.6.0
 */