package org.hsqldb;

import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.store.ValuePool;

public class Expression
{
  static final int VALUE = 1;
  static final int COLUMN = 2;
  static final int QUERY = 3;
  static final int TRUE = 4;
  static final int FALSE = -4;
  static final int VALUELIST = 5;
  static final int ASTERISK = 6;
  static final int FUNCTION = 7;
  static final int LIMIT = 8;
  static final int ROW = 9;
  static final int PARAM = 9;
  static final int NEGATE = 10;
  static final int ADD = 11;
  static final int SUBTRACT = 12;
  static final int MULTIPLY = 13;
  static final int DIVIDE = 14;
  static final int CONCAT = 15;
  static final int NOT = 20;
  static final int EQUAL = 21;
  static final int BIGGER_EQUAL = 22;
  static final int BIGGER = 23;
  static final int SMALLER = 24;
  static final int SMALLER_EQUAL = 25;
  static final int NOT_EQUAL = 26;
  static final int LIKE = 27;
  static final int AND = 28;
  static final int OR = 29;
  static final int IN = 30;
  static final int EXISTS = 31;
  static final int ALL = 32;
  static final int ANY = 33;
  static final int IS_NULL = 34;
  static final int COUNT = 40;
  static final int SUM = 41;
  static final int MIN = 42;
  static final int MAX = 43;
  static final int AVG = 44;
  static final int EVERY = 45;
  static final int SOME = 46;
  static final int STDDEV_POP = 47;
  static final int STDDEV_SAMP = 48;
  static final int VAR_POP = 49;
  static final int VAR_SAMP = 50;
  static final int IFNULL = 60;
  static final int CONVERT = 61;
  static final int CASEWHEN = 62;
  static final int EXTRACT = 63;
  static final int POSITION = 64;
  static final int TRIM = 65;
  static final int SUBSTRING = 66;
  static final int NULLIF = 67;
  static final int CASE = 68;
  static final int COALESCE = 69;
  static final int ALTERNATIVE = 70;
  static final int SEQUENCE = 71;
  static final int PLUS = 100;
  static final int OPEN = 101;
  static final int CLOSE = 102;
  static final int SELECT = 103;
  static final int COMMA = 104;
  static final int BETWEEN = 106;
  static final int CAST = 107;
  static final int END = 108;
  static final int IS = 109;
  static final int WHEN = 110;
  static final int THEN = 111;
  static final int ELSE = 112;
  static final int ENDWHEN = 113;
  static final int DISTINCT = 114;
  static final int VIEW = 115;
  static final int AS = 122;
  static final int FOR = 123;
  static final int FROM = 124;
  static final int BOTH = 125;
  static final int LEADING = 126;
  static final int TRAILING = 127;
  static final int YEAR = 128;
  static final int MONTH = 129;
  static final int DAY = 130;
  static final int HOUR = 131;
  static final int MINUTE = 132;
  static final int SECOND = 133;
  static final int TIMEZONE_HOUR = 134;
  static final int T_TIMEZONE_MINUTE = 135;
  static final int DOW = 136;
  static final HashSet SQL_EXTRACT_FIELD_NAMES = new HashSet();
  static final HashSet SQL_TRIM_SPECIFICATION = new HashSet();
  private static final int AGGREGATE_SELF = -1;
  private static final int AGGREGATE_NONE = 0;
  private static final int AGGREGATE_LEFT = 1;
  private static final int AGGREGATE_RIGHT = 2;
  private static final int AGGREGATE_BOTH = 3;
  private static final int AGGREGATE_FUNCTION = 4;
  int exprType;
  private int aggregateSpec = 0;
  Expression eArg;
  Expression eArg2;
  Object valueData;
  private int dataType;
  HashSet hList;
  Expression[] valueList;
  private boolean isFixedConstantValueList;
  SubQuery subQuery;
  boolean isQueryCorrelated;
  Function function;
  private Like likeObject;
  private String catalog;
  private String schema;
  private String tableName;
  private String columnName;
  private TableFilter tableFilter;
  TableFilter outerFilter;
  private int columnIndex;
  private boolean columnQuoted;
  private int precision;
  private int scale;
  private String columnAlias;
  private boolean aliasQuoted;
  private boolean isDescending;
  int joinedTableColumnIndex = -1;
  boolean isDistinctAggregate;
  private boolean isParam;
  boolean isInJoin;
  static final Integer INTEGER_0;
  static final Integer INTEGER_1;
  int oldIType = -1;
  static final int PARAM_UNKNOWN = 0;
  public static final int PARAM_IN = 1;
  public static final int PARAM_IN_OUT = 2;
  public static final int PARAM_OUT = 4;
  static final int NO_NULLS = 0;
  static final int NULLABLE = 1;
  static final int NULLABLE_UNKNOWN = 2;
  boolean isIdentity;
  int nullability = 2;
  boolean isWritable;
  int paramMode = 0;
  String valueClassName;

  Expression(boolean paramBoolean)
  {
    this.exprType = (paramBoolean ? 4 : -4);
  }

  Expression(Function paramFunction)
  {
    this.exprType = 7;
    this.function = paramFunction;
    if (paramFunction.hasAggregate)
      this.aggregateSpec = 4;
  }

  Expression(NumberSequence paramNumberSequence)
  {
    this.exprType = 71;
    this.valueData = paramNumberSequence;
    this.dataType = paramNumberSequence.getType();
  }

  Expression(Expression paramExpression)
  {
    this.exprType = paramExpression.exprType;
    this.dataType = paramExpression.dataType;
    this.eArg = paramExpression.eArg;
    this.eArg2 = paramExpression.eArg2;
    this.isInJoin = paramExpression.isInJoin;
    this.likeObject = paramExpression.likeObject;
    this.subQuery = paramExpression.subQuery;
    this.function = paramExpression.function;
    checkAggregate();
  }

  Expression(SubQuery paramSubQuery)
  {
    this.exprType = 3;
    this.subQuery = paramSubQuery;
  }

  Expression(Expression[] paramArrayOfExpression)
  {
    this.exprType = 5;
    this.valueList = paramArrayOfExpression;
  }

  Expression(int paramInt, Expression paramExpression1, Expression paramExpression2)
  {
    this.exprType = paramInt;
    this.eArg = paramExpression1;
    this.eArg2 = paramExpression2;
    checkAggregate();
  }

  Expression(Expression paramExpression, int paramInt1, int paramInt2, int paramInt3)
  {
    this.exprType = 61;
    this.eArg = paramExpression;
    this.dataType = paramInt1;
    this.precision = paramInt2;
    this.scale = paramInt3;
    this.columnAlias = paramExpression.columnAlias;
    this.aliasQuoted = paramExpression.aliasQuoted;
    checkAggregate();
  }

  Expression(Expression paramExpression1, Expression paramExpression2, Character paramCharacter, boolean paramBoolean)
  {
    this.exprType = 27;
    this.eArg = paramExpression1;
    this.eArg2 = paramExpression2;
    this.likeObject = new Like(paramCharacter, paramBoolean);
    checkAggregate();
  }

  Expression(String paramString1, String paramString2, String paramString3)
  {
    this.schema = paramString1;
    this.tableName = paramString2;
    if (paramString3 == null)
    {
      this.exprType = 6;
    }
    else
    {
      this.exprType = 2;
      this.columnName = paramString3;
    }
  }

  Expression(String paramString1, String paramString2, boolean paramBoolean)
  {
    this.tableName = paramString1;
    if (paramString2 == null)
    {
      this.exprType = 6;
    }
    else
    {
      this.exprType = 2;
      this.columnName = paramString2;
      this.columnQuoted = paramBoolean;
    }
  }

  Expression(TableFilter paramTableFilter, Column paramColumn)
  {
    this.schema = paramTableFilter.filterTable.tableName.schema.name;
    this.tableName = paramTableFilter.getName();
    if (paramColumn == null)
    {
      this.exprType = 6;
    }
    else
    {
      this.exprType = 2;
      this.columnName = paramColumn.columnName.name;
      this.columnQuoted = paramColumn.columnName.isNameQuoted;
      this.dataType = paramColumn.getType();
    }
  }

  Expression(int paramInt, Object paramObject)
  {
    this.exprType = 1;
    this.dataType = paramInt;
    this.valueData = paramObject;
  }

  Expression(int paramInt, Object paramObject, boolean paramBoolean)
  {
    this(paramInt, paramObject);
    this.isParam = paramBoolean;
    if (paramBoolean)
      this.paramMode = 1;
  }

  boolean isTypeEqual(Expression paramExpression)
  {
    return (this.dataType == paramExpression.dataType) && (this.precision == paramExpression.precision) && (this.scale == paramExpression.scale);
  }

  private void checkAggregate()
  {
    if (isAggregate(this.exprType))
    {
      this.aggregateSpec = -1;
    }
    else
    {
      this.aggregateSpec = 0;
      if ((this.eArg != null) && (this.eArg.isAggregate()))
        this.aggregateSpec += 1;
      if ((this.eArg2 != null) && (this.eArg2.isAggregate()))
        this.aggregateSpec += 2;
    }
  }

  public String describe(Session paramSession)
  {
    return describe(paramSession, 0);
  }

  static String getContextDDL(Expression paramExpression)
    throws HsqlException
  {
    String str = paramExpression.getDDL();
    if ((paramExpression.exprType != 1) && (paramExpression.exprType != 2) && (paramExpression.exprType != 7) && (paramExpression.exprType != 70) && (paramExpression.exprType != 62) && (paramExpression.exprType != 61))
    {
      StringBuffer localStringBuffer = new StringBuffer();
      str = '(' + str + ')';
    }
    return str;
  }

  String getColumnDDL()
    throws HsqlException
  {
    Trace.doAssert(this.exprType == 2);
    StringBuffer localStringBuffer = new StringBuffer();
    Table localTable = this.tableFilter.getTable();
    if (this.tableName != null)
    {
      if (!this.tableName.equals("SYSTEM_SUBQUERY"))
        localStringBuffer.append('"').append(this.tableName).append('"').append('.');
    }
    else
      localStringBuffer.append(localTable.tableName.statementName).append('.');
    localStringBuffer.append(localTable.getColumn(this.columnIndex).columnName.statementName);
    return localStringBuffer.toString();
  }

  String getDDL()
    throws HsqlException
  {
    StringBuffer localStringBuffer = new StringBuffer(64);
    String str1 = null;
    String str2 = null;
    if (this.eArg != null)
      str1 = getContextDDL(this.eArg);
    if (this.eArg2 != null)
      str2 = getContextDDL(this.eArg2);
    switch (this.exprType)
    {
    case 7:
      return this.function.getDLL();
    case 1:
      try
      {
        return this.isParam ? "?" : Column.createSQLString(this.valueData, this.dataType);
      }
      catch (HsqlException localHsqlException)
      {
        return localStringBuffer.toString();
      }
    case 2:
      Table localTable = this.tableFilter.getTable();
      if (this.tableName != null)
      {
        localStringBuffer.append(localTable.tableName.statementName);
        localStringBuffer.append('.');
      }
      localStringBuffer.append(localTable.getColumn(this.columnIndex).columnName.statementName);
      return localStringBuffer.toString();
    case 4:
      return "TRUE";
    case -4:
      return "FALSE";
    case 5:
      for (int i = 0; i < this.valueList.length; i++)
      {
        localStringBuffer.append(this.valueList[i].getDDL());
        if (i >= this.valueList.length - 1)
          continue;
        localStringBuffer.append(',');
      }
      return localStringBuffer.toString();
    case 6:
      localStringBuffer.append('*');
      return localStringBuffer.toString();
    case 10:
      localStringBuffer.append('-').append(str1);
      return localStringBuffer.toString();
    case 11:
      localStringBuffer.append(str1).append('+').append(str2);
      return localStringBuffer.toString();
    case 12:
      localStringBuffer.append(str1).append('-').append(str2);
      return localStringBuffer.toString();
    case 13:
      localStringBuffer.append(str1).append('*').append(str2);
      return localStringBuffer.toString();
    case 14:
      localStringBuffer.append(str1).append('/').append(str2);
      return localStringBuffer.toString();
    case 15:
      localStringBuffer.append(str1).append("||").append(str2);
      return localStringBuffer.toString();
    case 20:
      if (this.eArg.exprType == 34)
      {
        localStringBuffer.append(getContextDDL(this.eArg.eArg)).append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
        return localStringBuffer.toString();
      }
      localStringBuffer.append("NOT").append(' ').append(str1);
      return localStringBuffer.toString();
    case 21:
      localStringBuffer.append(str1).append('=').append(str2);
      return localStringBuffer.toString();
    case 22:
      localStringBuffer.append(str1).append(">=").append(str2);
      return localStringBuffer.toString();
    case 23:
      localStringBuffer.append(str1).append('>').append(str2);
      return localStringBuffer.toString();
    case 24:
      localStringBuffer.append(str1).append('<').append(str2);
      return localStringBuffer.toString();
    case 25:
      localStringBuffer.append(str1).append("<=").append(str2);
      return localStringBuffer.toString();
    case 26:
      if ("NULL".equals(str2))
        localStringBuffer.append(str1).append(" IS NOT ").append(str2);
      else
        localStringBuffer.append(str1).append("!=").append(str2);
      return localStringBuffer.toString();
    case 27:
      localStringBuffer.append(str1).append(' ').append("LIKE").append(' ');
      localStringBuffer.append(str2);
      if (this.likeObject.escapeChar != null)
      {
        localStringBuffer.append(' ').append("ESCAPE").append(' ').append('\'');
        localStringBuffer.append(this.likeObject.escapeChar.toString()).append('\'');
        localStringBuffer.append(' ');
      }
      return localStringBuffer.toString();
    case 28:
      localStringBuffer.append(str1).append(' ').append("AND").append(' ').append(str2);
      return localStringBuffer.toString();
    case 29:
      localStringBuffer.append(str1).append(' ').append("OR").append(' ').append(str2);
      return localStringBuffer.toString();
    case 32:
      localStringBuffer.append(str1).append(' ').append("ALL").append(' ').append(str2);
      return localStringBuffer.toString();
    case 33:
      localStringBuffer.append(str1).append(' ').append("ANY").append(' ').append(str2);
      return localStringBuffer.toString();
    case 30:
      localStringBuffer.append(str1).append(' ').append("IN").append(' ').append(str2);
      return localStringBuffer.toString();
    case 61:
      localStringBuffer.append(' ').append("CONVERT").append('(');
      localStringBuffer.append(str1).append(',');
      localStringBuffer.append(Types.getTypeString(this.dataType, this.precision, this.scale));
      localStringBuffer.append(')');
      return localStringBuffer.toString();
    case 62:
      localStringBuffer.append(' ').append("CASEWHEN").append('(');
      localStringBuffer.append(str1).append(',').append(str2).append(')');
      return localStringBuffer.toString();
    case 34:
      localStringBuffer.append(str1).append(' ').append("IS").append(' ').append("NULL");
      return localStringBuffer.toString();
    case 70:
      localStringBuffer.append(str1).append(',').append(str2);
      return localStringBuffer.toString();
    case 3:
      break;
    case 31:
      localStringBuffer.append(' ').append("EXISTS").append(' ');
      break;
    case 40:
      localStringBuffer.append(' ').append("COUNT").append('(');
      break;
    case 41:
      localStringBuffer.append(' ').append("SUM").append('(');
      localStringBuffer.append(str1).append(')');
      break;
    case 42:
      localStringBuffer.append(' ').append("MIN").append('(');
      localStringBuffer.append(str1).append(')');
      break;
    case 43:
      localStringBuffer.append(' ').append("MAX").append('(');
      localStringBuffer.append(str1).append(')');
      break;
    case 44:
      localStringBuffer.append(' ').append("AVG").append('(');
      localStringBuffer.append(str1).append(')');
      break;
    case 45:
      localStringBuffer.append(' ').append("EVERY").append('(');
      localStringBuffer.append(str1).append(')');
      break;
    case 46:
      localStringBuffer.append(' ').append("SOME").append('(');
      localStringBuffer.append(str1).append(')');
      break;
    case 47:
      localStringBuffer.append(' ').append("STDDEV_POP").append('(');
      localStringBuffer.append(str1).append(')');
      break;
    case 48:
      localStringBuffer.append(' ').append("STDDEV_SAMP").append('(');
      localStringBuffer.append(str1).append(')');
      break;
    case 49:
      localStringBuffer.append(' ').append("VAR_POP").append('(');
      localStringBuffer.append(str1).append(')');
      break;
    case 50:
      localStringBuffer.append(' ').append("VAR_SAMP").append('(');
      localStringBuffer.append(str1).append(')');
    case -3:
    case -2:
    case -1:
    case 0:
    case 8:
    case 9:
    case 16:
    case 17:
    case 18:
    case 19:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 63:
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
    }
    throw Trace.error(99);
  }

  private String describe(Session paramSession, int paramInt)
  {
    StringBuffer localStringBuffer = new StringBuffer(64);
    localStringBuffer.append('\n');
    for (int j = 0; j < paramInt; j++)
      localStringBuffer.append(' ');
    if (this.oldIType != -1)
      localStringBuffer.append("SET TRUE, WAS: ");
    int i = this.oldIType == -1 ? this.exprType : this.oldIType;
    switch (i)
    {
    case 7:
      localStringBuffer.append("FUNCTION ");
      localStringBuffer.append(this.function.describe(paramSession));
      return localStringBuffer.toString();
    case 1:
      if (this.isParam)
        localStringBuffer.append("PARAM ");
      localStringBuffer.append("VALUE = ").append(this.valueData);
      localStringBuffer.append(", TYPE = ").append(Types.getTypeString(this.dataType));
      return localStringBuffer.toString();
    case 2:
      localStringBuffer.append("COLUMN ");
      if (this.tableName != null)
      {
        localStringBuffer.append(this.tableName);
        localStringBuffer.append('.');
      }
      localStringBuffer.append(this.columnName);
      return localStringBuffer.toString();
    case 3:
      localStringBuffer.append("QUERY ");
      localStringBuffer.append(this.subQuery.select.describe(paramSession));
      return localStringBuffer.toString();
    case 4:
      localStringBuffer.append("TRUE ");
      break;
    case -4:
      localStringBuffer.append("FALSE ");
      break;
    case 5:
      localStringBuffer.append("VALUELIST ");
      localStringBuffer.append(" TYPE = ").append(Types.getTypeString(this.dataType));
      if (this.valueList == null)
        break;
      j = 0;
    case 6:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 32:
    case 33:
    case 30:
    case 34:
    case 31:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 61:
    case 62:
      while (j < this.valueList.length)
      {
        localStringBuffer.append(this.valueList[j].describe(paramSession, paramInt + paramInt));
        localStringBuffer.append(' ');
        j++;
        continue;
        localStringBuffer.append("* ");
        break;
        localStringBuffer.append("NEGATE ");
        break;
        localStringBuffer.append("ADD ");
        break;
        localStringBuffer.append("SUBTRACT ");
        break;
        localStringBuffer.append("MULTIPLY ");
        break;
        localStringBuffer.append("DIVIDE ");
        break;
        localStringBuffer.append("CONCAT ");
        break;
        localStringBuffer.append("NOT ");
        break;
        localStringBuffer.append("EQUAL ");
        break;
        localStringBuffer.append("BIGGER_EQUAL ");
        break;
        localStringBuffer.append("BIGGER ");
        break;
        localStringBuffer.append("SMALLER ");
        break;
        localStringBuffer.append("SMALLER_EQUAL ");
        break;
        localStringBuffer.append("NOT_EQUAL ");
        break;
        localStringBuffer.append("LIKE ");
        localStringBuffer.append(this.likeObject.describe(paramSession));
        break;
        localStringBuffer.append("AND ");
        break;
        localStringBuffer.append("OR ");
        break;
        localStringBuffer.append("ALL ");
        break;
        localStringBuffer.append("ANY ");
        break;
        localStringBuffer.append("IN ");
        break;
        localStringBuffer.append("IS_NULL ");
        break;
        localStringBuffer.append("EXISTS ");
        break;
        localStringBuffer.append("COUNT ");
        break;
        localStringBuffer.append("SUM ");
        break;
        localStringBuffer.append("MIN ");
        break;
        localStringBuffer.append("MAX ");
        break;
        localStringBuffer.append("AVG ");
        break;
        localStringBuffer.append("EVERY").append(' ');
        break;
        localStringBuffer.append("SOME").append(' ');
        break;
        localStringBuffer.append("STDDEV_POP").append(' ');
        break;
        localStringBuffer.append("STDDEV_SAMP").append(' ');
        break;
        localStringBuffer.append("VAR_POP").append(' ');
        break;
        localStringBuffer.append("VAR_SAMP").append(' ');
        break;
        localStringBuffer.append("CONVERT ");
        localStringBuffer.append(Types.getTypeString(this.dataType, this.precision, this.scale));
        localStringBuffer.append(' ');
        break;
        localStringBuffer.append("CASEWHEN ");
      }
    case -3:
    case -2:
    case -1:
    case 0:
    case 8:
    case 9:
    case 16:
    case 17:
    case 18:
    case 19:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    }
    if (this.isInJoin)
      localStringBuffer.append(" join");
    if (this.eArg != null)
    {
      localStringBuffer.append(" arg1=[");
      localStringBuffer.append(this.eArg.describe(paramSession, paramInt + 1));
      localStringBuffer.append(']');
    }
    if (this.eArg2 != null)
    {
      localStringBuffer.append(" arg2=[");
      localStringBuffer.append(this.eArg2.describe(paramSession, paramInt + 1));
      localStringBuffer.append(']');
    }
    return localStringBuffer.toString();
  }

  void setDataType(int paramInt)
  {
    this.dataType = paramInt;
  }

  void setTrue()
  {
    if (this.oldIType == -1)
      this.oldIType = this.exprType;
    this.exprType = 4;
  }

  void setNull()
  {
    this.isParam = false;
    this.exprType = 1;
    this.dataType = 0;
    this.valueData = null;
    this.eArg = null;
    this.eArg2 = null;
  }

  public boolean similarTo(Expression paramExpression)
  {
    if (paramExpression == null)
      return false;
    if (paramExpression == this)
      return true;
    return (this.exprType == paramExpression.exprType) && (this.dataType == paramExpression.dataType) && (equals(this.valueData, paramExpression.valueData)) && (equals(this.valueList, paramExpression.valueList)) && (equals(this.subQuery, paramExpression.subQuery)) && (equals(this.function, paramExpression.function)) && (equals(this.tableName, paramExpression.tableName)) && (equals(this.columnName, paramExpression.columnName)) && (similarTo(this.eArg, paramExpression.eArg)) && (similarTo(this.eArg2, paramExpression.eArg2));
  }

  static boolean equals(Object paramObject1, Object paramObject2)
  {
    return paramObject1 == null ? false : paramObject2 == null ? true : paramObject1.equals(paramObject2);
  }

  static boolean equals(Expression[] paramArrayOfExpression1, Expression[] paramArrayOfExpression2)
  {
    if (paramArrayOfExpression1 == paramArrayOfExpression2)
      return true;
    if (paramArrayOfExpression1.length != paramArrayOfExpression2.length)
      return false;
    int i = paramArrayOfExpression1.length;
    boolean bool = true;
    for (int j = 0; j < i; j++)
    {
      Expression localExpression1 = paramArrayOfExpression1[j];
      Expression localExpression2 = paramArrayOfExpression2[j];
      bool = localExpression1 == null ? false : localExpression2 == null ? true : localExpression1.equals(localExpression2);
    }
    return bool;
  }

  static boolean similarTo(Expression paramExpression1, Expression paramExpression2)
  {
    return paramExpression1 == null ? false : paramExpression2 == null ? true : paramExpression1.similarTo(paramExpression2);
  }

  boolean canBeInGroupBy()
  {
    if (this.exprType == 7)
      return true;
    return (isColumn()) && (!isAggregate());
  }

  boolean canBeInOrderBy()
  {
    return (this.exprType == 7) || (this.joinedTableColumnIndex != -1) || (isColumn()) || (isAggregate());
  }

  private boolean isColumn()
  {
    switch (this.exprType)
    {
    case 2:
      return true;
    case 10:
      return this.eArg.isColumn();
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
      return (this.eArg.isColumn()) || (this.eArg2.isColumn());
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    }
    return false;
  }

  boolean collectColumnName(HashSet paramHashSet)
  {
    int i = this.exprType == 2 ? 1 : 0;
    if (i != 0)
      paramHashSet.add(this.columnName);
    return i;
  }

  void collectAllColumnNames(HashSet paramHashSet)
  {
    if (!collectColumnName(paramHashSet))
    {
      if (this.eArg != null)
        this.eArg.collectAllColumnNames(paramHashSet);
      if (this.eArg2 != null)
        this.eArg2.collectAllColumnNames(paramHashSet);
    }
  }

  boolean isConstant()
  {
    switch (this.exprType)
    {
    case 1:
      return true;
    case 10:
      return this.eArg.isConstant();
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
      return (this.eArg.isConstant()) && (this.eArg2.isConstant());
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    }
    return false;
  }

  boolean canBeInAggregate()
  {
    return (isAggregate()) || (isConstant());
  }

  boolean isAggregate()
  {
    return this.aggregateSpec != 0;
  }

  boolean isSelfAggregate()
  {
    return this.aggregateSpec == -1;
  }

  static boolean isAggregate(int paramInt)
  {
    switch (paramInt)
    {
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
      return true;
    }
    return false;
  }

  boolean isConditional()
  {
    switch (this.exprType)
    {
    case -4:
    case 4:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 30:
    case 31:
    case 34:
      return true;
    case 20:
      return this.eArg.isConditional();
    case 28:
    case 29:
      return (this.eArg.isConditional()) && (this.eArg2.isConditional());
    case -3:
    case -2:
    case -1:
    case 0:
    case 1:
    case 2:
    case 3:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 32:
    case 33:
    }
    return false;
  }

  void collectInGroupByExpressions(HsqlArrayList paramHsqlArrayList)
  {
    if ((!isConstant()) && (!isSelfAggregate()))
      if (isColumn())
        paramHsqlArrayList.add(this);
      else if (this.exprType != 7)
        if (this.exprType == 62)
        {
          this.eArg2.collectInGroupByExpressions(paramHsqlArrayList);
        }
        else
        {
          if (this.eArg != null)
            this.eArg.collectInGroupByExpressions(paramHsqlArrayList);
          if (this.eArg2 != null)
            this.eArg2.collectInGroupByExpressions(paramHsqlArrayList);
        }
  }

  void setDescending()
  {
    this.isDescending = true;
  }

  boolean isDescending()
  {
    return this.isDescending;
  }

  void setAlias(String paramString, boolean paramBoolean)
  {
    this.columnAlias = paramString;
    this.aliasQuoted = paramBoolean;
  }

  void setColumnName(String paramString, boolean paramBoolean)
  {
    this.columnName = paramString;
    this.columnQuoted = paramBoolean;
  }

  void setTableName(String paramString)
  {
    this.tableName = paramString;
  }

  String getDefinedAlias()
  {
    return this.columnAlias;
  }

  String getAlias()
  {
    if (this.columnAlias != null)
      return this.columnAlias;
    if (this.exprType == 2)
      return this.columnName;
    return "";
  }

  boolean isAliasQuoted()
  {
    if (this.columnAlias != null)
      return this.aliasQuoted;
    if (this.exprType == 2)
      return this.columnQuoted;
    return false;
  }

  int getType()
  {
    return this.exprType;
  }

  Expression getArg()
  {
    return this.eArg;
  }

  Expression getArg2()
  {
    return this.eArg2;
  }

  TableFilter getFilter()
  {
    return this.tableFilter;
  }

  boolean checkResolved(boolean paramBoolean)
    throws HsqlException
  {
    int i = 1;
    if (this.eArg != null)
      i = (i != 0) && (this.eArg.checkResolved(paramBoolean)) ? 1 : 0;
    if (this.eArg2 != null)
      i = (i != 0) && (this.eArg2.checkResolved(paramBoolean)) ? 1 : 0;
    if ((this.subQuery != null) && (this.subQuery.select != null))
      i = (i != 0) && (this.subQuery.select.checkResolved(paramBoolean)) ? 1 : 0;
    if (this.function != null)
      i = (i != 0) && (this.function.checkResolved(paramBoolean)) ? 1 : 0;
    if (this.valueList != null)
      for (int j = 0; j < this.valueList.length; j++)
        i = (i != 0) && (this.valueList[j].checkResolved(paramBoolean)) ? 1 : 0;
    if (this.exprType == 2)
      if (this.tableFilter == null)
      {
        i = this.joinedTableColumnIndex != -1 ? 1 : 0;
        if ((i == 0) && (paramBoolean))
        {
          String str = this.tableName + "." + this.columnName;
          throw Trace.error(28, str);
        }
      }
      else
      {
        this.tableFilter.usedColumns[this.columnIndex] = true;
      }
    return i;
  }

  void checkTables(HsqlArrayList paramHsqlArrayList)
    throws HsqlException
  {
    if ((paramHsqlArrayList == null) || (this.exprType == 1))
      return;
    if (this.eArg != null)
      this.eArg.checkTables(paramHsqlArrayList);
    if (this.eArg2 != null)
      this.eArg2.checkTables(paramHsqlArrayList);
    switch (this.exprType)
    {
    case 2:
      int i = 0;
      int j = paramHsqlArrayList.size();
      for (int k = 0; k < j; k++)
      {
        TableFilter localTableFilter = (TableFilter)paramHsqlArrayList.get(k);
        String str = localTableFilter.getName();
        if ((this.tableName != null) && (!str.equals(this.tableName)))
          continue;
        Table localTable = localTableFilter.getTable();
        int n = localTable.findColumn(this.columnName);
        if (n == -1)
          continue;
        if (this.tableName == null)
        {
          if (i != 0)
            throw Trace.error(156, this.columnName);
          i = 1;
        }
        else
        {
          return;
        }
      }
      if (i != 0)
        return;
      throw Trace.error(28, this.columnName);
    case 3:
      break;
    case 7:
      if (this.function == null)
        break;
      this.function.checkTables(paramHsqlArrayList);
      break;
    case 32:
    case 33:
      break;
    case 30:
      if (this.eArg2.exprType == 3)
        break;
      Expression[] arrayOfExpression = this.eArg2.valueList;
      for (int m = 0; m < arrayOfExpression.length; m++)
        arrayOfExpression[m].checkTables(paramHsqlArrayList);
    }
  }

  Expression getExpressionForAlias(Expression[] paramArrayOfExpression, int paramInt)
  {
    for (int i = 0; i < paramInt; i++)
      if ((this.columnName.equals(paramArrayOfExpression[i].columnAlias)) && ((this.tableName == null) || (this.tableName.equals(paramArrayOfExpression[i].tableName))))
        return paramArrayOfExpression[i];
    return this;
  }

  void replaceAliases(Expression[] paramArrayOfExpression, int paramInt)
    throws HsqlException
  {
    if (this.eArg != null)
      if (this.eArg.exprType == 2)
        this.eArg = this.eArg.getExpressionForAlias(paramArrayOfExpression, paramInt);
      else
        this.eArg.replaceAliases(paramArrayOfExpression, paramInt);
    if (this.eArg2 != null)
      if (this.eArg2.exprType == 2)
        this.eArg2 = this.eArg2.getExpressionForAlias(paramArrayOfExpression, paramInt);
      else
        this.eArg2.replaceAliases(paramArrayOfExpression, paramInt);
    switch (this.exprType)
    {
    case 3:
      break;
    case 7:
      if (this.function == null)
        break;
      this.function.replaceAliases(paramArrayOfExpression, paramInt);
      break;
    case 32:
    case 33:
      break;
    case 30:
      if (this.eArg2.exprType == 3)
        break;
      Expression[] arrayOfExpression = this.eArg2.valueList;
      for (int i = 0; i < arrayOfExpression.length; i++)
        if (arrayOfExpression[i].exprType == 2)
          arrayOfExpression[i] = arrayOfExpression[i].getExpressionForAlias(paramArrayOfExpression, paramInt);
        else
          arrayOfExpression[i].replaceAliases(paramArrayOfExpression, paramInt);
    }
  }

  void setLikeOptimised()
    throws HsqlException
  {
    if (this.eArg != null)
      this.eArg.setLikeOptimised();
    if (this.eArg2 != null)
      this.eArg2.setLikeOptimised();
    if (this.exprType == 27)
      this.likeObject.optimised = true;
  }

  void getEquiJoinColumns(TableFilter paramTableFilter, boolean[] paramArrayOfBoolean, Expression[] paramArrayOfExpression)
  {
    if (this.eArg != null)
      this.eArg.getEquiJoinColumns(paramTableFilter, paramArrayOfBoolean, paramArrayOfExpression);
    if (this.eArg2 != null)
      this.eArg2.getEquiJoinColumns(paramTableFilter, paramArrayOfBoolean, paramArrayOfExpression);
    if (this.exprType == 21)
    {
      if (this.eArg.tableFilter == this.eArg2.tableFilter)
        return;
      if (this.eArg.tableFilter == paramTableFilter)
      {
        if ((this.eArg2.exprType == 2) || (this.eArg2.exprType == 1))
        {
          paramArrayOfBoolean[this.eArg.columnIndex] = true;
          paramArrayOfExpression[this.eArg.columnIndex] = this.eArg2;
        }
        return;
      }
      if ((this.eArg2.tableFilter == paramTableFilter) && ((this.eArg.exprType == 2) || (this.eArg.exprType == 1)))
      {
        paramArrayOfBoolean[this.eArg2.columnIndex] = true;
        paramArrayOfExpression[this.eArg2.columnIndex] = this.eArg;
      }
    }
  }

  TableFilter findTableFilter(TableFilter[] paramArrayOfTableFilter)
  {
    for (int i = 0; i < paramArrayOfTableFilter.length; i++)
    {
      TableFilter localTableFilter = paramArrayOfTableFilter[i];
      if (((this.schema == null) || (localTableFilter.filterTable.getSchemaName().equals(this.schema))) && (localTableFilter.getName().equals(this.tableName)))
        return localTableFilter;
    }
    return null;
  }

  void resolveTables(TableFilter paramTableFilter)
    throws HsqlException
  {
    if ((this.isParam) || (paramTableFilter == null) || (this.exprType == 1))
      return;
    if (this.eArg != null)
      this.eArg.resolveTables(paramTableFilter);
    if (this.eArg2 != null)
      this.eArg2.resolveTables(paramTableFilter);
    Object localObject;
    int i;
    switch (this.exprType)
    {
    case 2:
      if (this.tableFilter != null)
        break;
      String str = paramTableFilter.getName();
      if ((this.tableName != null) && (!this.tableName.equals(str)))
        break;
      localObject = paramTableFilter.getTable();
      i = ((Table)localObject).findColumn(this.columnName);
      if (i == -1)
        break;
      this.tableFilter = paramTableFilter;
      this.columnIndex = i;
      this.tableName = str;
      setTableColumnAttributes((Table)localObject, i);
      return;
    case 3:
      if (this.subQuery == null)
        break;
      this.subQuery.select.resolveTablesUnion(paramTableFilter);
      break;
    case 7:
      if (this.function == null)
        break;
      this.function.resolveTables(paramTableFilter);
      break;
    case 32:
    case 33:
      break;
    case 30:
      if (this.eArg2.exprType == 3)
        break;
      localObject = this.eArg2.valueList;
      for (i = 0; i < localObject.length; i++)
        localObject[i].resolveTables(paramTableFilter);
    }
  }

  int getCaseWhenType(Session paramSession)
    throws HsqlException
  {
    return this.eArg2.dataType;
  }

  void resolveTypes(Session paramSession)
    throws HsqlException
  {
    if (this.isParam)
      return;
    if (this.eArg != null)
      this.eArg.resolveTypes(paramSession);
    if (this.eArg2 != null)
      this.eArg2.resolveTypes(paramSession);
    boolean bool1;
    boolean bool2;
    Object localObject2;
    Object localObject3;
    Object localObject1;
    switch (this.exprType)
    {
    case 1:
      if ((this.dataType == 16) && (this.valueData != null))
        this.exprType = (((Boolean)this.valueData).booleanValue() ? 4 : -4);
      break;
    case 2:
      break;
    case 7:
      this.function.resolveType(paramSession);
      this.dataType = this.function.getReturnType();
      break;
    case 3:
      this.subQuery.select.resolveTypes(paramSession);
      this.dataType = this.subQuery.select.exprColumns[0].dataType;
      break;
    case 10:
      if (this.eArg.isParam)
        throw Trace.error(216, 212);
      this.dataType = this.eArg.dataType;
      if (isFixedConstant())
      {
        this.valueData = getValue(paramSession, this.dataType);
        this.eArg = null;
        this.exprType = 1;
      }
      break;
    case 11:
      if ((!Types.isCharacterType(this.eArg.dataType)) && (!Types.isCharacterType(this.eArg2.dataType)))
        break;
      this.exprType = 15;
      this.dataType = 12;
      if (isFixedConstant())
      {
        this.valueData = getValue(paramSession, this.dataType);
        this.eArg = null;
        this.eArg2 = null;
        this.exprType = 1;
      }
      else
      {
        if (this.eArg.isParam)
          this.eArg.dataType = 12;
        if (this.eArg2.isParam)
          this.eArg2.dataType = 12;
      }
      break;
    case 12:
    case 13:
    case 14:
      if ((this.eArg.isParam) && (this.eArg2.isParam))
        throw Trace.error(216, 213);
      if (isFixedConstant())
      {
        this.dataType = Column.getCombinedNumberType(this.eArg.dataType, this.eArg2.dataType, this.exprType);
        this.valueData = getValue(paramSession, this.dataType);
        this.eArg = null;
        this.eArg2 = null;
        this.exprType = 1;
      }
      else
      {
        if (this.eArg.isParam)
          this.eArg.dataType = this.eArg2.dataType;
        else if (this.eArg2.isParam)
          this.eArg2.dataType = this.eArg.dataType;
        this.dataType = Column.getCombinedNumberType(this.eArg.dataType, this.eArg2.dataType, this.exprType);
      }
      break;
    case 15:
      this.dataType = 12;
      if (isFixedConstant())
      {
        this.valueData = getValue(paramSession, this.dataType);
        this.eArg = null;
        this.eArg2 = null;
        this.exprType = 1;
      }
      else
      {
        if (this.eArg.isParam)
          this.eArg.dataType = 12;
        if (this.eArg2.isParam)
          this.eArg2.dataType = 12;
      }
      break;
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
      if ((this.eArg.isParam) && (this.eArg2.isParam))
        throw Trace.error(216, 214);
      if (isFixedConditional())
      {
        Boolean localBoolean = test(paramSession);
        if (localBoolean == null)
          setNull();
        else if (localBoolean.booleanValue())
          this.exprType = 4;
        else
          this.exprType = -4;
        this.eArg = null;
        this.eArg2 = null;
      }
      else if (this.eArg.isParam)
      {
        this.eArg.dataType = (this.eArg2.dataType == 0 ? 12 : this.eArg2.dataType);
        if (this.eArg2.exprType == 2)
          this.eArg.setTableColumnAttributes(this.eArg2);
      }
      else if (this.eArg2.isParam)
      {
        this.eArg2.dataType = (this.eArg.dataType == 0 ? 12 : this.eArg.dataType);
        if (this.eArg.exprType == 2)
          this.eArg2.setTableColumnAttributes(this.eArg);
      }
      this.dataType = 16;
      break;
    case 27:
      resolveTypeForLike(paramSession);
      this.dataType = 16;
      break;
    case 28:
      bool1 = this.eArg.isFixedConditional();
      bool2 = this.eArg2.isFixedConditional();
      localObject2 = bool1 ? this.eArg.test(paramSession) : null;
      localObject3 = bool2 ? this.eArg2.test(paramSession) : null;
      if ((bool1) && (bool2))
      {
        if ((localObject2 == null) || (localObject3 == null))
        {
          setNull();
        }
        else
        {
          this.exprType = ((localObject2.booleanValue()) && (localObject3.booleanValue()) ? 4 : -4);
          this.eArg = null;
          this.eArg2 = null;
        }
      }
      else if (((bool1) && (!Boolean.TRUE.equals(localObject2))) || ((bool2) && (!Boolean.TRUE.equals(localObject3))))
      {
        this.exprType = -4;
        this.eArg = null;
        this.eArg2 = null;
      }
      else
      {
        if (this.eArg.isParam)
          this.eArg.dataType = 16;
        if (this.eArg2.isParam)
          this.eArg2.dataType = 16;
      }
      this.dataType = 16;
      break;
    case 29:
      bool1 = this.eArg.isFixedConditional();
      bool2 = this.eArg2.isFixedConditional();
      localObject2 = bool1 ? this.eArg.test(paramSession) : null;
      localObject3 = bool2 ? this.eArg2.test(paramSession) : null;
      if ((bool1) && (bool2))
      {
        if ((localObject2 == null) || (localObject3 == null))
        {
          setNull();
        }
        else
        {
          this.exprType = ((localObject2.booleanValue()) || (localObject3.booleanValue()) ? 4 : -4);
          this.eArg = null;
          this.eArg2 = null;
        }
      }
      else if (((bool1) && (Boolean.TRUE.equals(localObject2))) || ((bool2) && (Boolean.TRUE.equals(localObject3))))
      {
        this.exprType = 4;
        this.eArg = null;
        this.eArg2 = null;
      }
      else
      {
        if (this.eArg.isParam)
          this.eArg.dataType = 16;
        if (this.eArg2.isParam)
          this.eArg2.dataType = 16;
      }
      this.dataType = 16;
      break;
    case 34:
      if (isFixedConditional())
      {
        this.exprType = (Boolean.TRUE.equals(test(paramSession)) ? 4 : -4);
        this.eArg = null;
      }
      else if (this.eArg.dataType == 0)
      {
        this.eArg.dataType = 12;
      }
      this.dataType = 16;
      break;
    case 20:
      if (isFixedConditional())
      {
        localObject1 = test(paramSession);
        if (localObject1 == null)
        {
          setNull();
        }
        else
        {
          this.exprType = (((Boolean)localObject1).booleanValue() ? 4 : -4);
          this.eArg = null;
        }
      }
      else if (this.eArg.isParam)
      {
        this.eArg.dataType = 16;
      }
      this.dataType = 16;
      break;
    case 32:
    case 33:
      this.dataType = this.eArg.dataType;
      break;
    case 30:
      resolveTypeForIn(paramSession);
      this.dataType = 16;
      break;
    case 31:
      this.dataType = 16;
      break;
    case 40:
      if (this.eArg.isParam)
        throw Trace.error(216, 215);
      this.dataType = 4;
      break;
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
      if (this.eArg.isParam)
        throw Trace.error(216, 215);
      this.dataType = SetFunction.getType(this.exprType, this.eArg.dataType);
      break;
    case 61:
      if ((this.eArg.isFixedConstant()) || (this.eArg.isFixedConditional()))
      {
        this.valueData = getValue(paramSession);
        this.exprType = 1;
        this.eArg = null;
      }
      break;
    case 62:
      if (this.eArg.isParam)
        this.eArg.dataType = 16;
      this.dataType = getCaseWhenType(paramSession);
      break;
    case 70:
      localObject1 = this.eArg;
      Expression localExpression = this.eArg2;
      if ((((Expression)localObject1).isParam) && (localExpression.isParam))
        throw Trace.error(216, 217);
      if ((((Expression)localObject1).isParam) || (((Expression)localObject1).dataType == 0))
        ((Expression)localObject1).dataType = localExpression.dataType;
      else if ((localExpression.isParam) || (localExpression.dataType == 0))
        localExpression.dataType = ((Expression)localObject1).dataType;
      if ((((Expression)localObject1).dataType == 0) && (localExpression.dataType == 0))
        this.dataType = 0;
      if ((Types.isNumberType(((Expression)localObject1).dataType)) && (Types.isNumberType(localExpression.dataType)))
        this.dataType = Column.getCombinedNumberType(((Expression)localObject1).dataType, localExpression.dataType, 70);
      else if ((Types.isCharacterType(((Expression)localObject1).dataType)) && (Types.isCharacterType(localExpression.dataType)))
        this.dataType = -1;
      else if (((Expression)localObject1).dataType != localExpression.dataType)
      {
        if (localExpression.exprType == 1)
        {
          this.dataType = (localExpression.dataType = ((Expression)localObject1).dataType);
          localExpression.valueData = Column.convertObject(localExpression.valueData, this.dataType);
        }
        else if (((Expression)localObject1).exprType == 1)
        {
          this.dataType = (((Expression)localObject1).dataType = localExpression.dataType);
          ((Expression)localObject1).valueData = Column.convertObject(((Expression)localObject1).valueData, this.dataType);
        }
        else
        {
          throw Trace.error(216, 218, new String[] { Types.getTypeString(((Expression)localObject1).dataType), Types.getTypeString(localExpression.dataType) });
        }
      }
      else
        this.dataType = ((Expression)localObject1).dataType;
    case 4:
    case 5:
    case 6:
    case 8:
    case 9:
    case 16:
    case 17:
    case 18:
    case 19:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 63:
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
    }
  }

  void resolveTypeForLike(Session paramSession)
    throws HsqlException
  {
    if ((this.eArg.isParam) && (this.eArg2.isParam))
      throw Trace.error(216, 219);
    if (isFixedConditional())
    {
      Boolean localBoolean = test(paramSession);
      if (localBoolean == null)
      {
        setNull();
      }
      else
      {
        this.exprType = (localBoolean.booleanValue() ? 4 : -4);
        this.eArg = null;
        this.eArg2 = null;
      }
    }
    else if (this.eArg.isParam)
    {
      this.eArg.dataType = 12;
    }
    else if (this.eArg2.isParam)
    {
      this.eArg2.dataType = 12;
    }
    if (this.likeObject.optimised)
      return;
    boolean bool1 = this.eArg2.isFixedConstant();
    String str = bool1 ? (String)this.eArg2.getValue(paramSession, 12) : null;
    boolean bool2 = (this.eArg.dataType == 100) || (this.eArg2.dataType == 100);
    this.likeObject.setParams(paramSession, str, bool2);
    if (!bool1)
      return;
    if (this.likeObject.isEquivalentToFalsePredicate())
    {
      this.exprType = -4;
      this.eArg = null;
      this.eArg2 = null;
      this.likeObject = null;
    }
    else if (this.likeObject.isEquivalentToEqualsPredicate())
    {
      this.exprType = 21;
      this.eArg2 = new Expression(12, this.likeObject.getRangeLow());
      this.likeObject = null;
    }
    else if (!this.likeObject.isEquivalentToNotNullPredicate())
    {
      if (this.eArg.exprType != 2)
        return;
      if (!Types.isCharacterType(this.eArg.dataType))
        return;
      int i = 0;
      int j = 0;
      boolean bool3 = false;
      if (this.likeObject.isEquivalentToBetweenPredicate())
      {
        bool3 = this.likeObject.hasCollation;
        i = !bool3 ? 1 : 0;
        j = bool3;
      }
      else if (this.likeObject.isEquivalentToBetweenPredicateAugmentedWithLike())
      {
        bool3 = this.likeObject.hasCollation;
        i = !bool3 ? 1 : 0;
        j = 1;
      }
      if ((i == 0) && (!bool3))
        return;
      Expression localExpression1 = new Expression(12, this.likeObject.getRangeLow());
      Expression localExpression2 = new Expression(12, this.likeObject.getRangeHigh());
      Expression localExpression3;
      if ((i != 0) && (j == 0))
      {
        localExpression3 = this.eArg;
        this.eArg = new Expression(22, localExpression3, localExpression1);
        this.eArg2 = new Expression(25, localExpression3, localExpression2);
        this.exprType = 28;
        this.likeObject = null;
      }
      else if ((i != 0) && (j != 0))
      {
        localExpression3 = new Expression(22, this.eArg, localExpression1);
        Expression localExpression4 = new Expression(25, this.eArg, localExpression2);
        this.eArg2 = new Expression(this.eArg, this.eArg2, this.likeObject.escapeChar, this.likeObject.hasCollation);
        this.eArg2.likeObject = this.likeObject;
        this.eArg = new Expression(28, localExpression3, localExpression4);
        this.exprType = 28;
        this.likeObject = null;
      }
      else if (bool3)
      {
        localExpression3 = new Expression(22, this.eArg, localExpression1);
        this.eArg2 = new Expression(this.eArg, this.eArg2, this.likeObject.escapeChar, this.likeObject.hasCollation);
        this.eArg2.likeObject = this.likeObject;
        this.eArg = localExpression3;
        this.exprType = 28;
        this.likeObject = null;
      }
    }
  }

  void resolveTypeForIn(Session paramSession)
    throws HsqlException
  {
    if (this.eArg2.exprType == 3)
    {
      if (this.eArg.isParam)
        this.eArg.dataType = this.eArg2.dataType;
      this.isQueryCorrelated = (!this.eArg2.subQuery.isResolved);
    }
    else
    {
      Expression[] arrayOfExpression = this.eArg2.valueList;
      int i = arrayOfExpression.length;
      if (this.eArg.isParam)
      {
        if (arrayOfExpression[0].isParam)
          throw Trace.error(216, 221);
        Expression localExpression1 = arrayOfExpression[0];
        k = localExpression1.dataType;
        if (k != 0)
        {
          if (this.eArg.dataType == 0)
            this.eArg.dataType = k;
          if (this.eArg2.dataType == 0)
            this.eArg2.dataType = k;
        }
        for (int m = 1; m < i; m++)
        {
          localExpression1 = arrayOfExpression[m];
          if (localExpression1.isParam)
          {
            if ((localExpression1.dataType != 0) || (k == 0))
              continue;
            localExpression1.dataType = k;
          }
          else
          {
            localExpression1.resolveTypes(paramSession);
          }
        }
      }
      int j = this.eArg.dataType;
      if ((this.eArg2.dataType == 0) && (j != 0))
        this.eArg2.dataType = j;
      for (int k = 0; k < i; k++)
      {
        Expression localExpression2 = arrayOfExpression[k];
        if (localExpression2.isParam)
        {
          if ((localExpression2.dataType != 0) || (j == 0))
            continue;
          localExpression2.dataType = j;
        }
        else
        {
          localExpression2.resolveTypes(paramSession);
        }
      }
      this.eArg2.isFixedConstantValueList = (this.eArg2.dataType != 100);
      for (j = 0; j < i; j++)
      {
        if (arrayOfExpression[j].isFixedConstant())
          continue;
        this.eArg2.isFixedConstantValueList = false;
        this.isQueryCorrelated = true;
        break;
      }
      if (this.eArg2.isFixedConstantValueList)
      {
        this.eArg2.hList = new HashSet();
        for (j = 0; j < i; j++)
          try
          {
            Object localObject = this.eArg2.valueList[j].getValue(paramSession);
            localObject = Column.convertObject(localObject, this.eArg2.dataType);
            if ((this.eArg2.dataType == 1) && (localObject != null))
              localObject = Library.rtrim((String)localObject);
            this.eArg2.hList.add(localObject);
          }
          catch (HsqlException localHsqlException)
          {
          }
      }
    }
  }

  boolean isResolved()
  {
    switch (this.exprType)
    {
    case 1:
    case 10:
      return true;
    case 2:
      return (this.tableFilter != null) && (this.tableFilter.isAssigned);
    case 3:
      return this.subQuery.isResolved;
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    }
    return false;
  }

  static boolean isCompare(int paramInt)
  {
    switch (paramInt)
    {
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
      return true;
    }
    return false;
  }

  String getTableName()
  {
    if (this.exprType == 6)
      return this.tableName;
    if (this.exprType == 2)
    {
      if (this.tableFilter == null)
        return this.tableName;
      return this.tableFilter.getTable().getName().name;
    }
    return "";
  }

  String getFilterTableName()
  {
    if (this.tableFilter == null)
      return "";
    return this.tableFilter.getTable().getName().name;
  }

  HsqlNameManager.HsqlName getTableHsqlName()
  {
    if (this.tableFilter == null)
      return null;
    return this.tableFilter.getTable().getName();
  }

  String getTableSchemaName()
  {
    if (this.tableFilter == null)
      return null;
    return this.tableFilter.getTable().getName().schema.name;
  }

  String getColumnName()
  {
    if (this.exprType == 2)
    {
      if (this.tableFilter == null)
        return this.columnName;
      return this.tableFilter.getTable().getColumn(this.columnIndex).columnName.name;
    }
    return getAlias();
  }

  String getBaseColumnName()
  {
    if ((this.exprType == 2) && (this.tableFilter != null))
      return this.tableFilter.getTable().getColumn(this.columnIndex).columnName.name;
    return null;
  }

  int getColumnNr()
  {
    return this.columnIndex;
  }

  int getColumnSize()
  {
    return this.precision;
  }

  int getColumnScale()
  {
    return this.scale;
  }

  void setDistinctAggregate(boolean paramBoolean)
  {
    this.isDistinctAggregate = ((paramBoolean) && (this.eArg.exprType != 6));
    if (this.exprType == 40)
      this.dataType = (paramBoolean ? this.dataType : 4);
  }

  void swapCondition()
    throws HsqlException
  {
    int i = 21;
    switch (this.exprType)
    {
    case 22:
      i = 25;
      break;
    case 25:
      i = 22;
      break;
    case 24:
      i = 23;
      break;
    case 23:
      i = 24;
      break;
    case 21:
      break;
    default:
      Trace.doAssert(false, "Expression.swapCondition");
    }
    this.exprType = i;
    Expression localExpression = this.eArg;
    this.eArg = this.eArg2;
    this.eArg2 = localExpression;
  }

  int getDataType()
  {
    return this.dataType;
  }

  Object getValue(Session paramSession, int paramInt)
    throws HsqlException
  {
    Object localObject = getValue(paramSession);
    if ((localObject == null) || (this.dataType == paramInt))
      return localObject;
    return Column.convertObject(localObject, paramInt);
  }

  Object getAggregatedValue(Session paramSession, Object paramObject)
    throws HsqlException
  {
    if (!isAggregate())
      return paramObject;
    Object localObject1 = null;
    Object localObject2 = null;
    switch (this.aggregateSpec)
    {
    case -1:
      switch (this.exprType)
      {
      case 40:
        if (paramObject == null)
          return INTEGER_0;
        return ((SetFunction)paramObject).getValue();
      case 41:
      case 42:
      case 43:
      case 44:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      case 50:
        if (paramObject == null)
          return null;
        return ((SetFunction)paramObject).getValue();
      }
    case 1:
      localObject1 = this.eArg.getAggregatedValue(paramSession, paramObject == null ? null : ((Object[])paramObject)[0]);
      if (paramObject == null)
        localObject2 = this.eArg2 == null ? null : this.eArg2.getValue(paramSession);
      else
        localObject2 = ((Object[])paramObject)[1];
      break;
    case 2:
      if (paramObject == null)
        localObject1 = this.eArg == null ? null : this.eArg.getValue(paramSession);
      else
        localObject1 = ((Object[])paramObject)[0];
      localObject2 = this.eArg2.getAggregatedValue(paramSession, paramObject == null ? null : ((Object[])paramObject)[1]);
      break;
    case 3:
      if (paramObject == null)
        paramObject = new Object[2];
      localObject1 = this.eArg.getAggregatedValue(paramSession, ((Object[])paramObject)[0]);
      localObject2 = this.eArg2.getAggregatedValue(paramSession, ((Object[])paramObject)[1]);
    case 0:
    }
    switch (this.exprType)
    {
    case 10:
      return Column.negate(localObject1, this.dataType);
    case 61:
      return Column.convertObject(paramSession, localObject1, this.dataType, this.precision, this.scale);
    case 4:
      return Boolean.TRUE;
    case -4:
      return Boolean.FALSE;
    case 20:
      if (localObject1 == null)
        return null;
      return ((Boolean)localObject1).booleanValue() ? Boolean.FALSE : Boolean.TRUE;
    case 28:
      if ((localObject1 == null) || (localObject2 == null))
        return null;
      return (((Boolean)localObject1).booleanValue()) && (((Boolean)localObject2).booleanValue()) ? Boolean.TRUE : Boolean.FALSE;
    case 29:
      if (Boolean.TRUE.equals(localObject1))
        return Boolean.TRUE;
      return Boolean.TRUE.equals(localObject2) ? Boolean.TRUE : Boolean.FALSE;
    case 34:
      return localObject1 == null ? Boolean.TRUE : Boolean.FALSE;
    case 27:
      String str1 = (String)Column.convertObject(localObject2, 12);
      if ((this.eArg2.isParam) || (this.eArg2.exprType != 1))
        this.likeObject.resetPattern(paramSession, str1);
      String str2 = (String)Column.convertObject(localObject1, 12);
      return this.likeObject.compare(paramSession, str2);
    case 32:
    case 33:
      return null;
    case 30:
      return this.eArg2.testInCondition(paramSession, localObject1);
    case 31:
      if (!this.eArg.subQuery.isResolved)
      {
        Result localResult = this.eArg.subQuery.select.getResult(paramSession, 1);
        return localResult.rRoot == null ? Boolean.FALSE : Boolean.TRUE;
      }
      return this.subQuery.table.isEmpty(paramSession) ? Boolean.FALSE : Boolean.TRUE;
    case 62:
      localObject1 = Column.convertObject(localObject1, 16);
      boolean bool = ((Boolean)localObject1).booleanValue();
      Object localObject3 = bool ? ((Object[])localObject2)[0] : ((Object[])localObject2)[1];
      return Column.convertObject(localObject3, this.dataType);
    case 70:
      localObject1 = Column.convertObject(localObject1, this.dataType);
      localObject2 = Column.convertObject(localObject2, this.dataType);
      Object[] arrayOfObject = new Object[2];
      arrayOfObject[0] = localObject1;
      arrayOfObject[1] = localObject2;
      return arrayOfObject;
    case 7:
      return this.function.getAggregatedValue(paramSession, paramObject);
    }
    if (isCompare(this.exprType))
    {
      if ((this.eArg2.exprType == 33) || (this.eArg2.exprType == 32))
        return testAnyAllCondition(paramSession, localObject1);
      return compareValues(paramSession, localObject1, localObject2);
    }
    if (localObject1 != null)
      localObject1 = Column.convertObject(localObject1, this.dataType);
    if (localObject2 != null)
      localObject2 = Column.convertObject(localObject2, this.dataType);
    switch (this.exprType)
    {
    case 11:
      return Column.add(localObject1, localObject2, this.dataType);
    case 12:
      return Column.subtract(localObject1, localObject2, this.dataType);
    case 13:
      return Column.multiply(localObject1, localObject2, this.dataType);
    case 14:
      return Column.divide(localObject1, localObject2, this.dataType);
    case 15:
      return Column.concat(localObject1, localObject2);
    }
    throw Trace.error(14, describe(paramSession));
  }

  Object updateAggregatingValue(Session paramSession, Object paramObject)
    throws HsqlException
  {
    Object localObject;
    switch (this.aggregateSpec)
    {
    case -1:
      if (paramObject == null)
        paramObject = new SetFunction(this.exprType, this.eArg.dataType, this.isDistinctAggregate);
      localObject = this.eArg.exprType == 6 ? INTEGER_1 : this.eArg.getValue(paramSession);
      ((SetFunction)paramObject).add(paramSession, localObject);
      return paramObject;
    case 3:
      localObject = (Object[])paramObject;
      if (localObject == null)
        localObject = new Object[2];
      localObject[0] = this.eArg.updateAggregatingValue(paramSession, localObject[0]);
      localObject[1] = this.eArg2.updateAggregatingValue(paramSession, localObject[1]);
      return localObject;
    case 1:
      localObject = (Object[])paramObject;
      if (localObject == null)
        localObject = new Object[2];
      localObject[0] = this.eArg.updateAggregatingValue(paramSession, localObject[0]);
      if (this.eArg2 != null)
        localObject[1] = this.eArg2.getValue(paramSession);
      return localObject;
    case 2:
      localObject = (Object[])paramObject;
      if (localObject == null)
        localObject = new Object[2];
      if (this.eArg != null)
        localObject[0] = this.eArg.getValue(paramSession);
      localObject[1] = this.eArg2.updateAggregatingValue(paramSession, localObject[1]);
      return localObject;
    case 4:
      return this.function.updateAggregatingValue(paramSession, paramObject);
    case 0:
    }
    return paramObject;
  }

  Object getValue(Session paramSession)
    throws HsqlException
  {
    switch (this.exprType)
    {
    case 1:
      return this.valueData;
    case 2:
      try
      {
        return this.tableFilter.currentData[this.columnIndex];
      }
      catch (NullPointerException localNullPointerException)
      {
        localObject2 = this.tableName + '.' + this.columnName;
        throw Trace.error(28, localObject2);
      }
    case 7:
      return this.function.getValue(paramSession);
    case 3:
      return this.subQuery.select.getValue(paramSession, this.dataType);
    case 10:
      return Column.negate(this.eArg.getValue(paramSession, this.dataType), this.dataType);
    case 32:
    case 33:
      return null;
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
      return test(paramSession);
    case 61:
      return Column.convertObject(paramSession, this.eArg.getValue(paramSession), this.dataType, this.precision, this.scale);
    case 62:
      localObject1 = this.eArg.test(paramSession);
      if (Boolean.TRUE.equals(localObject1))
        return this.eArg2.eArg.getValue(paramSession, this.dataType);
      return this.eArg2.eArg2.getValue(paramSession, this.dataType);
    case 70:
      return new Object[] { this.eArg.getValue(paramSession, this.dataType), this.eArg2.getValue(paramSession, this.dataType) };
    }
    Object localObject1 = null;
    Object localObject2 = null;
    if (this.eArg != null)
      localObject1 = this.eArg.getValue(paramSession, this.dataType);
    if (this.eArg2 != null)
      localObject2 = this.eArg2.getValue(paramSession, this.dataType);
    switch (this.exprType)
    {
    case 11:
      return Column.add(localObject1, localObject2, this.dataType);
    case 12:
      return Column.subtract(localObject1, localObject2, this.dataType);
    case 13:
      return Column.multiply(localObject1, localObject2, this.dataType);
    case 14:
      return Column.divide(localObject1, localObject2, this.dataType);
    case 15:
      return Column.concat(localObject1, localObject2);
    case 71:
      return ((NumberSequence)this.valueData).getValueObject();
    }
    return test(paramSession);
  }

  boolean testCondition(Session paramSession)
    throws HsqlException
  {
    return Boolean.TRUE.equals(test(paramSession));
  }

  Boolean test(Session paramSession)
    throws HsqlException
  {
    Object localObject3;
    switch (this.exprType)
    {
    case 4:
      return Boolean.TRUE;
    case -4:
      return Boolean.FALSE;
    case 20:
      if (this.eArg2 != null)
        Trace.doAssert(false, "Expression.test");
      localObject1 = this.eArg.test(paramSession);
      return ((Boolean)localObject1).booleanValue() ? Boolean.FALSE : localObject1 == null ? null : Boolean.TRUE;
    case 28:
      Boolean localBoolean = this.eArg.test(paramSession);
      if (localBoolean == null)
        return null;
      localObject3 = this.eArg2.test(paramSession);
      if (localObject3 == null)
        return null;
      return (localBoolean.booleanValue()) && (((Boolean)localObject3).booleanValue()) ? Boolean.TRUE : Boolean.FALSE;
    case 29:
      boolean bool = Boolean.TRUE.equals(this.eArg.test(paramSession));
      if (bool)
        return Boolean.TRUE;
      return Boolean.TRUE.equals(this.eArg2.test(paramSession)) ? Boolean.TRUE : Boolean.FALSE;
    case 34:
      return this.eArg.getValue(paramSession) == null ? Boolean.TRUE : Boolean.FALSE;
    case 27:
      localObject2 = (String)this.eArg2.getValue(paramSession, 12);
      if ((this.eArg2.isParam) || (this.eArg2.exprType != 1))
        this.likeObject.resetPattern(paramSession, (String)localObject2);
      localObject3 = (String)this.eArg.getValue(paramSession, 12);
      return this.likeObject.compare(paramSession, (String)localObject3);
    case 30:
      return this.eArg2.testInCondition(paramSession, this.eArg.getValue(paramSession));
    case 31:
      return this.eArg.testExistsCondition(paramSession);
    case 7:
      Object localObject4 = Column.convertObject(this.function.getValue(paramSession), 16);
      return (Boolean)localObject4;
    case -3:
    case -2:
    case -1:
    case 0:
    case 1:
    case 2:
    case 3:
    case 5:
    case 6:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 32:
    case 33:
    }
    if ((this.eArg == null) || (this.eArg2 == null))
    {
      if ((this.exprType == 2) && ((this.dataType == 16) || (Types.isNumberType(this.dataType))))
      {
        localObject1 = Column.convertObject(getValue(paramSession), 16);
        return (Boolean)localObject1;
      }
      throw Trace.error(106);
    }
    if ((this.eArg2.exprType == 33) || (this.eArg2.exprType == 32))
      return testAnyAllCondition(paramSession, this.eArg.getValue(paramSession));
    Object localObject1 = this.eArg.getValue(paramSession);
    Object localObject2 = this.eArg2.getValue(paramSession);
    if ((localObject1 == null) || (localObject2 == null))
    {
      if ((this.eArg.tableFilter != null) && (this.eArg.tableFilter.isOuterJoin))
        if (this.isInJoin)
        {
          if ((this.eArg.tableFilter.isCurrentOuter) && (localObject1 == null))
            return Boolean.TRUE;
        }
        else
          this.eArg.tableFilter.nonJoinIsNull = (localObject2 == null);
      return null;
    }
    return (Boolean)(Boolean)(Boolean)compareValues(paramSession, localObject1, localObject2);
  }

  private Boolean compareValues(Session paramSession, Object paramObject1, Object paramObject2)
    throws HsqlException
  {
    int i = this.eArg.dataType;
    if (this.eArg.dataType != this.eArg2.dataType)
    {
      if ((Types.isNumberType(this.eArg.dataType)) && (Types.isNumberType(this.eArg2.dataType)))
        i = Column.getCombinedNumberType(this.eArg.dataType, this.eArg2.dataType, this.exprType);
      paramObject1 = Column.convertObject(paramObject1, i);
      paramObject2 = Column.convertObject(paramObject2, i);
    }
    int j = Column.compare(paramSession.database.collation, paramObject1, paramObject2, i);
    switch (this.exprType)
    {
    case 21:
      return j == 0 ? Boolean.TRUE : Boolean.FALSE;
    case 23:
      return j > 0 ? Boolean.TRUE : Boolean.FALSE;
    case 22:
      return j >= 0 ? Boolean.TRUE : Boolean.FALSE;
    case 25:
      return j <= 0 ? Boolean.TRUE : Boolean.FALSE;
    case 24:
      return j < 0 ? Boolean.TRUE : Boolean.FALSE;
    case 26:
      return j != 0 ? Boolean.TRUE : Boolean.FALSE;
    }
    throw Trace.error(40, 167);
  }

  private Boolean testInCondition(Session paramSession, Object paramObject)
    throws HsqlException
  {
    if (paramObject == null)
      return null;
    if (this.exprType == 5)
    {
      try
      {
        paramObject = Column.convertObject(paramObject, this.dataType);
      }
      catch (HsqlException localHsqlException1)
      {
        return Boolean.FALSE;
      }
      if (this.isFixedConstantValueList)
      {
        if (this.dataType == 1)
          paramObject = Library.rtrim((String)paramObject);
        return this.hList.contains(paramObject) ? Boolean.TRUE : Boolean.FALSE;
      }
      int i = this.valueList.length;
      for (int j = 0; j < i; j++)
      {
        Object localObject = this.valueList[j].getValue(paramSession, this.dataType);
        if (Column.compare(paramSession.database.collation, paramObject, localObject, this.dataType) == 0)
          return Boolean.TRUE;
      }
      return Boolean.FALSE;
    }
    if (this.exprType == 3)
    {
      try
      {
        paramObject = Column.convertObject(paramObject, this.subQuery.table.getColumnTypes()[0]);
      }
      catch (HsqlException localHsqlException2)
      {
        return Boolean.FALSE;
      }
      if (!this.subQuery.isResolved)
        this.subQuery.populateTable(paramSession);
      Boolean localBoolean = this.subQuery.table.getPrimaryIndex().findFirstRow(paramSession, paramObject, 21).hasNext() ? Boolean.TRUE : Boolean.FALSE;
      if (!this.subQuery.isResolved)
        this.subQuery.table.clearAllRows(paramSession);
      return localBoolean;
    }
    throw Trace.error(16);
  }

  private Boolean testExistsCondition(Session paramSession)
    throws HsqlException
  {
    if (this.subQuery.isResolved)
      return this.subQuery.table.isEmpty(paramSession) ? Boolean.FALSE : Boolean.TRUE;
    Result localResult = this.subQuery.select.getResult(paramSession, 1);
    return localResult.rRoot == null ? Boolean.FALSE : Boolean.TRUE;
  }

  private Boolean testAnyAllCondition(Session paramSession, Object paramObject)
    throws HsqlException
  {
    if (paramObject == null)
      return null;
    SubQuery localSubQuery = this.eArg2.eArg.subQuery;
    int i = !localSubQuery.isResolved ? 1 : 0;
    if (i != 0)
      localSubQuery.populateTable(paramSession);
    Boolean localBoolean = getAnyAllValue(paramSession, paramObject, localSubQuery);
    if (i != 0)
      localSubQuery.table.clearAllRows(paramSession);
    return localBoolean;
  }

  private Boolean getAnyAllValue(Session paramSession, Object paramObject, SubQuery paramSubQuery)
    throws HsqlException
  {
    boolean bool = paramSubQuery.table.isEmpty(paramSession);
    Index localIndex = paramSubQuery.table.getPrimaryIndex();
    RowIterator localRowIterator = localIndex.findFirstRowNotNull(paramSession);
    Row localRow1 = localRowIterator.next();
    int i;
    Row localRow2;
    Object localObject1;
    Object localObject2;
    int j;
    int k;
    switch (this.eArg2.exprType)
    {
    case 33:
      if (bool)
        return Boolean.FALSE;
      if (localRow1 == null)
        return null;
      i = Column.compareToTypeRange(paramObject, this.eArg2.eArg.getDataType());
      if (i != 0)
        switch (this.exprType)
        {
        case 21:
          return Boolean.FALSE;
        case 26:
          return Boolean.TRUE;
        case 22:
        case 23:
          return i > 0 ? Boolean.TRUE : Boolean.FALSE;
        case 24:
        case 25:
          return i < 0 ? Boolean.TRUE : Boolean.FALSE;
        }
      paramObject = Column.convertObject(paramObject, this.eArg2.eArg.getDataType());
      if (this.exprType == 21)
      {
        localRowIterator = localIndex.findFirstRow(paramSession, paramObject, 21);
        return localRowIterator.hasNext() ? Boolean.TRUE : Boolean.FALSE;
      }
      localRow2 = localIndex.lastRow(paramSession);
      localObject1 = localRow1.getData()[0];
      localObject2 = localRow2.getData()[0];
      j = Column.compare(paramSession.database.collation, paramObject, localObject1, this.eArg.getDataType());
      k = Column.compare(paramSession.database.collation, paramObject, localObject2, this.eArg.getDataType());
      switch (this.exprType)
      {
      case 26:
        return (j == 0) && (k == 0) ? Boolean.FALSE : Boolean.TRUE;
      case 23:
        return j > 0 ? Boolean.TRUE : Boolean.FALSE;
      case 22:
        return j >= 0 ? Boolean.TRUE : Boolean.FALSE;
      case 24:
        return k < 0 ? Boolean.TRUE : Boolean.FALSE;
      case 25:
        return k <= 0 ? Boolean.TRUE : Boolean.FALSE;
      }
      break;
    case 32:
      if (bool)
        return Boolean.TRUE;
      if (localRow1 == null)
        return null;
      i = Column.compareToTypeRange(paramObject, this.eArg2.eArg.getDataType());
      if (i != 0)
        switch (this.exprType)
        {
        case 21:
          return Boolean.FALSE;
        case 26:
          return Boolean.TRUE;
        case 22:
        case 23:
          return i > 0 ? Boolean.TRUE : Boolean.FALSE;
        case 24:
        case 25:
          return i < 0 ? Boolean.TRUE : Boolean.FALSE;
        }
      paramObject = Column.convertObject(paramObject, this.eArg2.eArg.getDataType());
      if ((this.exprType == 21) || (this.exprType == 26))
      {
        localRowIterator = localIndex.findFirstRow(paramSession, paramObject, 21);
        if (this.exprType == 21)
          return (localRowIterator.hasNext()) && (paramSubQuery.table.getRowCount(paramSession) == 1) ? Boolean.TRUE : Boolean.FALSE;
        return localRowIterator.hasNext() ? Boolean.FALSE : Boolean.TRUE;
      }
      localRow2 = localIndex.lastRow(paramSession);
      localObject1 = localRow1.getData()[0];
      localObject2 = localRow2.getData()[0];
      paramObject = Column.convertObject(paramObject, this.eArg2.eArg.getDataType());
      j = Column.compare(paramSession.database.collation, paramObject, localObject1, this.eArg.getDataType());
      k = Column.compare(paramSession.database.collation, paramObject, localObject2, this.eArg.getDataType());
      switch (this.exprType)
      {
      case 26:
        return (j == 0) || (k == 0) ? Boolean.FALSE : Boolean.TRUE;
      case 23:
        return k > 0 ? Boolean.TRUE : Boolean.FALSE;
      case 22:
        return k >= 0 ? Boolean.TRUE : Boolean.FALSE;
      case 24:
        return j < 0 ? Boolean.TRUE : Boolean.FALSE;
      case 25:
        return j <= 0 ? Boolean.TRUE : Boolean.FALSE;
      }
    }
    return null;
  }

  boolean setForJoin(TableFilter paramTableFilter, boolean paramBoolean)
  {
    this.isInJoin = paramBoolean;
    if (paramBoolean)
      this.outerFilter = paramTableFilter;
    if ((this.eArg != null) && (!this.eArg.setForJoin(paramTableFilter, paramBoolean)))
      return false;
    if ((this.eArg2 != null) && (!this.eArg2.setForJoin(paramTableFilter, paramBoolean)))
      return false;
    return (!paramBoolean) || (this.exprType == 28) || (this.exprType == 29) || (this.exprType == 2) || (this.exprType == 1) || (this.exprType == 21) || (this.exprType == 26) || (this.exprType == 23) || (this.exprType == 22) || (this.exprType == 24) || (this.exprType == 25) || (this.exprType == 34);
  }

  static Select getCheckSelect(Session paramSession, Table paramTable, Expression paramExpression)
    throws HsqlException
  {
    Select localSelect = new Select();
    localSelect.exprColumns = new Expression[1];
    localSelect.exprColumns[0] = new Expression(1, Boolean.TRUE);
    localSelect.tFilter = new TableFilter[1];
    localSelect.tFilter[0] = new TableFilter(paramTable, null, null, false);
    Expression localExpression = new Expression(20, paramExpression, null);
    localSelect.queryCondition = localExpression;
    localSelect.resolveAll(paramSession, true);
    return localSelect;
  }

  void setLeftExpression(Expression paramExpression)
  {
    this.eArg = paramExpression;
  }

  void setRightExpression(Expression paramExpression)
  {
    this.eArg2 = paramExpression;
  }

  Expression getRightExpression()
  {
    return this.eArg2;
  }

  void bind(Object paramObject)
  {
    this.valueData = paramObject;
  }

  boolean isParam()
  {
    return this.isParam;
  }

  boolean isFixedConstant()
  {
    switch (this.exprType)
    {
    case 1:
      return !this.isParam;
    case 10:
      return this.eArg.isFixedConstant();
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
      return (this.eArg.isFixedConstant()) && (this.eArg2.isFixedConstant());
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    }
    return false;
  }

  boolean isFixedConditional()
  {
    switch (this.exprType)
    {
    case -4:
    case 4:
      return true;
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
      return (this.eArg.isFixedConstant()) && (this.eArg2.isFixedConstant());
    case 34:
      return this.eArg.isFixedConstant();
    case 20:
      return this.eArg.isFixedConditional();
    case 28:
    case 29:
      return (this.eArg.isFixedConditional()) && (this.eArg2.isFixedConditional());
    case -3:
    case -2:
    case -1:
    case 0:
    case 1:
    case 2:
    case 3:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 30:
    case 31:
    case 32:
    case 33:
    }
    return false;
  }

  void setTableColumnAttributes(Expression paramExpression)
  {
    this.precision = paramExpression.precision;
    this.scale = paramExpression.scale;
    this.isIdentity = paramExpression.isIdentity;
    this.nullability = paramExpression.nullability;
    this.isWritable = paramExpression.isWritable;
    this.catalog = paramExpression.catalog;
    this.schema = paramExpression.schema;
  }

  void setTableColumnAttributes(Table paramTable, int paramInt)
  {
    Column localColumn = paramTable.getColumn(paramInt);
    this.dataType = localColumn.getType();
    this.precision = localColumn.getSize();
    this.scale = localColumn.getScale();
    this.isIdentity = localColumn.isIdentity();
    this.nullability = ((localColumn.isNullable()) && (!this.isIdentity) ? 1 : 0);
    this.isWritable = paramTable.isWritable();
    this.catalog = paramTable.getCatalogName();
    this.schema = paramTable.getSchemaName();
  }

  String getValueClassName()
  {
    if (this.valueClassName == null)
      if (this.function == null)
        this.valueClassName = Types.getColStClsName(this.dataType == 100 ? 12 : this.dataType);
      else
        this.valueClassName = this.function.getReturnClassName();
    return this.valueClassName;
  }

  static
  {
    SQL_EXTRACT_FIELD_NAMES.addAll(new Object[] { "YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "DAYOFWEEK" });
    SQL_TRIM_SPECIFICATION.addAll(new Object[] { "LEADING", "TRAILING", "BOTH" });
    INTEGER_0 = ValuePool.getInt(0);
    INTEGER_1 = ValuePool.getInt(1);
  }

  static class Collector extends HashSet
  {
    void addAll(Expression paramExpression, int paramInt)
    {
      if (paramExpression == null)
        return;
      addAll(paramExpression.getArg(), paramInt);
      addAll(paramExpression.getArg2(), paramInt);
      if (paramExpression.exprType == paramInt)
        add(paramExpression);
      if (paramExpression.subQuery != null)
        addAll(paramExpression.subQuery.select, paramInt);
      Function localFunction = paramExpression.function;
      int i;
      if (localFunction != null)
      {
        arrayOfExpression = localFunction.eArg;
        if (arrayOfExpression != null)
          for (i = 0; i < arrayOfExpression.length; i++)
            addAll(arrayOfExpression[i], paramInt);
      }
      Expression[] arrayOfExpression = paramExpression.valueList;
      if (arrayOfExpression != null)
        for (i = 0; i < arrayOfExpression.length; i++)
          addAll(arrayOfExpression[i], paramInt);
    }

    void addAll(Select paramSelect, int paramInt)
    {
      while (paramSelect != null)
      {
        Expression[] arrayOfExpression = paramSelect.exprColumns;
        for (int i = 0; i < arrayOfExpression.length; i++)
          addAll(arrayOfExpression[i], paramInt);
        addAll(paramSelect.queryCondition, paramInt);
        addAll(paramSelect.havingCondition, paramInt);
        paramSelect = paramSelect.unionSelect;
      }
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Expression
 * JD-Core Version:    0.6.0
 */