package org.hsqldb;

import java.util.Vector;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.store.ValuePool;

public class DatabaseManager
{
  private static int dbIDCounter;
  static final HashMap memDatabaseMap = new HashMap();
  static final HashMap fileDatabaseMap = new HashMap();
  static final HashMap resDatabaseMap = new HashMap();
  static final IntKeyHashMap databaseIDMap = new IntKeyHashMap();
  static HashMap serverMap = new HashMap();
  private static final HsqlTimer timer = new HsqlTimer();

  public static Vector getDatabaseURIs()
  {
    Vector localVector = new Vector();
    Iterator localIterator = databaseIDMap.values().iterator();
    while (localIterator.hasNext())
    {
      Database localDatabase = (Database)localIterator.next();
      localVector.addElement(localDatabase.getURI());
    }
    return localVector;
  }

  public static void closeDatabases(int paramInt)
  {
    Iterator localIterator = databaseIDMap.values().iterator();
    while (localIterator.hasNext())
    {
      Database localDatabase = (Database)localIterator.next();
      try
      {
        localDatabase.close(paramInt);
      }
      catch (HsqlException localHsqlException)
      {
      }
    }
  }

  static Session newSession(int paramInt, String paramString1, String paramString2)
    throws HsqlException
  {
    Database localDatabase = (Database)databaseIDMap.get(paramInt);
    return localDatabase == null ? null : localDatabase.connect(paramString1, paramString2);
  }

  public static Session newSession(String paramString1, String paramString2, String paramString3, String paramString4, HsqlProperties paramHsqlProperties)
    throws HsqlException
  {
    Database localDatabase = getDatabase(paramString1, paramString2, paramHsqlProperties);
    return localDatabase == null ? null : localDatabase.connect(paramString3, paramString4);
  }

  static Session getSession(int paramInt1, int paramInt2)
  {
    Database localDatabase = (Database)databaseIDMap.get(paramInt1);
    return localDatabase == null ? null : localDatabase.sessionManager.getSession(paramInt2);
  }

  static int getDatabase(String paramString1, String paramString2, Server paramServer, HsqlProperties paramHsqlProperties)
    throws HsqlException
  {
    Database localDatabase = getDatabase(paramString1, paramString2, paramHsqlProperties);
    registerServer(paramServer, localDatabase);
    return localDatabase.databaseID;
  }

  static Database getDatabase(String paramString1, String paramString2, HsqlProperties paramHsqlProperties)
    throws HsqlException
  {
    Database localDatabase = getDatabaseObject(paramString1, paramString2, paramHsqlProperties);
    synchronized (localDatabase)
    {
      switch (localDatabase.getState())
      {
      case 1:
        break;
      case 16:
        if (lookupDatabaseObject(paramString1, paramString2) == null)
          addDatabaseObject(paramString1, paramString2, localDatabase);
        localDatabase.open();
        break;
      case 4:
      case 8:
        throw Trace.error(1, 107);
      }
    }
    return localDatabase;
  }

  private static synchronized Database getDatabaseObject(String paramString1, String paramString2, HsqlProperties paramHsqlProperties)
    throws HsqlException
  {
    String str = paramString2;
    HashMap localHashMap;
    if (paramString1 == "file:")
    {
      localHashMap = fileDatabaseMap;
      str = filePathToKey(paramString2);
    }
    else if (paramString1 == "res:")
    {
      localHashMap = resDatabaseMap;
    }
    else if (paramString1 == "mem:")
    {
      localHashMap = memDatabaseMap;
    }
    else
    {
      throw Trace.runtimeError(201, "DatabaseManager.getDatabaseObject");
    }
    Database localDatabase = (Database)localHashMap.get(str);
    if (localDatabase == null)
    {
      localDatabase = new Database(paramString1, paramString2, paramString1 + str, paramHsqlProperties);
      localDatabase.databaseID = dbIDCounter;
      databaseIDMap.put(dbIDCounter, localDatabase);
      dbIDCounter += 1;
      localHashMap.put(str, localDatabase);
    }
    return localDatabase;
  }

  private static synchronized Database lookupDatabaseObject(String paramString1, String paramString2)
    throws HsqlException
  {
    String str = paramString2;
    HashMap localHashMap;
    if (paramString1 == "file:")
    {
      localHashMap = fileDatabaseMap;
      str = filePathToKey(paramString2);
    }
    else if (paramString1 == "res:")
    {
      localHashMap = resDatabaseMap;
    }
    else if (paramString1 == "mem:")
    {
      localHashMap = memDatabaseMap;
    }
    else
    {
      throw Trace.runtimeError(201, "DatabaseManager.lookupDatabaseObject()");
    }
    return (Database)localHashMap.get(str);
  }

  private static synchronized void addDatabaseObject(String paramString1, String paramString2, Database paramDatabase)
    throws HsqlException
  {
    String str = paramString2;
    HashMap localHashMap;
    if (paramString1 == "file:")
    {
      localHashMap = fileDatabaseMap;
      str = filePathToKey(paramString2);
    }
    else if (paramString1 == "res:")
    {
      localHashMap = resDatabaseMap;
    }
    else if (paramString1 == "mem:")
    {
      localHashMap = memDatabaseMap;
    }
    else
    {
      throw Trace.runtimeError(201, "DatabaseManager.addDatabaseObject()");
    }
    databaseIDMap.put(paramDatabase.databaseID, paramDatabase);
    localHashMap.put(str, paramDatabase);
  }

  static void removeDatabase(Database paramDatabase)
  {
    int i = paramDatabase.databaseID;
    String str1 = paramDatabase.getType();
    String str2 = paramDatabase.getPath();
    Object localObject1 = str2;
    notifyServers(paramDatabase);
    HashMap localHashMap;
    if (str1 == "file:")
    {
      localHashMap = fileDatabaseMap;
      try
      {
        localObject1 = filePathToKey(str2);
      }
      catch (HsqlException localHsqlException)
      {
        Iterator localIterator = localHashMap.keySet().iterator();
        Object localObject2 = null;
        while (localIterator.hasNext())
        {
          Object localObject3 = localIterator.next();
          if (localHashMap.get(localObject3) != paramDatabase)
            continue;
          localObject2 = localObject3;
        }
        if (localObject2 != null)
          localObject1 = localObject2;
      }
    }
    else if (str1 == "res:")
    {
      localHashMap = resDatabaseMap;
    }
    else if (str1 == "mem:")
    {
      localHashMap = memDatabaseMap;
    }
    else
    {
      throw Trace.runtimeError(201, "DatabaseManager.lookupDatabaseObject()");
    }
    databaseIDMap.remove(i);
    localHashMap.remove(localObject1);
    if (databaseIDMap.isEmpty())
      ValuePool.resetPool();
  }

  static void deRegisterServer(Server paramServer)
  {
    serverMap.remove(paramServer);
  }

  private static void deRegisterServer(Server paramServer, Database paramDatabase)
  {
    Iterator localIterator = serverMap.values().iterator();
    while (localIterator.hasNext())
    {
      HashSet localHashSet = (HashSet)localIterator.next();
      localHashSet.remove(paramDatabase);
      if (!localHashSet.isEmpty())
        continue;
      localIterator.remove();
    }
  }

  private static void registerServer(Server paramServer, Database paramDatabase)
  {
    if (!serverMap.containsKey(paramServer))
      serverMap.put(paramServer, new HashSet());
    HashSet localHashSet = (HashSet)serverMap.get(paramServer);
    localHashSet.add(paramDatabase);
  }

  private static void notifyServers(Database paramDatabase)
  {
    Iterator localIterator = serverMap.keySet().iterator();
    while (localIterator.hasNext())
    {
      Server localServer = (Server)localIterator.next();
      HashSet localHashSet = (HashSet)serverMap.get(localServer);
      if (!localHashSet.contains(paramDatabase))
        continue;
      localServer.notify(0, paramDatabase.databaseID);
    }
  }

  static boolean isServerDB(Database paramDatabase)
  {
    Iterator localIterator = serverMap.keySet().iterator();
    while (localIterator.hasNext())
    {
      Server localServer = (Server)localIterator.next();
      HashSet localHashSet = (HashSet)serverMap.get(localServer);
      if (localHashSet.contains(paramDatabase))
        return true;
    }
    return false;
  }

  public static HsqlTimer getTimer()
  {
    return timer;
  }

  private static String filePathToKey(String paramString)
    throws HsqlException
  {
    try
    {
      return FileUtil.canonicalPath(paramString);
    }
    catch (Exception localException)
    {
    }
    throw Trace.error(29, localException.toString());
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.DatabaseManager
 * JD-Core Version:    0.6.0
 */