package org.hsqldb;

import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.store.ValuePool;

class DatabaseInformationMain extends DatabaseInformation
{
  protected static final HsqlNameManager.HsqlName[] sysTableHsqlNames;
  protected final int[] sysTableSessions = new int[sysTableNames.length];
  protected final boolean[] sysTableSessionDependent = new boolean[sysTableNames.length];
  protected final Table[] sysTables = new Table[sysTableNames.length];
  protected static final HashSet nonCachedTablesSet;
  protected static final HashMap columnNameMap;
  protected Session session;
  protected static final String[] tableTypes = { "GLOBAL TEMPORARY", "SYSTEM TABLE", "TABLE", "VIEW" };
  protected DINameSpace ns;

  DatabaseInformationMain(Database paramDatabase)
    throws HsqlException
  {
    super(paramDatabase);
    init();
  }

  protected final void addColumn(Table paramTable, String paramString, int paramInt1, int paramInt2, boolean paramBoolean)
    throws HsqlException
  {
    HsqlNameManager.HsqlName localHsqlName = (HsqlNameManager.HsqlName)columnNameMap.get(paramString);
    if (localHsqlName == null)
    {
      localHsqlName = this.database.nameManager.newHsqlName(paramString, false);
      columnNameMap.put(paramString, localHsqlName);
    }
    Column localColumn = new Column(localHsqlName, paramBoolean, paramInt1, paramInt2, 0, false, null);
    paramTable.addColumn(localColumn);
  }

  protected final void addColumn(Table paramTable, String paramString, int paramInt, boolean paramBoolean)
    throws HsqlException
  {
    addColumn(paramTable, paramString, paramInt, 0, paramBoolean);
  }

  protected final void addColumn(Table paramTable, String paramString, int paramInt)
    throws HsqlException
  {
    addColumn(paramTable, paramString, paramInt, true);
  }

  protected final Iterator allTables()
  {
    return new WrapperIterator(this.database.schemaManager.allTablesIterator(), new WrapperIterator(this.sysTables, true));
  }

  protected final void cacheClear()
    throws HsqlException
  {
    int i = this.sysTables.length;
    while (i-- > 0)
    {
      Table localTable = this.sysTables[i];
      if (localTable != null)
        localTable.clearAllRows(this.session);
      this.sysTableSessions[i] = -1;
    }
    this.isDirty = false;
  }

  protected Table generateTable(int paramInt)
    throws HsqlException
  {
    Table localTable = this.sysTables[paramInt];
    switch (paramInt)
    {
    case 0:
      return SYSTEM_BESTROWIDENTIFIER();
    case 1:
      return SYSTEM_CATALOGS();
    case 2:
      return SYSTEM_COLUMNPRIVILEGES();
    case 3:
      return SYSTEM_COLUMNS();
    case 4:
      return SYSTEM_CROSSREFERENCE();
    case 5:
      return SYSTEM_INDEXINFO();
    case 6:
      return SYSTEM_PRIMARYKEYS();
    case 7:
      return SYSTEM_PROCEDURECOLUMNS();
    case 8:
      return SYSTEM_PROCEDURES();
    case 9:
      return SYSTEM_SCHEMAS();
    case 12:
      return SYSTEM_TABLEPRIVILEGES();
    case 13:
      return SYSTEM_TABLES();
    case 14:
      return SYSTEM_TABLETYPES();
    case 15:
      return SYSTEM_TYPEINFO();
    case 18:
      return SYSTEM_USERS();
    case 29:
      return SYSTEM_ALLTYPEINFO();
    case 34:
      return SYSTEM_CHECK_CONSTRAINTS();
    case 32:
      return SYSTEM_SEQUENCES();
    case 10:
    case 11:
    case 16:
    case 17:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 30:
    case 31:
    case 33:
    }
    return null;
  }

  protected final void init()
    throws HsqlException
  {
    this.ns = new DINameSpace(this.database);
    int tmp223_222 = (this.sysTableSessionDependent[0] = this.sysTableSessionDependent[2] = this.sysTableSessionDependent[3] = this.sysTableSessionDependent[4] = this.sysTableSessionDependent[5] = this.sysTableSessionDependent[6] = this.sysTableSessionDependent[8] = this.sysTableSessionDependent[7] = this.sysTableSessionDependent[12] = this.sysTableSessionDependent[13] = this.sysTableSessionDependent[27] = this.sysTableSessionDependent[28] = this.sysTableSessionDependent[30] = this.sysTableSessionDependent[31] = this.sysTableSessionDependent[34] = this.sysTableSessionDependent[32] = this.sysTableSessionDependent[33] = this.sysTableSessionDependent[35] = this.sysTableSessionDependent[36] = this.sysTableSessionDependent[37] = this.sysTableSessionDependent[38] = this.sysTableSessionDependent[39] = this.sysTableSessionDependent[40] = this.sysTableSessionDependent[41] = this.sysTableSessionDependent[42] = 1);
    this.sysTableSessionDependent[23] = tmp223_222;
    this.sysTableSessionDependent[20] = tmp223_222;
    for (int i = 0; i < this.sysTables.length; i++)
    {
      Table localTable = this.sysTables[i] =  = generateTable(i);
      if (localTable == null)
        continue;
      localTable.setDataReadOnly(true);
    }
    GranteeManager localGranteeManager = this.database.getGranteeManager();
    for (int j = 0; j < sysTableHsqlNames.length; j++)
    {
      if (this.sysTables[j] == null)
        continue;
      localGranteeManager.grant("PUBLIC", sysTableHsqlNames[j], 1);
    }
  }

  protected final boolean isAccessibleTable(Table paramTable)
    throws HsqlException
  {
    return this.session.isAccessible(paramTable.getName());
  }

  protected final Table createBlankTable(HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    return new Table(this.database, paramHsqlName, 0);
  }

  final Table getSystemTable(Session paramSession, String paramString)
    throws HsqlException
  {
    this.session = paramSession;
    if (!isSystemTable(paramString))
      return null;
    int i = getSysTableID(paramString);
    Table localTable = this.sysTables[i];
    if (localTable == null)
      return localTable;
    if (!this.withContent)
      return localTable;
    if (this.isDirty)
      cacheClear();
    int j = this.sysTableSessions[i];
    int k = j != -1 ? 1 : 0;
    if ((paramSession.getId() != j) && (this.sysTableSessionDependent[i] != 0))
      k = 0;
    if (nonCachedTablesSet.contains(paramString))
      k = 0;
    if (k != 0)
      return localTable;
    localTable.clearAllRows(paramSession);
    this.sysTableSessions[i] = paramSession.getId();
    localTable = generateTable(i);
    return localTable;
  }

  final Table SYSTEM_BESTROWIDENTIFIER()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[0];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[0]);
      addColumn(localTable1, "SCOPE", 5, false);
      addColumn(localTable1, "COLUMN_NAME", 12, false);
      addColumn(localTable1, "DATA_TYPE", 5, false);
      addColumn(localTable1, "TYPE_NAME", 12, 32, false);
      addColumn(localTable1, "COLUMN_SIZE", 4);
      addColumn(localTable1, "BUFFER_LENGTH", 4);
      addColumn(localTable1, "DECIMAL_DIGITS", 5);
      addColumn(localTable1, "PSEUDO_COLUMN", 5, false);
      addColumn(localTable1, "TABLE_CAT", 12);
      addColumn(localTable1, "TABLE_SCHEM", 12);
      addColumn(localTable1, "TABLE_NAME", 12, false);
      addColumn(localTable1, "NULLABLE", 5, false);
      addColumn(localTable1, "IN_KEY", 16, false);
      localTable1.createPrimaryKey(null, new int[] { 0, 8, 9, 10, 1 }, false);
      return localTable1;
    }
    DITableInfo localDITableInfo = new DITableInfo();
    HsqlDatabaseProperties localHsqlDatabaseProperties = this.database.getProperties();
    Iterator localIterator = localHsqlDatabaseProperties.isPropertyTrue("hsqldb.system_table_bri") ? allTables() : this.database.schemaManager.allTablesIterator();
    while (localIterator.hasNext())
    {
      Table localTable2 = (Table)localIterator.next();
      if ((localTable2.isView()) || (!isAccessibleTable(localTable2)))
        continue;
      int[] arrayOfInt = localTable2.getBestRowIdentifiers();
      if (arrayOfInt == null)
        continue;
      localDITableInfo.setTable(localTable2);
      Boolean localBoolean = ValuePool.getBoolean(localTable2.isBestRowIdentifiersStrict());
      String str1 = this.ns.getCatalogName(localTable2);
      String str2 = localTable2.getSchemaName();
      String str3 = localDITableInfo.getName();
      Integer localInteger1 = localDITableInfo.getBRIScope();
      Integer localInteger2 = localDITableInfo.getBRIPseudo();
      for (int i = 0; i < arrayOfInt.length; i++)
      {
        Object[] arrayOfObject = localTable1.getEmptyRowData();
        arrayOfObject[0] = localInteger1;
        arrayOfObject[1] = localDITableInfo.getColName(i);
        arrayOfObject[2] = localDITableInfo.getColDataType(i);
        arrayOfObject[3] = localDITableInfo.getColDataTypeName(i);
        arrayOfObject[4] = localDITableInfo.getColSize(i);
        arrayOfObject[5] = localDITableInfo.getColBufLen(i);
        arrayOfObject[6] = localDITableInfo.getColScale(i);
        arrayOfObject[7] = localInteger2;
        arrayOfObject[8] = str1;
        arrayOfObject[9] = str2;
        arrayOfObject[10] = str3;
        arrayOfObject[11] = localDITableInfo.getColNullability(i);
        arrayOfObject[12] = localBoolean;
        localTable1.insertSys(arrayOfObject);
      }
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  final Table SYSTEM_CATALOGS()
    throws HsqlException
  {
    Table localTable = this.sysTables[1];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[1]);
      addColumn(localTable, "TABLE_CAT", 12, false);
      localTable.createPrimaryKey(null, new int[] { 0 }, true);
      return localTable;
    }
    Iterator localIterator = this.ns.iterateCatalogNames();
    while (localIterator.hasNext())
    {
      Object[] arrayOfObject = localTable.getEmptyRowData();
      arrayOfObject[0] = ((String)localIterator.next());
      localTable.insertSys(arrayOfObject);
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  final Table SYSTEM_COLUMNPRIVILEGES()
    throws HsqlException
  {
    Table localTable = this.sysTables[2];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[2]);
      addColumn(localTable, "TABLE_CAT", 12);
      addColumn(localTable, "TABLE_SCHEM", 12);
      addColumn(localTable, "TABLE_NAME", 12, false);
      addColumn(localTable, "COLUMN_NAME", 12, false);
      addColumn(localTable, "GRANTOR", 12, false);
      addColumn(localTable, "GRANTEE", 12, false);
      addColumn(localTable, "PRIVILEGE", 12, 10, false);
      addColumn(localTable, "IS_GRANTABLE", 12, 3, false);
      localTable.createPrimaryKey(null, new int[] { 3, 6, 5, 4, 2, 1, 0 }, false);
      return localTable;
    }
    Result localResult = this.session.sqlExecuteDirectNoPreChecks("select a.TABLE_CAT, a.TABLE_SCHEM, a.TABLE_NAME, b.COLUMN_NAME, a.GRANTOR, a.GRANTEE, a.PRIVILEGE, a.IS_GRANTABLE from  INFORMATION_SCHEMA.SYSTEM_TABLEPRIVILEGES a, INFORMATION_SCHEMA.SYSTEM_COLUMNS b where a.TABLE_NAME = b.TABLE_NAME and a.TABLE_SCHEM = b.TABLE_SCHEM;");
    localTable.insertSys(localResult);
    localTable.setDataReadOnly(true);
    return localTable;
  }

  final Table SYSTEM_COLUMNS()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[3];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[3]);
      addColumn(localTable1, "TABLE_CAT", 12);
      addColumn(localTable1, "TABLE_SCHEM", 12);
      addColumn(localTable1, "TABLE_NAME", 12, false);
      addColumn(localTable1, "COLUMN_NAME", 12, false);
      addColumn(localTable1, "DATA_TYPE", 5, false);
      addColumn(localTable1, "TYPE_NAME", 12, 32, false);
      addColumn(localTable1, "COLUMN_SIZE", 4);
      addColumn(localTable1, "BUFFER_LENGTH", 4);
      addColumn(localTable1, "DECIMAL_DIGITS", 4);
      addColumn(localTable1, "NUM_PREC_RADIX", 4);
      addColumn(localTable1, "NULLABLE", 4, false);
      addColumn(localTable1, "REMARKS", 12);
      addColumn(localTable1, "COLUMN_DEF", 12);
      addColumn(localTable1, "SQL_DATA_TYPE", 4);
      addColumn(localTable1, "SQL_DATETIME_SUB", 4);
      addColumn(localTable1, "CHAR_OCTET_LENGTH", 4);
      addColumn(localTable1, "ORDINAL_POSITION", 4, false);
      addColumn(localTable1, "IS_NULLABLE", 12, 3, false);
      addColumn(localTable1, "SCOPE_CATLOG", 12);
      addColumn(localTable1, "SCOPE_SCHEMA", 12);
      addColumn(localTable1, "SCOPE_TABLE", 12);
      addColumn(localTable1, "SOURCE_DATA_TYPE", 12);
      addColumn(localTable1, "TYPE_SUB", 4, false);
      localTable1.createPrimaryKey(null, new int[] { 1, 2, 16, 0 }, false);
      return localTable1;
    }
    Iterator localIterator = allTables();
    DITableInfo localDITableInfo = new DITableInfo();
    while (localIterator.hasNext())
    {
      Table localTable2 = (Table)localIterator.next();
      if (!isAccessibleTable(localTable2))
        continue;
      localDITableInfo.setTable(localTable2);
      String str1 = this.ns.getCatalogName(localTable2);
      String str2 = localTable2.getSchemaName();
      String str3 = localDITableInfo.getName();
      int i = localTable2.getColumnCount();
      for (int j = 0; j < i; j++)
      {
        Object[] arrayOfObject = localTable1.getEmptyRowData();
        arrayOfObject[0] = str1;
        arrayOfObject[1] = str2;
        arrayOfObject[2] = str3;
        arrayOfObject[3] = localDITableInfo.getColName(j);
        arrayOfObject[4] = localDITableInfo.getColDataType(j);
        arrayOfObject[5] = localDITableInfo.getColDataTypeName(j);
        arrayOfObject[6] = localDITableInfo.getColSize(j);
        arrayOfObject[7] = localDITableInfo.getColBufLen(j);
        arrayOfObject[8] = localDITableInfo.getColScale(j);
        arrayOfObject[9] = localDITableInfo.getColPrecRadix(j);
        arrayOfObject[10] = localDITableInfo.getColNullability(j);
        arrayOfObject[11] = localDITableInfo.getColRemarks(j);
        arrayOfObject[12] = localDITableInfo.getColDefault(j);
        arrayOfObject[13] = localDITableInfo.getColSqlDataType(j);
        arrayOfObject[14] = localDITableInfo.getColSqlDateTimeSub(j);
        arrayOfObject[15] = localDITableInfo.getColCharOctLen(j);
        arrayOfObject[16] = ValuePool.getInt(j + 1);
        arrayOfObject[17] = localDITableInfo.getColIsNullable(j);
        arrayOfObject[22] = localDITableInfo.getColDataTypeSub(j);
        localTable1.insertSys(arrayOfObject);
      }
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  final Table SYSTEM_CROSSREFERENCE()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[4];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[4]);
      addColumn(localTable1, "PKTABLE_CAT", 12);
      addColumn(localTable1, "PKTABLE_SCHEM", 12);
      addColumn(localTable1, "PKTABLE_NAME", 12, false);
      addColumn(localTable1, "PKCOLUMN_NAME", 12, false);
      addColumn(localTable1, "FKTABLE_CAT", 12);
      addColumn(localTable1, "FKTABLE_SCHEM", 12);
      addColumn(localTable1, "FKTABLE_NAME", 12, false);
      addColumn(localTable1, "FKCOLUMN_NAME", 12, false);
      addColumn(localTable1, "KEY_SEQ", 5, false);
      addColumn(localTable1, "UPDATE_RULE", 5, false);
      addColumn(localTable1, "DELETE_RULE", 5, false);
      addColumn(localTable1, "FK_NAME", 12);
      addColumn(localTable1, "PK_NAME", 12);
      addColumn(localTable1, "DEFERRABILITY", 5, false);
      localTable1.createPrimaryKey(null, new int[] { 4, 5, 6, 8, 11 }, false);
      return localTable1;
    }
    Iterator localIterator = this.database.schemaManager.allTablesIterator();
    DITableInfo localDITableInfo1 = new DITableInfo();
    DITableInfo localDITableInfo2 = new DITableInfo();
    Integer localInteger4 = ValuePool.getInt(7);
    HsqlArrayList localHsqlArrayList = new HsqlArrayList();
    Constraint localConstraint;
    while (localIterator.hasNext())
    {
      Table localTable2 = (Table)localIterator.next();
      if (!isAccessibleTable(localTable2))
        continue;
      Constraint[] arrayOfConstraint = localTable2.getConstraints();
      int j = arrayOfConstraint.length;
      for (k = 0; k < j; k++)
      {
        localConstraint = arrayOfConstraint[k];
        if ((localConstraint.getType() != 0) || (!isAccessibleTable(localConstraint.getRef())))
          continue;
        localHsqlArrayList.add(localConstraint);
      }
    }
    for (int k = 0; k < localHsqlArrayList.size(); k++)
    {
      localConstraint = (Constraint)localHsqlArrayList.get(k);
      Table localTable4 = localConstraint.getMain();
      localDITableInfo1.setTable(localTable4);
      String str3 = localDITableInfo1.getName();
      Table localTable3 = localConstraint.getRef();
      localDITableInfo2.setTable(localTable3);
      String str7 = localDITableInfo2.getName();
      String str1 = this.ns.getCatalogName(localTable4);
      String str2 = localTable4.getSchemaName();
      String str5 = this.ns.getCatalogName(localTable3);
      String str6 = localTable3.getSchemaName();
      int[] arrayOfInt1 = localConstraint.getMainColumns();
      int[] arrayOfInt2 = localConstraint.getRefColumns();
      int i = arrayOfInt2.length;
      String str9 = localConstraint.getFkName();
      String str10 = localConstraint.getPkName();
      Integer localInteger3 = ValuePool.getInt(localConstraint.getDeleteAction());
      Integer localInteger2 = ValuePool.getInt(localConstraint.getUpdateAction());
      for (int m = 0; m < i; m++)
      {
        Integer localInteger1 = ValuePool.getInt(m + 1);
        String str4 = localDITableInfo1.getColName(arrayOfInt1[m]);
        String str8 = localDITableInfo2.getColName(arrayOfInt2[m]);
        Object[] arrayOfObject = localTable1.getEmptyRowData();
        arrayOfObject[0] = str1;
        arrayOfObject[1] = str2;
        arrayOfObject[2] = str3;
        arrayOfObject[3] = str4;
        arrayOfObject[4] = str5;
        arrayOfObject[5] = str6;
        arrayOfObject[6] = str7;
        arrayOfObject[7] = str8;
        arrayOfObject[8] = localInteger1;
        arrayOfObject[9] = localInteger2;
        arrayOfObject[10] = localInteger3;
        arrayOfObject[11] = str9;
        arrayOfObject[12] = str10;
        arrayOfObject[13] = localInteger4;
        localTable1.insertSys(arrayOfObject);
      }
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  final Table SYSTEM_INDEXINFO()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[5];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[5]);
      addColumn(localTable1, "TABLE_CAT", 12);
      addColumn(localTable1, "TABLE_SCHEM", 12);
      addColumn(localTable1, "TABLE_NAME", 12, false);
      addColumn(localTable1, "NON_UNIQUE", 16, false);
      addColumn(localTable1, "INDEX_QUALIFIER", 12);
      addColumn(localTable1, "INDEX_NAME", 12);
      addColumn(localTable1, "TYPE", 5, false);
      addColumn(localTable1, "ORDINAL_POSITION", 5, false);
      addColumn(localTable1, "COLUMN_NAME", 12);
      addColumn(localTable1, "ASC_OR_DESC", 12, 1, true);
      addColumn(localTable1, "CARDINALITY", 4);
      addColumn(localTable1, "PAGES", 4);
      addColumn(localTable1, "FILTER_CONDITION", 12);
      addColumn(localTable1, "ROW_CARDINALITY", 4);
      localTable1.createPrimaryKey(null, new int[] { 3, 6, 5, 7, 4, 2 }, false);
      return localTable1;
    }
    DITableInfo localDITableInfo = new DITableInfo();
    HsqlDatabaseProperties localHsqlDatabaseProperties = this.database.getProperties();
    Iterator localIterator = localHsqlDatabaseProperties.isPropertyTrue("hsqldb.system_table_indexinfo") ? allTables() : this.database.schemaManager.allTablesIterator();
    while (localIterator.hasNext())
    {
      Table localTable2 = (Table)localIterator.next();
      if ((localTable2.isView()) || (!isAccessibleTable(localTable2)))
        continue;
      localDITableInfo.setTable(localTable2);
      String str1 = this.ns.getCatalogName(localTable2);
      String str2 = localTable2.getSchemaName();
      String str3 = localDITableInfo.getName();
      Object localObject = null;
      String str4 = str1;
      int i = localTable2.getIndexCount();
      for (int m = 0; m < i; m++)
      {
        int k = localDITableInfo.getIndexVisibleColumns(m);
        if (k < 1)
          continue;
        String str5 = localDITableInfo.getIndexName(m);
        Boolean localBoolean = localDITableInfo.isIndexNonUnique(m);
        Integer localInteger2 = localDITableInfo.getIndexCardinality(m);
        Integer localInteger3 = ValuePool.getInt(0);
        Integer localInteger4 = localDITableInfo.getIndexRowCardinality(m);
        int[] arrayOfInt = localDITableInfo.getIndexColumns(m);
        Integer localInteger1 = localDITableInfo.getIndexType(m);
        for (int n = 0; n < k; n++)
        {
          int j = arrayOfInt[n];
          Object[] arrayOfObject = localTable1.getEmptyRowData();
          arrayOfObject[0] = str1;
          arrayOfObject[1] = str2;
          arrayOfObject[2] = str3;
          arrayOfObject[3] = localBoolean;
          arrayOfObject[4] = str4;
          arrayOfObject[5] = str5;
          arrayOfObject[6] = localInteger1;
          arrayOfObject[7] = ValuePool.getInt(n + 1);
          arrayOfObject[8] = localDITableInfo.getColName(j);
          arrayOfObject[9] = localDITableInfo.getIndexColDirection(m, j);
          arrayOfObject[10] = localInteger2;
          arrayOfObject[11] = localInteger3;
          arrayOfObject[13] = localInteger4;
          arrayOfObject[12] = localObject;
          localTable1.insertSys(arrayOfObject);
        }
      }
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  final Table SYSTEM_PRIMARYKEYS()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[6];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[6]);
      addColumn(localTable1, "TABLE_CAT", 12);
      addColumn(localTable1, "TABLE_SCHEM", 12);
      addColumn(localTable1, "TABLE_NAME", 12, false);
      addColumn(localTable1, "COLUMN_NAME", 12, false);
      addColumn(localTable1, "KEY_SEQ", 5, false);
      addColumn(localTable1, "PK_NAME", 12);
      localTable1.createPrimaryKey(null, new int[] { 3, 2, 1, 0 }, false);
      return localTable1;
    }
    HsqlDatabaseProperties localHsqlDatabaseProperties = this.database.getProperties();
    Iterator localIterator = localHsqlDatabaseProperties.isPropertyTrue("hsqldb.system_table_primarykeys") ? allTables() : this.database.schemaManager.allTablesIterator();
    while (localIterator.hasNext())
    {
      Table localTable2 = (Table)localIterator.next();
      if ((localTable2.isView()) || (!isAccessibleTable(localTable2)) || (!localTable2.hasPrimaryKey()))
        continue;
      Constraint localConstraint = localTable2.getPrimaryConstraint();
      String str1 = this.ns.getCatalogName(localTable2);
      String str2 = localTable2.getSchemaName();
      String str3 = localTable2.getName().name;
      String str4 = localConstraint.getName().name;
      int[] arrayOfInt = localConstraint.getMainColumns();
      int i = arrayOfInt.length;
      for (int j = 0; j < i; j++)
      {
        Object[] arrayOfObject = localTable1.getEmptyRowData();
        arrayOfObject[0] = str1;
        arrayOfObject[1] = str2;
        arrayOfObject[2] = str3;
        arrayOfObject[3] = localTable2.getColumn(arrayOfInt[j]).columnName.name;
        arrayOfObject[4] = ValuePool.getInt(j + 1);
        arrayOfObject[5] = str4;
        localTable1.insertSys(arrayOfObject);
      }
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  Table SYSTEM_PROCEDURECOLUMNS()
    throws HsqlException
  {
    Table localTable = this.sysTables[7];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[7]);
      addColumn(localTable, "PROCEDURE_CAT", 12);
      addColumn(localTable, "PROCEDURE_SCHEM", 12);
      addColumn(localTable, "PROCEDURE_NAME", 12, false);
      addColumn(localTable, "COLUMN_NAME", 12, false);
      addColumn(localTable, "COLUMN_TYPE", 5, false);
      addColumn(localTable, "DATA_TYPE", 5, false);
      addColumn(localTable, "TYPE_NAME", 12, 32, false);
      addColumn(localTable, "PRECISION", 4);
      addColumn(localTable, "LENGTH", 4);
      addColumn(localTable, "SCALE", 5);
      addColumn(localTable, "RADIX", 5);
      addColumn(localTable, "NULLABLE", 5, false);
      addColumn(localTable, "REMARKS", 12);
      addColumn(localTable, "SPECIFIC_NAME", 12, false);
      addColumn(localTable, "SEQ", 4, false);
      localTable.createPrimaryKey(null, new int[] { 1, 2, 13, 14, 0 }, false);
      return localTable;
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_PROCEDURES()
    throws HsqlException
  {
    Table localTable = this.sysTables[8];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[8]);
      addColumn(localTable, "PROCEDURE_CAT", 12);
      addColumn(localTable, "PROCEDURE_SCHEM", 12);
      addColumn(localTable, "PROCEDURE_NAME", 12, false);
      addColumn(localTable, "NUM_INPUT_PARAMS", 4);
      addColumn(localTable, "NUM_OUTPUT_PARAMS", 4);
      addColumn(localTable, "NUM_RESULT_SETS", 4);
      addColumn(localTable, "REMARKS", 12);
      addColumn(localTable, "PROCEDURE_TYPE", 5, false);
      addColumn(localTable, "ORIGIN", 12, 32, false);
      addColumn(localTable, "SPECIFIC_NAME", 12, false);
      localTable.createPrimaryKey(null, new int[] { 1, 2, 9, 0 }, false);
      return localTable;
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  final Table SYSTEM_SCHEMAS()
    throws HsqlException
  {
    Table localTable = this.sysTables[9];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[9]);
      addColumn(localTable, "TABLE_SCHEM", 12, false);
      addColumn(localTable, "TABLE_CATALOG", 12);
      addColumn(localTable, "IS_DEFAULT", 16);
      localTable.createPrimaryKey(null, new int[] { 0 }, true);
      return localTable;
    }
    Iterator localIterator = this.database.schemaManager.fullSchemaNamesIterator();
    String str1 = this.database.schemaManager.getDefaultSchemaName();
    while (localIterator.hasNext())
    {
      Object[] arrayOfObject = localTable.getEmptyRowData();
      String str2 = (String)localIterator.next();
      arrayOfObject[0] = str2;
      arrayOfObject[1] = this.ns.getCatalogName(arrayOfObject[0]);
      arrayOfObject[2] = (str2.equals(str1) ? Boolean.TRUE : Boolean.FALSE);
      localTable.insertSys(arrayOfObject);
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  final Table SYSTEM_TABLEPRIVILEGES()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[12];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[12]);
      addColumn(localTable1, "TABLE_CAT", 12);
      addColumn(localTable1, "TABLE_SCHEM", 12);
      addColumn(localTable1, "TABLE_NAME", 12, false);
      addColumn(localTable1, "GRANTOR", 12, false);
      addColumn(localTable1, "GRANTEE", 12, false);
      addColumn(localTable1, "PRIVILEGE", 12, 10, false);
      addColumn(localTable1, "IS_GRANTABLE", 12, 3, false);
      localTable1.createPrimaryKey(null, new int[] { 1, 2, 5, 4, 3, 0 }, false);
      return localTable1;
    }
    String str4 = "DBA";
    HsqlArrayList localHsqlArrayList = this.database.getUserManager().listVisibleUsers(this.session, true);
    Iterator localIterator = allTables();
    while (localIterator.hasNext())
    {
      Table localTable2 = (Table)localIterator.next();
      HsqlNameManager.HsqlName localHsqlName = localTable2.getName();
      if (!isAccessibleTable(localTable2))
        continue;
      String str3 = localTable2.getName().name;
      String str1 = this.ns.getCatalogName(localTable2);
      String str2 = localTable2.getSchemaName();
      for (int i = 0; i < localHsqlArrayList.size(); i++)
      {
        User localUser = (User)localHsqlArrayList.get(i);
        String str5 = localUser.getName();
        String[] arrayOfString;
        if (localUser.isAdmin())
          arrayOfString = UserManager.getRightsArray(15);
        else
          arrayOfString = localUser.listGrantedTablePrivileges(localHsqlName);
        String str7 = localUser.isAdmin() ? "YES" : "NO";
        for (int j = 0; j < arrayOfString.length; j++)
        {
          String str6 = arrayOfString[j];
          Object[] arrayOfObject = localTable1.getEmptyRowData();
          arrayOfObject[0] = str1;
          arrayOfObject[1] = str2;
          arrayOfObject[2] = str3;
          arrayOfObject[3] = str4;
          arrayOfObject[4] = str5;
          arrayOfObject[5] = str6;
          arrayOfObject[6] = str7;
          localTable1.insertSys(arrayOfObject);
        }
      }
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  final Table SYSTEM_TABLES()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[13];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[13]);
      addColumn(localTable1, "TABLE_CAT", 12);
      addColumn(localTable1, "TABLE_SCHEM", 12);
      addColumn(localTable1, "TABLE_NAME", 12, false);
      addColumn(localTable1, "TABLE_TYPE", 12, 16, false);
      addColumn(localTable1, "REMARKS", 12);
      addColumn(localTable1, "TYPE_CAT", 12);
      addColumn(localTable1, "TYPE_SCHEM", 12);
      addColumn(localTable1, "TYPE_NAME", 12);
      addColumn(localTable1, "SELF_REFERENCING_COL_NAME", 12);
      addColumn(localTable1, "REF_GENERATION", 12);
      addColumn(localTable1, "HSQLDB_TYPE", 12, 6, true);
      addColumn(localTable1, "READ_ONLY", 16, false);
      localTable1.createPrimaryKey(null, new int[] { 3, 1, 2, 0 }, false);
      return localTable1;
    }
    Iterator localIterator = allTables();
    DITableInfo localDITableInfo = new DITableInfo();
    while (localIterator.hasNext())
    {
      Table localTable2 = (Table)localIterator.next();
      if (!isAccessibleTable(localTable2))
        continue;
      localDITableInfo.setTable(localTable2);
      Object[] arrayOfObject = localTable1.getEmptyRowData();
      arrayOfObject[0] = this.ns.getCatalogName(localTable2);
      arrayOfObject[1] = localTable2.getSchemaName();
      arrayOfObject[2] = localDITableInfo.getName();
      arrayOfObject[3] = localDITableInfo.getStandardType();
      arrayOfObject[4] = localDITableInfo.getRemark();
      arrayOfObject[10] = localDITableInfo.getHsqlType();
      arrayOfObject[11] = localDITableInfo.isReadOnly();
      localTable1.insertSys(arrayOfObject);
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  Table SYSTEM_TABLETYPES()
    throws HsqlException
  {
    Table localTable = this.sysTables[14];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[14]);
      addColumn(localTable, "TABLE_TYPE", 12, 16, false);
      localTable.createPrimaryKey(null, new int[] { 0 }, true);
      return localTable;
    }
    for (int i = 0; i < tableTypes.length; i++)
    {
      Object[] arrayOfObject = localTable.getEmptyRowData();
      arrayOfObject[0] = tableTypes[i];
      localTable.insertSys(arrayOfObject);
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  final Table SYSTEM_TYPEINFO()
    throws HsqlException
  {
    Table localTable = this.sysTables[15];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[15]);
      addColumn(localTable, "TYPE_NAME", 12, 32, false);
      addColumn(localTable, "DATA_TYPE", 5, false);
      addColumn(localTable, "PRECISION", 4);
      addColumn(localTable, "LITERAL_PREFIX", 12, 2, true);
      addColumn(localTable, "LITERAL_SUFFIX", 12, 2, true);
      addColumn(localTable, "CREATE_PARAMS", 12);
      addColumn(localTable, "NULLABLE", 5);
      addColumn(localTable, "CASE_SENSITIVE", 16);
      addColumn(localTable, "SEARCHABLE", 5);
      addColumn(localTable, "UNSIGNED_ATTRIBUTE", 16);
      addColumn(localTable, "FIXED_PREC_SCALE", 16);
      addColumn(localTable, "AUTO_INCREMENT", 16);
      addColumn(localTable, "LOCAL_TYPE_NAME", 12);
      addColumn(localTable, "MINIMUM_SCALE", 5);
      addColumn(localTable, "MAXIMUM_SCALE", 5);
      addColumn(localTable, "SQL_DATA_TYPE", 4);
      addColumn(localTable, "SQL_DATETIME_SUB", 4);
      addColumn(localTable, "NUM_PREC_RADIX", 4);
      addColumn(localTable, "TYPE_SUB", 4);
      localTable.createPrimaryKey(null, new int[] { 1, 18 }, true);
      return localTable;
    }
    Result localResult = this.session.sqlExecuteDirectNoPreChecks("select TYPE_NAME, DATA_TYPE, PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX, CREATE_PARAMS, NULLABLE, CASE_SENSITIVE, SEARCHABLE,UNSIGNED_ATTRIBUTE, FIXED_PREC_SCALE, AUTO_INCREMENT, LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE, SQL_DATA_TYPE, SQL_DATETIME_SUB, NUM_PREC_RADIX, TYPE_SUB from INFORMATION_SCHEMA.SYSTEM_ALLTYPEINFO  where AS_TAB_COL = true;");
    localTable.insertSys(localResult);
    localTable.setDataReadOnly(true);
    return localTable;
  }

  final Table SYSTEM_ALLTYPEINFO()
    throws HsqlException
  {
    Table localTable = this.sysTables[29];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[29]);
      addColumn(localTable, "TYPE_NAME", 12, 32, false);
      addColumn(localTable, "DATA_TYPE", 5, false);
      addColumn(localTable, "PRECISION", 4);
      addColumn(localTable, "LITERAL_PREFIX", 12, 2, true);
      addColumn(localTable, "LITERAL_SUFFIX", 12, 2, true);
      addColumn(localTable, "CREATE_PARAMS", 12);
      addColumn(localTable, "NULLABLE", 5);
      addColumn(localTable, "CASE_SENSITIVE", 16);
      addColumn(localTable, "SEARCHABLE", 5);
      addColumn(localTable, "UNSIGNED_ATTRIBUTE", 16);
      addColumn(localTable, "FIXED_PREC_SCALE", 16);
      addColumn(localTable, "AUTO_INCREMENT", 16);
      addColumn(localTable, "LOCAL_TYPE_NAME", 12);
      addColumn(localTable, "MINIMUM_SCALE", 5);
      addColumn(localTable, "MAXIMUM_SCALE", 5);
      addColumn(localTable, "SQL_DATA_TYPE", 4);
      addColumn(localTable, "SQL_DATETIME_SUB", 4);
      addColumn(localTable, "NUM_PREC_RADIX", 4);
      addColumn(localTable, "INTERVAL_PRECISION", 4);
      addColumn(localTable, "AS_TAB_COL", 16);
      addColumn(localTable, "AS_PROC_COL", 16);
      addColumn(localTable, "MAX_PREC_ACT", -5);
      addColumn(localTable, "MIN_SCALE_ACT", 4);
      addColumn(localTable, "MAX_SCALE_ACT", 4);
      addColumn(localTable, "COL_ST_CLS_NAME", 12);
      addColumn(localTable, "COL_ST_IS_SUP", 16);
      addColumn(localTable, "STD_MAP_CLS_NAME", 12);
      addColumn(localTable, "STD_MAP_IS_SUP", 16);
      addColumn(localTable, "CST_MAP_CLS_NAME", 12);
      addColumn(localTable, "CST_MAP_IS_SUP", 16);
      addColumn(localTable, "MCOL_JDBC", 4);
      addColumn(localTable, "MCOL_ACT", -5);
      addColumn(localTable, "DEF_OR_FIXED_SCALE", 4);
      addColumn(localTable, "REMARKS", 12);
      addColumn(localTable, "TYPE_SUB", 4);
      localTable.createPrimaryKey(null, new int[] { 1, 34 }, true);
      return localTable;
    }
    DITypeInfo localDITypeInfo = new DITypeInfo();
    for (int i = 0; i < Types.ALL_TYPES.length; i++)
    {
      localDITypeInfo.setTypeCode(Types.ALL_TYPES[i][0]);
      localDITypeInfo.setTypeSub(Types.ALL_TYPES[i][1]);
      Object[] arrayOfObject = localTable.getEmptyRowData();
      arrayOfObject[0] = localDITypeInfo.getTypeName();
      arrayOfObject[1] = localDITypeInfo.getDataType();
      arrayOfObject[2] = localDITypeInfo.getPrecision();
      arrayOfObject[3] = localDITypeInfo.getLiteralPrefix();
      arrayOfObject[4] = localDITypeInfo.getLiteralSuffix();
      arrayOfObject[5] = localDITypeInfo.getCreateParams();
      arrayOfObject[6] = localDITypeInfo.getNullability();
      arrayOfObject[7] = localDITypeInfo.isCaseSensitive();
      arrayOfObject[8] = localDITypeInfo.getSearchability();
      arrayOfObject[9] = localDITypeInfo.isUnsignedAttribute();
      arrayOfObject[10] = localDITypeInfo.isFixedPrecisionScale();
      arrayOfObject[11] = localDITypeInfo.isAutoIncrement();
      arrayOfObject[12] = localDITypeInfo.getLocalName();
      arrayOfObject[13] = localDITypeInfo.getMinScale();
      arrayOfObject[14] = localDITypeInfo.getMaxScale();
      arrayOfObject[15] = localDITypeInfo.getSqlDataType();
      arrayOfObject[16] = localDITypeInfo.getSqlDateTimeSub();
      arrayOfObject[17] = localDITypeInfo.getNumPrecRadix();
      arrayOfObject[18] = localDITypeInfo.getIntervalPrecision();
      arrayOfObject[19] = localDITypeInfo.isSupportedAsTCol();
      arrayOfObject[20] = localDITypeInfo.isSupportedAsPCol();
      arrayOfObject[21] = localDITypeInfo.getPrecisionAct();
      arrayOfObject[22] = localDITypeInfo.getMinScaleAct();
      arrayOfObject[23] = localDITypeInfo.getMaxScaleAct();
      arrayOfObject[24] = localDITypeInfo.getColStClsName();
      arrayOfObject[25] = localDITypeInfo.isColStClsSupported();
      arrayOfObject[26] = localDITypeInfo.getStdMapClsName();
      arrayOfObject[27] = localDITypeInfo.isStdMapClsSupported();
      arrayOfObject[28] = localDITypeInfo.getCstMapClsName();
      try
      {
        this.ns.classForName((String)arrayOfObject[28]);
        arrayOfObject[29] = Boolean.TRUE;
      }
      catch (Exception localException)
      {
        arrayOfObject[29] = Boolean.FALSE;
      }
      arrayOfObject[30] = localDITypeInfo.getCharOctLen();
      arrayOfObject[31] = localDITypeInfo.getCharOctLenAct();
      arrayOfObject[32] = localDITypeInfo.getDefaultScale();
      arrayOfObject[33] = localDITypeInfo.getRemarks();
      arrayOfObject[34] = localDITypeInfo.getDataTypeSub();
      localTable.insertSys(arrayOfObject);
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_USERS()
    throws HsqlException
  {
    Table localTable = this.sysTables[18];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[18]);
      addColumn(localTable, "USER", 12, false);
      addColumn(localTable, "ADMIN", 16, false);
      localTable.createPrimaryKey(null, new int[] { 0 }, true);
      return localTable;
    }
    HsqlArrayList localHsqlArrayList = this.database.getUserManager().listVisibleUsers(this.session, false);
    for (int i = 0; i < localHsqlArrayList.size(); i++)
    {
      Object[] arrayOfObject = localTable.getEmptyRowData();
      User localUser = (User)localHsqlArrayList.get(i);
      arrayOfObject[0] = localUser.getName();
      arrayOfObject[1] = ValuePool.getBoolean(localUser.isAdmin());
      localTable.insertSys(arrayOfObject);
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  final Table SYSTEM_CHECK_CONSTRAINTS()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[34];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[34]);
      addColumn(localTable1, "CONSTRAINT_CATALOG", 12);
      addColumn(localTable1, "CONSTRAINT_SCHEMA", 12);
      addColumn(localTable1, "CONSTRAINT_NAME", 12, false);
      addColumn(localTable1, "CHECK_CLAUSE", 12, false);
      localTable1.createPrimaryKey(null, new int[] { 0, 1, 2 }, false);
      return localTable1;
    }
    Iterator localIterator = this.database.schemaManager.allTablesIterator();
    HsqlArrayList localHsqlArrayList = new HsqlArrayList();
    Table localTable2;
    Constraint localConstraint;
    while (localIterator.hasNext())
    {
      localTable2 = (Table)localIterator.next();
      if (!isAccessibleTable(localTable2))
        continue;
      Constraint[] arrayOfConstraint = localTable2.getConstraints();
      int i = arrayOfConstraint.length;
      for (j = 0; j < i; j++)
      {
        localConstraint = arrayOfConstraint[j];
        if (localConstraint.getType() != 3)
          continue;
        localHsqlArrayList.add(localConstraint);
      }
    }
    for (int j = 0; j < localHsqlArrayList.size(); j++)
    {
      Object[] arrayOfObject = localTable1.getEmptyRowData();
      localConstraint = (Constraint)localHsqlArrayList.get(j);
      localTable2 = localConstraint.getMain();
      arrayOfObject[0] = this.ns.getCatalogName(localTable2);
      arrayOfObject[1] = localTable2.getSchemaName();
      arrayOfObject[2] = localConstraint.constName.name;
      try
      {
        arrayOfObject[3] = localConstraint.core.check.getDDL();
      }
      catch (Exception localException)
      {
      }
      localTable1.insertSys(arrayOfObject);
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  final Table SYSTEM_SEQUENCES()
    throws HsqlException
  {
    Table localTable = this.sysTables[32];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[32]);
      addColumn(localTable, "SEQUENCE_CATALOG", 12);
      addColumn(localTable, "SEQUENCE_SCHEMA", 12);
      addColumn(localTable, "SEQUENCE_NAME", 12, true);
      addColumn(localTable, "DTD_IDENTIFIER", 12, true);
      addColumn(localTable, "MAXIMUM_VALUE", 12, 20, true);
      addColumn(localTable, "MINIMUM_VALUE", 12, 20, true);
      addColumn(localTable, "INCREMENT", 12, 20, true);
      addColumn(localTable, "CYCLE_OPTION", 12, 3, true);
      addColumn(localTable, "START_WITH", 12, 20, true);
      localTable.createPrimaryKey(null, new int[] { 0, 1, 2 }, false);
      return localTable;
    }
    String str1 = ValuePool.getString("0");
    String str2 = ValuePool.getString(String.valueOf(2147483647));
    String str3 = String.valueOf(9223372036854775807L);
    String str4 = ValuePool.getString("NO");
    Iterator localIterator = this.database.schemaManager.allSequencesIterator();
    while (localIterator.hasNext())
    {
      Object[] arrayOfObject = localTable.getEmptyRowData();
      NumberSequence localNumberSequence = (NumberSequence)localIterator.next();
      int i = localNumberSequence.getType();
      String str5 = localNumberSequence.getName().name;
      arrayOfObject[0] = this.ns.getCatalogName(localNumberSequence);
      arrayOfObject[1] = localNumberSequence.getSchemaName();
      arrayOfObject[2] = str5;
      arrayOfObject[3] = Types.getTypeString(i);
      arrayOfObject[5] = str1;
      arrayOfObject[6] = String.valueOf(localNumberSequence.getIncrement());
      arrayOfObject[7] = str4;
      arrayOfObject[8] = String.valueOf(localNumberSequence.peek());
      switch (i)
      {
      case 4:
        arrayOfObject[4] = str2;
        break;
      case -5:
      default:
        arrayOfObject[4] = str3;
      }
      localTable.insertSys(arrayOfObject);
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  static
  {
    columnNameMap = new HashMap();
    nonCachedTablesSet = new HashSet();
    sysTableHsqlNames = new HsqlNameManager.HsqlName[sysTableNames.length];
    for (int i = 0; i < sysTableNames.length; i++)
    {
      sysTableHsqlNames[i] = HsqlNameManager.newHsqlSystemObjectName(sysTableNames[i]);
      sysTableHsqlNames[i].schema = SchemaManager.INFORMATION_SCHEMA_HSQLNAME;
    }
    nonCachedTablesSet.add("SYSTEM_CACHEINFO");
    nonCachedTablesSet.add("SYSTEM_SESSIONINFO");
    nonCachedTablesSet.add("SYSTEM_SESSIONS");
    nonCachedTablesSet.add("SYSTEM_PROPERTIES");
    nonCachedTablesSet.add("SYSTEM_SEQUENCES");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.DatabaseInformationMain
 * JD-Core Version:    0.6.0
 */