package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.Logger;
import org.hsqldb.persist.TextCache;
import org.hsqldb.store.ValuePool;

final class DatabaseInformationFull extends DatabaseInformationMain
{
  protected DIProcedureInfo pi = new DIProcedureInfo(this.ns);

  DatabaseInformationFull(Database paramDatabase)
    throws HsqlException
  {
    super(paramDatabase);
  }

  protected Table generateTable(int paramInt)
    throws HsqlException
  {
    switch (paramInt)
    {
    case 7:
      return SYSTEM_PROCEDURECOLUMNS();
    case 8:
      return SYSTEM_PROCEDURES();
    case 10:
      return SYSTEM_SUPERTABLES();
    case 11:
      return SYSTEM_SUPERTYPES();
    case 16:
      return SYSTEM_UDTATTRIBUTES();
    case 17:
      return SYSTEM_UDTS();
    case 19:
      return SYSTEM_VERSIONCOLUMNS();
    case 20:
      return SYSTEM_ALIASES();
    case 22:
      return SYSTEM_CACHEINFO();
    case 23:
      return SYSTEM_CLASSPRIVILEGES();
    case 24:
      return SYSTEM_SESSIONINFO();
    case 25:
      return SYSTEM_PROPERTIES();
    case 26:
      return SYSTEM_SESSIONS();
    case 27:
      return SYSTEM_TRIGGERCOLUMNS();
    case 28:
      return SYSTEM_TRIGGERS();
    case 30:
      return SYSTEM_VIEWS();
    case 31:
      return SYSTEM_TEXTTABLES();
    case 33:
      return SYSTEM_USAGE_PRIVILEGES();
    case 36:
      return SYSTEM_CHECK_COLUMN_USAGE();
    case 37:
      return SYSTEM_CHECK_ROUTINE_USAGE();
    case 38:
      return SYSTEM_CHECK_TABLE_USAGE();
    case 35:
      return SYSTEM_TABLE_CONSTRAINTS();
    case 40:
      return SYSTEM_VIEW_TABLE_USAGE();
    case 39:
      return SYSTEM_VIEW_COLUMN_USAGE();
    case 41:
      return SYSTEM_VIEW_ROUTINE_USAGE();
    case 42:
      return SYSTEM_AUTHORIZATIONS();
    case 44:
      return SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS();
    case 45:
      return SYSTEM_SCHEMATA();
    case 43:
      return SYSTEM_COLLATIONS();
    case 9:
    case 12:
    case 13:
    case 14:
    case 15:
    case 18:
    case 21:
    case 29:
    case 32:
    case 34:
    }
    return super.generateTable(paramInt);
  }

  Table SYSTEM_ALIASES()
    throws HsqlException
  {
    Table localTable = this.sysTables[20];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[20]);
      addColumn(localTable, "OBJECT_TYPE", 12, 32, false);
      addColumn(localTable, "OBJECT_CAT", 12);
      addColumn(localTable, "OBJECT_SCHEM", 12);
      addColumn(localTable, "OBJECT_NAME", 12, false);
      addColumn(localTable, "ALIAS_CAT", 12);
      addColumn(localTable, "ALIAS_SCHEM", 12);
      addColumn(localTable, "ALIAS", 12, false);
      localTable.createPrimaryKey(null, new int[] { 0, 3, 6 }, true);
      return localTable;
    }
    HashMap localHashMap = this.database.getAliasMap();
    Iterator localIterator1 = localHashMap.keySet().iterator();
    String str5 = "ROUTINE";
    Object[] arrayOfObject;
    String str3;
    String str4;
    String str1;
    String str2;
    while (localIterator1.hasNext())
    {
      arrayOfObject = localTable.getEmptyRowData();
      str3 = (String)localIterator1.next();
      str4 = (String)localHashMap.get(str3);
      int i = str4.lastIndexOf('.');
      if (i <= 0)
        continue;
      String str6 = str4.substring(0, i);
      if (!this.session.isAccessible(str6))
        continue;
      str1 = this.ns.getCatalogName(str4);
      str2 = this.ns.getSchemaName(str6);
      arrayOfObject[0] = str5;
      arrayOfObject[1] = str1;
      arrayOfObject[2] = str2;
      arrayOfObject[3] = str4;
      arrayOfObject[4] = str1;
      arrayOfObject[5] = str2;
      arrayOfObject[6] = str3;
      localTable.insertSys(arrayOfObject);
    }
    if (this.session.isAdmin())
    {
      Iterator localIterator2 = Types.typeAliases.keySet().iterator();
      str5 = "DOMAIN";
      while (localIterator2.hasNext())
      {
        arrayOfObject = localTable.getEmptyRowData();
        str3 = (String)localIterator2.next();
        int j = Types.typeAliases.get(str3, -2147483648);
        str4 = Types.getTypeString(j);
        if (str3.equals(str4))
          continue;
        str1 = this.ns.getCatalogName(str4);
        str2 = this.ns.getSchemaName(str4);
        arrayOfObject[0] = str5;
        arrayOfObject[1] = str1;
        arrayOfObject[2] = str2;
        arrayOfObject[3] = str4;
        arrayOfObject[4] = str1;
        arrayOfObject[5] = str2;
        arrayOfObject[6] = str3;
        localTable.insertSys(arrayOfObject);
      }
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_CACHEINFO()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[22];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[22]);
      addColumn(localTable1, "CACHE_FILE", 12, false);
      addColumn(localTable1, "MAX_CACHE_COUNT", 4, false);
      addColumn(localTable1, "MAX_CACHE_BYTES", -5, false);
      addColumn(localTable1, "CACHE_SIZE", 4, false);
      addColumn(localTable1, "CACHE_BYTES", -5, false);
      addColumn(localTable1, "FILE_FREE_BYTES", 4, false);
      addColumn(localTable1, "FILE_FREE_COUNT", 4, false);
      addColumn(localTable1, "FILE_FREE_POS", -5, false);
      localTable1.createPrimaryKey(null, new int[] { 0 }, true);
      return localTable1;
    }
    HashSet localHashSet = new HashSet();
    Iterator localIterator2 = this.database.schemaManager.allTablesIterator();
    DataFileCache localDataFileCache;
    while (localIterator2.hasNext())
    {
      Table localTable2 = (Table)localIterator2.next();
      if ((!localTable2.isFileBased()) || (!isAccessibleTable(localTable2)))
        continue;
      localDataFileCache = localTable2.getCache();
      if (localDataFileCache == null)
        continue;
      localHashSet.add(localDataFileCache);
    }
    Iterator localIterator1 = localHashSet.iterator();
    while (localIterator1.hasNext())
    {
      localDataFileCache = (DataFileCache)localIterator1.next();
      Object[] arrayOfObject = localTable1.getEmptyRowData();
      arrayOfObject[0] = FileUtil.canonicalOrAbsolutePath(localDataFileCache.getFileName());
      arrayOfObject[1] = ValuePool.getInt(localDataFileCache.capacity());
      arrayOfObject[2] = ValuePool.getLong(localDataFileCache.bytesCapacity());
      arrayOfObject[3] = ValuePool.getInt(localDataFileCache.getCachedObjectCount());
      arrayOfObject[4] = ValuePool.getLong(localDataFileCache.getTotalCachedBlockSize());
      arrayOfObject[5] = ValuePool.getInt(localDataFileCache.getTotalFreeBlockSize());
      arrayOfObject[6] = ValuePool.getInt(localDataFileCache.getFreeBlockCount());
      arrayOfObject[7] = ValuePool.getLong(localDataFileCache.getFileFreePos());
      localTable1.insertSys(arrayOfObject);
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  Table SYSTEM_CLASSPRIVILEGES()
    throws HsqlException
  {
    Table localTable = this.sysTables[23];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[23]);
      addColumn(localTable, "CLASS_CAT", 12);
      addColumn(localTable, "CLASS_SCHEM", 12);
      addColumn(localTable, "CLASS_NAME", 12, false);
      addColumn(localTable, "GRANTOR", 12, false);
      addColumn(localTable, "GRANTEE", 12, false);
      addColumn(localTable, "PRIVILEGE", 12, 7, false);
      addColumn(localTable, "IS_GRANTABLE", 12, 3, false);
      localTable.createPrimaryKey(null, new int[] { 2, 4, 5 }, true);
      return localTable;
    }
    String str4 = "DBA";
    UserManager localUserManager = this.database.getUserManager();
    HsqlArrayList localHsqlArrayList = localUserManager.listVisibleUsers(this.session, true);
    for (int i = 0; i < localHsqlArrayList.size(); i++)
    {
      User localUser = (User)localHsqlArrayList.get(i);
      String str5 = localUser.getName();
      String str7 = localUser.isAdmin() ? "YES" : "NO";
      HashSet localHashSet = localUser.getGrantedClassNames(false);
      if (localUser.isPublic())
        this.ns.addBuiltinToSet(localHashSet);
      Iterator localIterator = localHashSet.iterator();
      String str6 = "EXECUTE";
      String str3;
      String str1;
      String str2;
      Object[] arrayOfObject;
      while (localIterator.hasNext())
      {
        str3 = (String)localIterator.next();
        str1 = this.ns.getCatalogName(str3);
        str2 = this.ns.getSchemaName(str3);
        arrayOfObject = localTable.getEmptyRowData();
        arrayOfObject[0] = str1;
        arrayOfObject[1] = str2;
        arrayOfObject[2] = str3;
        arrayOfObject[3] = str4;
        arrayOfObject[4] = str5;
        arrayOfObject[5] = str6;
        arrayOfObject[6] = str7;
        localTable.insertSys(arrayOfObject);
      }
      localIterator = this.ns.iterateAccessibleTriggerClassNames(localUser);
      str6 = "TRIGGER";
      while (localIterator.hasNext())
      {
        str3 = (String)localIterator.next();
        str1 = this.ns.getCatalogName(str3);
        str2 = this.ns.getSchemaName(str3);
        arrayOfObject = localTable.getEmptyRowData();
        arrayOfObject[0] = str1;
        arrayOfObject[1] = str2;
        arrayOfObject[2] = str3;
        arrayOfObject[3] = str4;
        arrayOfObject[4] = str5;
        arrayOfObject[5] = str6;
        arrayOfObject[6] = str7;
        localTable.insertSys(arrayOfObject);
      }
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_SESSIONINFO()
    throws HsqlException
  {
    Table localTable = this.sysTables[24];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[24]);
      addColumn(localTable, "KEY", 12, false);
      addColumn(localTable, "VALUE", 12, false);
      localTable.createPrimaryKey(null);
      return localTable;
    }
    Object[] arrayOfObject = localTable.getEmptyRowData();
    arrayOfObject[0] = "SESSION_ID";
    arrayOfObject[1] = String.valueOf(this.session.getId());
    localTable.insertSys(arrayOfObject);
    arrayOfObject = localTable.getEmptyRowData();
    arrayOfObject[0] = "AUTOCOMMIT";
    arrayOfObject[1] = (this.session.isAutoCommit() ? "TRUE" : "FALSE");
    localTable.insertSys(arrayOfObject);
    arrayOfObject = localTable.getEmptyRowData();
    arrayOfObject[0] = "USER";
    arrayOfObject[1] = this.session.getUsername();
    localTable.insertSys(arrayOfObject);
    arrayOfObject = localTable.getEmptyRowData();
    arrayOfObject[0] = "SESSION_READONLY";
    arrayOfObject[1] = (this.session.isReadOnly() ? "TRUE" : "FALSE");
    localTable.insertSys(arrayOfObject);
    arrayOfObject = localTable.getEmptyRowData();
    arrayOfObject[0] = "DATABASE_READONLY";
    arrayOfObject[1] = (this.database.databaseReadOnly ? "TRUE" : "FALSE");
    localTable.insertSys(arrayOfObject);
    arrayOfObject = localTable.getEmptyRowData();
    arrayOfObject[0] = "MAXROWS";
    arrayOfObject[1] = String.valueOf(this.session.getSQLMaxRows());
    localTable.insertSys(arrayOfObject);
    arrayOfObject = localTable.getEmptyRowData();
    arrayOfObject[0] = "DATABASE";
    arrayOfObject[1] = this.database.getURI();
    localTable.insertSys(arrayOfObject);
    arrayOfObject = localTable.getEmptyRowData();
    arrayOfObject[0] = "IDENTITY";
    arrayOfObject[1] = String.valueOf(this.session.getLastIdentity());
    localTable.insertSys(arrayOfObject);
    arrayOfObject = localTable.getEmptyRowData();
    arrayOfObject[0] = "SCHEMA";
    arrayOfObject[1] = String.valueOf(this.session.getSchemaName(null));
    localTable.insertSys(arrayOfObject);
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_PROPERTIES()
    throws HsqlException
  {
    Table localTable = this.sysTables[25];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[25]);
      addColumn(localTable, "PROPERTY_SCOPE", 12, false);
      addColumn(localTable, "PROPERTY_NAMESPACE", 12, false);
      addColumn(localTable, "PROPERTY_NAME", 12, false);
      addColumn(localTable, "PROPERTY_VALUE", 12);
      addColumn(localTable, "PROPERTY_CLASS", 12, false);
      localTable.createPrimaryKey(null, new int[] { 0, 1, 2 }, true);
      return localTable;
    }
    String str1 = "SESSION";
    HsqlDatabaseProperties localHsqlDatabaseProperties = this.database.getProperties();
    String str2 = "database.properties";
    Iterator localIterator = localHsqlDatabaseProperties.getUserDefinedPropertyData().iterator();
    while (localIterator.hasNext())
    {
      Object[] arrayOfObject2 = (Object[])localIterator.next();
      arrayOfObject1 = localTable.getEmptyRowData();
      arrayOfObject1[0] = str1;
      arrayOfObject1[1] = str2;
      arrayOfObject1[2] = arrayOfObject2[0];
      arrayOfObject1[3] = localHsqlDatabaseProperties.getProperty((String)arrayOfObject1[2]);
      arrayOfObject1[4] = arrayOfObject2[2];
      localTable.insertSys(arrayOfObject1);
    }
    Object[] arrayOfObject1 = localTable.getEmptyRowData();
    arrayOfObject1[0] = str1;
    arrayOfObject1[1] = str2;
    arrayOfObject1[2] = "SCRIPTFORMAT";
    try
    {
      arrayOfObject1[3] = org.hsqldb.scriptio.ScriptWriterBase.LIST_SCRIPT_FORMATS[this.database.logger.getScriptType()];
    }
    catch (Exception localException)
    {
    }
    arrayOfObject1[4] = "java.lang.String";
    localTable.insertSys(arrayOfObject1);
    arrayOfObject1 = localTable.getEmptyRowData();
    arrayOfObject1[0] = str1;
    arrayOfObject1[1] = str2;
    arrayOfObject1[2] = "WRITE_DELAY";
    arrayOfObject1[3] = ("" + this.database.logger.getWriteDelay());
    arrayOfObject1[4] = "int";
    localTable.insertSys(arrayOfObject1);
    arrayOfObject1 = localTable.getEmptyRowData();
    arrayOfObject1[0] = str1;
    arrayOfObject1[1] = str2;
    arrayOfObject1[2] = "IGNORECASE";
    arrayOfObject1[3] = (this.database.isIgnoreCase() ? "true" : "false");
    arrayOfObject1[4] = "boolean";
    localTable.insertSys(arrayOfObject1);
    arrayOfObject1 = localTable.getEmptyRowData();
    arrayOfObject1[0] = str1;
    arrayOfObject1[1] = str2;
    arrayOfObject1[2] = "REFERENTIAL_INTEGRITY";
    arrayOfObject1[3] = (this.database.isReferentialIntegrity() ? "true" : "false");
    arrayOfObject1[4] = "boolean";
    localTable.insertSys(arrayOfObject1);
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_SESSIONS()
    throws HsqlException
  {
    Table localTable = this.sysTables[26];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[26]);
      addColumn(localTable, "SESSION_ID", 4, false);
      addColumn(localTable, "CONNECTED", 93, false);
      addColumn(localTable, "USER_NAME", 12, false);
      addColumn(localTable, "IS_ADMIN", 16, false);
      addColumn(localTable, "AUTOCOMMIT", 16, false);
      addColumn(localTable, "READONLY", 16, false);
      addColumn(localTable, "MAXROWS", 4, false);
      addColumn(localTable, "LAST_IDENTITY", -5);
      addColumn(localTable, "TRANSACTION_SIZE", 4, false);
      addColumn(localTable, "SCHEMA", 12, false);
      localTable.createPrimaryKey(null, new int[] { 0 }, true);
      return localTable;
    }
    Session[] arrayOfSession = this.ns.listVisibleSessions(this.session);
    for (int i = 0; i < arrayOfSession.length; i++)
    {
      Session localSession = arrayOfSession[i];
      Object[] arrayOfObject = localTable.getEmptyRowData();
      arrayOfObject[0] = ValuePool.getInt(localSession.getId());
      arrayOfObject[1] = HsqlDateTime.getTimestamp(localSession.getConnectTime());
      arrayOfObject[2] = localSession.getUsername();
      arrayOfObject[3] = ValuePool.getBoolean(localSession.isAdmin());
      arrayOfObject[4] = ValuePool.getBoolean(localSession.isAutoCommit());
      arrayOfObject[5] = ValuePool.getBoolean(localSession.isReadOnly());
      arrayOfObject[6] = ValuePool.getInt(localSession.getSQLMaxRows());
      arrayOfObject[7] = ValuePool.getLong(localSession.getLastIdentity().longValue());
      arrayOfObject[8] = ValuePool.getInt(localSession.getTransactionSize());
      arrayOfObject[9] = localSession.getSchemaName(null);
      localTable.insertSys(arrayOfObject);
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_SUPERTABLES()
    throws HsqlException
  {
    Table localTable = this.sysTables[10];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[10]);
      addColumn(localTable, "TABLE_CAT", 12);
      addColumn(localTable, "TABLE_SCHEM", 12);
      addColumn(localTable, "TABLE_NAME", 12, false);
      addColumn(localTable, "SUPERTABLE_NAME", 12, false);
      localTable.createPrimaryKey(null);
      return localTable;
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_SUPERTYPES()
    throws HsqlException
  {
    Table localTable = this.sysTables[11];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[11]);
      addColumn(localTable, "TYPE_CAT", 12);
      addColumn(localTable, "TYPE_SCHEM", 12);
      addColumn(localTable, "TYPE_NAME", 12, false);
      addColumn(localTable, "SUPERTYPE_CAT", 12);
      addColumn(localTable, "SUPERTYPE_SCHEM", 12);
      addColumn(localTable, "SUPERTYPE_NAME", 12, false);
      localTable.createPrimaryKey(null);
      return localTable;
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_TEXTTABLES()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[31];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[31]);
      addColumn(localTable1, "TABLE_CAT", 12);
      addColumn(localTable1, "TABLE_SCHEM", 12);
      addColumn(localTable1, "TABLE_NAME", 12, false);
      addColumn(localTable1, "DATA_SOURCE_DEFINTION", 12);
      addColumn(localTable1, "FILE_PATH", 12);
      addColumn(localTable1, "FILE_ENCODING", 12);
      addColumn(localTable1, "FIELD_SEPARATOR", 12);
      addColumn(localTable1, "VARCHAR_SEPARATOR", 12);
      addColumn(localTable1, "LONGVARCHAR_SEPARATOR", 12);
      addColumn(localTable1, "IS_IGNORE_FIRST", 16);
      addColumn(localTable1, "IS_ALL_QUOTED", 16);
      addColumn(localTable1, "IS_QUOTED", 16);
      addColumn(localTable1, "IS_DESC", 16);
      localTable1.createPrimaryKey();
      return localTable1;
    }
    Iterator localIterator = this.database.schemaManager.allTablesIterator();
    while (localIterator.hasNext())
    {
      Table localTable2 = (Table)localIterator.next();
      if ((!localTable2.isText()) || (!isAccessibleTable(localTable2)))
        continue;
      Object[] arrayOfObject = localTable1.getEmptyRowData();
      arrayOfObject[0] = this.ns.getCatalogName(localTable2);
      arrayOfObject[1] = localTable2.getSchemaName();
      arrayOfObject[2] = localTable2.getName().name;
      arrayOfObject[3] = localTable2.getDataSource();
      if ((localTable2.getCache() instanceof TextCache))
      {
        TextCache localTextCache = (TextCache)localTable2.getCache();
        arrayOfObject[4] = FileUtil.canonicalOrAbsolutePath(localTextCache.getFileName());
        arrayOfObject[5] = localTextCache.stringEncoding;
        arrayOfObject[6] = localTextCache.fs;
        arrayOfObject[7] = localTextCache.vs;
        arrayOfObject[8] = localTextCache.lvs;
        arrayOfObject[9] = ValuePool.getBoolean(localTextCache.ignoreFirst);
        arrayOfObject[10] = ValuePool.getBoolean(localTextCache.isQuoted);
        arrayOfObject[11] = ValuePool.getBoolean(localTextCache.isAllQuoted);
        arrayOfObject[12] = ValuePool.getBoolean(localTable2.isDescDataSource());
      }
      localTable1.insertSys(arrayOfObject);
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  Table SYSTEM_TRIGGERCOLUMNS()
    throws HsqlException
  {
    Table localTable = this.sysTables[27];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[27]);
      addColumn(localTable, "TRIGGER_CAT", 12);
      addColumn(localTable, "TRIGGER_SCHEM", 12);
      addColumn(localTable, "TRIGGER_NAME", 12);
      addColumn(localTable, "TABLE_CAT", 12);
      addColumn(localTable, "TABLE_SCHEM", 12);
      addColumn(localTable, "TABLE_NAME", 12);
      addColumn(localTable, "COLUMN_NAME", 12);
      addColumn(localTable, "COLUMN_LIST", 12);
      addColumn(localTable, "COLUMN_USAGE", 12);
      localTable.createPrimaryKey(null, new int[] { 0, 1, 2, 3, 4, 5, 6, 7, 8 }, false);
      return localTable;
    }
    Result localResult = this.session.sqlExecuteDirectNoPreChecks("select a.TRIGGER_CAT,a.TRIGGER_SCHEM,a.TRIGGER_NAME, a.TABLE_CAT,a.TABLE_SCHEM,a.TABLE_NAME,b.COLUMN_NAME,'Y','IN' from INFORMATION_SCHEMA.SYSTEM_TRIGGERS a, INFORMATION_SCHEMA.SYSTEM_COLUMNS b where a.TABLE_NAME=b.TABLE_NAME and a.TABLE_SCHEM=b.TABLE_SCHEM");
    localTable.insertSys(localResult);
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_TRIGGERS()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[28];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[28]);
      addColumn(localTable1, "TRIGGER_CAT", 12);
      addColumn(localTable1, "TRIGGER_SCHEM", 12);
      addColumn(localTable1, "TRIGGER_NAME", 12, false);
      addColumn(localTable1, "TRIGGER_TYPE", 12, 15, false);
      addColumn(localTable1, "TRIGGERING_EVENT", 12, 10, false);
      addColumn(localTable1, "TABLE_CAT", 12);
      addColumn(localTable1, "TABLE_SCHEM", 12);
      addColumn(localTable1, "BASE_OBJECT_TYPE", 12, 8, false);
      addColumn(localTable1, "TABLE_NAME", 12, false);
      addColumn(localTable1, "COLUMN_NAME", 12);
      addColumn(localTable1, "REFERENCING_NAMES", 12, false);
      addColumn(localTable1, "WHEN_CLAUSE", 12);
      addColumn(localTable1, "STATUS", 12, 8, false);
      addColumn(localTable1, "DESCRIPTION", 12, false);
      addColumn(localTable1, "ACTION_TYPE", 12, false);
      addColumn(localTable1, "TRIGGER_BODY", 12, false);
      localTable1.createPrimaryKey(null, new int[] { 3, 1, 2, 0 }, false);
      return localTable1;
    }
    Iterator localIterator = this.database.schemaManager.allTablesIterator();
    String str13 = "CALL";
    String str8 = "TABLE";
    Object localObject1 = null;
    String str10 = "ROW";
    Object localObject2 = null;
    while (localIterator.hasNext())
    {
      Table localTable2 = (Table)localIterator.next();
      HsqlArrayList[] arrayOfHsqlArrayList = localTable2.triggerLists;
      if ((arrayOfHsqlArrayList == null) || (!isAccessibleTable(localTable2)))
        continue;
      String str6 = this.ns.getCatalogName(localTable2);
      String str1 = str6;
      String str7 = localTable2.getSchemaName();
      String str2 = str7;
      String str9 = localTable2.getName().name;
      for (int i = 0; i < arrayOfHsqlArrayList.length; i++)
      {
        HsqlArrayList localHsqlArrayList = arrayOfHsqlArrayList[i];
        if (localHsqlArrayList == null)
          continue;
        for (int j = 0; j < localHsqlArrayList.size(); j++)
        {
          TriggerDef localTriggerDef = (TriggerDef)localHsqlArrayList.get(j);
          if (localTriggerDef == null)
            continue;
          String str3 = localTriggerDef.name.name;
          String str12 = localTriggerDef.getDDL().toString();
          String str11 = localTriggerDef.valid ? "ENABLED" : "DISABLED";
          String str14 = localTriggerDef.triggerClassName;
          String str4 = localTriggerDef.when;
          if (localTriggerDef.forEachRow)
            str4 = str4 + " EACH ROW";
          String str5 = localTriggerDef.operation;
          Object[] arrayOfObject = localTable1.getEmptyRowData();
          arrayOfObject[0] = str1;
          arrayOfObject[1] = str2;
          arrayOfObject[2] = str3;
          arrayOfObject[3] = str4;
          arrayOfObject[4] = str5;
          arrayOfObject[5] = str6;
          arrayOfObject[6] = str7;
          arrayOfObject[7] = str8;
          arrayOfObject[8] = str9;
          arrayOfObject[9] = localObject1;
          arrayOfObject[10] = str10;
          arrayOfObject[11] = localObject2;
          arrayOfObject[12] = str11;
          arrayOfObject[13] = str12;
          arrayOfObject[14] = str13;
          arrayOfObject[15] = str14;
          localTable1.insertSys(arrayOfObject);
        }
      }
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  Table SYSTEM_UDTATTRIBUTES()
    throws HsqlException
  {
    Table localTable = this.sysTables[16];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[16]);
      addColumn(localTable, "TYPE_CAT", 12);
      addColumn(localTable, "TYPE_SCHEM", 12);
      addColumn(localTable, "TYPE_NAME", 12, false);
      addColumn(localTable, "ATTR_NAME", 12, false);
      addColumn(localTable, "DATA_TYPE", 5, false);
      addColumn(localTable, "ATTR_TYPE_NAME", 12, false);
      addColumn(localTable, "ATTR_SIZE", 4);
      addColumn(localTable, "DECIMAL_DIGITS", 4);
      addColumn(localTable, "NUM_PREC_RADIX", 4);
      addColumn(localTable, "NULLABLE", 4);
      addColumn(localTable, "REMARKS", 12);
      addColumn(localTable, "ATTR_DEF", 12);
      addColumn(localTable, "SQL_DATA_TYPE", 4);
      addColumn(localTable, "SQL_DATETIME_SUB", 4);
      addColumn(localTable, "CHAR_OCTET_LENGTH", 4);
      addColumn(localTable, "ORDINAL_POSITION", 4, false);
      addColumn(localTable, "IS_NULLABLE", 12, false);
      addColumn(localTable, "SCOPE_CATALOG", 12);
      addColumn(localTable, "SCOPE_SCHEMA", 12);
      addColumn(localTable, "SCOPE_TABLE", 12);
      addColumn(localTable, "SOURCE_DATA_TYPE", 5);
      localTable.createPrimaryKey(null);
      return localTable;
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_UDTS()
    throws HsqlException
  {
    Table localTable = this.sysTables[17];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[17]);
      addColumn(localTable, "TYPE_CAT", 12);
      addColumn(localTable, "TYPE_SCHEM", 12);
      addColumn(localTable, "TYPE_NAME", 12, false);
      addColumn(localTable, "CLASS_NAME", 12, false);
      addColumn(localTable, "DATA_TYPE", 12, false);
      addColumn(localTable, "REMARKS", 12);
      addColumn(localTable, "BASE_TYPE", 5);
      localTable.createPrimaryKey(null);
      return localTable;
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_VERSIONCOLUMNS()
    throws HsqlException
  {
    Table localTable = this.sysTables[19];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[19]);
      addColumn(localTable, "SCOPE", 4);
      addColumn(localTable, "COLUMN_NAME", 12, false);
      addColumn(localTable, "DATA_TYPE", 5, false);
      addColumn(localTable, "TYPE_NAME", 12, false);
      addColumn(localTable, "COLUMN_SIZE", 5);
      addColumn(localTable, "BUFFER_LENGTH", 4);
      addColumn(localTable, "DECIMAL_DIGITS", 5);
      addColumn(localTable, "PSEUDO_COLUMN", 5, false);
      addColumn(localTable, "TABLE_CAT", 12);
      addColumn(localTable, "TABLE_SCHEM", 12);
      addColumn(localTable, "TABLE_NAME", 12, false);
      localTable.createPrimaryKey(null);
      return localTable;
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_VIEWS()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[30];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[30]);
      addColumn(localTable1, "TABLE_CATALOG", 12);
      addColumn(localTable1, "TABLE_SCHEMA", 12);
      addColumn(localTable1, "TABLE_NAME", 12, true);
      addColumn(localTable1, "VIEW_DEFINITION", 12, true);
      addColumn(localTable1, "CHECK_OPTION", 12, 8, true);
      addColumn(localTable1, "IS_UPDATABLE", 12, 3, true);
      addColumn(localTable1, "VALID", 16, true);
      localTable1.createPrimaryKey(null, new int[] { 1, 2, 0 }, false);
      return localTable1;
    }
    Iterator localIterator = this.database.schemaManager.allTablesIterator();
    while (localIterator.hasNext())
    {
      Table localTable2 = (Table)localIterator.next();
      if ((!localTable2.isView()) || (!isAccessibleTable(localTable2)))
        continue;
      Object[] arrayOfObject = localTable1.getEmptyRowData();
      String str = ((View)localTable2).getStatement();
      arrayOfObject[0] = this.ns.getCatalogName(localTable2);
      arrayOfObject[1] = localTable2.getSchemaName();
      arrayOfObject[2] = localTable2.getName().name;
      arrayOfObject[3] = str;
      arrayOfObject[4] = "NONE";
      arrayOfObject[5] = "NO";
      arrayOfObject[6] = Boolean.TRUE;
      localTable1.insertSys(arrayOfObject);
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  Table SYSTEM_PROCEDURECOLUMNS()
    throws HsqlException
  {
    Table localTable = this.sysTables[7];
    if (localTable == null)
      return super.SYSTEM_PROCEDURECOLUMNS();
    Iterator localIterator = this.ns.iterateAllAccessibleMethods(this.session, true);
    DITypeInfo localDITypeInfo = new DITypeInfo();
    localDITypeInfo.setTypeSub(1);
    while (localIterator.hasNext())
    {
      Object[] arrayOfObject = (Object[])localIterator.next();
      Method localMethod = (Method)arrayOfObject[0];
      HsqlArrayList localHsqlArrayList = (HsqlArrayList)arrayOfObject[1];
      String str1 = this.ns.getCatalogName(localMethod);
      String str2 = this.ns.getSchemaName(localMethod);
      this.pi.setMethod(localMethod);
      String str7 = this.pi.getSpecificName();
      String str3 = this.pi.getFQN();
      int j = this.pi.getColCount();
      for (int k = 0; k < j; k++)
      {
        localDITypeInfo.setTypeCode(this.pi.getColTypeCode(k));
        String str4 = this.pi.getColName(k);
        Integer localInteger1 = this.pi.getColUsage(k);
        Integer localInteger2 = this.pi.getColDataType(k);
        String str5 = localDITypeInfo.getTypeName();
        Integer localInteger3 = localDITypeInfo.getPrecision();
        Integer localInteger4 = this.pi.getColLen(k);
        Integer localInteger5 = localDITypeInfo.getDefaultScale();
        Integer localInteger6 = localDITypeInfo.getNumPrecRadix();
        Integer localInteger7 = this.pi.getColNullability(k);
        String str6 = this.pi.getColRemark(k);
        int i = this.pi.getColSequence(k);
        addPColRows(localTable, localHsqlArrayList, str1, str2, str3, str4, localInteger1, localInteger2, str5, localInteger3, localInteger4, localInteger5, localInteger6, localInteger7, str6, str7, i);
      }
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_PROCEDURES()
    throws HsqlException
  {
    Table localTable = this.sysTables[8];
    if (localTable == null)
      return super.SYSTEM_PROCEDURES();
    Iterator localIterator = this.ns.iterateAllAccessibleMethods(this.session, true);
    while (localIterator.hasNext())
    {
      Object[] arrayOfObject = (Object[])localIterator.next();
      Method localMethod = (Method)arrayOfObject[0];
      HsqlArrayList localHsqlArrayList = (HsqlArrayList)arrayOfObject[1];
      String str7 = (String)arrayOfObject[2];
      this.pi.setMethod(localMethod);
      String str1 = this.ns.getCatalogName(localMethod);
      String str2 = this.ns.getSchemaName(localMethod);
      String str3 = this.pi.getFQN();
      Integer localInteger1 = this.pi.getInputParmCount();
      Integer localInteger2 = this.pi.getOutputParmCount();
      Integer localInteger3 = this.pi.getResultSetCount();
      String str4 = this.pi.getRemark();
      Integer localInteger4 = this.pi.getResultType(str7);
      String str5 = this.pi.getOrigin(str7);
      String str6 = this.pi.getSpecificName();
      addProcRows(localTable, localHsqlArrayList, str1, str2, str3, localInteger1, localInteger2, localInteger3, str4, localInteger4, str5, str6);
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_USAGE_PRIVILEGES()
    throws HsqlException
  {
    Table localTable = this.sysTables[33];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[33]);
      addColumn(localTable, "GRANTOR", 12, false);
      addColumn(localTable, "GRANTEE", 12, false);
      addColumn(localTable, "OBJECT_CATALOG", 12);
      addColumn(localTable, "OBJECT_SCHEMA", 12);
      addColumn(localTable, "OBJECT_NAME", 12, false);
      addColumn(localTable, "OBJECT_TYPE", 12, 32, false);
      addColumn(localTable, "IS_GRANTABLE", 12, 3, false);
      localTable.createPrimaryKey(null, new int[] { 0, 1, 2, 3, 4, 5 }, false);
      return localTable;
    }
    Result localResult = this.session.sqlExecuteDirectNoPreChecks("SELECT '_SYSTEM', 'PUBLIC', SEQUENCE_CATALOG, SEQUENCE_SCHEMA, SEQUENCE_NAME, 'SEQUENCE', 'FALSE' FROM  INFORMATION_SCHEMA.SYSTEM_SEQUENCES");
    localTable.insertSys(localResult);
    localResult = this.session.sqlExecuteDirectNoPreChecks("SELECT '_SYSTEM', 'PUBLIC', COLLATION_CATALOG, COLLATION_SCHEMA, COLLATION_NAME, 'COLLATION', 'FALSE' FROM  INFORMATION_SCHEMA.SYSTEM_COLLATIONS");
    localTable.insertSys(localResult);
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_CHECK_COLUMN_USAGE()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[36];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[36]);
      addColumn(localTable1, "CONSTRAINT_CATALOG", 12);
      addColumn(localTable1, "CONSTRAINT_SCHEMA", 12);
      addColumn(localTable1, "CONSTRAINT_NAME", 12, false);
      addColumn(localTable1, "TABLE_CATALOG", 12);
      addColumn(localTable1, "TABLE_SCHEMA", 12);
      addColumn(localTable1, "TABLE_NAME", 12, false);
      addColumn(localTable1, "COLUMN_NAME", 12, false);
      localTable1.createPrimaryKey(null, new int[] { 0, 1, 2, 3, 4, 5, 6 }, false);
      return localTable1;
    }
    Iterator localIterator1 = this.database.schemaManager.allTablesIterator();
    Expression.Collector localCollector = new Expression.Collector();
    Result localResult = new Result(3, 4);
    int tmp210_209 = (localResult.metaData.colTypes[2] = localResult.metaData.colTypes[3] = 12);
    localResult.metaData.colTypes[1] = tmp210_209;
    localResult.metaData.colTypes[0] = tmp210_209;
    while (localIterator1.hasNext())
    {
      Table localTable2 = (Table)localIterator1.next();
      if (!isAccessibleTable(localTable2))
        continue;
      Constraint[] arrayOfConstraint = localTable2.getConstraints();
      int i = arrayOfConstraint.length;
      String str1 = this.ns.getCatalogName(localTable2);
      String str2 = localTable2.getSchemaName();
      for (int j = 0; j < i; j++)
      {
        Constraint localConstraint = arrayOfConstraint[j];
        if (localConstraint.getType() != 3)
          continue;
        String str3 = localConstraint.getName().name;
        localResult.setRows(null);
        localCollector.clear();
        localCollector.addAll(localConstraint.core.check, 2);
        Iterator localIterator2 = localCollector.iterator();
        while (localIterator2.hasNext())
        {
          Expression localExpression = (Expression)localIterator2.next();
          TableFilter localTableFilter = localExpression.getFilter();
          Table localTable3 = localTableFilter.getTable();
          if ((localTable3.getTableType() == 1) || (!isAccessibleTable(localTable3)))
            continue;
          localResult.add(new Object[] { this.ns.getCatalogName(localTable3), localTable3.getSchemaName(), localTable3.getName().name, localExpression.getColumnName() });
        }
        localResult.removeDuplicates(this.session);
        localIterator2 = localResult.iterator();
        while (localIterator2.hasNext())
        {
          Object[] arrayOfObject2 = localTable1.getEmptyRowData();
          Object[] arrayOfObject1 = (Object[])localIterator2.next();
          arrayOfObject2[0] = str1;
          arrayOfObject2[1] = str2;
          arrayOfObject2[2] = str3;
          arrayOfObject2[3] = arrayOfObject1[0];
          arrayOfObject2[4] = arrayOfObject1[1];
          arrayOfObject2[5] = arrayOfObject1[2];
          arrayOfObject2[6] = arrayOfObject1[3];
          localTable1.insertSys(arrayOfObject2);
        }
      }
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  Table SYSTEM_CHECK_ROUTINE_USAGE()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[37];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[37]);
      addColumn(localTable1, "CONSTRAINT_CATALOG", 12);
      addColumn(localTable1, "CONSTRAINT_SCHEMA", 12);
      addColumn(localTable1, "CONSTRAINT_NAME", 12, false);
      addColumn(localTable1, "SPECIFIC_CATALOG", 12);
      addColumn(localTable1, "SPECIFIC_SCHEMA", 12);
      addColumn(localTable1, "SPECIFIC_NAME", 12, false);
      localTable1.createPrimaryKey(null, new int[] { 0, 1, 2, 3, 4, 5 }, false);
      return localTable1;
    }
    Iterator localIterator1 = this.database.schemaManager.allTablesIterator();
    Expression.Collector localCollector = new Expression.Collector();
    while (localIterator1.hasNext())
    {
      localCollector.clear();
      Table localTable2 = (Table)localIterator1.next();
      if (!isAccessibleTable(localTable2))
        continue;
      Constraint[] arrayOfConstraint = localTable2.getConstraints();
      int i = arrayOfConstraint.length;
      String str1 = this.ns.getCatalogName(localTable2);
      String str2 = localTable2.getSchemaName();
      for (int j = 0; j < i; j++)
      {
        Constraint localConstraint = arrayOfConstraint[j];
        if (localConstraint.getType() != 3)
          continue;
        String str3 = localConstraint.getName().name;
        localCollector.addAll(localConstraint.core.check, 7);
        HashSet localHashSet = new HashSet();
        Iterator localIterator2 = localCollector.iterator();
        while (localIterator2.hasNext())
        {
          Expression localExpression = (Expression)localIterator2.next();
          Function localFunction = localExpression.function;
          if (!this.session.isAccessible(localFunction.getMethod().getDeclaringClass().getName()))
            continue;
          localHashSet.add(localFunction.getMethod());
        }
        localIterator2 = localHashSet.iterator();
        while (localIterator2.hasNext())
        {
          Method localMethod = (Method)localIterator2.next();
          Object[] arrayOfObject = localTable1.getEmptyRowData();
          arrayOfObject[0] = str1;
          arrayOfObject[1] = str2;
          arrayOfObject[2] = str3;
          arrayOfObject[3] = this.ns.getCatalogName(localMethod);
          arrayOfObject[4] = this.ns.getSchemaName(localMethod);
          arrayOfObject[5] = DINameSpace.getMethodSpecificName(localMethod);
          localTable1.insertSys(arrayOfObject);
        }
      }
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  Table SYSTEM_CHECK_TABLE_USAGE()
    throws HsqlException
  {
    Table localTable = this.sysTables[38];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[38]);
      addColumn(localTable, "CONSTRAINT_CATALOG", 12);
      addColumn(localTable, "CONSTRAINT_SCHEMA", 12);
      addColumn(localTable, "CONSTRAINT_NAME", 12, false);
      addColumn(localTable, "TABLE_CATALOG", 12);
      addColumn(localTable, "TABLE_SCHEMA", 12);
      addColumn(localTable, "TABLE_NAME", 12, false);
      localTable.createPrimaryKey(null, new int[] { 0, 1, 2, 3, 4, 5 }, false);
      return localTable;
    }
    Result localResult = this.session.sqlExecuteDirectNoPreChecks("select DISTINCT CONSTRAINT_CATALOG, CONSTRAINT_SCHEMA, CONSTRAINT_NAME, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME from INFORMATION_SCHEMA.SYSTEM_CHECK_COLUMN_USAGE");
    localTable.insertSys(localResult);
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_TABLE_CONSTRAINTS()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[35];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[35]);
      addColumn(localTable1, "CONSTRAINT_CATALOG", 12);
      addColumn(localTable1, "CONSTRAINT_SCHEMA", 12);
      addColumn(localTable1, "CONSTRAINT_NAME", 12, false);
      addColumn(localTable1, "CONSTRAINT_TYPE", 12, 11, false);
      addColumn(localTable1, "TABLE_CATALOG", 12);
      addColumn(localTable1, "TABLE_SCHEMA", 12);
      addColumn(localTable1, "TABLE_NAME", 12, false);
      addColumn(localTable1, "IS_DEFERRABLE", 12, 3, false);
      addColumn(localTable1, "INITIALLY_DEFERRED", 12, 3, false);
      localTable1.createPrimaryKey(null, new int[] { 0, 1, 2, 4, 5, 6 }, false);
      return localTable1;
    }
    Iterator localIterator1 = this.database.schemaManager.allTablesIterator();
    HashSet localHashSet = new HashSet();
    Table localTable2 = null;
    Constraint localConstraint;
    while (localIterator1.hasNext())
    {
      localTable2 = (Table)localIterator1.next();
      if ((localTable2.isView()) || (!isAccessibleTable(localTable2)))
        continue;
      Constraint[] arrayOfConstraint = localTable2.getConstraints();
      int i = arrayOfConstraint.length;
      for (int j = 0; j < i; j++)
      {
        localConstraint = arrayOfConstraint[j];
        if ((localConstraint.getType() == 0) && (!isAccessibleTable(localConstraint.getRef())))
          continue;
        localHashSet.add(localConstraint);
      }
    }
    Iterator localIterator2 = localHashSet.iterator();
    while (localIterator2.hasNext())
    {
      Object[] arrayOfObject = localTable1.getEmptyRowData();
      localConstraint = (Constraint)localIterator2.next();
      switch (localConstraint.getType())
      {
      case 3:
        arrayOfObject[3] = "CHECK";
        localTable2 = localConstraint.getMain();
        break;
      case 2:
        arrayOfObject[3] = "UNIQUE";
        localTable2 = localConstraint.getMain();
        break;
      case 0:
        arrayOfObject[3] = "FOREIGN KEY";
        localTable2 = localConstraint.getRef();
        break;
      case 4:
        arrayOfObject[3] = "PRIMARY KEY";
        localTable2 = localConstraint.getMain();
        break;
      case 1:
      default:
        break;
      }
      String str1 = this.ns.getCatalogName(localTable2);
      String str2 = localTable2.getSchemaName();
      arrayOfObject[0] = str1;
      arrayOfObject[1] = str2;
      arrayOfObject[2] = localConstraint.constName.name;
      arrayOfObject[4] = str1;
      arrayOfObject[5] = str2;
      arrayOfObject[6] = localTable2.getName().name;
      arrayOfObject[7] = "NO";
      arrayOfObject[8] = "NO";
      localTable1.insertSys(arrayOfObject);
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  Table SYSTEM_VIEW_TABLE_USAGE()
    throws HsqlException
  {
    Table localTable = this.sysTables[40];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[40]);
      addColumn(localTable, "VIEW_CATALOG", 12);
      addColumn(localTable, "VIEW_SCHEMA", 12);
      addColumn(localTable, "VIEW_NAME", 12, true);
      addColumn(localTable, "TABLE_CATALOG", 12);
      addColumn(localTable, "TABLE_SCHEMA", 12);
      addColumn(localTable, "TABLE_NAME", 12, true);
      localTable.createPrimaryKey(null, new int[] { 0, 1, 2, 3, 4, 5 }, false);
      return localTable;
    }
    Result localResult = this.session.sqlExecuteDirectNoPreChecks("select DISTINCT VIEW_CATALOG, VIEW_SCHEMA, VIEW_NAME, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME from INFORMATION_SCHEMA.SYSTEM_VIEW_COLUMN_USAGE");
    localTable.insertSys(localResult);
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_VIEW_COLUMN_USAGE()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[39];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[39]);
      addColumn(localTable1, "VIEW_CATALOG", 12);
      addColumn(localTable1, "VIEW_SCHEMA", 12);
      addColumn(localTable1, "VIEW_NAME", 12, true);
      addColumn(localTable1, "TABLE_CATALOG", 12);
      addColumn(localTable1, "TABLE_SCHEMA", 12);
      addColumn(localTable1, "TABLE_NAME", 12, true);
      addColumn(localTable1, "COLUMN_NAME", 12, true);
      localTable1.createPrimaryKey(null, new int[] { 0, 1, 2, 3, 4, 5, 6 }, false);
      return localTable1;
    }
    Iterator localIterator1 = this.database.schemaManager.allTablesIterator();
    Expression.Collector localCollector = new Expression.Collector();
    Result localResult = new Result(3, 4);
    int tmp210_209 = (localResult.metaData.colTypes[2] = localResult.metaData.colTypes[3] = 12);
    localResult.metaData.colTypes[1] = tmp210_209;
    localResult.metaData.colTypes[0] = tmp210_209;
    while (localIterator1.hasNext())
    {
      localCollector.clear();
      localResult.setRows(null);
      Table localTable2 = (Table)localIterator1.next();
      if ((!localTable2.isView()) || (!isAccessibleTable(localTable2)))
        continue;
      String str1 = this.ns.getCatalogName(localTable2);
      String str2 = localTable2.getSchemaName();
      String str3 = localTable2.getName().name;
      View localView = (View)localTable2;
      SubQuery[] arrayOfSubQuery = localView.viewSubqueries;
      localCollector.addAll(localView.viewSelect, 2);
      for (int i = 0; i < arrayOfSubQuery.length; i++)
        localCollector.addAll(arrayOfSubQuery[i].select, 2);
      Iterator localIterator2 = localCollector.iterator();
      while (localIterator2.hasNext())
      {
        Expression localExpression = (Expression)localIterator2.next();
        TableFilter localTableFilter = localExpression.getFilter();
        Table localTable3 = localTableFilter.getTable();
        if ((localTable3.getTableType() == 1) || (!isAccessibleTable(localTable3)))
          continue;
        localResult.add(new Object[] { this.ns.getCatalogName(localTable3), localTable3.getSchemaName(), localTable3.getName().name, localExpression.getColumnName() });
      }
      localResult.removeDuplicates(this.session);
      localIterator2 = localResult.iterator();
      while (localIterator2.hasNext())
      {
        Object[] arrayOfObject1 = localTable1.getEmptyRowData();
        Object[] arrayOfObject2 = (Object[])localIterator2.next();
        arrayOfObject1[0] = str1;
        arrayOfObject1[1] = str2;
        arrayOfObject1[2] = str3;
        arrayOfObject1[3] = arrayOfObject2[0];
        arrayOfObject1[4] = arrayOfObject2[1];
        arrayOfObject1[5] = arrayOfObject2[2];
        arrayOfObject1[6] = arrayOfObject2[3];
        localTable1.insertSys(arrayOfObject1);
      }
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  Table SYSTEM_VIEW_ROUTINE_USAGE()
    throws HsqlException
  {
    Table localTable1 = this.sysTables[41];
    if (localTable1 == null)
    {
      localTable1 = createBlankTable(sysTableHsqlNames[41]);
      addColumn(localTable1, "TABLE_CATALOG", 12);
      addColumn(localTable1, "TABLE_SCHEMA", 12);
      addColumn(localTable1, "TABLE_NAME", 12, true);
      addColumn(localTable1, "SPECIFIC_CATALOG", 12);
      addColumn(localTable1, "SPECIFIC_SCHEMA", 12);
      addColumn(localTable1, "SPECIFIC_NAME", 12, true);
      localTable1.createPrimaryKey(null, new int[] { 0, 1, 2, 3, 4, 5 }, false);
      return localTable1;
    }
    Iterator localIterator1 = this.database.schemaManager.allTablesIterator();
    Expression.Collector localCollector = new Expression.Collector();
    while (localIterator1.hasNext())
    {
      localCollector.clear();
      Table localTable2 = (Table)localIterator1.next();
      if ((!localTable2.isView()) || (!isAccessibleTable(localTable2)))
        continue;
      String str1 = this.ns.getCatalogName(localTable2);
      String str2 = localTable2.getSchemaName();
      String str3 = localTable2.getName().name;
      View localView = (View)localTable2;
      SubQuery[] arrayOfSubQuery = localView.viewSubqueries;
      localCollector.addAll(localView.viewSelect, 7);
      for (int i = 0; i < arrayOfSubQuery.length; i++)
        localCollector.addAll(arrayOfSubQuery[i].select, 7);
      HashSet localHashSet = new HashSet();
      Iterator localIterator2 = localCollector.iterator();
      while (localIterator2.hasNext())
      {
        Expression localExpression = (Expression)localIterator2.next();
        Function localFunction = localExpression.function;
        if (!this.session.isAccessible(localFunction.getMethod().getDeclaringClass().getName()))
          continue;
        localHashSet.add(localFunction.getMethod());
      }
      localIterator2 = localHashSet.iterator();
      while (localIterator2.hasNext())
      {
        Method localMethod = (Method)localIterator2.next();
        Object[] arrayOfObject = localTable1.getEmptyRowData();
        arrayOfObject[0] = str1;
        arrayOfObject[1] = str2;
        arrayOfObject[2] = str3;
        arrayOfObject[3] = this.ns.getCatalogName(localMethod);
        arrayOfObject[4] = this.ns.getSchemaName(localMethod);
        arrayOfObject[5] = DINameSpace.getMethodSpecificName(localMethod);
        localTable1.insertSys(arrayOfObject);
      }
    }
    localTable1.setDataReadOnly(true);
    return localTable1;
  }

  protected void addPColRows(Table paramTable, HsqlArrayList paramHsqlArrayList, String paramString1, String paramString2, String paramString3, String paramString4, Integer paramInteger1, Integer paramInteger2, String paramString5, Integer paramInteger3, Integer paramInteger4, Integer paramInteger5, Integer paramInteger6, Integer paramInteger7, String paramString6, String paramString7, int paramInt)
    throws HsqlException
  {
    Object[] arrayOfObject = paramTable.getEmptyRowData();
    Integer localInteger = ValuePool.getInt(paramInt);
    arrayOfObject[0] = paramString1;
    arrayOfObject[1] = paramString2;
    arrayOfObject[2] = paramString3;
    arrayOfObject[3] = paramString4;
    arrayOfObject[4] = paramInteger1;
    arrayOfObject[5] = paramInteger2;
    arrayOfObject[6] = paramString5;
    arrayOfObject[7] = paramInteger3;
    arrayOfObject[8] = paramInteger4;
    arrayOfObject[9] = paramInteger5;
    arrayOfObject[10] = paramInteger6;
    arrayOfObject[11] = paramInteger7;
    arrayOfObject[12] = paramString6;
    arrayOfObject[13] = paramString7;
    arrayOfObject[14] = localInteger;
    paramTable.insertSys(arrayOfObject);
    if (paramHsqlArrayList != null)
    {
      int i = paramHsqlArrayList.size();
      for (int j = 0; j < i; j++)
      {
        arrayOfObject = paramTable.getEmptyRowData();
        paramString3 = (String)paramHsqlArrayList.get(j);
        arrayOfObject[0] = paramString1;
        arrayOfObject[1] = paramString2;
        arrayOfObject[2] = paramString3;
        arrayOfObject[3] = paramString4;
        arrayOfObject[4] = paramInteger1;
        arrayOfObject[5] = paramInteger2;
        arrayOfObject[6] = paramString5;
        arrayOfObject[7] = paramInteger3;
        arrayOfObject[8] = paramInteger4;
        arrayOfObject[9] = paramInteger5;
        arrayOfObject[10] = paramInteger6;
        arrayOfObject[11] = paramInteger7;
        arrayOfObject[12] = paramString6;
        arrayOfObject[13] = paramString7;
        arrayOfObject[14] = localInteger;
        paramTable.insertSys(arrayOfObject);
      }
    }
  }

  protected void addProcRows(Table paramTable, HsqlArrayList paramHsqlArrayList, String paramString1, String paramString2, String paramString3, Integer paramInteger1, Integer paramInteger2, Integer paramInteger3, String paramString4, Integer paramInteger4, String paramString5, String paramString6)
    throws HsqlException
  {
    Object[] arrayOfObject = paramTable.getEmptyRowData();
    arrayOfObject[0] = paramString1;
    arrayOfObject[1] = paramString2;
    arrayOfObject[2] = paramString3;
    arrayOfObject[3] = paramInteger1;
    arrayOfObject[4] = paramInteger2;
    arrayOfObject[5] = paramInteger3;
    arrayOfObject[6] = paramString4;
    arrayOfObject[7] = paramInteger4;
    arrayOfObject[8] = paramString5;
    arrayOfObject[9] = paramString6;
    paramTable.insertSys(arrayOfObject);
    if (paramHsqlArrayList != null)
    {
      int i = paramHsqlArrayList.size();
      for (int j = 0; j < i; j++)
      {
        arrayOfObject = paramTable.getEmptyRowData();
        paramString3 = (String)paramHsqlArrayList.get(j);
        arrayOfObject[0] = paramString1;
        arrayOfObject[1] = paramString2;
        arrayOfObject[2] = paramString3;
        arrayOfObject[3] = paramInteger1;
        arrayOfObject[4] = paramInteger2;
        arrayOfObject[5] = paramInteger3;
        arrayOfObject[6] = paramString4;
        arrayOfObject[7] = paramInteger4;
        arrayOfObject[8] = "ALIAS";
        arrayOfObject[9] = paramString6;
        paramTable.insertSys(arrayOfObject);
      }
    }
  }

  Table SYSTEM_AUTHORIZATIONS()
    throws HsqlException
  {
    Table localTable = this.sysTables[42];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[42]);
      addColumn(localTable, "AUTHORIZATION_NAME", 12, true);
      addColumn(localTable, "AUTHORIZATION_TYPE", 12, true);
      localTable.createPrimaryKey(null, new int[] { 0 }, true);
      return localTable;
    }
    HsqlArrayList localHsqlArrayList = this.database.getUserManager().listVisibleUsers(this.session, false);
    int i = localHsqlArrayList.size();
    Object[] arrayOfObject;
    for (int j = 0; j < localHsqlArrayList.size(); j++)
    {
      arrayOfObject = localTable.getEmptyRowData();
      User localUser = (User)localHsqlArrayList.get(j);
      arrayOfObject[0] = localUser.getName();
      arrayOfObject[1] = "USER";
      localTable.insertSys(arrayOfObject);
    }
    Iterator localIterator = this.database.getGranteeManager().getRoleNames().iterator();
    while (localIterator.hasNext())
    {
      arrayOfObject = localTable.getEmptyRowData();
      arrayOfObject[0] = localIterator.next().toString();
      arrayOfObject[1] = "ROLE";
      localTable.insertSys(arrayOfObject);
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_COLLATIONS()
    throws HsqlException
  {
    Table localTable = this.sysTables[43];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[43]);
      addColumn(localTable, "COLLATION_CATALOG", 12);
      addColumn(localTable, "COLLATION_SCHEMA", 12, true);
      addColumn(localTable, "COLLATION_NAME", 12, true);
      addColumn(localTable, "PAD_ATTRIBUTE", 12, 9, true);
      addColumn(localTable, "COLLATION_TYPE", 12, true);
      addColumn(localTable, "COLLATION_DEFINITION", 12);
      addColumn(localTable, "COLLATION_DICTIONARY", 12);
      addColumn(localTable, "CHARACTER_REPERTOIRE_NAME", 12, true);
      localTable.createPrimaryKey(null, new int[] { 0, 1, 2 }, false);
      return localTable;
    }
    String str2 = "PUBLIC";
    String str3 = "NO PAD";
    String str4 = "UNICODE";
    Iterator localIterator = Collation.nameToJavaName.keySet().iterator();
    while (localIterator.hasNext())
    {
      Object[] arrayOfObject = localTable.getEmptyRowData();
      String str1 = (String)localIterator.next();
      arrayOfObject[0] = this.ns.getCatalogName(str1);
      arrayOfObject[1] = str2;
      arrayOfObject[2] = str1;
      arrayOfObject[3] = str3;
      arrayOfObject[7] = str4;
      localTable.insertSys(arrayOfObject);
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS()
    throws HsqlException
  {
    Table localTable = this.sysTables[44];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[44]);
      addColumn(localTable, "ROLE_NAME", 12, true);
      addColumn(localTable, "GRANTEE", 12, true);
      addColumn(localTable, "GRANTOR", 12, true);
      addColumn(localTable, "IS_GRANTABLE", 12, true);
      localTable.createPrimaryKey(null, new int[] { 0, 1 }, true);
      return localTable;
    }
    String str1 = "_SYSTEM";
    Iterator localIterator1 = this.database.getGranteeManager().getGrantees().iterator();
    while (localIterator1.hasNext())
    {
      Grantee localGrantee = (Grantee)localIterator1.next();
      String str2 = localGrantee.getName();
      Iterator localIterator2 = localGrantee.getDirectRoles().iterator();
      while (localIterator2.hasNext())
      {
        Object[] arrayOfObject = localTable.getEmptyRowData();
        String str3 = (String)localIterator2.next();
        String str4 = localGrantee.hasRole("DBA") ? "YES" : "NO";
        arrayOfObject[0] = str3;
        arrayOfObject[1] = str2;
        arrayOfObject[2] = str1;
        arrayOfObject[3] = str4;
        localTable.insertSys(arrayOfObject);
      }
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }

  Table SYSTEM_SCHEMATA()
    throws HsqlException
  {
    Table localTable = this.sysTables[45];
    if (localTable == null)
    {
      localTable = createBlankTable(sysTableHsqlNames[45]);
      addColumn(localTable, "CATALOG_NAME", 12);
      addColumn(localTable, "SCHEMA_NAME", 12, true);
      addColumn(localTable, "SCHEMA_OWNER", 12, true);
      addColumn(localTable, "DEFAULT_CHARACTER_SET_CATALOG", 12);
      addColumn(localTable, "DEFAULT_CHARACTER_SET_SCHEMA", 12, true);
      addColumn(localTable, "DEFAULT_CHARACTER_SET_NAME", 12);
      addColumn(localTable, "SQL_PATH", 12);
      localTable.createPrimaryKey(null, new int[] { 0, 1 }, false);
      return localTable;
    }
    String str2 = "DBA";
    String str3 = "INFORMATION_SCHEMA";
    String str4 = ValuePool.getString("UTF16");
    Object localObject = null;
    Iterator localIterator = this.database.schemaManager.fullSchemaNamesIterator();
    while (localIterator.hasNext())
    {
      Object[] arrayOfObject = localTable.getEmptyRowData();
      String str1 = (String)localIterator.next();
      arrayOfObject[0] = this.ns.getCatalogName(str1);
      arrayOfObject[1] = str1;
      arrayOfObject[2] = str2;
      arrayOfObject[3] = this.ns.getCatalogName(str3);
      arrayOfObject[4] = str3;
      arrayOfObject[5] = str4;
      arrayOfObject[6] = localObject;
      localTable.insertSys(arrayOfObject);
    }
    localTable.setDataReadOnly(true);
    return localTable;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.DatabaseInformationFull
 * JD-Core Version:    0.6.0
 */