package org.hsqldb;

import I;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Locale;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.Logger;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.scriptio.ScriptWriterText;

class DatabaseCommandInterpreter
{
  private Tokenizer tokenizer = new Tokenizer();
  private Database database;
  private Session session;
  static final String oldLib = "org.hsql.Library.";
  static final int oldLibLen = "org.hsql.Library.".length();
  static final String newLib = "org.hsqldb.Library.";

  DatabaseCommandInterpreter(Session paramSession)
  {
    this.session = paramSession;
    this.database = paramSession.getDatabase();
  }

  Result execute(String paramString)
  {
    JavaSystem.gc();
    Result localResult = null;
    int i = -1;
    try
    {
      this.tokenizer.reset(paramString);
      while (true)
      {
        this.tokenizer.setPartMarker();
        this.session.setScripting(false);
        String str = this.tokenizer.getSimpleToken();
        if (str.length() == 0)
        {
          this.session.endSchemaDefinition();
          break;
        }
        i = Token.get(str);
        if (i == 323)
        {
          this.session.endSchemaDefinition();
          continue;
        }
        localResult = executePart(i, str);
        if (localResult.isError())
        {
          this.session.endSchemaDefinition();
          break;
        }
        if (!this.session.getScripting())
          continue;
        this.database.logger.writeToLog(this.session, this.tokenizer.getLastPart());
      }
    }
    catch (Throwable localThrowable)
    {
      try
      {
        if (this.session.isSchemaDefintion())
        {
          HsqlNameManager.HsqlName localHsqlName = this.session.getSchemaHsqlName(null);
          this.database.schemaManager.dropSchema(localHsqlName.name, true);
          this.database.logger.writeToLog(this.session, "DROP SCHEMA " + localHsqlName.statementName + ' ' + "CASCADE");
          this.session.endSchemaDefinition();
        }
      }
      catch (HsqlException localHsqlException)
      {
      }
      localResult = new Result(localThrowable, this.tokenizer.getLastPart());
    }
    return localResult == null ? Session.emptyUpdateCount : localResult;
  }

  private Result executePart(int paramInt, String paramString)
    throws Throwable
  {
    Result localResult = Session.emptyUpdateCount;
    int i = 0;
    if (this.session.isSchemaDefintion())
      switch (paramInt)
      {
      case 41:
      case 96:
        break;
      default:
        throw Trace.error(74, 250, new Object[] { paramString });
      }
    Parser localParser;
    CompiledStatement localCompiledStatement;
    switch (paramInt)
    {
    case 313:
      localParser = new Parser(this.session, this.database, this.tokenizer);
      i = localParser.parseOpenBracketsSelect() + 1;
    case 193:
      localParser = new Parser(this.session, this.database, this.tokenizer);
      localCompiledStatement = localParser.compileSelectStatement(i);
      if (localCompiledStatement.parameters.length != 0)
        Trace.doAssert(false, Trace.getMessage(165));
      localResult = this.session.sqlExecuteCompiledNoPreChecks(localCompiledStatement, null);
      break;
    case 112:
      localParser = new Parser(this.session, this.database, this.tokenizer);
      localCompiledStatement = localParser.compileInsertStatement();
      if (localCompiledStatement.parameters.length != 0)
        Trace.doAssert(false, Trace.getMessage(165));
      localResult = this.session.sqlExecuteCompiledNoPreChecks(localCompiledStatement, null);
      break;
    case 222:
      localParser = new Parser(this.session, this.database, this.tokenizer);
      localCompiledStatement = localParser.compileUpdateStatement();
      if (localCompiledStatement.parameters.length != 0)
        Trace.doAssert(false, Trace.getMessage(165));
      localResult = this.session.sqlExecuteCompiledNoPreChecks(localCompiledStatement, null);
      break;
    case 62:
      localParser = new Parser(this.session, this.database, this.tokenizer);
      localCompiledStatement = localParser.compileDeleteStatement();
      if (localCompiledStatement.parameters.length != 0)
        Trace.doAssert(false, Trace.getMessage(165));
      localResult = this.session.sqlExecuteCompiledNoPreChecks(localCompiledStatement, null);
      break;
    case 23:
      localParser = new Parser(this.session, this.database, this.tokenizer);
      localCompiledStatement = localParser.compileCallStatement();
      if (localCompiledStatement.parameters.length != 0)
        Trace.doAssert(false, Trace.getMessage(165));
      localResult = this.session.sqlExecuteCompiledNoPreChecks(localCompiledStatement, null);
      break;
    case 196:
      processSet();
      break;
    case 35:
      processCommit();
      break;
    case 184:
      processRollback();
      break;
    case 188:
      processSavepoint();
      break;
    case 176:
      processReleaseSavepoint();
      break;
    case 41:
      processCreate();
      this.database.setMetaDirty(false);
      break;
    case 4:
      processAlter();
      this.database.setMetaDirty(true);
      break;
    case 70:
      processDrop();
      this.database.setMetaDirty(true);
      break;
    case 96:
      processGrantOrRevoke(true);
      this.database.setMetaDirty(false);
      break;
    case 182:
      processGrantOrRevoke(false);
      this.database.setMetaDirty(true);
      break;
    case 37:
      processConnect();
      this.database.setMetaDirty(false);
      this.session.setScripting(false);
      break;
    case 66:
      processDisconnect();
      this.session.setScripting(true);
      break;
    case 321:
      localResult = processScript();
      break;
    case 325:
      processShutdown();
      break;
    case 303:
      processCheckpoint();
      break;
    case 304:
      localResult = processExplainPlan();
      break;
    default:
      throw Trace.error(11, paramString);
    }
    return localResult;
  }

  private Result processScript()
    throws IOException, HsqlException
  {
    String str = this.tokenizer.getString();
    ScriptWriterText localScriptWriterText = null;
    this.session.checkAdmin();
    try
    {
      if (this.tokenizer.wasValue())
      {
        if (this.tokenizer.getType() != 12)
          throw Trace.error(74);
        localScriptWriterText = new ScriptWriterText(this.database, str, true, true, true);
        localScriptWriterText.writeAll();
        localResult = new Result(1);
        return localResult;
      }
      this.tokenizer.back();
      Result localResult = DatabaseScript.getScript(this.database, false);
      return localResult;
    }
    finally
    {
      if (localScriptWriterText != null)
        localScriptWriterText.close();
    }
    throw localObject;
  }

  private void processCreate()
    throws HsqlException
  {
    boolean bool = false;
    int j = 0;
    this.session.checkAdmin();
    this.session.checkDDLWrite();
    this.session.setScripting(true);
    if (this.tokenizer.isGetThis("GLOBAL"))
    {
      this.tokenizer.getThis("TEMPORARY");
      j = 1;
    }
    else if (this.tokenizer.isGetThis("TEMP"))
    {
      j = 1;
    }
    else if (this.tokenizer.isGetThis("TEMPORARY"))
    {
      j = 1;
    }
    String str = this.tokenizer.getSimpleToken();
    switch (Token.get(str))
    {
    case 310:
      this.tokenizer.getThis("TABLE");
    case 213:
      int i = j != 0 ? 2 : this.database.getDefaultTableType();
      processCreateTable(i);
      return;
    case 302:
      if (j != 0)
        throw Trace.error(11, str);
      this.tokenizer.getThis("TABLE");
      processCreateTable(4);
      return;
    case 328:
      if (j != 0)
        throw Trace.error(11, str);
      this.tokenizer.getThis("TABLE");
      processCreateTable(6);
      return;
    }
    if (j != 0)
      throw Trace.error(11, str);
    switch (Token.get(str))
    {
    case 300:
      processCreateAlias();
      break;
    case 324:
      processCreateSequence();
      break;
    case 338:
      this.session.setScripting(false);
      processCreateSchema();
      break;
    case 224:
      processCreateTrigger();
      break;
    case 223:
      processCreateUser();
      break;
    case 339:
      this.database.getGranteeManager().addRole(getUserIdentifier());
      break;
    case 329:
      processCreateView();
      break;
    case 228:
      bool = true;
      this.tokenizer.getThis("INDEX");
    case 306:
      processCreateIndex(bool);
      break;
    default:
      throw Trace.error(11, str);
    }
  }

  private int[] processColumnList(Table paramTable, boolean paramBoolean)
    throws HsqlException
  {
    HashMappedList localHashMappedList = Parser.processColumnList(this.tokenizer, paramBoolean);
    int i = localHashMappedList.size();
    int[] arrayOfInt = new int[i];
    for (int j = 0; j < i; j++)
      arrayOfInt[j] = paramTable.getColumnNr((String)localHashMappedList.getKey(j));
    return arrayOfInt;
  }

  private void processCreateTrigger()
    throws HsqlException
  {
    String str1 = this.tokenizer.getName();
    String str7 = this.tokenizer.getLongNameFirst();
    this.database.schemaManager.checkTriggerExists(str1, this.session.getSchemaNameForWrite(str7), false);
    boolean bool3 = this.tokenizer.wasQuotedIdentifier();
    boolean bool1 = false;
    boolean bool2 = false;
    int i = TriggerDef.getDefaultQueueSize();
    String str2 = this.tokenizer.getSimpleToken();
    String str3 = this.tokenizer.getSimpleToken();
    this.tokenizer.getThis("ON");
    String str4 = this.tokenizer.getName();
    if (str7 == null)
      str7 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
    else if (!str7.equals(this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst())))
      throw Trace.error(227);
    Table localTable = this.database.schemaManager.getUserTable(this.session, str4, str7);
    if (localTable.isView())
      throw Trace.error(55);
    this.session.setScripting(true);
    String str5 = this.tokenizer.getSimpleToken();
    if (str5.equals("FOR"))
    {
      str5 = this.tokenizer.getSimpleToken();
      if (str5.equals("EACH"))
      {
        str5 = this.tokenizer.getSimpleToken();
        if (str5.equals("ROW"))
        {
          bool1 = true;
          str5 = this.tokenizer.getSimpleToken();
        }
        else
        {
          throw Trace.error(12, str5);
        }
      }
      else
      {
        throw Trace.error(12, str5);
      }
    }
    if (str5.equals("NOWAIT"))
    {
      bool2 = true;
      str5 = this.tokenizer.getSimpleToken();
    }
    if (str5.equals("QUEUE"))
    {
      i = this.tokenizer.getInt();
      str5 = this.tokenizer.getSimpleToken();
    }
    if (!str5.equals("CALL"))
      throw Trace.error(12, str5);
    String str6 = this.tokenizer.getSimpleName();
    if (!this.tokenizer.wasQuotedIdentifier())
      throw Trace.error(12, str6);
    HsqlNameManager.HsqlName localHsqlName = this.database.nameManager.newHsqlName(str1, bool3);
    TriggerDef localTriggerDef = new TriggerDef(localHsqlName, str2, str3, bool1, localTable, str6, bool2, i, this.database.classLoader);
    localTable.addTrigger(localTriggerDef);
    if (localTriggerDef.isValid())
      try
      {
        localTriggerDef.start();
      }
      catch (Exception localException)
      {
        throw Trace.error(13, localException.toString());
      }
    this.database.schemaManager.registerTriggerName(str1, localTable.getName());
  }

  private Column processCreateColumn()
    throws HsqlException
  {
    String str = this.tokenizer.getSimpleName();
    boolean bool = this.tokenizer.wasQuotedIdentifier();
    HsqlNameManager.HsqlName localHsqlName = this.database.nameManager.newHsqlName(str, bool);
    return processCreateColumn(localHsqlName);
  }

  private Column processCreateColumn(HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    boolean bool1 = false;
    long l1 = this.database.firstIdentity;
    long l2 = 1L;
    boolean bool2 = false;
    int j = 0;
    int k = 0;
    int m = 0;
    boolean bool3 = true;
    Expression localExpression = null;
    String str1 = this.tokenizer.getSimpleToken();
    int i = Types.getTypeNr(str1);
    if ((i == 1) && (this.tokenizer.isGetThis("VARYING")))
      i = 12;
    if (str1.equals("IDENTITY"))
    {
      bool1 = true;
      bool2 = true;
    }
    if (i == 8)
      this.tokenizer.isGetThis("PRECISION");
    if (this.tokenizer.isGetThis("("))
    {
      m = 1;
      j = this.tokenizer.getInt();
      Trace.check(Types.acceptsPrecisionCreateParam(i), 11);
      if ((i != 93) && (i != 92) && (j == 0))
        throw Trace.error(254);
      if (this.tokenizer.isGetThis(","))
      {
        Trace.check(Types.acceptsScaleCreateParam(i), 11);
        k = this.tokenizer.getInt();
      }
      this.tokenizer.getThis(")");
    }
    else if ((i == 1) && (this.database.sqlEnforceStrictSize))
    {
      j = 1;
    }
    else if ((i == 12) && (this.database.sqlEnforceStrictSize))
    {
      throw Trace.error(253);
    }
    if ((i == 12) && (this.database.isIgnoreCase()))
      i = 100;
    if ((i == 6) && (j > 53))
      throw Trace.error(65);
    if (i == 93)
      if (m == 0)
        j = 6;
      else if ((j != 0) && (j != 6))
        throw Trace.error(65);
    if ((i == 92) && (j != 0))
      throw Trace.error(65);
    String str2 = this.tokenizer.getSimpleToken();
    if (str2.equals("DEFAULT"))
    {
      localExpression = processCreateDefaultExpression(i, j, k);
      str2 = this.tokenizer.getSimpleToken();
    }
    else if (str2.equals("GENERATED"))
    {
      this.tokenizer.getThis("BY");
      this.tokenizer.getThis("DEFAULT");
      this.tokenizer.getThis("AS");
      this.tokenizer.getThis("IDENTITY");
      if (this.tokenizer.isGetThis("("))
      {
        this.tokenizer.getThis("START");
        this.tokenizer.getThis("WITH");
        l1 = this.tokenizer.getBigint();
        if (this.tokenizer.isGetThis(","))
        {
          this.tokenizer.getThis("INCREMENT");
          this.tokenizer.getThis("BY");
          l2 = this.tokenizer.getBigint();
        }
        this.tokenizer.getThis(")");
      }
      bool1 = true;
      bool2 = true;
      str2 = this.tokenizer.getSimpleToken();
    }
    if (str2.equals("IDENTITY"))
    {
      bool1 = true;
      bool2 = true;
      str2 = this.tokenizer.getSimpleToken();
    }
    if (str2.equals("NULL"))
    {
      str2 = this.tokenizer.getSimpleToken();
    }
    else if (str2.equals("NOT"))
    {
      this.tokenizer.getThis("NULL");
      bool3 = false;
      str2 = this.tokenizer.getSimpleToken();
    }
    if (str2.equals("IDENTITY"))
    {
      if (bool1)
        throw Trace.error(24, "IDENTITY");
      bool1 = true;
      bool2 = true;
      str2 = this.tokenizer.getSimpleToken();
    }
    if (str2.equals("PRIMARY"))
    {
      this.tokenizer.getThis("KEY");
      bool2 = true;
    }
    else
    {
      this.tokenizer.back();
    }
    if ((bool1) && (localExpression != null))
      throw Trace.error(11, "DEFAULT");
    Column localColumn = new Column(paramHsqlName, bool3, i, j, k, bool2, localExpression);
    localColumn.setIdentity(bool1, l1, l2);
    return localColumn;
  }

  private Expression processCreateDefaultExpression(int paramInt1, int paramInt2, int paramInt3)
    throws HsqlException
  {
    if (paramInt1 == 1111)
      throw Trace.error(46);
    Parser localParser = new Parser(this.session, this.database, this.tokenizer);
    Expression localExpression = localParser.readDefaultClause(paramInt1);
    localExpression.resolveTypes(this.session);
    int i = localExpression.getType();
    if ((i == 1) || (i == 4) || (i == -4) || ((i == 7) && (localExpression.function.isSimple)))
    {
      Object localObject;
      try
      {
        localObject = localExpression.getValue(this.session, paramInt1);
      }
      catch (HsqlException localHsqlException1)
      {
        throw Trace.error(46);
      }
      if ((localObject != null) && (this.database.sqlEnforceStrictSize))
        try
        {
          Column.enforceSize(localObject, paramInt1, paramInt2, paramInt3, true);
        }
        catch (HsqlException localHsqlException2)
        {
          throw Trace.error(46);
        }
      return localExpression;
    }
    throw Trace.error(46);
  }

  public static void checkBooleanDefault(String paramString, int paramInt)
    throws HsqlException
  {
    if ((paramInt != 16) || (paramString == null))
      return;
    paramString = paramString.toUpperCase();
    if ((paramString.equals("TRUE")) || (paramString.equals("FALSE")))
      return;
    if ((paramString.equals("0")) || (paramString.equals("1")))
      return;
    throw Trace.error(46, paramString);
  }

  private HsqlArrayList processCreateConstraints(Table paramTable, boolean paramBoolean, int[] paramArrayOfInt)
    throws HsqlException
  {
    HsqlArrayList localHsqlArrayList = new HsqlArrayList();
    Constraint localConstraint1 = new Constraint(null, paramArrayOfInt, null, null, 1, 3, 3);
    Object localObject1 = null;
    localHsqlArrayList.add(localConstraint1);
    if (!paramBoolean)
      return localHsqlArrayList;
    String str;
    do
    {
      HsqlNameManager.HsqlName localHsqlName = null;
      Object localObject2;
      if (this.tokenizer.isGetThis("CONSTRAINT"))
      {
        str = this.tokenizer.getName();
        localObject2 = this.tokenizer.getLongNameFirst();
        if (localObject2 != null)
        {
          localObject2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
          if (!paramTable.getSchemaName().equals(localObject2))
            throw Trace.error(227, localObject2);
        }
        localHsqlName = this.database.nameManager.newHsqlName(str, this.tokenizer.wasQuotedIdentifier());
      }
      str = this.tokenizer.getSimpleToken();
      switch (Token.get(str))
      {
      case 167:
        this.tokenizer.getThis("KEY");
        localObject1 = localHsqlName;
        localObject2 = processColumnList(paramTable, false);
        Constraint localConstraint2 = (Constraint)localHsqlArrayList.get(0);
        if ((localConstraint2.core.mainColArray != null) && (!ArrayUtil.areEqual(localConstraint2.core.mainColArray, localObject2, localObject2.length, true)))
          throw Trace.error(24);
        localConstraint2.core.mainColArray = ((I)localObject2);
        localConstraint2.constName = localObject1;
        break;
      case 228:
        localObject2 = processColumnList(paramTable, false);
        if (localHsqlName == null)
          localHsqlName = this.database.nameManager.newAutoName("CT");
        localConstraint1 = new Constraint(localHsqlName, localObject2, null, null, 2, 3, 3);
        localHsqlArrayList.add(localConstraint1);
        break;
      case 89:
        this.tokenizer.getThis("KEY");
        localConstraint1 = processCreateFK(paramTable, localHsqlName);
        if (localConstraint1.core.refColArray == null)
        {
          localObject2 = (Constraint)localHsqlArrayList.get(0);
          localConstraint1.core.refColArray = ((Constraint)localObject2).core.mainColArray;
          if (localConstraint1.core.refColArray == null)
            throw Trace.error(61, 103);
        }
        checkFKColumnDefaults(paramTable, localConstraint1);
        paramTable.checkColumnsMatch(localConstraint1.core.mainColArray, localConstraint1.core.refTable, localConstraint1.core.refColArray);
        localHsqlArrayList.add(localConstraint1);
        break;
      case 30:
        if (localHsqlName == null)
          localHsqlName = this.database.nameManager.newAutoName("CT");
        localConstraint1 = new Constraint(localHsqlName, null, null, null, 3, 3, 3);
        processCreateCheckConstraintCondition(localConstraint1);
        localHsqlArrayList.add(localConstraint1);
      }
      str = this.tokenizer.getSimpleToken();
    }
    while (str.equals(","));
    if (!str.equals(")"))
      throw Trace.error(11, str);
    return (HsqlArrayList)localHsqlArrayList;
  }

  private void processCreateCheckConstraintCondition(Constraint paramConstraint)
    throws HsqlException
  {
    this.tokenizer.getThis("(");
    Parser localParser = new Parser(this.session, this.database, this.tokenizer);
    Expression localExpression = localParser.parseExpression();
    this.tokenizer.getThis(")");
    paramConstraint.core.check = localExpression;
  }

  private void processCreateTable(int paramInt)
    throws HsqlException
  {
    String str = this.tokenizer.getName();
    HsqlNameManager.HsqlName localHsqlName = this.session.getSchemaHsqlNameForWrite(this.tokenizer.getLongNameFirst());
    this.database.schemaManager.checkUserTableNotExists(this.session, str, localHsqlName.name);
    boolean bool1 = this.tokenizer.wasQuotedIdentifier();
    int[] arrayOfInt = null;
    int i = 0;
    boolean bool2 = false;
    Table localTable = newTable(paramInt, str, bool1, localHsqlName);
    this.tokenizer.getThis("(");
    while (true)
    {
      str = this.tokenizer.getString();
      switch (Token.get(str))
      {
      case 30:
      case 38:
      case 89:
      case 167:
      case 228:
        bool2 = (!this.tokenizer.wasQuotedIdentifier()) && (!this.tokenizer.wasLongName());
      }
      this.tokenizer.back();
      if (bool2)
        break;
      localObject = processCreateColumn();
      localTable.addColumn((Column)localObject);
      if (((Column)localObject).isPrimaryKey())
      {
        Trace.check(arrayOfInt == null, 24, ((Column)localObject).columnName.name);
        arrayOfInt = new int[] { i };
      }
      str = this.tokenizer.getSimpleToken();
      if (str.equals(","))
      {
        i++;
        continue;
      }
      if (str.equals(")"))
        break;
      throw Trace.error(11, str);
    }
    Object localObject = processCreateConstraints(localTable, bool2, arrayOfInt);
    if (this.tokenizer.isGetThis("ON"))
    {
      if (!localTable.isTemp)
        throw Trace.error(11, "ON");
      this.tokenizer.getThis("COMMIT");
      str = this.tokenizer.getSimpleToken();
      if (!str.equals("DELETE"))
        if (str.equals("PRESERVE"))
          localTable.onCommitPreserve = true;
        else
          throw Trace.error(11, str);
      this.tokenizer.getThis("ROWS");
    }
    try
    {
      this.session.commit();
      Constraint localConstraint1 = (Constraint)((HsqlArrayList)localObject).get(0);
      localTable.createPrimaryKey(null, localConstraint1.core.mainColArray, true);
      if (localConstraint1.core.mainColArray != null)
      {
        if (localConstraint1.constName == null)
          localConstraint1.constName = localTable.makeSysPKName();
        Constraint localConstraint2 = new Constraint(localConstraint1.constName, localTable, localTable.getPrimaryIndex(), 4);
        localTable.addConstraint(localConstraint2);
        this.database.schemaManager.registerConstraintName(localConstraint1.constName.name, localTable.getName());
      }
      for (int j = 1; j < ((HsqlArrayList)localObject).size(); j++)
      {
        Constraint localConstraint3 = (Constraint)((HsqlArrayList)localObject).get(j);
        if (localConstraint3.constType == 2)
        {
          localTableWorks = new TableWorks(this.session, localTable);
          localTableWorks.createUniqueConstraint(localConstraint3.core.mainColArray, localConstraint3.constName);
          localTable = localTableWorks.getTable();
        }
        if (localConstraint3.constType == 0)
        {
          localTableWorks = new TableWorks(this.session, localTable);
          localTableWorks.createForeignKey(localConstraint3.core.mainColArray, localConstraint3.core.refColArray, localConstraint3.constName, localConstraint3.core.refTable, localConstraint3.core.deleteAction, localConstraint3.core.updateAction);
          localTable = localTableWorks.getTable();
        }
        if (localConstraint3.constType != 3)
          continue;
        TableWorks localTableWorks = new TableWorks(this.session, localTable);
        localTableWorks.createCheckConstraint(localConstraint3, localConstraint3.constName);
        localTable = localTableWorks.getTable();
      }
      this.database.schemaManager.linkTable(localTable);
    }
    catch (HsqlException localHsqlException)
    {
      this.database.schemaManager.removeExportedKeys(localTable);
      this.database.schemaManager.removeIndexNames(localTable.tableName);
      this.database.schemaManager.removeConstraintNames(localTable.tableName);
      throw localHsqlException;
    }
  }

  private Constraint processCreateFK(Table paramTable, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    int[] arrayOfInt1 = processColumnList(paramTable, false);
    this.tokenizer.getThis("REFERENCES");
    String str1 = this.tokenizer.getName();
    String str3 = this.tokenizer.getLongNameFirst();
    if (str3 != null)
    {
      str3 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
      if (!paramTable.getSchemaName().equals(str3))
        throw Trace.error(227, str3);
    }
    Table localTable;
    if (paramTable.getName().name.equals(str1))
      localTable = paramTable;
    else
      localTable = this.database.schemaManager.getTable(this.session, str1, paramTable.getSchemaName());
    int[] arrayOfInt2 = null;
    String str2 = this.tokenizer.getSimpleToken();
    this.tokenizer.back();
    if (str2.equals("("))
      arrayOfInt2 = processColumnList(localTable, false);
    else if (localTable.getPrimaryKey() == null)
      Trace.check(paramTable == localTable, 103);
    else if (localTable.hasPrimaryKey())
      arrayOfInt2 = localTable.getPrimaryKey();
    else
      throw Trace.error(61, 103);
    str2 = this.tokenizer.getSimpleToken();
    int i = 3;
    int j = 3;
    while (str2.equals("ON"))
    {
      str2 = this.tokenizer.getSimpleToken();
      if ((i == 3) && (str2.equals("DELETE")))
      {
        str2 = this.tokenizer.getSimpleToken();
        if (str2.equals("SET"))
        {
          str2 = this.tokenizer.getSimpleToken();
          if (str2.equals("DEFAULT"))
            i = 4;
          else if (str2.equals("NULL"))
            i = 2;
          else
            throw Trace.error(11, str2);
        }
        else if (str2.equals("CASCADE"))
        {
          i = 0;
        }
        else if (!str2.equals("RESTRICT"))
        {
          this.tokenizer.matchThis("NO");
          this.tokenizer.getThis("ACTION");
        }
      }
      else if ((j == 3) && (str2.equals("UPDATE")))
      {
        str2 = this.tokenizer.getSimpleToken();
        if (str2.equals("SET"))
        {
          str2 = this.tokenizer.getSimpleToken();
          if (str2.equals("DEFAULT"))
            j = 4;
          else if (str2.equals("NULL"))
            j = 2;
          else
            throw Trace.error(11, str2);
        }
        else if (str2.equals("CASCADE"))
        {
          j = 0;
        }
        else if (!str2.equals("RESTRICT"))
        {
          this.tokenizer.matchThis("NO");
          this.tokenizer.getThis("ACTION");
        }
      }
      else
      {
        throw Trace.error(11, str2);
      }
      str2 = this.tokenizer.getSimpleToken();
    }
    this.tokenizer.back();
    if (paramHsqlName == null)
      paramHsqlName = this.database.nameManager.newAutoName("FK");
    return new Constraint(paramHsqlName, arrayOfInt1, localTable, arrayOfInt2, 0, i, j);
  }

  private void processCreateView()
    throws HsqlException
  {
    String str = this.tokenizer.getName();
    HsqlNameManager.HsqlName localHsqlName1 = this.session.getSchemaHsqlNameForWrite(this.tokenizer.getLongNameFirst());
    int i = this.tokenizer.getPartMarker();
    this.database.schemaManager.checkUserViewNotExists(this.session, str, localHsqlName1.name);
    HsqlNameManager.HsqlName localHsqlName2 = this.database.nameManager.newHsqlName(str, this.tokenizer.wasQuotedIdentifier());
    localHsqlName2.schema = localHsqlName1;
    HsqlNameManager.HsqlName[] arrayOfHsqlName = null;
    if (this.tokenizer.isGetThis("("))
      try
      {
        HsqlArrayList localHsqlArrayList = Parser.getColumnNames(this.database, null, this.tokenizer, true);
        arrayOfHsqlName = new HsqlNameManager.HsqlName[localHsqlArrayList.size()];
        arrayOfHsqlName = (HsqlNameManager.HsqlName[])localHsqlArrayList.toArray(arrayOfHsqlName);
        if (this.database.isStoredFileAccess())
          for (j = 0; j < arrayOfHsqlName.length; j++)
          {
            if (arrayOfHsqlName[j].isNameQuoted)
              continue;
            arrayOfHsqlName = null;
            break;
          }
      }
      catch (HsqlException localHsqlException)
      {
        if (this.database.isStoredFileAccess())
          while (!this.tokenizer.getString().equals(")"));
        throw localHsqlException;
      }
    this.tokenizer.getThis("AS");
    this.tokenizer.setPartMarker();
    Parser localParser = new Parser(this.session, this.database, this.tokenizer);
    int j = localParser.parseOpenBracketsSelect();
    Select localSelect = localParser.parseSelect(j, true, false, true, true);
    if (localSelect.sIntoTable != null)
      throw Trace.error(74, 117);
    localSelect.prepareResult(this.session);
    View localView = new View(this.session, this.database, localHsqlName2, this.tokenizer.getLastPart(), arrayOfHsqlName);
    this.session.commit();
    this.database.schemaManager.linkTable(localView);
    this.tokenizer.setPartMarker(i);
  }

  private void processAlterTableRename(Table paramTable)
    throws HsqlException
  {
    String str1 = paramTable.getSchemaName();
    this.tokenizer.getThis("TO");
    String str2 = this.tokenizer.getName();
    String str3 = this.tokenizer.getLongNameFirst();
    boolean bool = this.tokenizer.wasQuotedIdentifier();
    str3 = str3 == null ? str1 : this.session.getSchemaNameForWrite(str3);
    if (!str1.equals(str3))
      throw Trace.error(227);
    this.database.schemaManager.checkUserTableNotExists(this.session, str2, str1);
    this.session.commit();
    this.session.setScripting(true);
    this.database.schemaManager.renameTable(this.session, paramTable, str2, bool);
  }

  private void processAlter()
    throws HsqlException
  {
    this.session.checkAdmin();
    this.session.checkDDLWrite();
    this.session.setScripting(true);
    String str = this.tokenizer.getSimpleToken();
    switch (Token.get(str))
    {
    case 306:
      processAlterIndex();
      break;
    case 338:
      processAlterSchema();
      break;
    case 324:
      processAlterSequence();
      break;
    case 213:
      processAlterTable();
      break;
    case 223:
      processAlterUser();
      break;
    default:
      throw Trace.error(11, str);
    }
  }

  private void processAlterTable()
    throws HsqlException
  {
    String str1 = this.tokenizer.getName();
    String str2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
    Table localTable = this.database.schemaManager.getUserTable(this.session, str1, str2);
    if (localTable.isView())
      throw Trace.error(55);
    this.session.setScripting(true);
    String str3 = this.tokenizer.getSimpleToken();
    switch (Token.get(str3))
    {
    case 319:
      processAlterTableRename(localTable);
      return;
    case 1:
      HsqlNameManager.HsqlName localHsqlName = null;
      if (this.tokenizer.isGetThis("CONSTRAINT"))
      {
        str3 = this.tokenizer.getName();
        String str4 = this.tokenizer.getLongNameFirst();
        if (str4 != null)
        {
          str4 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
          if (!localTable.getSchemaName().equals(str4))
            throw Trace.error(227, str4);
        }
        localHsqlName = this.database.nameManager.newHsqlName(str3, this.tokenizer.wasQuotedIdentifier());
      }
      str3 = this.tokenizer.getString();
      if ((this.tokenizer.wasQuotedIdentifier()) && (this.tokenizer.wasSimpleName()))
      {
        this.tokenizer.back();
        processAlterTableAddColumn(localTable);
        return;
      }
      if (!this.tokenizer.wasSimpleToken())
        throw Trace.error(11, str3);
      switch (Token.get(str3))
      {
      case 89:
        this.tokenizer.getThis("KEY");
        processAlterTableAddForeignKeyConstraint(localTable, localHsqlName);
        return;
      case 228:
        processAlterTableAddUniqueConstraint(localTable, localHsqlName);
        return;
      case 30:
        processAlterTableAddCheckConstraint(localTable, localHsqlName);
        return;
      case 167:
        this.tokenizer.getThis("KEY");
        processAlterTableAddPrimaryKey(localTable, localHsqlName);
        return;
      default:
        if (localHsqlName != null)
          throw Trace.error(11, str3);
        this.tokenizer.back();
      case 34:
      }
      processAlterTableAddColumn(localTable);
      return;
    case 70:
      str3 = this.tokenizer.getString();
      if ((this.tokenizer.wasQuotedIdentifier()) && (this.tokenizer.wasSimpleName()))
      {
        this.tokenizer.back();
        processAlterTableDropColumn(localTable);
        return;
      }
      if (!this.tokenizer.wasSimpleToken())
        throw Trace.error(11, str3);
      switch (Token.get(str3))
      {
      case 167:
        this.tokenizer.getThis("KEY");
        if (localTable.hasPrimaryKey())
          processAlterTableDropConstraint(localTable, localTable.getPrimaryConstraint().getName().name);
        else
          throw Trace.error(61, 103, new Object[] { "PRIMARY KEY", localTable.getName().name });
        return;
      case 38:
        processAlterTableDropConstraint(localTable);
        return;
      default:
        this.tokenizer.back();
      case 34:
      }
      processAlterTableDropColumn(localTable);
      return;
    case 4:
      this.tokenizer.isGetThis("COLUMN");
      processAlterColumn(localTable);
      return;
    }
    throw Trace.error(11, str3);
  }

  private void processAlterColumn(Table paramTable)
    throws HsqlException
  {
    String str1 = this.tokenizer.getSimpleName();
    int i = paramTable.getColumnNr(str1);
    Column localColumn = paramTable.getColumn(i);
    String str2 = this.tokenizer.getSimpleToken();
    TableWorks localTableWorks;
    int k;
    switch (Token.get(str2))
    {
    case 319:
      this.tokenizer.getThis("TO");
      processAlterColumnRename(paramTable, localColumn);
      return;
    case 70:
      this.tokenizer.getThis("DEFAULT");
      localTableWorks = new TableWorks(this.session, paramTable);
      localTableWorks.setColDefaultExpression(i, null);
      return;
    case 196:
      str2 = this.tokenizer.getSimpleToken();
      if (str2.equals("NOT"))
      {
        this.tokenizer.getThis("NULL");
        localTableWorks = new TableWorks(this.session, paramTable);
        localTableWorks.setColNullability(localColumn, false);
      }
      else if (str2.equals("NULL"))
      {
        localTableWorks = new TableWorks(this.session, paramTable);
        localTableWorks.setColNullability(localColumn, true);
      }
      else if (str2.equals("DEFAULT"))
      {
        localTableWorks = new TableWorks(this.session, paramTable);
        int j = localColumn.getType();
        k = localColumn.getSize();
        int m = localColumn.getScale();
        Expression localExpression = processCreateDefaultExpression(j, k, m);
        localTableWorks.setColDefaultExpression(i, localExpression);
      }
      else
      {
        throw Trace.error(11, str2);
      }
      return;
    case 320:
      this.tokenizer.getThis("WITH");
      long l = this.tokenizer.getBigint();
      k = paramTable.getIdentityColumn();
      if (k == -1)
        throw Trace.error(73);
      paramTable.identitySequence.reset(l);
      return;
    }
    this.tokenizer.back();
    processAlterColumnType(paramTable, localColumn);
  }

  private void processAlterColumnType(Table paramTable, Column paramColumn)
    throws HsqlException
  {
    Column localColumn = processCreateColumn(paramColumn.columnName);
    TableWorks localTableWorks = new TableWorks(this.session, paramTable);
    localTableWorks.reTypeColumn(paramColumn, localColumn);
  }

  private void processAlterColumnRename(Table paramTable, Column paramColumn)
    throws HsqlException
  {
    String str = this.tokenizer.getSimpleName();
    boolean bool = this.tokenizer.wasQuotedIdentifier();
    if (paramTable.findColumn(str) > -1)
      throw Trace.error(27, str);
    paramTable.database.schemaManager.checkColumnIsInView(paramTable, paramColumn.columnName.name);
    this.session.commit();
    this.session.setScripting(true);
    paramTable.renameColumn(paramColumn, str, bool);
  }

  private void processAlterIndex()
    throws HsqlException
  {
    processAlterIndexRename();
  }

  private void processAlterSchema()
    throws HsqlException
  {
    processAlterSchemaRename();
  }

  private void processDrop()
    throws HsqlException
  {
    this.session.checkReadWrite();
    this.session.checkAdmin();
    this.session.setScripting(true);
    String str = this.tokenizer.getSimpleToken();
    boolean bool = false;
    switch (Token.get(str))
    {
    case 306:
      processDropIndex();
      break;
    case 338:
      processDropSchema();
      break;
    case 324:
      processDropSequence();
      break;
    case 224:
      processDropTrigger();
      break;
    case 223:
      processDropUser();
      break;
    case 339:
      this.database.getGranteeManager().dropRole(this.tokenizer.getSimpleName());
      break;
    case 329:
      bool = true;
    case 213:
      processDropTable(bool);
      break;
    default:
      throw Trace.error(11, str);
    }
  }

  private void processGrantOrRevoke(boolean paramBoolean)
    throws HsqlException
  {
    this.session.checkAdmin();
    this.session.checkDDLWrite();
    this.session.setScripting(true);
    int i = 0;
    String str = this.tokenizer.getSimpleToken();
    this.tokenizer.back();
    if (!GranteeManager.validRightString(str))
    {
      processRoleGrantOrRevoke(paramBoolean);
      return;
    }
    do
    {
      str = this.tokenizer.getSimpleToken();
      i |= GranteeManager.getCheckRight(str);
    }
    while (this.tokenizer.isGetThis(","));
    this.tokenizer.getThis("ON");
    Object localObject1 = null;
    if (this.tokenizer.isGetThis("CLASS"))
    {
      localObject1 = this.tokenizer.getSimpleName();
      if (!this.tokenizer.wasQuotedIdentifier())
        throw Trace.error(125);
    }
    else
    {
      str = this.tokenizer.getName();
      localObject2 = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
      Table localTable = this.database.schemaManager.getTable(this.session, str, (String)localObject2);
      localObject1 = localTable.getName();
      this.session.setScripting(true);
    }
    this.tokenizer.getThis(paramBoolean ? "TO" : "FROM");
    str = getUserIdentifier();
    Object localObject2 = this.database.getGranteeManager();
    if (paramBoolean)
      ((GranteeManager)localObject2).grant(str, localObject1, i);
    else
      ((GranteeManager)localObject2).revoke(str, localObject1, i);
  }

  private void processConnect()
    throws HsqlException
  {
    this.tokenizer.getThis("USER");
    String str1 = getUserIdentifier();
    if (this.tokenizer.isGetThis("PASSWORD"))
    {
      String str2 = getPassword();
      User localUser = this.database.getUserManager().getUser(str1, str2);
      this.session.commit();
      this.session.setUser(localUser);
      this.database.logger.logConnectUser(this.session);
    }
    else if (this.session.isProcessingLog)
    {
      this.session.commit();
    }
    else
    {
      this.tokenizer.getThis("PASSWORD");
    }
  }

  private void processSet()
    throws HsqlException
  {
    this.session.setScripting(true);
    String str1 = this.tokenizer.getSimpleToken();
    int i;
    Object localObject1;
    int j;
    switch (Token.get(str1))
    {
    case 316:
      this.session.checkAdmin();
      str1 = this.tokenizer.getSimpleName();
      if (!this.tokenizer.wasQuotedIdentifier())
        throw Trace.error(125);
      HsqlDatabaseProperties localHsqlDatabaseProperties = this.database.getProperties();
      boolean bool1 = localHsqlDatabaseProperties.isBoolean(str1);
      boolean bool2 = localHsqlDatabaseProperties.isIntegral(str1);
      boolean bool4 = localHsqlDatabaseProperties.isString(str1);
      Trace.check((bool1) || (bool2) || (bool4), 33, str1);
      int k = bool2 ? 4 : bool1 ? 16 : 12;
      Object localObject2 = this.tokenizer.getInType(k);
      if (("hsqldb.cache_file_scale".equals(str1)) && ((this.database.logger.hasCache()) || (((Integer)localObject2).intValue() != 8)))
        Trace.throwerror(33, str1);
      localHsqlDatabaseProperties.setDatabaseProperty(str1, localObject2.toString().toLowerCase());
      localHsqlDatabaseProperties.setDatabaseVariables();
      break;
    case 338:
      this.session.setScripting(false);
      this.session.setSchema(this.tokenizer.getSimpleName());
      break;
    case 314:
      this.session.checkDDLWrite();
      this.session.getUser().setPassword(getPassword());
      break;
    case 317:
      this.session.commit();
      this.session.setReadOnly(processTrueOrFalse());
      break;
    case 307:
      this.session.checkAdmin();
      this.session.checkDDLWrite();
      i = this.tokenizer.getInt();
      this.database.logger.setLogSize(i);
      break;
    case 322:
      this.session.checkAdmin();
      this.session.checkDDLWrite();
      this.session.setScripting(false);
      str1 = this.tokenizer.getSimpleToken();
      i = ArrayUtil.find(ScriptWriterBase.LIST_SCRIPT_FORMATS, str1);
      if ((i == 0) || (i == 1) || (i == 3))
        this.database.logger.setScriptType(i);
      else
        throw Trace.error(11, str1);
    case 305:
      this.session.checkAdmin();
      this.session.checkDDLWrite();
      this.database.setIgnoreCase(processTrueOrFalse());
      break;
    case 309:
      this.session.setScripting(false);
      i = this.tokenizer.getInt();
      this.session.setSQLMaxRows(i);
      break;
    case 301:
      this.session.setAutoCommit(processTrueOrFalse());
      break;
    case 213:
      this.session.checkAdmin();
      this.session.checkDDLWrite();
      str1 = this.tokenizer.getName();
      String str2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
      localObject1 = this.database.schemaManager.getTable(this.session, str1, str2);
      str1 = this.tokenizer.getSimpleToken();
      this.session.setScripting(true);
      switch (Token.get(str1))
      {
      default:
        throw Trace.error(11, str1);
      case 326:
        this.session.checkAdmin();
        if (this.tokenizer.isGetThis("HEADER"))
        {
          str1 = this.tokenizer.getString();
          if (!this.tokenizer.wasQuotedIdentifier())
            throw Trace.error(75);
          try
          {
            ((Table)localObject1).setHeader(str1);
          }
          catch (Throwable localThrowable1)
          {
            if ((this.session.isProcessingLog()) || (this.session.isProcessingScript()))
            {
              HsqlException localHsqlException1 = Trace.error(98, localThrowable1.getMessage());
              this.session.addWarning(localHsqlException1);
            }
            else
            {
              if ((localThrowable1 instanceof HsqlException))
                throw ((HsqlException)localThrowable1);
              throw Trace.error(98, localThrowable1.getMessage());
            }
          }
        }
        else if (this.tokenizer.isGetThis("ON"))
        {
          ((Table)localObject1).connect(this.session);
          this.database.setMetaDirty(false);
        }
        else if (this.tokenizer.isGetThis("OFF"))
        {
          ((Table)localObject1).disconnect(this.session);
          this.database.setMetaDirty(false);
        }
        else
        {
          str1 = this.tokenizer.getString();
          if (!this.tokenizer.wasQuotedIdentifier())
            throw Trace.error(75);
          boolean bool3 = false;
          bool3 = this.tokenizer.isGetThis("DESC");
          try
          {
            ((Table)localObject1).setDataSource(this.session, str1, bool3, false);
          }
          catch (Throwable localThrowable2)
          {
            if ((this.session.isProcessingLog()) || (this.session.isProcessingScript()))
            {
              HsqlException localHsqlException2 = Trace.error(98, localThrowable2.getMessage());
              this.session.addWarning(localHsqlException2);
            }
            else
            {
              if ((localThrowable2 instanceof HsqlException))
                throw ((HsqlException)localThrowable2);
              throw Trace.error(98, localThrowable2.getMessage());
            }
          }
        }
        break;
      case 317:
        this.session.checkAdmin();
        ((Table)localObject1).setDataReadOnly(processTrueOrFalse());
        this.database.setMetaDirty(false);
        break;
      case 306:
        this.session.checkAdmin();
        String str4 = (String)this.tokenizer.getInType(12);
        ((Table)localObject1).setIndexRoots(str4);
      }
      break;
    case 318:
      this.session.checkAdmin();
      this.session.checkDDLWrite();
      this.session.setScripting(false);
      this.database.setReferentialIntegrity(processTrueOrFalse());
      break;
    case 303:
      this.session.checkAdmin();
      this.session.checkDDLWrite();
      this.tokenizer.getThis("DEFRAG");
      j = this.tokenizer.getInt();
      this.database.getProperties().setProperty("hsqldb.defrag_limit", j);
      break;
    case 330:
      this.session.checkAdmin();
      this.session.checkDDLWrite();
      j = 0;
      this.tokenizer.getString();
      localObject1 = this.tokenizer.getAsValue();
      if (this.tokenizer.getType() == 4)
        j = ((Integer)localObject1).intValue();
      else if (Boolean.TRUE.equals(localObject1))
        j = this.database.getProperties().getDefaultWriteDelay();
      else if (Boolean.FALSE.equals(localObject1))
        j = 0;
      else
        throw Trace.error(11);
      if (!this.tokenizer.isGetThis("MILLIS"))
        j *= 1000;
      this.database.logger.setWriteDelay(j);
      break;
    case 337:
      this.session.checkAdmin();
      this.session.checkDDLWrite();
      this.tokenizer.getThis("COLLATION");
      String str3 = this.tokenizer.getSimpleName();
      if (!this.tokenizer.wasQuotedIdentifier())
        throw Trace.error(74);
      this.database.collation.setCollation(str3);
      break;
    default:
      throw Trace.error(11, str1);
    }
  }

  private boolean processTrueOrFalse()
    throws HsqlException
  {
    String str = this.tokenizer.getSimpleToken();
    if (str.equals("TRUE"))
      return true;
    if (str.equals("FALSE"))
      return false;
    throw Trace.error(11, str);
  }

  private void processCommit()
    throws HsqlException
  {
    this.tokenizer.isGetThis("WORK");
    this.session.commit();
  }

  private void processRollback()
    throws HsqlException
  {
    String str = this.tokenizer.getSimpleToken();
    int i = 0;
    if (!str.equals("WORK"))
      if (str.equals("TO"))
      {
        this.tokenizer.getThis("SAVEPOINT");
        str = this.tokenizer.getSimpleName();
        i = 1;
      }
      else
      {
        this.tokenizer.back();
      }
    if (i != 0)
      this.session.rollbackToSavepoint(str);
    else
      this.session.rollback();
  }

  private void processSavepoint()
    throws HsqlException
  {
    String str = this.tokenizer.getSimpleName();
    this.session.savepoint(str);
  }

  private void processShutdown()
    throws HsqlException
  {
    if (!this.session.isClosed())
      this.session.checkAdmin();
    int i = 0;
    String str = this.tokenizer.getSimpleToken();
    if (str.equals("IMMEDIATELY"))
      i = -1;
    else if (str.equals("COMPACT"))
      i = 1;
    else if (str.equals("SCRIPT"))
      i = 2;
    else if ((!str.equals(";")) && (str.length() != 0))
      throw Trace.error(11, str);
    this.database.close(i);
  }

  private void processCheckpoint()
    throws HsqlException
  {
    this.session.checkAdmin();
    this.session.checkDDLWrite();
    boolean bool = false;
    String str = this.tokenizer.getSimpleToken();
    if (str.equals("DEFRAG"))
      bool = true;
    else if ((!str.equals(";")) && (str.length() != 0))
      throw Trace.error(11, str);
    this.database.logger.checkpoint(bool);
  }

  private HsqlNameManager.HsqlName newIndexHsqlName(String paramString, boolean paramBoolean)
    throws HsqlException
  {
    return HsqlNameManager.HsqlName.isReservedName(paramString) ? this.database.nameManager.newAutoName("USER", paramString) : this.database.nameManager.newHsqlName(paramString, paramBoolean);
  }

  private Table newTable(int paramInt, String paramString, boolean paramBoolean, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    HsqlNameManager.HsqlName localHsqlName = this.database.nameManager.newHsqlName(paramString, paramBoolean);
    localHsqlName.schema = paramHsqlName;
    switch (paramInt)
    {
    case 5:
    case 6:
      return new TextTable(this.database, localHsqlName, paramInt);
    }
    return new Table(this.database, localHsqlName, paramInt);
  }

  private void checkAddColumn(Table paramTable, Column paramColumn)
    throws HsqlException
  {
    int i = 1;
    if (paramTable.findColumn(paramColumn.columnName.name) != -1)
      throw Trace.error(27, paramColumn.columnName.name);
    if ((paramColumn.isPrimaryKey()) && (paramTable.hasPrimaryKey()))
      i = 0;
    if ((i != 0) && (!paramTable.isEmpty(this.session)))
      i = (paramColumn.isNullable()) || (paramColumn.getDefaultExpression() != null) ? 1 : 0;
    if (i == 0)
      throw Trace.error(58);
  }

  private void checkFKColumnDefaults(Table paramTable, Constraint paramConstraint)
    throws HsqlException
  {
    int i = paramConstraint.core.updateAction == 4 ? 1 : 0;
    i = (i != 0) || (paramConstraint.core.deleteAction == 4) ? 1 : 0;
    if (i != 0)
    {
      int[] arrayOfInt = paramConstraint.core.mainColArray;
      for (int j = 0; j < arrayOfInt.length; j++)
      {
        Column localColumn = paramTable.getColumn(arrayOfInt[j]);
        Expression localExpression = localColumn.getDefaultExpression();
        if (localExpression != null)
          continue;
        String str = localColumn.columnName.name;
        throw Trace.error(105, new Object[] { str });
      }
    }
  }

  private void processAlterSequence()
    throws HsqlException
  {
    String str1 = this.tokenizer.getName();
    String str2 = this.tokenizer.getLongNameFirst();
    str2 = this.session.getSchemaNameForWrite(str2);
    this.tokenizer.getThis("RESTART");
    this.tokenizer.getThis("WITH");
    long l = this.tokenizer.getBigint();
    NumberSequence localNumberSequence = this.database.schemaManager.getSequence(str1, str2);
    localNumberSequence.reset(l);
  }

  private void processAlterIndexRename()
    throws HsqlException
  {
    String str1 = this.tokenizer.getName();
    String str2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
    this.tokenizer.getThis("RENAME");
    this.tokenizer.getThis("TO");
    String str3 = this.tokenizer.getName();
    String str4 = this.tokenizer.getLongNameFirst();
    str4 = str4 == null ? str2 : this.session.getSchemaNameForWrite(str4);
    boolean bool = this.tokenizer.wasQuotedIdentifier();
    if (!str2.equals(str4))
      throw Trace.error(227);
    Table localTable = this.database.schemaManager.findUserTableForIndex(this.session, str1, str2);
    if (localTable == null)
      throw Trace.error(26, str1);
    this.database.schemaManager.checkIndexExists(str1, localTable.getSchemaName(), true);
    if (HsqlNameManager.HsqlName.isReservedName(str1))
      throw Trace.error(56, str1);
    if (HsqlNameManager.HsqlName.isReservedName(str3))
      throw Trace.error(49, str3);
    this.session.setScripting(true);
    this.session.commit();
    localTable.getIndex(str1).setName(str3, bool);
    this.database.schemaManager.renameIndex(str1, str3, localTable.getName());
  }

  private void processAlterSchemaRename()
    throws HsqlException
  {
    String str1 = this.tokenizer.getSimpleName();
    this.tokenizer.getThis("RENAME");
    this.tokenizer.getThis("TO");
    String str2 = this.tokenizer.getSimpleName();
    boolean bool = this.tokenizer.wasQuotedIdentifier();
    this.database.schemaManager.renameSchema(str1, str2, bool);
  }

  private void processAlterTableAddColumn(Table paramTable)
    throws HsqlException
  {
    int i = paramTable.getColumnCount();
    Column localColumn = processCreateColumn();
    checkAddColumn(paramTable, localColumn);
    if (this.tokenizer.isGetThis("BEFORE"))
    {
      String str = this.tokenizer.getSimpleName();
      i = paramTable.getColumnNr(str);
    }
    this.session.commit();
    TableWorks localTableWorks = new TableWorks(this.session, paramTable);
    localTableWorks.addColumn(localColumn, i);
  }

  private void processAlterTableDropColumn(Table paramTable)
    throws HsqlException
  {
    String str = this.tokenizer.getName();
    int i = paramTable.getColumnNr(str);
    this.session.commit();
    TableWorks localTableWorks = new TableWorks(this.session, paramTable);
    localTableWorks.dropColumn(i);
  }

  private void processAlterTableDropConstraint(Table paramTable)
    throws HsqlException
  {
    processAlterTableDropConstraint(paramTable, this.tokenizer.getName());
  }

  private void processAlterTableDropConstraint(Table paramTable, String paramString)
    throws HsqlException
  {
    this.session.commit();
    TableWorks localTableWorks = new TableWorks(this.session, paramTable);
    localTableWorks.dropConstraint(paramString);
  }

  private void processCreateAlias()
    throws HsqlException
  {
    String str1;
    try
    {
      str1 = this.tokenizer.getSimpleName();
    }
    catch (HsqlException localHsqlException)
    {
      if (this.session.isProcessingScript())
        str1 = null;
      else
        throw localHsqlException;
    }
    this.tokenizer.getThis("FOR");
    String str2 = upgradeMethodFQN(this.tokenizer.getSimpleName());
    if (str1 != null)
      this.database.getAliasMap().put(str1, str2);
  }

  private void processCreateIndex(boolean paramBoolean)
    throws HsqlException
  {
    String str1 = this.tokenizer.getName();
    String str2 = this.tokenizer.getLongNameFirst();
    boolean bool = this.tokenizer.wasQuotedIdentifier();
    this.tokenizer.getThis("ON");
    String str3 = this.tokenizer.getName();
    String str4 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
    if ((str2 != null) && (!str2.equals(str4)))
      throw Trace.error(227);
    Table localTable = this.database.schemaManager.getTable(this.session, str3, str4);
    this.database.schemaManager.checkIndexExists(str1, localTable.getSchemaName(), false);
    HsqlNameManager.HsqlName localHsqlName = newIndexHsqlName(str1, bool);
    int[] arrayOfInt = processColumnList(localTable, true);
    String str5 = this.tokenizer.getSimpleToken();
    if ((!"DESC".equals(str5)) && (!"ASC".equals(str5)))
      this.tokenizer.back();
    this.session.commit();
    this.session.setScripting(true);
    TableWorks localTableWorks = new TableWorks(this.session, localTable);
    localTableWorks.createIndex(arrayOfInt, localHsqlName, paramBoolean, false, false);
  }

  private void processCreateSequence()
    throws HsqlException
  {
    int i = 4;
    long l1 = 1L;
    long l2 = 0L;
    String str = this.tokenizer.getName();
    boolean bool = this.tokenizer.wasQuotedIdentifier();
    HsqlNameManager.HsqlName localHsqlName = this.session.getSchemaHsqlNameForWrite(this.tokenizer.getLongNameFirst());
    if (this.tokenizer.isGetThis("AS"))
    {
      localObject = this.tokenizer.getSimpleToken();
      i = Types.getTypeNr((String)localObject);
      Trace.check((i == 4) || (i == -5), 16);
    }
    if (this.tokenizer.isGetThis("START"))
    {
      this.tokenizer.getThis("WITH");
      l2 = this.tokenizer.getBigint();
    }
    if (this.tokenizer.isGetThis("INCREMENT"))
    {
      this.tokenizer.getThis("BY");
      l1 = this.tokenizer.getBigint();
    }
    Object localObject = this.database.nameManager.newHsqlName(str, bool);
    ((HsqlNameManager.HsqlName)localObject).schema = localHsqlName;
    this.database.schemaManager.createSequence((HsqlNameManager.HsqlName)localObject, l2, l1, i);
  }

  private void processCreateSchema()
    throws HsqlException
  {
    String str = this.tokenizer.getSimpleName();
    boolean bool = this.tokenizer.wasQuotedIdentifier();
    if (this.session.isSchemaDefintion())
      throw Trace.error(74);
    this.tokenizer.getThis("AUTHORIZATION");
    this.tokenizer.getThis("DBA");
    if (this.database.schemaManager.schemaExists(str))
    {
      if (!this.session.isProcessingScript)
        throw Trace.error(227);
    }
    else
      this.database.schemaManager.createSchema(str, bool);
    HsqlNameManager.HsqlName localHsqlName = this.database.schemaManager.getSchemaHsqlName(str);
    this.database.logger.writeToLog(this.session, DatabaseScript.getSchemaCreateDDL(this.database, localHsqlName));
    this.database.logger.writeToLog(this.session, "SET SCHEMA " + localHsqlName.statementName);
    this.session.startSchemaDefinition(str);
    this.session.loggedSchema = this.session.currentSchema;
  }

  private void processCreateUser()
    throws HsqlException
  {
    String str1 = getUserIdentifier();
    this.tokenizer.getThis("PASSWORD");
    String str2 = getPassword();
    boolean bool = this.tokenizer.isGetThis("ADMIN");
    this.database.getUserManager().createUser(str1, str2);
    if (bool)
      this.database.getGranteeManager().grant(str1, "DBA");
  }

  private void processDisconnect()
    throws HsqlException
  {
    this.session.close();
  }

  private void processDropTable(boolean paramBoolean)
    throws HsqlException
  {
    boolean bool1 = false;
    boolean bool2 = false;
    if (this.tokenizer.isGetThis("IF"))
    {
      this.tokenizer.getThis("EXISTS");
      bool1 = true;
    }
    String str1 = this.tokenizer.getName();
    String str2 = this.tokenizer.getLongNameFirst();
    if (this.tokenizer.isGetThis("IF"))
    {
      this.tokenizer.getThis("EXISTS");
      bool1 = true;
    }
    bool2 = this.tokenizer.isGetThis("CASCADE");
    if (!bool2)
      this.tokenizer.isGetThis("RESTRICT");
    if ((bool1) && (str2 != null) && (!this.database.schemaManager.schemaExists(str2)))
      return;
    str2 = this.session.getSchemaNameForWrite(str2);
    this.database.schemaManager.dropTable(this.session, str1, str2, bool1, paramBoolean, bool2);
  }

  private void processDropUser()
    throws HsqlException
  {
    this.session.checkAdmin();
    this.session.checkDDLWrite();
    String str = getPassword();
    if (this.database.getSessionManager().isUserActive(str))
      throw Trace.error(33);
    this.database.getUserManager().dropUser(str);
  }

  private void processDropSequence()
    throws HsqlException
  {
    int i = 0;
    this.session.checkAdmin();
    this.session.checkDDLWrite();
    String str1 = this.tokenizer.getName();
    String str2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
    if (this.tokenizer.isGetThis("IF"))
    {
      this.tokenizer.getThis("EXISTS");
      i = 1;
    }
    boolean bool = this.tokenizer.isGetThis("CASCADE");
    if (!bool)
      this.tokenizer.isGetThis("RESTRICT");
    NumberSequence localNumberSequence = this.database.schemaManager.findSequence(str1, str2);
    if (localNumberSequence == null)
    {
      if (i != 0)
        return;
      throw Trace.error(191);
    }
    this.database.schemaManager.checkCascadeDropViews(localNumberSequence, bool);
    this.database.schemaManager.dropSequence(localNumberSequence);
  }

  private void processDropTrigger()
    throws HsqlException
  {
    this.session.checkAdmin();
    this.session.checkDDLWrite();
    String str1 = this.tokenizer.getName();
    String str2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
    this.database.schemaManager.dropTrigger(this.session, str1, str2);
  }

  private void processDropIndex()
    throws HsqlException
  {
    String str1 = this.tokenizer.getName();
    String str2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
    boolean bool = false;
    if (this.tokenizer.isGetThis("ON"))
      this.tokenizer.getName();
    if (this.tokenizer.isGetThis("IF"))
    {
      this.tokenizer.getThis("EXISTS");
      bool = true;
    }
    this.session.checkAdmin();
    this.session.checkDDLWrite();
    this.database.schemaManager.dropIndex(this.session, str1, str2, bool);
  }

  private void processDropSchema()
    throws HsqlException
  {
    String str = this.tokenizer.getSimpleName();
    boolean bool = this.tokenizer.isGetThis("CASCADE");
    if (!bool)
      this.tokenizer.isGetThis("RESTRICT");
    processDropSchema(str, bool);
  }

  private void processDropSchema(String paramString, boolean paramBoolean)
    throws HsqlException
  {
    if (!this.database.schemaManager.schemaExists(paramString))
      throw Trace.error(227);
    this.database.schemaManager.dropSchema(paramString, paramBoolean);
    if (paramString.equals(this.session.getSchemaName(null)))
      this.session.setSchema(this.database.schemaManager.getDefaultSchemaName());
  }

  private Result processExplainPlan()
    throws IOException, HsqlException
  {
    this.tokenizer.getThis("PLAN");
    this.tokenizer.getThis("FOR");
    Parser localParser = new Parser(this.session, this.database, this.tokenizer);
    String str1 = this.tokenizer.getSimpleToken();
    int i = Token.get(str1);
    Result localResult = Result.newSingleColumnResult("OPERATION", 12);
    int j = 0;
    CompiledStatement localCompiledStatement;
    switch (i)
    {
    case 313:
      j = localParser.parseOpenBracketsSelect() + 1;
    case 193:
      localCompiledStatement = localParser.compileSelectStatement(j);
      break;
    case 112:
      localCompiledStatement = localParser.compileInsertStatement();
      break;
    case 222:
      localCompiledStatement = localParser.compileUpdateStatement();
      break;
    case 62:
      localCompiledStatement = localParser.compileDeleteStatement();
      break;
    case 23:
      localCompiledStatement = localParser.compileCallStatement();
      break;
    default:
      return localResult;
    }
    LineNumberReader localLineNumberReader = new LineNumberReader(new StringReader(localCompiledStatement.describe(this.session)));
    String str2;
    while (null != (str2 = localLineNumberReader.readLine()))
      localResult.add(new Object[] { str2 });
    return localResult;
  }

  private static String upgradeMethodFQN(String paramString)
  {
    if (paramString.startsWith("org.hsql.Library."))
      paramString = "org.hsqldb.Library." + paramString.substring(oldLibLen);
    else if (paramString.equals("java.lang.Math.abs"))
      paramString = "org.hsqldb.Library.abs";
    return paramString;
  }

  Result processSelectInto(Result paramResult, HsqlNameManager.HsqlName paramHsqlName, int paramInt)
    throws HsqlException
  {
    int i = paramResult.getColumnCount();
    for (int j = 0; j < i; j++)
    {
      if (paramResult.metaData.colLabels[j].length() != 0)
        continue;
      throw Trace.error(45);
    }
    Table localTable = paramInt == 6 ? new TextTable(this.database, paramHsqlName, paramInt) : new Table(this.database, paramHsqlName, paramInt);
    localTable.addColumns(paramResult.metaData, paramResult.getColumnCount());
    localTable.createPrimaryKey();
    this.database.schemaManager.linkTable(localTable);
    if (paramInt == 6)
    {
      try
      {
        String str = StringUtil.toLowerSubset(paramHsqlName.name, '_') + ".csv";
        localTable.setDataSource(this.session, str, false, true);
        logTableDDL(localTable);
        localTable.insertIntoTable(this.session, paramResult);
      }
      catch (HsqlException localHsqlException)
      {
        this.database.schemaManager.dropTable(this.session, paramHsqlName.name, null, false, false, false);
        throw localHsqlException;
      }
    }
    else
    {
      logTableDDL(localTable);
      localTable.insertIntoTable(this.session, paramResult);
    }
    Result localResult = new Result(1);
    localResult.updateCount = paramResult.getSize();
    return localResult;
  }

  private void logTableDDL(Table paramTable)
    throws HsqlException
  {
    StringBuffer localStringBuffer = new StringBuffer();
    DatabaseScript.getTableDDL(this.database, paramTable, 0, null, true, localStringBuffer);
    String str = DatabaseScript.getDataSource(paramTable);
    this.database.logger.writeToLog(this.session, localStringBuffer.toString());
    if (str != null)
      this.database.logger.writeToLog(this.session, str);
  }

  private void processAlterTableAddUniqueConstraint(Table paramTable, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    int[] arrayOfInt = processColumnList(paramTable, false);
    if (paramHsqlName == null)
      paramHsqlName = this.database.nameManager.newAutoName("CT");
    this.session.commit();
    TableWorks localTableWorks = new TableWorks(this.session, paramTable);
    localTableWorks.createUniqueConstraint(arrayOfInt, paramHsqlName);
  }

  private void processAlterTableAddForeignKeyConstraint(Table paramTable, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    if (paramHsqlName == null)
      paramHsqlName = this.database.nameManager.newAutoName("FK");
    Constraint localConstraint = processCreateFK(paramTable, paramHsqlName);
    checkFKColumnDefaults(paramTable, localConstraint);
    paramTable.checkColumnsMatch(localConstraint.core.mainColArray, localConstraint.core.refTable, localConstraint.core.refColArray);
    this.session.commit();
    TableWorks localTableWorks = new TableWorks(this.session, paramTable);
    localTableWorks.createForeignKey(localConstraint.core.mainColArray, localConstraint.core.refColArray, localConstraint.constName, localConstraint.core.refTable, localConstraint.core.deleteAction, localConstraint.core.updateAction);
  }

  private void processAlterTableAddCheckConstraint(Table paramTable, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    if (paramHsqlName == null)
      paramHsqlName = this.database.nameManager.newAutoName("CT");
    Constraint localConstraint = new Constraint(paramHsqlName, null, null, null, 3, 3, 3);
    processCreateCheckConstraintCondition(localConstraint);
    this.session.commit();
    TableWorks localTableWorks = new TableWorks(this.session, paramTable);
    localTableWorks.createCheckConstraint(localConstraint, paramHsqlName);
  }

  private void processAlterTableAddPrimaryKey(Table paramTable, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    int[] arrayOfInt = processColumnList(paramTable, false);
    this.session.commit();
    TableWorks localTableWorks = new TableWorks(this.session, paramTable);
    localTableWorks.addPrimaryKey(arrayOfInt, paramHsqlName);
  }

  private void processReleaseSavepoint()
    throws HsqlException
  {
    this.tokenizer.getThis("SAVEPOINT");
    String str = this.tokenizer.getSimpleName();
    this.session.releaseSavepoint(str);
  }

  private void processAlterUser()
    throws HsqlException
  {
    String str1 = getUserIdentifier();
    User localUser = (User)this.database.getUserManager().getUsers().get(str1);
    Trace.check(localUser != null, 37, str1);
    this.tokenizer.getThis("SET");
    this.tokenizer.getThis("PASSWORD");
    String str2 = getPassword();
    localUser.setPassword(str2);
    this.database.logger.writeToLog(this.session, localUser.getAlterUserDDL());
    this.session.setScripting(false);
  }

  private String getUserIdentifier()
    throws HsqlException
  {
    String str = this.tokenizer.getString();
    Tokenizer localTokenizer = new Tokenizer(str);
    return localTokenizer.getSimpleName();
  }

  private String getPassword()
    throws HsqlException
  {
    String str = this.tokenizer.getString();
    return str.toUpperCase(Locale.ENGLISH);
  }

  private void processRoleGrantOrRevoke(boolean paramBoolean)
    throws HsqlException
  {
    HsqlArrayList localHsqlArrayList = new HsqlArrayList();
    GranteeManager localGranteeManager1 = this.database.getGranteeManager();
    do
    {
      String str2 = this.tokenizer.getSimpleToken();
      Trace.check(localGranteeManager1.isRole(str2), paramBoolean ? 229 : 230);
      localHsqlArrayList.add(str2);
    }
    while (this.tokenizer.isGetThis(","));
    this.tokenizer.getThis(paramBoolean ? "TO" : "FROM");
    String str1 = getUserIdentifier();
    GranteeManager localGranteeManager2 = this.database.getGranteeManager();
    for (int i = 0; i < localHsqlArrayList.size(); i++)
      if (paramBoolean)
        localGranteeManager2.grant(str1, (String)localHsqlArrayList.get(i));
      else
        localGranteeManager2.revoke(str1, (String)localHsqlArrayList.get(i));
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.DatabaseCommandInterpreter
 * JD-Core Version:    0.6.0
 */