package org.hsqldb;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.Logger;

public class Database
{
  int databaseID;
  String sType;
  String sName;
  private HsqlProperties urlProperties;
  private String sPath;
  DatabaseInformation dbInfo;
  ClassLoader classLoader;
  private int dbState;
  public Logger logger;
  boolean databaseReadOnly;
  private boolean filesReadOnly;
  private boolean filesInJar;
  public boolean sqlEnforceStrictSize;
  public int firstIdentity;
  private boolean bIgnoreCase;
  private boolean bReferentialIntegrity;
  private HsqlDatabaseProperties databaseProperties;
  private boolean shutdownOnNoConnection;
  private HashMap hAlias;
  public UserManager userManager;
  public GranteeManager granteeManager;
  public HsqlNameManager nameManager;
  public SessionManager sessionManager;
  public TransactionManager txManager;
  CompiledStatementManager compiledStatementManager;
  public SchemaManager schemaManager;
  public Collation collation;
  public static final int DATABASE_ONLINE = 1;
  public static final int DATABASE_OPENING = 4;
  public static final int DATABASE_CLOSING = 8;
  public static final int DATABASE_SHUTDOWN = 16;
  public static final int CLOSEMODE_IMMEDIATELY = -1;
  public static final int CLOSEMODE_NORMAL = 0;
  public static final int CLOSEMODE_COMPACT = 1;
  public static final int CLOSEMODE_SCRIPT = 2;
  private FileAccess fileaccess;
  private boolean isStoredFileAccess;

  Database(String paramString1, String paramString2, String paramString3, HsqlProperties paramHsqlProperties)
    throws HsqlException
  {
    this.urlProperties = paramHsqlProperties;
    setState(16);
    this.sName = paramString3;
    this.sType = paramString1;
    this.sPath = paramString2;
    if (this.sType == "res:")
    {
      this.filesInJar = true;
      this.filesReadOnly = true;
    }
    try
    {
      this.classLoader = getClass().getClassLoader();
    }
    catch (Exception localException1)
    {
      this.classLoader = null;
    }
    String str1 = this.urlProperties.getProperty("fileaccess_class_name");
    if (str1 != null)
    {
      String str2 = this.urlProperties.getProperty("storage_key");
      try
      {
        Class localClass = Class.forName(str1);
        Constructor localConstructor = localClass.getConstructor(new Class[] { Object.class });
        this.fileaccess = ((FileAccess)localConstructor.newInstance(new Object[] { str2 }));
        this.isStoredFileAccess = true;
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        System.out.println("ClassNotFoundException");
      }
      catch (InstantiationException localInstantiationException)
      {
        System.out.println("InstantiationException");
      }
      catch (IllegalAccessException localIllegalAccessException)
      {
        System.out.println("IllegalAccessException");
      }
      catch (Exception localException2)
      {
        System.out.println("Exception");
      }
    }
    else
    {
      this.fileaccess = FileUtil.getDefaultInstance();
    }
    this.shutdownOnNoConnection = this.urlProperties.getProperty("shutdown", "false").equals("true");
    this.logger = new Logger();
    this.compiledStatementManager = new CompiledStatementManager(this);
  }

  synchronized void open()
    throws HsqlException
  {
    if (!isShutdown())
      return;
    reopen();
  }

  void reopen()
    throws HsqlException
  {
    setState(4);
    try
    {
      this.databaseProperties = new HsqlDatabaseProperties(this);
      int i = (!DatabaseURL.isFileBasedDatabaseType(this.sType)) || (!this.databaseProperties.checkFileExists()) ? 1 : 0;
      if ((i != 0) && (this.urlProperties.isPropertyTrue("ifexists")))
        throw Trace.error(94, this.sName);
      this.databaseProperties.load();
      this.databaseProperties.setURLProperties(this.urlProperties);
      this.compiledStatementManager.reset();
      this.nameManager = new HsqlNameManager();
      this.granteeManager = new GranteeManager(this);
      this.userManager = new UserManager(this);
      this.hAlias = Library.getAliasMap();
      this.schemaManager = new SchemaManager(this);
      this.bReferentialIntegrity = true;
      this.sessionManager = new SessionManager(this);
      this.txManager = new TransactionManager(this);
      this.collation = new Collation();
      this.dbInfo = DatabaseInformation.newDatabaseInformation(this);
      this.databaseProperties.setDatabaseVariables();
      if (DatabaseURL.isFileBasedDatabaseType(this.sType))
        this.logger.openLog(this);
      if (i != 0)
      {
        this.sessionManager.getSysSession().sqlExecuteDirectNoPreChecks("CREATE USER SA PASSWORD \"\" ADMIN");
        this.logger.synchLogForce();
      }
      this.dbInfo.setWithContent(true);
    }
    catch (Throwable localHsqlException)
    {
      this.logger.closeLog(-1);
      this.logger.releaseLock();
      setState(16);
      clearStructures();
      DatabaseManager.removeDatabase(this);
      HsqlException localHsqlException;
      if (!(localThrowable instanceof HsqlException))
        localHsqlException = Trace.error(40, localThrowable.toString());
      throw ((HsqlException)localHsqlException);
    }
    setState(1);
  }

  void clearStructures()
  {
    if (this.schemaManager != null)
      this.schemaManager.clearStructures();
    this.granteeManager = null;
    this.userManager = null;
    this.hAlias = null;
    this.nameManager = null;
    this.schemaManager = null;
    this.sessionManager = null;
    this.dbInfo = null;
  }

  public String getType()
  {
    return this.sType;
  }

  public String getPath()
  {
    return this.sPath;
  }

  public HsqlDatabaseProperties getProperties()
  {
    return this.databaseProperties;
  }

  public SessionManager getSessionManager()
  {
    return this.sessionManager;
  }

  synchronized boolean isShutdown()
  {
    return this.dbState == 16;
  }

  synchronized Session connect(String paramString1, String paramString2)
    throws HsqlException
  {
    User localUser = this.userManager.getUser(paramString1, paramString2);
    Session localSession = this.sessionManager.newSession(this, localUser, this.databaseReadOnly, false);
    this.logger.logConnectUser(localSession);
    return localSession;
  }

  public void setReadOnly()
  {
    this.databaseReadOnly = true;
    this.filesReadOnly = true;
  }

  public void setFilesReadOnly()
  {
    this.filesReadOnly = true;
  }

  public boolean isFilesReadOnly()
  {
    return this.filesReadOnly;
  }

  public boolean isFilesInJar()
  {
    return this.filesInJar;
  }

  UserManager getUserManager()
  {
    return this.userManager;
  }

  GranteeManager getGranteeManager()
  {
    return this.granteeManager;
  }

  public void setReferentialIntegrity(boolean paramBoolean)
  {
    this.bReferentialIntegrity = paramBoolean;
  }

  boolean isReferentialIntegrity()
  {
    return this.bReferentialIntegrity;
  }

  HashMap getAliasMap()
  {
    return this.hAlias;
  }

  String getJavaName(String paramString)
  {
    String str = (String)this.hAlias.get(paramString);
    return str == null ? paramString : str;
  }

  void setIgnoreCase(boolean paramBoolean)
  {
    this.bIgnoreCase = paramBoolean;
  }

  boolean isIgnoreCase()
  {
    return this.bIgnoreCase;
  }

  int getDefaultTableType()
  {
    String str = getProperties().getProperty("hsqldb.default_table_type");
    return "CACHED".equalsIgnoreCase(str) ? 4 : 3;
  }

  protected void finalize()
  {
    if (getState() != 1)
      return;
    try
    {
      close(-1);
    }
    catch (HsqlException localHsqlException)
    {
    }
  }

  void closeIfLast()
  {
    if ((this.shutdownOnNoConnection) && (this.sessionManager.isEmpty()) && (this.dbState == 1))
      try
      {
        close(0);
      }
      catch (HsqlException localHsqlException)
      {
      }
  }

  void close(int paramInt)
    throws HsqlException
  {
    HsqlException localHsqlException = null;
    setState(8);
    this.sessionManager.closeAllSessions();
    this.sessionManager.clearAll();
    if (this.filesReadOnly)
      paramInt = -1;
    this.logger.closeLog(paramInt);
    try
    {
      if (paramInt == 1)
      {
        clearStructures();
        reopen();
        setState(8);
        this.logger.closeLog(0);
      }
    }
    catch (Throwable localThrowable)
    {
      if ((localThrowable instanceof HsqlException))
        localHsqlException = (HsqlException)localThrowable;
      else
        localHsqlException = Trace.error(40, localThrowable.toString());
    }
    this.classLoader = null;
    this.logger.releaseLock();
    setState(16);
    clearStructures();
    DatabaseManager.removeDatabase(this);
    if (localHsqlException != null)
      throw localHsqlException;
  }

  public void setMetaDirty(boolean paramBoolean)
  {
    if (this.dbInfo != null)
      this.dbInfo.setDirty();
    if (paramBoolean)
      this.compiledStatementManager.resetStatements();
  }

  private synchronized void setState(int paramInt)
  {
    this.dbState = paramInt;
  }

  synchronized int getState()
  {
    return this.dbState;
  }

  String getStateString()
  {
    int i = getState();
    switch (i)
    {
    case 8:
      return "DATABASE_CLOSING";
    case 1:
      return "DATABASE_ONLINE";
    case 4:
      return "DATABASE_OPENING";
    case 16:
      return "DATABASE_SHUTDOWN";
    }
    return "UNKNOWN";
  }

  public String getURI()
  {
    return this.sName;
  }

  public HsqlProperties getURLProperties()
  {
    return this.urlProperties;
  }

  public synchronized FileAccess getFileAccess()
  {
    return this.fileaccess;
  }

  public synchronized boolean isStoredFileAccess()
  {
    return this.isStoredFileAccess;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Database
 * JD-Core Version:    0.6.0
 */