package org.hsqldb;

import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.Iterator;

class Constraint
{
  static final int CASCADE = 0;
  static final int SET_NULL = 2;
  static final int NO_ACTION = 3;
  static final int SET_DEFAULT = 4;
  static final int INIT_DEFERRED = 5;
  static final int INIT_IMMEDIATE = 6;
  static final int NOT_DEFERRABLE = 7;
  static final int FOREIGN_KEY = 0;
  static final int MAIN = 1;
  static final int UNIQUE = 2;
  static final int CHECK = 3;
  static final int PRIMARY_KEY = 4;
  ConstraintCore core;
  HsqlNameManager.HsqlName constName;
  int constType;

  Constraint(HsqlNameManager.HsqlName paramHsqlName, Table paramTable, Index paramIndex, int paramInt)
  {
    this.core = new ConstraintCore();
    this.constName = paramHsqlName;
    this.constType = paramInt;
    this.core.mainTable = paramTable;
    this.core.mainIndex = paramIndex;
    this.core.mainColArray = ArrayUtil.arraySlice(paramIndex.getColumns(), 0, paramIndex.getVisibleColumns());
    this.core.colLen = this.core.mainColArray.length;
  }

  Constraint(HsqlNameManager.HsqlName paramHsqlName, Constraint paramConstraint)
  {
    this.constName = paramHsqlName;
    this.constType = 1;
    this.core = paramConstraint.core;
  }

  Constraint(HsqlNameManager.HsqlName paramHsqlName1, HsqlNameManager.HsqlName paramHsqlName2, Table paramTable1, Table paramTable2, int[] paramArrayOfInt1, int[] paramArrayOfInt2, Index paramIndex1, Index paramIndex2, int paramInt1, int paramInt2)
    throws HsqlException
  {
    this.core = new ConstraintCore();
    this.core.pkName = paramHsqlName1;
    this.core.fkName = paramHsqlName2;
    this.constName = paramHsqlName2;
    this.constType = 0;
    this.core.mainTable = paramTable1;
    this.core.refTable = paramTable2;
    this.core.mainColArray = paramArrayOfInt1;
    this.core.colLen = this.core.mainColArray.length;
    this.core.refColArray = paramArrayOfInt2;
    this.core.mainIndex = paramIndex1;
    this.core.refIndex = paramIndex2;
    this.core.deleteAction = paramInt1;
    this.core.updateAction = paramInt2;
  }

  Constraint(HsqlNameManager.HsqlName paramHsqlName, int[] paramArrayOfInt1, Table paramTable, int[] paramArrayOfInt2, int paramInt1, int paramInt2, int paramInt3)
  {
    this.core = new ConstraintCore();
    this.constName = paramHsqlName;
    this.constType = paramInt1;
    this.core.mainColArray = paramArrayOfInt1;
    this.core.refTable = paramTable;
    this.core.refColArray = paramArrayOfInt2;
    this.core.deleteAction = paramInt2;
    this.core.updateAction = paramInt3;
  }

  private Constraint()
  {
  }

  HsqlNameManager.HsqlName getName()
  {
    return this.constName;
  }

  private void setName(String paramString, boolean paramBoolean)
    throws HsqlException
  {
    this.constName.rename(paramString, paramBoolean);
  }

  String getPkName()
  {
    return this.core.pkName == null ? null : this.core.pkName.name;
  }

  String getFkName()
  {
    return this.core.fkName == null ? null : this.core.fkName.name;
  }

  int getType()
  {
    return this.constType;
  }

  Table getMain()
  {
    return this.core.mainTable;
  }

  Index getMainIndex()
  {
    return this.core.mainIndex;
  }

  Table getRef()
  {
    return this.core.refTable;
  }

  Index getRefIndex()
  {
    return this.core.refIndex;
  }

  int getDeleteAction()
  {
    return this.core.deleteAction;
  }

  int getUpdateAction()
  {
    return this.core.updateAction;
  }

  int[] getMainColumns()
  {
    return this.core.mainColArray;
  }

  int[] getRefColumns()
  {
    return this.core.refColArray;
  }

  boolean isIndexFK(Index paramIndex)
  {
    return ((this.constType == 0) || (this.constType == 1)) && ((this.core.mainIndex == paramIndex) || (this.core.refIndex == paramIndex));
  }

  boolean isIndexUnique(Index paramIndex)
  {
    return (this.constType == 2) && (this.core.mainIndex == paramIndex);
  }

  boolean hasColumn(Table paramTable, String paramString)
  {
    if (this.constType != 3)
      return false;
    Expression.Collector localCollector = new Expression.Collector();
    localCollector.addAll(this.core.check, 2);
    Iterator localIterator = localCollector.iterator();
    while (localIterator.hasNext())
    {
      Expression localExpression = (Expression)localIterator.next();
      if ((localExpression.getColumnName().equals(paramString)) && (paramTable.tableName.name.equals(localExpression.getTableName())))
        return true;
    }
    return false;
  }

  boolean hasColumn(int paramInt)
  {
    if (this.constType == 1)
      return ArrayUtil.find(this.core.mainColArray, paramInt) != -1;
    if (this.constType == 0)
      return ArrayUtil.find(this.core.refColArray, paramInt) != -1;
    return false;
  }

  boolean isEquivalent(int[] paramArrayOfInt, int paramInt)
  {
    if ((paramInt != this.constType) || (this.constType != 2) || (this.core.colLen != paramArrayOfInt.length))
      return false;
    return ArrayUtil.haveEqualSets(this.core.mainColArray, paramArrayOfInt, this.core.colLen);
  }

  boolean isEquivalent(Table paramTable1, int[] paramArrayOfInt1, Table paramTable2, int[] paramArrayOfInt2)
  {
    if ((this.constType != 1) && (this.constType != 0))
      return false;
    if ((paramTable1 != this.core.mainTable) || (paramTable2 != this.core.refTable))
      return false;
    return (ArrayUtil.areEqualSets(this.core.mainColArray, paramArrayOfInt1)) && (ArrayUtil.areEqualSets(this.core.refColArray, paramArrayOfInt2));
  }

  void replaceTable(Table paramTable1, Table paramTable2, int paramInt1, int paramInt2)
    throws HsqlException
  {
    if (paramTable1 == this.core.mainTable)
    {
      this.core.mainTable = paramTable2;
      if (this.core.mainIndex != null)
      {
        this.core.mainIndex = this.core.mainTable.getIndex(this.core.mainIndex.getName().name);
        this.core.mainColArray = ArrayUtil.toAdjustedColumnArray(this.core.mainColArray, paramInt1, paramInt2);
      }
    }
    if (paramTable1 == this.core.refTable)
    {
      this.core.refTable = paramTable2;
      if (this.core.refIndex != null)
      {
        this.core.refIndex = this.core.refTable.getIndex(this.core.refIndex.getName().name);
        if (this.core.refIndex != this.core.mainIndex)
          this.core.refColArray = ArrayUtil.toAdjustedColumnArray(this.core.refColArray, paramInt1, paramInt2);
      }
    }
  }

  void checkInsert(Session paramSession, Object[] paramArrayOfObject)
    throws HsqlException
  {
    if ((this.constType == 1) || (this.constType == 2) || (this.constType == 4))
      return;
    if (this.constType == 3)
    {
      checkCheckConstraint(paramSession, paramArrayOfObject);
      return;
    }
    if (Index.isNull(paramArrayOfObject, this.core.refColArray))
      return;
    boolean bool = this.core.mainIndex.exists(paramSession, paramArrayOfObject, this.core.refColArray);
    if (!bool)
    {
      if (this.core.mainTable == this.core.refTable)
      {
        int i = 1;
        for (int j = 0; j < this.core.colLen; j++)
        {
          if (paramArrayOfObject[this.core.refColArray[j]].equals(paramArrayOfObject[this.core.mainColArray[j]]))
            continue;
          i = 0;
          break;
        }
        if (i != 0)
          return;
      }
      throw Trace.error(177, 100, new Object[] { this.core.fkName.name, this.core.mainTable.getName().name });
    }
  }

  void checkCheckConstraint(Session paramSession, Object[] paramArrayOfObject)
    throws HsqlException
  {
    this.core.checkFilter.currentData = paramArrayOfObject;
    boolean bool = Boolean.FALSE.equals(this.core.check.test(paramSession));
    this.core.checkFilter.currentData = null;
    if (bool)
      throw Trace.error(157, 100, new Object[] { this.constName.name, this.core.mainTable.tableName.name });
  }

  RowIterator findFkRef(Session paramSession, Object[] paramArrayOfObject, boolean paramBoolean)
    throws HsqlException
  {
    if ((paramArrayOfObject == null) || (Index.isNull(paramArrayOfObject, this.core.mainColArray)))
      return this.core.refIndex.emptyIterator();
    return paramBoolean ? this.core.refIndex.findFirstRowForDelete(paramSession, paramArrayOfObject, this.core.mainColArray) : this.core.refIndex.findFirstRow(paramSession, paramArrayOfObject, this.core.mainColArray);
  }

  boolean hasMainRef(Session paramSession, Object[] paramArrayOfObject)
    throws HsqlException
  {
    if (Index.isNull(paramArrayOfObject, this.core.refColArray))
      return false;
    boolean bool = this.core.mainIndex.exists(paramSession, paramArrayOfObject, this.core.refColArray);
    if (!bool)
      throw Trace.error(177, 100, new Object[] { this.core.fkName.name, this.core.refTable.getName().name });
    return bool;
  }

  private static boolean hasReferencedRow(Session paramSession, Object[] paramArrayOfObject, int[] paramArrayOfInt, Index paramIndex)
    throws HsqlException
  {
    if (Index.isNull(paramArrayOfObject, paramArrayOfInt))
      return true;
    return paramIndex.exists(paramSession, paramArrayOfObject, paramArrayOfInt);
  }

  static void checkReferencedRows(Session paramSession, Table paramTable, int[] paramArrayOfInt, Index paramIndex)
    throws HsqlException
  {
    RowIterator localRowIterator = paramTable.getPrimaryIndex().firstRow(paramSession);
    while (true)
    {
      Row localRow = localRowIterator.next();
      if (localRow == null)
        break;
      Object[] arrayOfObject = localRow.getData();
      if (hasReferencedRow(paramSession, arrayOfObject, paramArrayOfInt, paramIndex))
        continue;
      String str = "";
      for (int i = 0; i < paramArrayOfInt.length; i++)
      {
        Object localObject = arrayOfObject[paramArrayOfInt[i]];
        str = str + localObject;
        str = str + ",";
      }
      throw Trace.error(177, 100, new Object[] { str, paramTable.getName().name });
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Constraint
 * JD-Core Version:    0.6.0
 */