/*     */ package org.apache.xml.resolver.helpers;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Hashtable;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.TransformerException;
/*     */ import javax.xml.transform.URIResolver;
/*     */ import javax.xml.transform.sax.SAXSource;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ public class BootstrapResolver
/*     */   implements EntityResolver, URIResolver
/*     */ {
/*     */   public static final String xmlCatalogXSD = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.xsd";
/*     */   public static final String xmlCatalogRNG = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.rng";
/*     */   public static final String xmlCatalogPubId = "-//OASIS//DTD XML Catalogs V1.0//EN";
/*     */   public static final String xmlCatalogSysId = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd";
/*     */   public static final String xCatalogPubId = "-//DTD XCatalog//EN";
/*  69 */   private Hashtable publicMap = new Hashtable();
/*     */ 
/*  72 */   private Hashtable systemMap = new Hashtable();
/*     */ 
/*  75 */   private Hashtable uriMap = new Hashtable();
/*     */ 
/*     */   public BootstrapResolver()
/*     */   {
/*  79 */     URL url = getClass().getResource("/org/apache/xml/resolver/etc/catalog.dtd");
/*  80 */     if (url != null) {
/*  81 */       this.publicMap.put("-//OASIS//DTD XML Catalogs V1.0//EN", url.toString());
/*  82 */       this.systemMap.put("http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd", url.toString());
/*     */     }
/*     */ 
/*  85 */     url = getClass().getResource("/org/apache/xml/resolver/etc/catalog.rng");
/*  86 */     if (url != null) {
/*  87 */       this.uriMap.put("http://www.oasis-open.org/committees/entity/release/1.0/catalog.rng", url.toString());
/*     */     }
/*     */ 
/*  90 */     url = getClass().getResource("/org/apache/xml/resolver/etc/catalog.xsd");
/*  91 */     if (url != null) {
/*  92 */       this.uriMap.put("http://www.oasis-open.org/committees/entity/release/1.0/catalog.xsd", url.toString());
/*     */     }
/*     */ 
/*  95 */     url = getClass().getResource("/org/apache/xml/resolver/etc/xcatalog.dtd");
/*  96 */     if (url != null)
/*  97 */       this.publicMap.put("-//DTD XCatalog//EN", url.toString());
/*     */   }
/*     */ 
/*     */   public InputSource resolveEntity(String publicId, String systemId)
/*     */   {
/* 103 */     String resolved = null;
/*     */ 
/* 105 */     if ((systemId != null) && (this.systemMap.containsKey(systemId)))
/* 106 */       resolved = (String)this.systemMap.get(systemId);
/* 107 */     else if ((publicId != null) && (this.publicMap.containsKey(publicId))) {
/* 108 */       resolved = (String)this.publicMap.get(publicId);
/*     */     }
/*     */ 
/* 111 */     if (resolved != null) {
/*     */       try {
/* 113 */         InputSource iSource = new InputSource(resolved);
/* 114 */         iSource.setPublicId(publicId);
/*     */ 
/* 127 */         URL url = new URL(resolved);
/* 128 */         InputStream iStream = url.openStream();
/* 129 */         iSource.setByteStream(iStream);
/*     */ 
/* 131 */         return iSource;
/*     */       }
/*     */       catch (Exception e) {
/* 134 */         return null;
/*     */       }
/*     */     }
/*     */ 
/* 138 */     return null;
/*     */   }
/*     */ 
/*     */   public Source resolve(String href, String base)
/*     */     throws TransformerException
/*     */   {
/* 145 */     String uri = href;
/* 146 */     String fragment = null;
/* 147 */     int hashPos = href.indexOf("#");
/* 148 */     if (hashPos >= 0) {
/* 149 */       uri = href.substring(0, hashPos);
/* 150 */       fragment = href.substring(hashPos + 1);
/*     */     }
/*     */ 
/* 153 */     String result = null;
/* 154 */     if ((href != null) && (this.uriMap.containsKey(href))) {
/* 155 */       result = (String)this.uriMap.get(href);
/*     */     }
/*     */ 
/* 158 */     if (result == null) {
/*     */       try {
/* 160 */         URL url = null;
/*     */ 
/* 162 */         if (base == null) {
/* 163 */           url = new URL(uri);
/* 164 */           result = url.toString();
/*     */         } else {
/* 166 */           URL baseURL = new URL(base);
/* 167 */           url = href.length() == 0 ? baseURL : new URL(baseURL, uri);
/* 168 */           result = url.toString();
/*     */         }
/*     */       }
/*     */       catch (MalformedURLException mue) {
/* 172 */         String absBase = makeAbsolute(base);
/* 173 */         if (!absBase.equals(base))
/*     */         {
/* 175 */           return resolve(href, absBase);
/*     */         }
/* 177 */         throw new TransformerException("Malformed URL " + href + "(base " + base + ")", mue);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 184 */     SAXSource source = new SAXSource();
/* 185 */     source.setInputSource(new InputSource(result));
/* 186 */     return source;
/*     */   }
/*     */ 
/*     */   private String makeAbsolute(String uri)
/*     */   {
/* 191 */     if (uri == null) {
/* 192 */       uri = "";
/*     */     }
/*     */     try
/*     */     {
/* 196 */       URL url = new URL(uri);
/* 197 */       return url.toString();
/*     */     } catch (MalformedURLException mue) {
/*     */       try {
/* 200 */         URL fileURL = FileURL.makeURL(uri);
/* 201 */         return fileURL.toString(); } catch (MalformedURLException mue2) {
/*     */       }
/*     */     }
/* 204 */     return uri;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.helpers.BootstrapResolver
 * JD-Core Version:    0.6.0
 */